/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.bigdecimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Numeric;
import org.jruby.util.SafeDoubleParser;

@JRubyClass(name={"BigDecimal"}, parent="Numeric")
public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public RubyBigDecimal allocate(Ruby runtime, RubyClass klass) {
            return new RubyBigDecimal(runtime, klass);
        }
    };
    @JRubyConstant
    public static final int ROUND_DOWN = 1;
    @JRubyConstant
    public static final int ROUND_CEILING = 2;
    @JRubyConstant
    public static final int ROUND_UP = 0;
    @JRubyConstant
    public static final int ROUND_HALF_DOWN = 5;
    @JRubyConstant
    public static final int ROUND_HALF_EVEN = 6;
    @JRubyConstant
    public static final int ROUND_HALF_UP = 4;
    @JRubyConstant
    public static final int ROUND_FLOOR = 3;
    @JRubyConstant
    public static final int SIGN_POSITIVE_INFINITE = 3;
    @JRubyConstant
    public static final int EXCEPTION_OVERFLOW = 8;
    @JRubyConstant
    public static final int SIGN_POSITIVE_ZERO = 1;
    @JRubyConstant
    public static final int EXCEPTION_ALL = 255;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_FINITE = -2;
    @JRubyConstant
    public static final int EXCEPTION_UNDERFLOW = 4;
    @JRubyConstant
    public static final int SIGN_NaN = 0;
    @JRubyConstant
    public static final int BASE = 10000;
    @JRubyConstant
    public static final int ROUND_MODE = 256;
    @JRubyConstant
    public static final int SIGN_POSITIVE_FINITE = 2;
    @JRubyConstant
    public static final int EXCEPTION_INFINITY = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_INFINITE = -3;
    @JRubyConstant
    public static final int EXCEPTION_ZERODIVIDE = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_ZERO = -1;
    @JRubyConstant
    public static final int EXCEPTION_NaN = 2;
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final double SQRT_10 = 3.1622776601683795;
    private boolean isNaN;
    private int infinitySign;
    private int zeroSign;
    private BigDecimal value;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE]?)([+-]?\\d*)).*");

    public static RubyClass createBigDecimal(Ruby runtime) {
        try {
            RubyClass bigDecimal = runtime.defineClass("BigDecimal", runtime.getNumeric(), ALLOCATOR);
            runtime.getKernel().defineAnnotatedMethods(BigDecimalKernelMethods.class);
            bigDecimal.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(runtime));
            bigDecimal.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(runtime));
            bigDecimal.setInternalModuleVariable("vpRoundingMode", runtime.newFixnum(4));
            bigDecimal.defineAnnotatedMethods(RubyBigDecimal.class);
            bigDecimal.defineAnnotatedConstants(RubyBigDecimal.class);
            RubyModule bigMath = runtime.defineModule("BigMath");
            bigDecimal.defineConstant("NAN", RubyBigDecimal.newNaN(runtime));
            bigDecimal.defineConstant("INFINITY", RubyBigDecimal.newInfinity(runtime, 1));
            return bigDecimal;
        }
        catch (Exception e) {
            System.out.println("E:" + e);
            e.printStackTrace();
            return null;
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = BigDecimal.ZERO;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass, BigDecimal value2) {
        super(runtime, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2, int infinitySign) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = infinitySign;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2, int infinitySign, int zeroSign) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = infinitySign;
        this.zeroSign = zeroSign;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2, boolean isNan) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = isNan;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, RubyBigDecimal rbd) {
        this(runtime, runtime.getClass("BigDecimal"), rbd);
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass, RubyBigDecimal rbd) {
        super(runtime, klass);
        this.isNaN = rbd.isNaN;
        this.infinitySign = rbd.infinitySign;
        this.zeroSign = rbd.zeroSign;
        this.value = rbd.value;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ver(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newString("1.0.1");
    }

    @JRubyMethod
    public IRubyObject _dump(ThreadContext context) {
        return RubyString.newUnicodeString(context.runtime, "0:").append(this.asString());
    }

    @JRubyMethod
    public IRubyObject _dump(ThreadContext context, IRubyObject unused2) {
        return RubyString.newUnicodeString(context.runtime, "0:").append(this.asString());
    }

    @JRubyMethod(meta=true)
    public static RubyBigDecimal _load(ThreadContext context, IRubyObject recv2, IRubyObject from) {
        RubyBigDecimal instance = (RubyBigDecimal)((RubyClass)recv2).allocate();
        String precisionAndValue = from.convertToString().asJavaString();
        String value2 = precisionAndValue.substring(precisionAndValue.indexOf(":") + 1);
        instance.value = new BigDecimal(value2);
        return instance;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject double_fig(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newFixnum(20);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject limit(ThreadContext context, IRubyObject recv2) {
        return ((RubyModule)recv2).searchInternalModuleVariable("vpPrecLimit");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject limit(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        IRubyObject old = RubyBigDecimal.limit(context, recv2);
        if (arg2.isNil()) {
            return old;
        }
        if (!(arg2 instanceof RubyFixnum)) {
            throw context.runtime.newTypeError(arg2, context.runtime.getFixnum());
        }
        if (0L > ((RubyFixnum)arg2).getLongValue()) {
            throw context.runtime.newArgumentError("argument must be positive");
        }
        ((RubyModule)recv2).setInternalModuleVariable("vpPrecLimit", arg2);
        return old;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_limit(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv2, block, "vpPrecLimit");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_exception_mode(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv2, block, "vpExceptionMode");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_rounding_mode(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv2, block, "vpRoundingMode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject modeExecute(ThreadContext context, RubyModule BigDecimal2, Block block, String intVariableName) {
        IRubyObject current2 = BigDecimal2.searchInternalModuleVariable(intVariableName);
        try {
            IRubyObject iRubyObject = block.yieldSpecific(context);
            return iRubyObject;
        }
        finally {
            BigDecimal2.setInternalModuleVariable(intVariableName, current2);
        }
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject mode(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long _EXCEPTION_ALL;
        RubyClass clazz = context.runtime.getClass("BigDecimal");
        RubyModule c = (RubyModule)recv2;
        args2 = Arity.scanArgs(context.runtime, args2, 1, 1);
        IRubyObject mode2 = args2[0];
        IRubyObject value2 = args2[1];
        if (!(mode2 instanceof RubyFixnum)) {
            throw context.runtime.newTypeError("wrong argument type " + mode2.getMetaClass() + " (expected Fixnum)");
        }
        long longMode = ((RubyFixnum)mode2).getLongValue();
        if ((longMode & (_EXCEPTION_ALL = RubyBigDecimal.bigDecimalConst(context.runtime, "EXCEPTION_ALL"))) != 0L) {
            RubyFixnum _EXCEPTION_OVERFLOW;
            RubyFixnum _EXCEPTION_UNDERFLOW;
            RubyFixnum _EXCEPTION_NaN;
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!(value2 instanceof RubyBoolean)) {
                throw context.runtime.newArgumentError("second argument must be true or false");
            }
            RubyFixnum currentExceptionMode = (RubyFixnum)c.searchInternalModuleVariable("vpExceptionMode");
            RubyFixnum newExceptionMode = new RubyFixnum(context.runtime, currentExceptionMode.getLongValue());
            RubyFixnum _EXCEPTION_INFINITY = (RubyFixnum)clazz.getConstant("EXCEPTION_INFINITY");
            if ((longMode & _EXCEPTION_INFINITY.getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", _EXCEPTION_INFINITY) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(context.runtime, _EXCEPTION_INFINITY.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (_EXCEPTION_NaN = (RubyFixnum)clazz.getConstant("EXCEPTION_NaN")).getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", _EXCEPTION_NaN) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(context.runtime, _EXCEPTION_NaN.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (_EXCEPTION_UNDERFLOW = (RubyFixnum)clazz.getConstant("EXCEPTION_UNDERFLOW")).getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", _EXCEPTION_UNDERFLOW) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(context.runtime, _EXCEPTION_UNDERFLOW.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (_EXCEPTION_OVERFLOW = (RubyFixnum)clazz.getConstant("EXCEPTION_OVERFLOW")).getLongValue()) != 0L) {
                newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", _EXCEPTION_OVERFLOW) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(context.runtime, _EXCEPTION_OVERFLOW.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            c.setInternalModuleVariable("vpExceptionMode", newExceptionMode);
            return newExceptionMode;
        }
        long ROUND_MODE = ((RubyFixnum)clazz.getConstant("ROUND_MODE")).getLongValue();
        if (longMode == ROUND_MODE) {
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpRoundingMode");
            }
            RoundingMode javaRoundingMode = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context.runtime, value2);
            RubyFixnum roundingMode = context.runtime.newFixnum(javaRoundingMode.ordinal());
            c.setInternalModuleVariable("vpRoundingMode", roundingMode);
            return c.searchInternalModuleVariable("vpRoundingMode");
        }
        throw context.runtime.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private static RubyModule bigDecimal(Ruby runtime) {
        return runtime.getClass("BigDecimal");
    }

    private static long bigDecimalVar(Ruby runtime, String variableName) {
        return ((RubyFixnum)RubyBigDecimal.bigDecimal(runtime).searchInternalModuleVariable(variableName)).getLongValue();
    }

    private static long bigDecimalConst(Ruby runtime, String constantName) {
        return ((RubyFixnum)RubyBigDecimal.bigDecimal(runtime).getConstant(constantName)).getLongValue();
    }

    private static RoundingMode getRoundingMode(Ruby runtime) {
        return RoundingMode.valueOf((int)RubyBigDecimal.bigDecimalVar(runtime, "vpRoundingMode"));
    }

    private static boolean isNaNExceptionMode(Ruby runtime) {
        return (RubyBigDecimal.bigDecimalVar(runtime, "vpExceptionMode") & RubyBigDecimal.bigDecimalConst(runtime, "EXCEPTION_NaN")) != 0L;
    }

    private static boolean isInfinityExceptionMode(Ruby runtime) {
        return (RubyBigDecimal.bigDecimalVar(runtime, "vpExceptionMode") & RubyBigDecimal.bigDecimalConst(runtime, "EXCEPTION_INFINITY")) != 0L;
    }

    private static boolean isOverflowExceptionMode(Ruby runtime) {
        return (RubyBigDecimal.bigDecimalVar(runtime, "vpExceptionMode") & RubyBigDecimal.bigDecimalConst(runtime, "EXCEPTION_OVERFLOW")) != 0L;
    }

    private static RubyBigDecimal cannotBeCoerced(ThreadContext context, IRubyObject value2, boolean must) {
        if (must) {
            throw context.runtime.newTypeError(RubyBigDecimal.errMessageType(context, value2) + " can't be coerced into BigDecimal");
        }
        return null;
    }

    private static String errMessageType(ThreadContext context, IRubyObject value2) {
        if (value2 == null || value2.isNil()) {
            return "nil";
        }
        if (value2.isImmediate()) {
            return RubyObject.inspect(context, value2).toString();
        }
        return value2.getMetaClass().getBaseName();
    }

    private static RubyBigDecimal getVpValue19(ThreadContext context, IRubyObject v, boolean must) {
        long precision = v instanceof RubyFloat || v instanceof RubyRational ? 0L : -1L;
        return RubyBigDecimal.getVpValueWithPrec19(context, v, precision, must);
    }

    private static RubyBigDecimal getVpRubyObjectWithPrec19Inner(ThreadContext context, RubyRational value2) {
        BigDecimal numerator2 = BigDecimal.valueOf(RubyNumeric.num2long(value2.numerator(context)));
        BigDecimal denominator2 = BigDecimal.valueOf(RubyNumeric.num2long(value2.denominator(context)));
        int len = numerator2.precision() + denominator2.precision();
        int pow = len / 4;
        MathContext mathContext = new MathContext((pow + 1) * 4, RubyBigDecimal.getRoundingMode(context.runtime));
        return new RubyBigDecimal(context.runtime, numerator2.divide(denominator2, mathContext));
    }

    private static RubyBigDecimal getVpValueWithPrec19(ThreadContext context, IRubyObject value2, long precision, boolean must) {
        if (value2 instanceof RubyFloat) {
            if (precision > Long.MAX_VALUE) {
                return RubyBigDecimal.cannotBeCoerced(context, value2, must);
            }
            return new RubyBigDecimal(context.runtime, BigDecimal.valueOf(((RubyFloat)value2).getDoubleValue()));
        }
        if (value2 instanceof RubyRational) {
            if (precision < 0L) {
                if (must) {
                    throw context.runtime.newArgumentError(value2.getMetaClass().getBaseName() + " can't be coerced into BigDecimal without a precision");
                }
                return null;
            }
            return RubyBigDecimal.getVpRubyObjectWithPrec19Inner(context, (RubyRational)value2);
        }
        return RubyBigDecimal.getVpValue(context, value2, must);
    }

    private static RubyBigDecimal getVpValue(ThreadContext context, IRubyObject value2, boolean must) {
        if (value2 instanceof RubyBigDecimal) {
            return (RubyBigDecimal)value2;
        }
        if (value2 instanceof RubyFixnum || value2 instanceof RubyBignum) {
            return RubyBigDecimal.newInstance(context, (IRubyObject)context.runtime.getClass("BigDecimal"), value2.asString());
        }
        if (value2 instanceof RubyRational || value2 instanceof RubyFloat) {
            return RubyBigDecimal.newInstance(context, (IRubyObject)context.runtime.getClass("BigDecimal"), value2, RubyFixnum.newFixnum(context.runtime, 15L));
        }
        return RubyBigDecimal.cannotBeCoerced(context, value2, must);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyBigDecimal.getVpValue(context, arg2, true);
    }

    private static RubyBigDecimal newInstance(Ruby runtime, IRubyObject recv2, RubyBigDecimal arg2) {
        return new RubyBigDecimal(runtime, (RubyClass)recv2, arg2);
    }

    private static RubyBigDecimal newInstance(Ruby runtime, IRubyObject recv2, RubyFixnum arg2, MathContext mathContext) {
        return new RubyBigDecimal(runtime, (RubyClass)recv2, new BigDecimal(arg2.getLongValue(), mathContext));
    }

    private static RubyBigDecimal newInstance(ThreadContext context, RubyRational arg2, MathContext mathContext) {
        BigDecimal num = new BigDecimal(arg2.numerator(context).convertToInteger().getLongValue());
        BigDecimal den = new BigDecimal(arg2.denominator(context).convertToInteger().getLongValue());
        BigDecimal value2 = num.divide(den, mathContext);
        return new RubyBigDecimal(context.runtime, value2);
    }

    private static RubyBigDecimal newInstance(Ruby runtime, IRubyObject recv2, RubyFloat arg2, MathContext mathContext) {
        if (mathContext.getPrecision() > 16) {
            throw runtime.newArgumentError("precision too large");
        }
        double dblVal = arg2.getDoubleValue();
        if (Double.isInfinite(dblVal) || Double.isNaN(dblVal)) {
            throw runtime.newFloatDomainError("NaN");
        }
        return new RubyBigDecimal(runtime, (RubyClass)recv2, new BigDecimal(dblVal, mathContext));
    }

    private static RubyBigDecimal newInstance(Ruby runtime, IRubyObject recv2, RubyBignum arg2, MathContext mathContext) {
        return new RubyBigDecimal(runtime, (RubyClass)recv2, new BigDecimal(arg2.getBigIntegerValue(), mathContext));
    }

    private static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, IRubyObject arg2, MathContext mathContext) {
        BigDecimal decimal;
        String strValue = arg2.convertToString().toString().trim();
        int sign2 = 1;
        if (strValue.length() > 0) {
            switch (strValue.charAt(0)) {
                case '_': {
                    return RubyBigDecimal.newZero(context.runtime, 1);
                }
                case 'N': {
                    if (!"NaN".equals(strValue)) break;
                    return RubyBigDecimal.newNaN(context.runtime);
                }
                case 'I': {
                    if (!"Infinity".equals(strValue)) break;
                    return RubyBigDecimal.newInfinity(context.runtime, 1);
                }
                case '-': {
                    if ("-Infinity".equals(strValue)) {
                        return RubyBigDecimal.newInfinity(context.runtime, -1);
                    }
                    sign2 = -1;
                    break;
                }
                case '+': {
                    if (!"+Infinity".equals(strValue)) break;
                    return RubyBigDecimal.newInfinity(context.runtime, 1);
                }
            }
        }
        strValue = strValue.replaceFirst("[dD]", "E");
        strValue = strValue.replaceAll("_", "");
        Matcher matcher = NUMBER_PATTERN.matcher(strValue);
        strValue = matcher.replaceFirst("$1");
        String exp = matcher.group(2);
        if (!exp.isEmpty()) {
            String expValue = matcher.group(3);
            if (expValue.isEmpty() || expValue.equals("-") || expValue.equals("+")) {
                strValue = strValue.concat("0");
            } else if (RubyBigDecimal.isExponentOutOfRange(expValue)) {
                return RubyBigDecimal.newInfinity(context.runtime, sign2);
            }
        }
        try {
            decimal = new BigDecimal(strValue, mathContext);
        }
        catch (NumberFormatException e) {
            if (RubyBigDecimal.isOverflowExceptionMode(context.runtime)) {
                throw context.runtime.newFloatDomainError("exponent overflow");
            }
            decimal = new BigDecimal(0);
        }
        if (decimal.signum() == 0) {
            return RubyBigDecimal.newZero(context.runtime, sign2);
        }
        return new RubyBigDecimal(context.runtime, (RubyClass)recv2, decimal);
    }

    private static boolean isExponentOutOfRange(String expValue) {
        int num = 0;
        int sign2 = 1;
        int len = expValue.length();
        char ch = expValue.charAt(0);
        if (ch == '-') {
            sign2 = -1;
        } else if (ch != '+') {
            num = 48 - ch;
        }
        int i2 = 1;
        int max2 = sign2 == 1 ? -2147483647 : -2147483647;
        int multmax = max2 / 10;
        while (i2 < len) {
            int d = expValue.charAt(i2++) - 48;
            if (num < multmax) {
                return true;
            }
            if ((num *= 10) < max2 + d) {
                return true;
            }
            num -= d;
        }
        return false;
    }

    @Deprecated
    public static RubyBigDecimal newInstance(IRubyObject recv2, IRubyObject[] args2) {
        ThreadContext context = recv2.getRuntime().getCurrentContext();
        switch (args2.length) {
            case 1: {
                return RubyBigDecimal.newInstance(context, recv2, args2[0]);
            }
            case 2: {
                return RubyBigDecimal.newInstance(context, recv2, args2[0], args2[1]);
            }
        }
        throw new IllegalArgumentException("unexpected argument count: " + args2.length);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (arg2 instanceof RubyBigDecimal) {
            return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyBigDecimal)arg2);
        }
        if (arg2 instanceof RubyRational) {
            throw context.runtime.newArgumentError("can't omit precision for a Rational.");
        }
        if (arg2 instanceof RubyFloat) {
            throw context.runtime.newArgumentError("can't omit precision for a Float.");
        }
        if (arg2 instanceof RubyFixnum) {
            return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyFixnum)arg2, MathContext.UNLIMITED);
        }
        if (arg2 instanceof RubyBignum) {
            return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyBignum)arg2, MathContext.UNLIMITED);
        }
        return RubyBigDecimal.newInstance(context, recv2, arg2, MathContext.UNLIMITED);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject mathArg) {
        int digits = (int)mathArg.convertToInteger().getLongValue();
        if (digits < 0) {
            throw context.runtime.newArgumentError("argument must be positive");
        }
        MathContext mathContext = new MathContext(digits);
        if (arg2 instanceof RubyBigDecimal) {
            return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyBigDecimal)arg2);
        }
        if (arg2 instanceof RubyFloat) {
            return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyFloat)arg2, mathContext);
        }
        if (arg2 instanceof RubyRational) {
            return RubyBigDecimal.newInstance(context, (RubyRational)arg2, mathContext);
        }
        if (arg2 instanceof RubyFixnum) {
            return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyFixnum)arg2, mathContext);
        }
        if (arg2 instanceof RubyBignum) {
            return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyBignum)arg2, mathContext);
        }
        return RubyBigDecimal.newInstance(context, recv2, arg2, MathContext.UNLIMITED);
    }

    private static RubyBigDecimal newZero(Ruby runtime, int sign2) {
        return new RubyBigDecimal(runtime, BigDecimal.ZERO, 0, sign2 < 0 ? -1 : 1);
    }

    private static RubyBigDecimal newNaN(Ruby runtime) {
        if (RubyBigDecimal.isNaNExceptionMode(runtime)) {
            throw runtime.newFloatDomainError("Computation results to 'NaN'(Not a Number)");
        }
        return new RubyBigDecimal(runtime, BigDecimal.ZERO, true);
    }

    private static RubyBigDecimal newInfinity(Ruby runtime, int sign2) {
        if (RubyBigDecimal.isInfinityExceptionMode(runtime)) {
            throw runtime.newFloatDomainError("Computation results to 'Infinity'");
        }
        return new RubyBigDecimal(runtime, BigDecimal.ZERO, sign2 < 0 ? -1 : 1);
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int scale) {
        int prec = RubyFixnum.fix2int(this.getRuntime().getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
        int prec2 = Math.max(scale, prec);
        if (prec2 > 0 && this.value.scale() > prec2 - this.getExponent()) {
            this.value = this.value.setScale(prec2 - this.getExponent(), 4);
        }
        return this;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.stripTrailingZeros().hashCode());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (!(original instanceof RubyBigDecimal)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyBigDecimal origRbd = (RubyBigDecimal)original;
        this.isNaN = origRbd.isNaN;
        this.infinitySign = origRbd.infinitySign;
        this.zeroSign = origRbd.zeroSign;
        this.value = origRbd.value;
        return this;
    }

    public IRubyObject op_mod(ThreadContext context, IRubyObject arg2) {
        return this.op_mod19(context, arg2);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "%", other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (val.isInfinity()) {
            return this;
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(context.runtime, this.value.signum());
        }
        BigDecimal modulo = this.value.remainder(val.value);
        if (modulo.signum() * val.value.signum() < 0) {
            modulo = modulo.add(val.value);
        }
        return new RubyBigDecimal(context.runtime, modulo).setResult();
    }

    @Override
    public IRubyObject remainder(ThreadContext context, IRubyObject arg2) {
        return this.remainder19(context, arg2);
    }

    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder19(ThreadContext context, IRubyObject arg2) {
        return this.remainderInternal(context, RubyBigDecimal.getVpValue19(context, arg2, false), arg2);
    }

    private IRubyObject remainderInternal(ThreadContext context, RubyBigDecimal val, IRubyObject arg2) {
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (val == null) {
            return this.callCoerced(context, "remainder", arg2, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        return new RubyBigDecimal(context.runtime, this.value.remainder(val.value)).setResult();
    }

    public IRubyObject op_mul(ThreadContext context, IRubyObject arg2) {
        return this.op_mul19(context, arg2);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul19(ThreadContext context, IRubyObject arg2) {
        return this.mult219(context, arg2, RubyBigDecimal.vpPrecLimit(context.runtime));
    }

    public IRubyObject mult2(ThreadContext context, IRubyObject b2, IRubyObject n) {
        return this.mult219(context, b2, n);
    }

    @JRubyMethod(name={"mult"}, required=2)
    public IRubyObject mult219(ThreadContext context, IRubyObject b2, IRubyObject n) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, b2, false);
        if (val == null) {
            return this.callCoerced(context, "*", b2, true);
        }
        return this.multInternal(context.runtime, val, n);
    }

    private RubyBigDecimal multInternal(Ruby runtime, RubyBigDecimal val, IRubyObject n) {
        int digits = RubyNumeric.fix2int(n);
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity() && val.isZero() || this.isZero() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isZero() || val.isZero()) {
            int sign1 = this.isZero() ? this.zeroSign : this.value.signum();
            int sign2 = val.isZero() ? val.zeroSign : val.value.signum();
            return RubyBigDecimal.newZero(runtime, sign1 * sign2);
        }
        if (this.isInfinity() || val.isInfinity()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            int sign2 = val.isInfinity() ? val.infinitySign : val.value.signum();
            return RubyBigDecimal.newInfinity(runtime, sign1 * sign2);
        }
        BigDecimal res = this.value.multiply(val.value);
        if (res.precision() > digits) {
            res = res.round(new MathContext(digits, RoundingMode.HALF_UP));
        }
        return new RubyBigDecimal(runtime, res).setResult();
    }

    private RubyBigDecimal newPowOfInfinity(ThreadContext context, IRubyObject exp) {
        if (Numeric.f_negative_p(context, exp)) {
            if (this.infinitySign >= 0) {
                return RubyBigDecimal.newZero(context.runtime, 0);
            }
            if (Numeric.f_integer_p(context, exp).isTrue()) {
                return RubyBigDecimal.newZero(context.runtime, this.is_even(exp) ? 1 : -1);
            }
            return RubyBigDecimal.newZero(context.runtime, -1);
        }
        if (this.infinitySign >= 0) {
            return RubyBigDecimal.newInfinity(context.runtime, 1);
        }
        if (Numeric.f_integer_p(context, exp).isTrue()) {
            return RubyBigDecimal.newInfinity(context.runtime, this.is_even(exp) ? 1 : -1);
        }
        throw context.runtime.newMathDomainError("a non-integral exponent for a negative base");
    }

    private static IRubyObject vpPrecLimit(Ruby runtime) {
        return runtime.getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit");
    }

    public IRubyObject op_pow(IRubyObject arg2) {
        return this.op_pow19(this.getRuntime().getCurrentContext(), arg2);
    }

    public RubyBigDecimal op_pow(ThreadContext context, IRubyObject arg2) {
        return this.op_pow19(context, arg2);
    }

    public IRubyObject op_pow19(IRubyObject exp) {
        return this.op_pow19(this.getRuntime().getCurrentContext(), exp);
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public RubyBigDecimal op_pow19(ThreadContext context, IRubyObject exp) {
        BigDecimal pow;
        double rem;
        int times2;
        Ruby runtime = context.runtime;
        if (!(exp instanceof RubyNumeric)) {
            throw context.runtime.newTypeError("wrong argument type " + exp.getMetaClass() + " (expected scalar Numeric)");
        }
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity()) {
            return this.newPowOfInfinity(context, exp);
        }
        if (!(exp instanceof RubyInteger)) {
            BigDecimal expVal = BigDecimal.valueOf(((RubyNumeric)exp).getDoubleValue());
            BigDecimal[] divAndRem = expVal.divideAndRemainder(BigDecimal.ONE);
            times2 = divAndRem[0].intValueExact();
            rem = divAndRem[1].doubleValue();
        } else {
            times2 = RubyNumeric.fix2int(exp);
            rem = 0.0;
        }
        if (times2 < 0) {
            if (this.isZero()) {
                return RubyBigDecimal.newInfinity(context.runtime, this.value.signum());
            }
            pow = this.powNegative(times2);
        } else {
            pow = this.value.pow(times2);
        }
        if (rem > 0.0) {
            double remPow = Math.pow(this.value.doubleValue(), rem);
            pow = pow.multiply(BigDecimal.valueOf(remPow));
        }
        return new RubyBigDecimal(runtime, pow);
    }

    private BigDecimal powNegative(int times2) {
        int precision = (-times2 + 4) * (this.getAllDigits().length() + 4);
        return this.value.pow(times2, new MathContext(precision, RoundingMode.HALF_UP));
    }

    public IRubyObject op_plus(ThreadContext context, IRubyObject b2) {
        return this.op_plus19(context, b2);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus19(ThreadContext context, IRubyObject b2) {
        return this.addInternal(context, RubyBigDecimal.getVpValue19(context, b2, false), b2, RubyBigDecimal.vpPrecLimit(context.runtime));
    }

    public IRubyObject add2(ThreadContext context, IRubyObject b2, IRubyObject digits) {
        return this.add219(context, b2, digits);
    }

    @JRubyMethod(name={"add"})
    public IRubyObject add219(ThreadContext context, IRubyObject b2, IRubyObject digits) {
        return this.addInternal(context, RubyBigDecimal.getVpValue19(context, b2, false), b2, digits);
    }

    private IRubyObject addInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b2, IRubyObject digits) {
        Ruby runtime = context.runtime;
        int prec = RubyBigDecimal.getPositiveInt(context, digits);
        if (val == null) {
            return this.callCoerced(context, "+", b2, true);
        }
        RubyBigDecimal res = this.handleAddSpecialValues(context, val);
        if (res != null) {
            return res;
        }
        RoundingMode roundMode = RubyBigDecimal.getRoundingMode(runtime);
        return new RubyBigDecimal(runtime, this.value.add(val.value, new MathContext(prec, roundMode)));
    }

    private static int getPositiveInt(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyFixnum) {
            int value2 = RubyNumeric.fix2int(arg2);
            if (value2 < 0) {
                throw runtime.newArgumentError("argument must be positive");
            }
            return value2;
        }
        throw runtime.newTypeError(arg2, runtime.getFixnum());
    }

    private RubyBigDecimal handleAddSpecialValues(ThreadContext context, RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return this.isInfinity() ? this : val;
        }
        if (sign2 < 0) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (sign2 == 0 && (sign2 = this.infinitySign + val.infinitySign) != 0) {
            return RubyBigDecimal.newInfinity(context.runtime, sign2);
        }
        return null;
    }

    @Override
    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    public IRubyObject op_minus(ThreadContext context, IRubyObject b2) {
        return this.op_minus19(context, b2);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus19(ThreadContext context, IRubyObject b2) {
        return this.subInternal(context, RubyBigDecimal.getVpValue19(context, b2, true), b2);
    }

    public IRubyObject sub2(ThreadContext context, IRubyObject b2, IRubyObject n) {
        return this.sub219(context, b2, n);
    }

    @JRubyMethod(name={"sub"}, required=2)
    public IRubyObject sub219(ThreadContext context, IRubyObject b2, IRubyObject n) {
        return this.subInternal(context, RubyBigDecimal.getVpValue19(context, b2, false), b2);
    }

    private IRubyObject subInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b2) {
        if (val == null) {
            return this.callCoerced(context, "-", b2);
        }
        RubyBigDecimal res = this.handleMinusSpecialValues(context, val);
        return res != null ? res : new RubyBigDecimal(context.runtime, this.value.subtract(val.value)).setResult();
    }

    private RubyBigDecimal handleMinusSpecialValues(ThreadContext context, RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (sign2 < 0) {
            return this;
        }
        if (sign2 == 0) {
            if (this.isInfinity()) {
                return this;
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.newInfinity(context.runtime, val.infinitySign * -1);
            }
            sign2 = this.infinitySign + val.infinitySign;
            if (sign2 != 0) {
                return RubyBigDecimal.newInfinity(context.runtime, sign2);
            }
        }
        return null;
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(context.runtime, -this.infinitySign);
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(context.runtime, -this.zeroSign);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.negate());
    }

    public IRubyObject op_quo(ThreadContext context, IRubyObject other) {
        return this.op_quo20(context, other);
    }

    public IRubyObject op_quo19(ThreadContext context, IRubyObject other) {
        return this.op_quo19_20(context, other);
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_quo20(ThreadContext context, IRubyObject other) {
        return this.op_quo19_20(context, other);
    }

    private IRubyObject op_quo19_20(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "/", other, true);
        }
        int len = this.value.precision() + val.value.precision();
        int pow = len / 4;
        int precision = (pow + 1) * 4 * 2;
        return this.op_div(context, val, context.runtime.newFixnum(precision));
    }

    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "div", other);
        }
        if (this.isNaN() || val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (this.isInfinity() || val.isInfinity()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        return new RubyBigDecimal(context.runtime, this.value.divideToIntegralValue(val.value)).setResult();
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div19(ThreadContext context, IRubyObject r) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, r, false);
        if (val == null) {
            return this.callCoerced(context, "div", r, true);
        }
        if (this.isNaN() || val.isNaN()) {
            throw context.runtime.newFloatDomainError("Computation results to 'NaN'");
        }
        if (this.isInfinity() && val.isOne()) {
            throw context.runtime.newFloatDomainError("Computation results to 'Infinity'");
        }
        if (val.isInfinity()) {
            return RubyBigDecimal.newZero(context.runtime, val.infinitySign);
        }
        if (this.isZero() || val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.op_div(context, r);
    }

    public IRubyObject op_div(ThreadContext context, IRubyObject other, IRubyObject digits) {
        int scale = RubyNumeric.fix2int(digits);
        RubyBigDecimal val = RubyBigDecimal.getVpValue(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "div", other, true);
        }
        if (this.isNaN() || this.isZero() && val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (val.isZero()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            return RubyBigDecimal.newInfinity(context.runtime, sign1 * val.zeroSign);
        }
        if (this.isInfinity() && !val.isInfinity()) {
            return RubyBigDecimal.newInfinity(context.runtime, this.infinitySign * val.value.signum());
        }
        if (!this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newZero(context.runtime, this.value.signum() * val.infinitySign);
        }
        if (this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(context.runtime, this.zeroSign * val.value.signum());
        }
        if (scale == 0) {
            return this.op_quo(context, other);
        }
        MathContext mathContext = new MathContext(scale, RubyBigDecimal.getRoundingMode(context.runtime));
        return new RubyBigDecimal(context.runtime, this.value.divide(val.value, mathContext)).setResult(scale);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div19(ThreadContext context, IRubyObject other, IRubyObject digits) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "div", other, true);
        }
        if (this.isNaN() || val.isNaN()) {
            throw context.runtime.newFloatDomainError("Computation results to 'NaN'");
        }
        return this.op_div(context, other, digits);
    }

    private IRubyObject cmp(ThreadContext context, IRubyObject arg2, char op) {
        int e;
        RubyBigDecimal rb = RubyBigDecimal.getVpValue(context, arg2, false);
        if (rb == null) {
            IRubyObject cmp2 = this.callCoerced(context, "<=>", arg2, false);
            if (cmp2.isNil()) {
                if (op == '*') {
                    return context.nil;
                }
                if (op == '=' || this.isNaN()) {
                    return context.runtime.getFalse();
                }
                throw context.runtime.newArgumentError("comparison of BigDecimal with " + RubyBigDecimal.errMessageType(context, arg2) + " failed");
            }
            e = RubyNumeric.fix2int(cmp2);
        } else {
            if (this.isNaN() || rb.isNaN()) {
                return op == '*' ? context.nil : context.runtime.getFalse();
            }
            e = this.infinitySign != 0 || rb.infinitySign != 0 ? this.infinitySign - rb.infinitySign : this.value.compareTo(rb.value);
        }
        switch (op) {
            case '*': {
                return context.runtime.newFixnum(e);
            }
            case '=': {
                return context.runtime.newBoolean(e == 0);
            }
            case '!': {
                return context.runtime.newBoolean(e != 0);
            }
            case 'G': {
                return context.runtime.newBoolean(e >= 0);
            }
            case '>': {
                return context.runtime.newBoolean(e > 0);
            }
            case 'L': {
                return context.runtime.newBoolean(e <= 0);
            }
            case '<': {
                return context.runtime.newBoolean(e < 0);
            }
        }
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '*');
    }

    @Override
    @JRubyMethod(name={"eql?", "==", "==="}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '=');
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '<');
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'L');
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '>');
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'G');
    }

    @JRubyMethod
    public IRubyObject abs() {
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), 1);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod
    public IRubyObject ceil(ThreadContext context, IRubyObject arg2) {
        this.checkFloatDomain();
        int n = RubyNumeric.fix2int(arg2);
        if (this.value.scale() <= n) {
            return this;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.CEILING));
    }

    @JRubyMethod
    public IRubyObject ceil(ThreadContext context) {
        this.checkFloatDomain();
        BigInteger ceil2 = this.value.setScale(0, RoundingMode.CEILING).toBigInteger();
        if (ceil2.compareTo(BigInteger.valueOf(ceil2.intValue())) == 0) {
            return RubyInteger.int2fix(context.runtime, ceil2.intValue());
        }
        return RubyBignum.newBignum(context.runtime, ceil2);
    }

    @Override
    public IRubyObject coerce(IRubyObject other) {
        return this.coerce(this.getRuntime().getCurrentContext(), other);
    }

    @JRubyMethod
    public RubyArray coerce(ThreadContext context, IRubyObject other) {
        return context.runtime.newArray((IRubyObject)RubyBigDecimal.getVpValue(context, other, true), (IRubyObject)this);
    }

    @Override
    public double getDoubleValue() {
        return SafeDoubleParser.doubleValue(this.value);
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public int getIntValue() {
        return this.value.intValue();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.value.toBigInteger();
    }

    public BigDecimal getBigDecimalValue() {
        return this.value;
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyInteger value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyFloat value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyBignum value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    @Override
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        return this.divmod19(context, other);
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "divmod", other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newNaN(runtime), RubyBigDecimal.newNaN(runtime));
        }
        if (val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            int sign2 = this.infinitySign == val.value.signum() ? 1 : -1;
            return RubyArray.newArray(runtime, RubyBigDecimal.newInfinity(runtime, sign2), RubyBigDecimal.newNaN(runtime));
        }
        if (val.isInfinity()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newZero(runtime, val.value.signum()), this);
        }
        if (this.isZero()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newZero(runtime, this.value.signum()), RubyBigDecimal.newZero(runtime, this.value.signum()));
        }
        BigDecimal[] divmod2 = this.value.divideAndRemainder(val.value);
        BigDecimal div = divmod2[0];
        BigDecimal mod = divmod2[1];
        if (mod.signum() * val.value.signum() < 0) {
            div = div.subtract(BigDecimal.ONE);
            mod = mod.add(val.value);
        }
        return RubyArray.newArray(runtime, new RubyBigDecimal(runtime, div), new RubyBigDecimal(runtime, mod));
    }

    @JRubyMethod
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.getExponent());
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        return this.getRuntime().newBoolean(!this.isNaN() && !this.isInfinity());
    }

    private void floorNaNInfinityCheck(Ruby runtime) {
        if (this.isNaN() || this.isInfinity()) {
            throw runtime.newFloatDomainError("Computation results to '" + this.to_s(NULL_ARRAY).asJavaString() + "'");
        }
    }

    private RubyBigDecimal floorInternal(ThreadContext context, int n) {
        return this.value.scale() > n ? new RubyBigDecimal(context.runtime, this.value.setScale(n, RoundingMode.FLOOR)) : this;
    }

    @JRubyMethod
    public IRubyObject floor(ThreadContext context) {
        this.floorNaNInfinityCheck(context.runtime);
        return this.floorInternal(context, 0).to_int();
    }

    @JRubyMethod
    public IRubyObject floor(ThreadContext context, IRubyObject arg2) {
        this.floorNaNInfinityCheck(context.runtime);
        return this.floorInternal(context, RubyNumeric.fix2int(arg2));
    }

    @JRubyMethod
    public IRubyObject frac(ThreadContext context) {
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(context.runtime, this.infinitySign);
        }
        if (this.value.scale() > 0 && this.value.precision() < this.value.scale()) {
            return new RubyBigDecimal(context.runtime, this.value);
        }
        return new RubyBigDecimal(context.runtime, this.value.subtract(((RubyBigDecimal)this.fix()).value));
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p(ThreadContext context) {
        return this.infinitySign == 0 ? context.runtime.getNil() : context.runtime.newFixnum(this.infinitySign);
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder val = new StringBuilder("#<BigDecimal:");
        val.append(Integer.toHexString(System.identityHashCode(this))).append(",");
        val.append("'").append(this.callMethod(context, "to_s")).append("'").append(",");
        val.append(this.getSignificantDigits().length()).append("(");
        val.append((this.getAllDigits().length() / 4 + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isNaN());
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        return this.isZero() ? this.getRuntime().getNil() : this;
    }

    @JRubyMethod
    public IRubyObject precs(ThreadContext context) {
        return RubyArray.newArrayNoCopy(context.runtime, new IRubyObject[]{context.runtime.newFixnum(this.getSignificantDigits().length()), context.runtime.newFixnum((this.getAllDigits().length() / 4 + 1) * 4)});
    }

    @JRubyMethod(name={"round"}, optional=2)
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        RubyBigDecimal bigDecimal;
        RoundingMode mode2;
        int scale;
        int n = scale = args2.length > 0 ? RubyBigDecimal.num2int(args2[0]) : 0;
        if (scale == 0 && (this.isNaN() || this.isInfinity())) {
            StringBuilder message2 = new StringBuilder("Computation results to ");
            message2.append("'").append(this.callMethod(context, "to_s")).append("'");
            if (this.isNaN()) {
                message2.append("(Not a Number)");
            }
            throw this.getRuntime().newFloatDomainError(message2.toString());
        }
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(context.runtime, this.infinitySign);
        }
        RoundingMode roundingMode = mode2 = args2.length > 1 ? RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context.runtime, args2[1]) : RubyBigDecimal.getRoundingMode(context.runtime);
        if (scale < 0) {
            BigDecimal normalized = this.value.movePointRight(scale);
            BigDecimal rounded = normalized.setScale(0, mode2);
            bigDecimal = new RubyBigDecimal(this.getRuntime(), rounded.movePointLeft(scale));
        } else {
            bigDecimal = new RubyBigDecimal(this.getRuntime(), this.value.setScale(scale, mode2));
        }
        if (args2.length == 0) {
            return bigDecimal.to_int();
        }
        return bigDecimal;
    }

    public IRubyObject round(ThreadContext context, IRubyObject scale, IRubyObject mode2) {
        return this.round(context, new IRubyObject[]{scale, mode2});
    }

    private static RoundingMode javaRoundingModeFromRubyRoundingMode(Ruby runtime, IRubyObject arg2) {
        if (arg2 instanceof RubySymbol) {
            RubySymbol roundingModeSymbol = (RubySymbol)arg2;
            String roundingModeString = roundingModeSymbol.asJavaString();
            if (roundingModeString.equals("up")) {
                return RoundingMode.UP;
            }
            if (roundingModeString.equals("down") || roundingModeString.equals("truncate")) {
                return RoundingMode.DOWN;
            }
            if (roundingModeString.equals("half_up") || roundingModeString.equals("default")) {
                return RoundingMode.HALF_UP;
            }
            if (roundingModeString.equals("half_down")) {
                return RoundingMode.HALF_DOWN;
            }
            if (roundingModeString.equals("half_even") || roundingModeString.equals("banker")) {
                return RoundingMode.HALF_EVEN;
            }
            if (roundingModeString.equals("ceiling") || roundingModeString.equals("ceil")) {
                return RoundingMode.CEILING;
            }
            if (roundingModeString.equals("floor")) {
                return RoundingMode.FLOOR;
            }
            throw runtime.newArgumentError("invalid rounding mode");
        }
        try {
            return RoundingMode.valueOf(RubyBigDecimal.num2int(arg2));
        }
        catch (IllegalArgumentException iae) {
            throw runtime.newArgumentError("invalid rounding mode");
        }
    }

    @JRubyMethod
    public IRubyObject sign() {
        if (this.isNaN()) {
            return this.getMetaClass().getConstant("SIGN_NaN");
        }
        if (this.isInfinity()) {
            return this.getMetaClass().getConstant(this.infinitySign < 0 ? "SIGN_NEGATIVE_INFINITE" : "SIGN_POSITIVE_INFINITE");
        }
        if (this.isZero()) {
            return this.getMetaClass().getConstant(this.zeroSign < 0 ? "SIGN_NEGATIVE_ZERO" : "SIGN_POSITIVE_ZERO");
        }
        return this.getMetaClass().getConstant(this.value.signum() < 0 ? "SIGN_NEGATIVE_FINITE" : "SIGN_POSITIVE_FINITE");
    }

    private RubyFixnum signValue(Ruby runtime) {
        if (this.isNaN()) {
            return RubyFixnum.zero(runtime);
        }
        if (this.isInfinity()) {
            return runtime.newFixnum(this.infinitySign);
        }
        if (this.isZero()) {
            return runtime.newFixnum(this.zeroSign);
        }
        return runtime.newFixnum(this.value.signum());
    }

    @JRubyMethod
    public RubyArray split(ThreadContext context) {
        return RubyArray.newArrayNoCopy(context.runtime, new IRubyObject[]{this.signValue(context.runtime), context.runtime.newString(this.splitDigits()), context.runtime.newFixnum(10), this.exponent()});
    }

    private String splitDigits() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInfinity()) {
            return "Infinity";
        }
        if (this.isZero()) {
            return "0";
        }
        return this.getSignificantDigits();
    }

    private String getSignificantDigits() {
        return this.value.abs().stripTrailingZeros().unscaledValue().toString();
    }

    private String getAllDigits() {
        return this.value.abs().unscaledValue().toString();
    }

    private int getExponent() {
        if (this.isZero() || this.isNaN() || this.isInfinity()) {
            return 0;
        }
        BigDecimal val = this.value.abs().stripTrailingZeros();
        return val.precision() - val.scale();
    }

    @JRubyMethod
    public IRubyObject sqrt(IRubyObject arg2) {
        Ruby runtime = this.getRuntime();
        if (this.isNaN()) {
            throw runtime.newFloatDomainError("(VpSqrt) SQRT(NaN value)");
        }
        if (this.isInfinity() && this.infinitySign < 0 || this.value.signum() < 0) {
            throw runtime.newFloatDomainError("(VpSqrt) SQRT(negative value)");
        }
        if (this.isInfinity() && this.infinitySign > 0) {
            return RubyBigDecimal.newInfinity(runtime, 1);
        }
        int n = RubyNumeric.fix2int(arg2);
        if (n < 0) {
            throw runtime.newArgumentError("argument must be positive");
        }
        return new RubyBigDecimal(runtime, RubyBigDecimal.bigSqrt(this.value, new MathContext(n += 4, RoundingMode.HALF_UP))).setResult();
    }

    @JRubyMethod
    public IRubyObject to_f() {
        if (this.isNaN()) {
            return RubyFloat.newFloat(this.getRuntime(), Double.NaN);
        }
        if (this.isInfinity()) {
            return RubyFloat.newFloat(this.getRuntime(), this.infinitySign < 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (this.isZero()) {
            return RubyFloat.newFloat(this.getRuntime(), this.zeroSign < 0 ? -0.0 : 0.0);
        }
        if (-this.value.scale() <= 308) {
            return RubyFloat.newFloat(this.getRuntime(), SafeDoubleParser.doubleValue(this.value));
        }
        switch (this.value.signum()) {
            case -1: {
                return RubyFloat.newFloat(this.getRuntime(), Double.NEGATIVE_INFINITY);
            }
            case 0: {
                return RubyFloat.newFloat(this.getRuntime(), 0.0);
            }
            case 1: {
                return RubyFloat.newFloat(this.getRuntime(), Double.POSITIVE_INFINITY);
            }
        }
        throw this.getRuntime().newArgumentError("signum of this rational is invalid: " + this.value.signum());
    }

    @JRubyMethod(name={"to_i", "to_int"})
    public IRubyObject to_int() {
        this.checkFloatDomain();
        try {
            return RubyNumeric.int2fix(this.getRuntime(), this.value.longValueExact());
        }
        catch (ArithmeticException ae) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.toBigInteger());
        }
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        IRubyObject den;
        IRubyObject num;
        this.checkFloatDomain();
        RubyArray i2 = this.split(context);
        long sign2 = (Long)i2.get(0);
        String digits = i2.get(1).toString();
        long base = (Long)i2.get(2);
        long power = (Long)i2.get(3);
        long denomi_power = power - (long)digits.length();
        IRubyObject bigDigits = RubyBignum.newBignum(this.getRuntime(), digits).op_mul(context, sign2);
        RubyBignum numerator2 = bigDigits instanceof RubyBignum ? (RubyBignum)bigDigits : RubyBignum.newBignum(this.getRuntime(), bigDigits.toString());
        if (denomi_power < 0L) {
            num = numerator2;
            den = RubyFixnum.newFixnum(this.getRuntime(), base).op_mul(context, RubyFixnum.newFixnum(this.getRuntime(), -denomi_power));
        } else {
            num = numerator2.op_pow(context, RubyFixnum.newFixnum(this.getRuntime(), base).op_mul(context, RubyFixnum.newFixnum(this.getRuntime(), denomi_power)));
            den = RubyFixnum.newFixnum(this.getRuntime(), 1L);
        }
        return RubyRational.newInstance(context, context.runtime.getRational(), num, den);
    }

    public IRubyObject to_int19() {
        return this.to_int();
    }

    private String removeTrailingZeroes(String in) {
        while (in.length() > 0 && in.charAt(in.length() - 1) == '0') {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public static boolean formatHasLeadingPlus(String format) {
        return format.startsWith("+");
    }

    public static boolean formatHasLeadingSpace(String format) {
        return format.startsWith(" ");
    }

    public static boolean formatHasFloatingPointNotation(String format) {
        return format.endsWith("F");
    }

    public static int formatFractionalDigitGroups(String format) {
        Matcher m = Pattern.compile("(\\+| )?(\\d+)(E|F)?").matcher(format);
        return m.matches() ? Integer.parseInt(m.group(2)) : 0;
    }

    private static String firstArgument(IRubyObject[] args2) {
        if (args2.length == 0) {
            return null;
        }
        IRubyObject arg2 = args2[0];
        return arg2.isNil() ? null : arg2.toString();
    }

    private static boolean posSpace(String arg2) {
        if (arg2 == null) {
            return false;
        }
        return RubyBigDecimal.formatHasLeadingSpace(arg2);
    }

    private static boolean posSign(String arg2) {
        if (arg2 == null) {
            return false;
        }
        return RubyBigDecimal.formatHasLeadingPlus(arg2) || RubyBigDecimal.posSpace(arg2);
    }

    private static boolean asEngineering(String arg2) {
        if (arg2 == null) {
            return true;
        }
        return !RubyBigDecimal.formatHasFloatingPointNotation(arg2);
    }

    private static int groups(String arg2) {
        if (arg2 == null) {
            return 0;
        }
        return RubyBigDecimal.formatFractionalDigitGroups(arg2);
    }

    private boolean isZero() {
        return !this.isNaN() && !this.isInfinity() && this.value.signum() == 0;
    }

    private boolean isOne() {
        return this.value.abs().compareTo(BigDecimal.ONE) == 0;
    }

    private boolean isNaN() {
        return this.isNaN;
    }

    private boolean isInfinity() {
        return this.infinitySign != 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private String sign(String arg2, int signum) {
        return signum == -1 ? "-" : (signum == 1 ? (RubyBigDecimal.posSign(arg2) ? (RubyBigDecimal.posSpace(arg2) ? " " : "+") : "") : "");
    }

    private CharSequence engineeringValue(String arg2) {
        StringBuilder build = new StringBuilder();
        build.append(this.sign(arg2, this.value.signum())).append("0.");
        String s2 = this.removeTrailingZeroes(this.unscaledValue());
        if (RubyBigDecimal.groups(arg2) == 0) {
            build.append("".equals(s2) ? "0" : s2);
        } else {
            int length2 = s2.length();
            String sep = "";
            for (int index2 = 0; index2 < length2; index2 += RubyBigDecimal.groups(arg2)) {
                int next2 = index2 + RubyBigDecimal.groups(arg2);
                build.append(sep).append(s2.substring(index2, next2 > length2 ? length2 : next2));
                sep = " ";
            }
        }
        build.append('E').append(this.getExponent());
        return build;
    }

    private CharSequence floatingPointValue(String arg2) {
        String[] values2 = this.value.abs().stripTrailingZeros().toPlainString().split("\\.");
        String whole = values2.length > 0 ? values2[0] : "0";
        String after = values2.length > 1 ? values2[1] : "0";
        StringBuilder build = new StringBuilder().append(this.sign(arg2, this.value.signum()));
        if (RubyBigDecimal.groups(arg2) == 0) {
            build.append(whole);
            if (after != null) {
                build.append(".").append(after);
            }
        } else {
            int next2;
            int index2;
            String sep = "";
            for (index2 = 0; index2 < whole.length(); index2 += RubyBigDecimal.groups(arg2)) {
                next2 = index2 + RubyBigDecimal.groups(arg2);
                if (next2 > whole.length()) {
                    next2 = whole.length();
                }
                build.append(sep).append(whole.substring(index2, next2));
                sep = " ";
            }
            if (null != after) {
                build.append(".");
                sep = "";
                for (index2 = 0; index2 < after.length(); index2 += RubyBigDecimal.groups(arg2)) {
                    next2 = index2 + RubyBigDecimal.groups(arg2);
                    if (next2 > after.length()) {
                        next2 = after.length();
                    }
                    build.append(sep).append(after.substring(index2, next2));
                    sep = " ";
                }
            }
        }
        return build;
    }

    @JRubyMethod(optional=1)
    public IRubyObject to_s(IRubyObject[] args2) {
        if (this.isNaN()) {
            return this.getRuntime().newString("NaN");
        }
        if (this.isInfinity()) {
            return this.getRuntime().newString(this.infinityString());
        }
        if (this.isZero()) {
            return this.getRuntime().newString(this.zeroSign < 0 ? "-0.0" : "0.0");
        }
        String arg2 = RubyBigDecimal.firstArgument(args2);
        return this.getRuntime().newString((RubyBigDecimal.asEngineering(arg2) ? this.engineeringValue(arg2) : this.floatingPointValue(arg2)).toString());
    }

    @JRubyMethod
    public IRubyObject fix() {
        return this.truncateInternal(0);
    }

    private RubyBigDecimal truncateInternal(int arg2) {
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int precision = this.value.precision() - this.value.scale() + arg2;
        if (precision > 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.round(new MathContext(precision, RoundingMode.DOWN)));
        }
        return new RubyBigDecimal(this.getRuntime(), BigDecimal.ZERO);
    }

    @JRubyMethod
    public IRubyObject truncate(ThreadContext context) {
        return this.truncateInternal(0).to_int();
    }

    @JRubyMethod
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        return this.truncateInternal(RubyNumeric.fix2int(arg2));
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.isZero());
    }

    public static BigDecimal bigSqrt(BigDecimal squarD, MathContext rootMC) {
        int biLen;
        int sign2 = squarD.signum();
        if (sign2 == -1) {
            throw new ArithmeticException("Square root of a negative number: " + squarD);
        }
        if (sign2 == 0) {
            return squarD.round(rootMC);
        }
        int prec = rootMC.getPrecision();
        if (prec == 0) {
            throw new IllegalArgumentException("Most roots won't have infinite precision = 0");
        }
        int BITS = 62;
        int nInit = 16;
        MathContext nMC = new MathContext(18, RoundingMode.HALF_DOWN);
        BigInteger bi = squarD.unscaledValue();
        int shift2 = Math.max(0, biLen - BITS + ((biLen = bi.bitLength()) % 2 == 0 ? 0 : 1));
        bi = bi.shiftRight(shift2);
        double root = Math.sqrt(SafeDoubleParser.doubleValue(bi));
        BigDecimal halfBack = new BigDecimal(BigInteger.ONE.shiftLeft(shift2 / 2));
        int scale = squarD.scale();
        if (scale % 2 == 1) {
            root *= 3.1622776601683795;
        }
        scale = (int)Math.ceil((double)scale / 2.0);
        BigDecimal x = new BigDecimal(root, nMC);
        x = x.multiply(halfBack, nMC);
        if (scale != 0) {
            x = x.movePointLeft(scale);
        }
        if (prec < nInit) {
            return x.round(rootMC);
        }
        BigDecimal v = BigDecimal.ONE.divide(TWO.multiply(x), nMC);
        ArrayList<Integer> nPrecs = new ArrayList<Integer>();
        assert (nInit > 3) : "Never ending loop!";
        int m = prec + 1;
        while (m > nInit) {
            nPrecs.add(m);
            m = m / 2 + (m > 100 ? 1 : 2);
        }
        for (int i2 = nPrecs.size() - 1; i2 > -1; --i2) {
            nMC = new MathContext((Integer)nPrecs.get(i2), i2 % 2 == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN);
            BigDecimal e = squarD.subtract(x.multiply(x, nMC), nMC);
            if (i2 == 0) {
                x = x.add(e.multiply(v, rootMC), rootMC);
                break;
            }
            x = x.add(e.multiply(v, nMC));
            BigDecimal g = BigDecimal.ONE.subtract(TWO.multiply(x).multiply(v, nMC));
            v = v.add(g.multiply(v, nMC));
        }
        return x;
    }

    private void checkFloatDomain() {
        if (this.isNaN()) {
            throw this.getRuntime().newFloatDomainError("NaN");
        }
        if (this.isInfinity()) {
            throw this.getRuntime().newFloatDomainError(this.infinityString());
        }
    }

    private String infinityString() {
        return this.infinitySign == -1 ? "-Infinity" : "Infinity";
    }

    private boolean is_even(IRubyObject x) {
        if (x instanceof RubyFixnum) {
            return RubyNumeric.fix2long((RubyFixnum)x) % 2L == 0L;
        }
        if (x instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)x) % 2L == 0L;
        }
        return false;
    }

    public static class BigDecimalKernelMethods {
        @JRubyMethod(name={"BigDecimal"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            if (args2.length == 1) {
                return RubyBigDecimal.newInstance(context, (IRubyObject)context.runtime.getClass("BigDecimal"), args2[0]);
            }
            return RubyBigDecimal.newInstance(context, (IRubyObject)context.runtime.getClass("BigDecimal"), args2[0], args2[1]);
        }
    }
}

