/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;

public class JavaUtil {
    public static final boolean CAN_SET_ACCESSIBLE;
    private static final Pattern RUBY_CASE_SPLITTER;
    private static final JavaConverter JAVA_DEFAULT_CONVERTER;
    private static final JavaConverter JAVA_BOOLEAN_CONVERTER;
    private static final JavaConverter JAVA_FLOAT_CONVERTER;
    private static final JavaConverter JAVA_DOUBLE_CONVERTER;
    private static final JavaConverter JAVA_CHAR_CONVERTER;
    private static final JavaConverter JAVA_BYTE_CONVERTER;
    private static final JavaConverter JAVA_SHORT_CONVERTER;
    private static final JavaConverter JAVA_INT_CONVERTER;
    private static final JavaConverter JAVA_LONG_CONVERTER;
    private static final JavaConverter JAVA_BOOLEANPRIM_CONVERTER;
    private static final JavaConverter JAVA_FLOATPRIM_CONVERTER;
    private static final JavaConverter JAVA_DOUBLEPRIM_CONVERTER;
    private static final JavaConverter JAVA_CHARPRIM_CONVERTER;
    private static final JavaConverter JAVA_BYTEPRIM_CONVERTER;
    private static final JavaConverter JAVA_SHORTPRIM_CONVERTER;
    private static final JavaConverter JAVA_INTPRIM_CONVERTER;
    private static final JavaConverter JAVA_LONGPRIM_CONVERTER;
    private static final JavaConverter JAVA_STRING_CONVERTER;
    private static final JavaConverter JAVA_CHARSEQUENCE_CONVERTER;
    private static final JavaConverter BYTELIST_CONVERTER;
    private static final JavaConverter JAVA_BIGINTEGER_CONVERTER;
    private static final Map<Class, JavaConverter> JAVA_CONVERTERS;
    private static final NumericConverter NUMERIC_TO_BYTE;
    private static final NumericConverter NUMERIC_TO_SHORT;
    private static final NumericConverter NUMERIC_TO_CHARACTER;
    private static final NumericConverter NUMERIC_TO_INTEGER;
    private static final NumericConverter NUMERIC_TO_LONG;
    private static final NumericConverter NUMERIC_TO_FLOAT;
    private static final NumericConverter NUMERIC_TO_DOUBLE;
    private static final NumericConverter NUMERIC_TO_BIGINTEGER;
    private static final NumericConverter NUMERIC_TO_OBJECT;
    private static final NumericConverter NUMERIC_TO_OTHER;
    private static final NumericConverter NUMERIC_TO_VOID;
    private static final Map<Class, NumericConverter> NUMERIC_CONVERTERS;
    public static final Map<String, Class> PRIMITIVE_CLASSES;
    @Deprecated
    public static final RubyConverter RUBY_BOOLEAN_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_BYTE_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_SHORT_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_CHAR_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_INTEGER_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_LONG_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_FLOAT_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_DOUBLE_CONVERTER;
    @Deprecated
    public static final Map<Class, RubyConverter> RUBY_CONVERTERS;
    @Deprecated
    public static final RubyConverter ARRAY_BOOLEAN_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_BYTE_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_SHORT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_CHAR_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_INT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_LONG_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_FLOAT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_DOUBLE_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_OBJECT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_CLASS_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_STRING_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_BIGINTEGER_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_BIGDECIMAL_CONVERTER;
    @Deprecated
    public static final Map<Class, RubyConverter> ARRAY_CONVERTERS;

    public static IRubyObject[] convertJavaArrayToRuby(Ruby runtime, Object[] objects) {
        if (objects == null || objects.length == 0) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] rubyObjects = new IRubyObject[objects.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            rubyObjects[i2] = JavaUtil.convertJavaToUsableRubyObject(runtime, objects[i2]);
        }
        return rubyObjects;
    }

    public static RubyArray convertJavaArrayToRubyWithNesting(ThreadContext context, Object array) {
        int length2 = Array.getLength(array);
        IRubyObject[] rubyElements = new IRubyObject[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            Object element = Array.get(array, i2);
            rubyElements[i2] = element instanceof ArrayJavaProxy ? JavaUtil.convertJavaArrayToRubyWithNesting(context, ((ArrayJavaProxy)element).getObject()) : (element != null && element.getClass().isArray() ? JavaUtil.convertJavaArrayToRubyWithNesting(context, element) : JavaUtil.convertJavaToUsableRubyObject(context.runtime, element));
        }
        return context.runtime.newArrayNoCopy(rubyElements);
    }

    public static JavaConverter getJavaConverter(Class clazz) {
        JavaConverter converter = JAVA_CONVERTERS.get(clazz);
        return converter == null ? JAVA_DEFAULT_CONVERTER : converter;
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object) {
        return JavaUtil.convertJavaToUsableRubyObject(runtime, object);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object, Class javaClass) {
        return JavaUtil.convertJavaToUsableRubyObjectWithConverter(runtime, object, JavaUtil.getJavaConverter(javaClass));
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, int i2) {
        return runtime.newFixnum(i2);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, long l) {
        return runtime.newFixnum(l);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, float f) {
        return runtime.newFloat(f);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, double d) {
        return runtime.newFloat(d);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, boolean b2) {
        return runtime.newBoolean(b2);
    }

    public static IRubyObject convertJavaToUsableRubyObject(Ruby runtime, Object object) {
        IRubyObject result2 = JavaUtil.trySimpleConversions(runtime, object);
        if (result2 != null) {
            return result2;
        }
        JavaConverter converter = JavaUtil.getJavaConverter(object.getClass());
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime, object);
        }
        return converter.convert(runtime, object);
    }

    public static IRubyObject convertJavaToUsableRubyObjectWithConverter(Ruby runtime, Object object, JavaConverter converter) {
        IRubyObject result2 = JavaUtil.trySimpleConversions(runtime, object);
        if (result2 != null) {
            return result2;
        }
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime, object);
        }
        return converter.convert(runtime, object);
    }

    public static IRubyObject convertJavaArrayElementToRuby(Ruby runtime, JavaConverter converter, Object array, int i2) {
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return JavaUtil.convertJavaToUsableRubyObject(runtime, ((Object[])array)[i2]);
        }
        return converter.get(runtime, array, i2);
    }

    public static Class<?> primitiveToWrapper(Class<?> type2) {
        return type2.isPrimitive() ? CodegenUtils.getBoxType(type2) : type2;
    }

    public static boolean isDuckTypeConvertable(Class<?> argumentType, Class<?> targetType) {
        return targetType.isInterface() && !targetType.isAssignableFrom(argumentType) && RubyObject.class.isAssignableFrom(argumentType);
    }

    public static <T> T convertProcToInterface(ThreadContext context, RubyObject rubyObject, Class<T> targetType) {
        return JavaUtil.convertProcToInterface(context, (RubyBasicObject)rubyObject, targetType);
    }

    public static <T> T convertProcToInterface(ThreadContext context, RubyBasicObject rubyObject, Class<T> targetType) {
        Ruby runtime = context.runtime;
        RubyModule ifaceModule = Java.getInterfaceModule(runtime, JavaClass.get(runtime, targetType));
        if (!ifaceModule.isInstance(rubyObject)) {
            ifaceModule.callMethod(context, "extend_object", (IRubyObject)rubyObject);
            ifaceModule.callMethod(context, "extended", (IRubyObject)rubyObject);
        }
        if (rubyObject instanceof RubyProc) {
            RubyClass singletonClass = rubyObject.getSingletonClass();
            Java.ProcToInterface procToIface = new Java.ProcToInterface(singletonClass);
            singletonClass.addMethod("method_missing", procToIface);
            for (Method method : targetType.getMethods()) {
                Java.ProcToInterface.ConcreteMethod implMethod = procToIface.getConcreteMethod(method.getName());
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                singletonClass.addMethodInternal(method.getName(), implMethod);
            }
        }
        JavaObject javaObject = (JavaObject)Helpers.invoke(context, rubyObject, "__jcreate_meta!");
        return (T)javaObject.getValue();
    }

    public static NumericConverter getNumericConverter(Class target) {
        NumericConverter converter = NUMERIC_CONVERTERS.get(target);
        return converter == null ? NUMERIC_TO_OTHER : converter;
    }

    public static boolean isJavaObject(IRubyObject object) {
        return object instanceof JavaProxy || object.dataGetStruct() instanceof JavaObject;
    }

    public static <T> T unwrapJavaObject(IRubyObject object) {
        if (object instanceof JavaProxy) {
            return (T)((JavaProxy)object).getObject();
        }
        return (T)((JavaObject)object.dataGetStruct()).getValue();
    }

    public static <T> T unwrapIfJavaObject(IRubyObject object) {
        if (object instanceof JavaProxy) {
            return (T)((JavaProxy)object).getObject();
        }
        Object unwrap = object.dataGetStruct();
        if (unwrap instanceof JavaObject) {
            return (T)((JavaObject)unwrap).getValue();
        }
        return (T)object;
    }

    @Deprecated
    public static Object unwrapJavaValue(Ruby runtime, IRubyObject object, String errorMessage) {
        if (object instanceof JavaProxy) {
            return ((JavaProxy)object).getObject();
        }
        if (object instanceof JavaObject) {
            return ((JavaObject)object).getValue();
        }
        Object unwrap = object.dataGetStruct();
        if (unwrap instanceof IRubyObject) {
            return JavaUtil.unwrapJavaValue(runtime, (IRubyObject)unwrap, errorMessage);
        }
        throw runtime.newTypeError(errorMessage);
    }

    public static Object unwrapJavaValue(IRubyObject object) {
        if (object instanceof JavaProxy) {
            return ((JavaProxy)object).getObject();
        }
        if (object instanceof JavaObject) {
            return ((JavaObject)object).getValue();
        }
        Object unwrap = object.dataGetStruct();
        if (unwrap instanceof IRubyObject) {
            return JavaUtil.unwrapJavaValue((IRubyObject)unwrap);
        }
        return null;
    }

    public static String getJavaPropertyName(String beanMethodName) {
        char ch;
        boolean maybeGetOrSet;
        int length2 = beanMethodName.length();
        boolean bl = maybeGetOrSet = length2 > 3 && beanMethodName.charAt(2) == 't';
        if (maybeGetOrSet && (beanMethodName.startsWith("get") || beanMethodName.startsWith("set"))) {
            char ch2 = beanMethodName.charAt(3);
            if (JavaUtil.isUpperDigit(ch2)) {
                if (length2 == 4) {
                    return Character.toString(Character.toLowerCase(ch2));
                }
                return Character.toLowerCase(ch2) + beanMethodName.substring(4);
            }
        } else if (beanMethodName.startsWith("is") && length2 > 2 && JavaUtil.isUpperDigit(ch = beanMethodName.charAt(2))) {
            if (length2 == 3) {
                return Character.toString(Character.toLowerCase(ch));
            }
            return Character.toLowerCase(ch) + beanMethodName.substring(3);
        }
        return null;
    }

    public static String toJavaGetName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        int len = propertyName.length();
        if (len == 0) {
            return null;
        }
        char first2 = Character.toUpperCase(propertyName.charAt(0));
        if (len == 1) {
            return "get" + first2;
        }
        return "get" + first2 + propertyName.substring(1);
    }

    public static String toJavaIsName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        int len = propertyName.length();
        if (len == 0) {
            return null;
        }
        char first2 = Character.toUpperCase(propertyName.charAt(0));
        if (len == 1) {
            return "is" + first2;
        }
        return "is" + first2 + propertyName.substring(1);
    }

    public static String getRubyCasedName(String javaCasedName) {
        char[] javaName = javaCasedName.toCharArray();
        int len = javaName.length;
        StringBuilder rubyName = new StringBuilder(len + 8);
        int behind = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (behind < 2) {
                ++behind;
                continue;
            }
            behind = JavaUtil.consume(rubyName, javaName, i2);
        }
        if (behind == 2) {
            char c1 = javaName[len - 1];
            char c2 = javaName[len - 2];
            rubyName.append(Character.toLowerCase(c2));
            if (Character.isUpperCase(c1) && !Character.isUpperCase(c2)) {
                rubyName.append('_');
            }
            rubyName.append(Character.toLowerCase(c1));
        } else if (behind > 0) {
            if (behind > 1) {
                rubyName.append(Character.toLowerCase(javaName[len - 2]));
            }
            rubyName.append(Character.toLowerCase(javaName[len - 1]));
        }
        return rubyName.toString();
    }

    private static int consume(StringBuilder rubyName, char[] javaName, int i2) {
        char cur;
        char prev1 = javaName[i2 - 1];
        char prev2 = javaName[i2 - 2];
        if (JavaUtil.isLowerDigit(prev2) && Character.isUpperCase(prev1)) {
            rubyName.append(prev2).append('_').append(Character.toLowerCase(prev1));
            return 1;
        }
        if (JavaUtil.isLetterDigit(prev2) && Character.isUpperCase(prev1) && Character.isLowerCase(cur = javaName[i2])) {
            rubyName.append(Character.toLowerCase(prev2)).append('_').append(Character.toLowerCase(prev1)).append(cur);
            return 0;
        }
        rubyName.append(Character.toLowerCase(prev2));
        return 2;
    }

    private static boolean isUpperDigit(char c) {
        return Character.isUpperCase(c) || Character.isDigit(c);
    }

    private static boolean isLowerDigit(char c) {
        return Character.isLowerCase(c) || Character.isDigit(c);
    }

    private static boolean isLetterDigit(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    public static String getJavaCasedName(String javaCasedName) {
        Matcher m = RUBY_CASE_SPLITTER.matcher(javaCasedName);
        StringBuffer newName = new StringBuffer();
        if (!m.find()) {
            return null;
        }
        m.reset();
        while (m.find()) {
            m.appendReplacement(newName, m.group(1) + Character.toUpperCase(m.group(2).charAt(0)));
        }
        m.appendTail(newName);
        return newName.toString();
    }

    public static Set<String> getRubyNamesForJavaName(String javaName, List<Method> methods2) {
        String javaPropertyName = JavaUtil.getJavaPropertyName(javaName);
        String rubyName = JavaUtil.getRubyCasedName(javaName);
        int len = methods2.size();
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>(6 * len + 2, 1.0f);
        nameSet.add(javaName);
        nameSet.add(rubyName);
        if (len == 1) {
            JavaUtil.addRubyNamesForJavaName(javaName, methods2.get(0), javaPropertyName, rubyName, nameSet);
        } else {
            for (int i2 = 0; i2 < len; ++i2) {
                JavaUtil.addRubyNamesForJavaName(javaName, methods2.get(i2), javaPropertyName, rubyName, nameSet);
            }
        }
        return nameSet;
    }

    private static void addRubyNamesForJavaName(String javaName, Method method, String javaPropertyName, String rubyName, LinkedHashSet<String> nameSet) {
        Class<?> resultType = method.getReturnType();
        if (javaPropertyName != null) {
            boolean maybeGetOrSet_;
            Class<?>[] argTypes = method.getParameterTypes();
            int argCount = argTypes.length;
            boolean bl = maybeGetOrSet_ = rubyName.length() > 3 && rubyName.charAt(3) == '_';
            if (maybeGetOrSet_ && rubyName.startsWith("get")) {
                if (argCount == 0 || argCount == 1 && argTypes[0] == Integer.TYPE) {
                    String rubyPropertyName = rubyName.substring(4);
                    nameSet.add(javaPropertyName);
                    nameSet.add(rubyPropertyName);
                    if (resultType == Boolean.TYPE) {
                        nameSet.add(javaPropertyName + '?');
                        nameSet.add(rubyPropertyName + '?');
                    }
                }
            } else if (maybeGetOrSet_ && rubyName.startsWith("set")) {
                if (argCount == 1 && resultType == Void.TYPE) {
                    String rubyPropertyName = rubyName.substring(4);
                    nameSet.add(javaPropertyName + '=');
                    nameSet.add(rubyPropertyName + '=');
                }
            } else if (rubyName.startsWith("is_") && resultType == Boolean.TYPE) {
                String rubyPropertyName = rubyName.substring(3);
                nameSet.add(javaPropertyName);
                nameSet.add(rubyPropertyName);
                nameSet.add(javaPropertyName + '?');
                nameSet.add(rubyPropertyName + '?');
            }
        } else if (resultType == Boolean.TYPE) {
            nameSet.add(javaName + '?');
            nameSet.add(rubyName + '?');
        }
    }

    public static Object[] convertArguments(IRubyObject[] args2, Class<?>[] types) {
        return JavaUtil.convertArguments(args2, types, 0);
    }

    public static Object[] convertArguments(IRubyObject[] args2, Class<?>[] types, int offset2) {
        Object[] arguments = new Object[args2.length - offset2];
        int i2 = arguments.length;
        while (--i2 >= 0) {
            arguments[i2] = args2[i2 + offset2].toJava(types[i2]);
        }
        return arguments;
    }

    public static <T> T clone(Object object) {
        return (T)JavaUtil.clone(object, false);
    }

    static Object clone(Object object, boolean silent) {
        try {
            Method clone2 = object.getClass().getMethod("clone", new Class[0]);
            return clone2.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (!silent) {
                Helpers.throwException(e.getTargetException());
            }
            return null;
        }
    }

    private static IRubyObject trySimpleConversions(Ruby runtime, Object object) {
        InternalJavaProxy internalJavaProxy;
        IRubyObject orig;
        if (object == null) {
            return runtime.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        if (object instanceof RubyObjectHolderProxy) {
            return ((RubyObjectHolderProxy)object).__ruby_object();
        }
        if (object instanceof InternalJavaProxy && (orig = (internalJavaProxy = (InternalJavaProxy)object).___getInvocationHandler().getOrig()) != null) {
            return orig;
        }
        return null;
    }

    private static boolean isDoubleFloatable(double value2) {
        return true;
    }

    private static boolean isLongByteable(long value2) {
        return value2 >= -128L && value2 <= 127L;
    }

    private static boolean isLongShortable(long value2) {
        return value2 >= -32768L && value2 <= 32767L;
    }

    private static boolean isLongCharable(long value2) {
        return value2 >= 0L && value2 <= 65535L;
    }

    private static boolean isLongIntable(long value2) {
        return value2 >= Integer.MIN_VALUE && value2 <= Integer.MAX_VALUE;
    }

    public static Object objectFromJavaProxy(IRubyObject self2) {
        return ((JavaProxy)self2).getObject();
    }

    public static Class<?> getPrimitiveClass(String name2) {
        switch (name2) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return null;
    }

    @Deprecated
    public static Object convertRubyToJava(IRubyObject rubyObject) {
        return JavaUtil.convertRubyToJava(rubyObject, Object.class);
    }

    @Deprecated
    public static Object convertRubyToJava(IRubyObject rubyObject, Class javaClass) {
        if (javaClass == Void.TYPE || rubyObject == null || rubyObject.isNil()) {
            return null;
        }
        Ruby runtime = rubyObject.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject origObject = rubyObject;
        if (rubyObject.dataGetStruct() instanceof JavaObject) {
            if ((rubyObject = (IRubyObject)rubyObject.dataGetStruct()) == null) {
                throw new RuntimeException("dataGetStruct returned null for " + origObject.getType().getName());
            }
        } else if (rubyObject.respondsTo("java_object") && (rubyObject = rubyObject.callMethod(context, "java_object")) == null) {
            throw new RuntimeException("java_object returned null for " + origObject.getType().getName());
        }
        if (rubyObject instanceof JavaObject) {
            Object value2 = ((JavaObject)rubyObject).getValue();
            return JavaUtil.convertArgument(runtime, value2, value2.getClass());
        }
        if (javaClass == Object.class || javaClass == null) {
            javaClass = rubyObject.getJavaClass();
        }
        if (javaClass.isInstance(rubyObject)) {
            return rubyObject;
        }
        RubyConverter converter = RUBY_CONVERTERS.get(javaClass);
        if (converter != null) {
            return converter.convert(context, rubyObject);
        }
        if (javaClass.isPrimitive()) {
            String s2 = ((RubyString)TypeConverter.convertToType(rubyObject, runtime.getString(), "to_s", true)).getUnicodeValue();
            if (s2.length() > 0) {
                return Character.valueOf(s2.charAt(0));
            }
            return Character.valueOf('\u0000');
        }
        if (javaClass == String.class) {
            RubyString rubyString = (RubyString)rubyObject.callMethod(context, "to_s");
            ByteList bytes2 = rubyString.getByteList();
            return RubyEncoding.decodeUTF8(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        if (javaClass == ByteList.class) {
            return rubyObject.convertToString().getByteList();
        }
        if (javaClass == BigInteger.class) {
            if (rubyObject instanceof RubyBignum) {
                return ((RubyBignum)rubyObject).getValue();
            }
            if (rubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)rubyObject).getLongValue());
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyNumeric rubyNumeric = (RubyNumeric)rubyObject.callMethod(context, "to_f");
                return BigInteger.valueOf(rubyNumeric.getLongValue());
            }
        }
        if (javaClass == BigDecimal.class && !(rubyObject instanceof JavaObject) && rubyObject.respondsTo("to_f")) {
            double double_value = ((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue();
            return new BigDecimal(double_value);
        }
        try {
            if (JavaUtil.isDuckTypeConvertable(rubyObject.getClass(), javaClass)) {
                return JavaUtil.convertProcToInterface(context, (RubyObject)rubyObject, javaClass);
            }
            return ((JavaObject)rubyObject).getValue();
        }
        catch (ClassCastException ex) {
            if (runtime.getDebug().isTrue()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    @Deprecated
    public static byte convertRubyToJavaByte(IRubyObject rubyObject) {
        return (Byte)JavaUtil.convertRubyToJava(rubyObject, Byte.TYPE);
    }

    @Deprecated
    public static short convertRubyToJavaShort(IRubyObject rubyObject) {
        return (Short)JavaUtil.convertRubyToJava(rubyObject, Short.TYPE);
    }

    @Deprecated
    public static char convertRubyToJavaChar(IRubyObject rubyObject) {
        return ((Character)JavaUtil.convertRubyToJava(rubyObject, Character.TYPE)).charValue();
    }

    @Deprecated
    public static int convertRubyToJavaInt(IRubyObject rubyObject) {
        return (Integer)JavaUtil.convertRubyToJava(rubyObject, Integer.TYPE);
    }

    @Deprecated
    public static long convertRubyToJavaLong(IRubyObject rubyObject) {
        return (Long)JavaUtil.convertRubyToJava(rubyObject, Long.TYPE);
    }

    @Deprecated
    public static float convertRubyToJavaFloat(IRubyObject rubyObject) {
        return ((Float)JavaUtil.convertRubyToJava(rubyObject, Float.TYPE)).floatValue();
    }

    @Deprecated
    public static double convertRubyToJavaDouble(IRubyObject rubyObject) {
        return (Double)JavaUtil.convertRubyToJava(rubyObject, Double.TYPE);
    }

    @Deprecated
    public static boolean convertRubyToJavaBoolean(IRubyObject rubyObject) {
        return (Boolean)JavaUtil.convertRubyToJava(rubyObject, Boolean.TYPE);
    }

    @Deprecated
    public static Object convertArgumentToType(ThreadContext context, IRubyObject arg2, Class target) {
        return arg2.toJava(target);
    }

    @Deprecated
    public static Object coerceNilToType(RubyNil nil, Class target) {
        return nil.toJava(target);
    }

    @Deprecated
    public static IRubyObject convertJavaToRuby(Ruby runtime, JavaConverter converter, Object object) {
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime, object);
        }
        return converter.convert(runtime, object);
    }

    @Deprecated
    public static RubyConverter getArrayConverter(Class type2) {
        RubyConverter converter = ARRAY_CONVERTERS.get(type2);
        if (converter == null) {
            return ARRAY_OBJECT_CONVERTER;
        }
        return converter;
    }

    @Deprecated
    public static IRubyObject ruby_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        if (object.respondsTo("to_java_object")) {
            IRubyObject result2 = (IRubyObject)object.dataGetStruct();
            if (result2 == null) {
                result2 = object.callMethod(recv2.getRuntime().getCurrentContext(), "to_java_object");
            }
            if (result2 instanceof JavaObject) {
                recv2.getRuntime().getJavaSupport().getObjectProxyCache().put(((JavaObject)result2).getValue(), object);
            }
            return result2;
        }
        return JavaUtil.primitive_to_java(recv2, object, unusedBlock);
    }

    @Deprecated
    public static IRubyObject java_to_primitive(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv2.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    @Deprecated
    public static IRubyObject primitive_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        Object javaObject;
        if (object instanceof JavaObject) {
            return object;
        }
        Ruby runtime = recv2.getRuntime();
        switch (object.getMetaClass().getClassIndex()) {
            case NIL: {
                javaObject = null;
                break;
            }
            case FIXNUM: {
                javaObject = ((RubyFixnum)object).getLongValue();
                break;
            }
            case BIGNUM: {
                javaObject = ((RubyBignum)object).getValue();
                break;
            }
            case FLOAT: {
                javaObject = new Double(((RubyFloat)object).getValue());
                break;
            }
            case STRING: {
                ByteList bytes2 = ((RubyString)object).getByteList();
                javaObject = RubyEncoding.decodeUTF8(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
                break;
            }
            case TRUE: {
                javaObject = Boolean.TRUE;
                break;
            }
            case FALSE: {
                javaObject = Boolean.FALSE;
                break;
            }
            case TIME: {
                javaObject = ((RubyTime)object).getJavaDate();
                break;
            }
            default: {
                return object;
            }
        }
        return JavaObject.wrap(runtime, javaObject);
    }

    @Deprecated
    public static Object convertArgument(Ruby runtime, Object argument, Class<?> parameterType) {
        RubyObject rubyObject;
        if (argument == null) {
            if (parameterType.isPrimitive()) {
                throw runtime.newTypeError("primitives do not accept null");
            }
            return null;
        }
        if (argument instanceof JavaObject && (argument = ((JavaObject)argument).getValue()) == null) {
            return null;
        }
        Class<?> type2 = JavaUtil.primitiveToWrapper(parameterType);
        if (argument.getClass() == type2) {
            return argument;
        }
        if (type2 == Void.class) {
            return null;
        }
        if (argument instanceof Number) {
            Number number = (Number)argument;
            if (type2 == Long.class) {
                return number.longValue();
            }
            if (type2 == Integer.class) {
                return number.intValue();
            }
            if (type2 == Byte.class) {
                return number.byteValue();
            }
            if (type2 == Character.class) {
                return Character.valueOf((char)number.intValue());
            }
            if (type2 == Double.class) {
                return number.doubleValue();
            }
            if (type2 == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (type2 == Short.class) {
                return number.shortValue();
            }
        }
        if (JavaUtil.isDuckTypeConvertable(argument.getClass(), parameterType) && !(rubyObject = (RubyObject)argument).respondsTo("java_object")) {
            return JavaUtil.convertProcToInterface(runtime.getCurrentContext(), rubyObject, parameterType);
        }
        return argument;
    }

    @Deprecated
    public static IRubyObject java_to_ruby(Ruby runtime, IRubyObject object) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToUsableRubyObject(runtime, ((JavaObject)object).getValue());
        }
        return object;
    }

    @Deprecated
    public static Object coerceStringToType(RubyString string2, Class target) {
        try {
            ByteList bytes2 = string2.getByteList();
            return new String(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length(), string2.getEncoding().toString());
        }
        catch (UnsupportedEncodingException uee) {
            return string2.toString();
        }
    }

    @Deprecated
    public static Object coerceOtherToType(ThreadContext context, IRubyObject arg2, Class target) {
        RubyObject rubyObject;
        if (JavaUtil.isDuckTypeConvertable(arg2.getClass(), target) && !(rubyObject = (RubyObject)arg2).respondsTo("java_object")) {
            return JavaUtil.convertProcToInterface(context, rubyObject, target);
        }
        return arg2;
    }

    @Deprecated
    public static Object coerceJavaObjectToType(ThreadContext context, Object javaObject, Class target) {
        if (javaObject != null && JavaUtil.isDuckTypeConvertable(javaObject.getClass(), target)) {
            RubyObject rubyObject = (RubyObject)javaObject;
            if (!rubyObject.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(context, rubyObject, target);
            }
            return javaObject;
        }
        return javaObject;
    }

    @Deprecated
    public static JavaObject unwrapJavaObject(Ruby runtime, IRubyObject convertee, String errorMessage) {
        IRubyObject obj = convertee;
        if (!(obj instanceof JavaObject)) {
            if (obj.dataGetStruct() != null && obj.dataGetStruct() instanceof JavaObject) {
                obj = (JavaObject)obj.dataGetStruct();
            } else {
                throw runtime.newTypeError(errorMessage);
            }
        }
        return (JavaObject)obj;
    }

    static {
        boolean canSetAccessible = false;
        if (RubyInstanceConfig.CAN_SET_ACCESSIBLE) {
            try {
                Field f = Java.class.getDeclaredField("HIDDEN_STATIC_FIELD");
                f.setAccessible(true);
                canSetAccessible = f.getByte(null) == 72;
            }
            catch (Exception t) {
                if (Options.JI_LOGCANSETACCESSIBLE.load().booleanValue()) {
                    t.printStackTrace();
                }
                canSetAccessible = false;
            }
        }
        CAN_SET_ACCESSIBLE = canSetAccessible;
        RUBY_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)_([a-z])");
        JAVA_DEFAULT_CONVERTER = new JavaConverter(Object.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                IRubyObject result2 = JavaUtil.trySimpleConversions(runtime, object);
                return result2 == null ? JavaObject.wrap(runtime, object) : result2;
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Object[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Object[])array)[i2] = value2.toJava(Object.class);
            }
        };
        JAVA_BOOLEAN_CONVERTER = new JavaConverter(Boolean.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyBoolean.newBoolean(runtime, (Boolean)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Boolean[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Boolean[])array)[i2] = (Boolean)value2.toJava(Boolean.class);
            }
        };
        JAVA_FLOAT_CONVERTER = new JavaConverter(Float.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, ((Float)object).doubleValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Float[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Float[])array)[i2] = (Float)value2.toJava(Float.class);
            }
        };
        JAVA_DOUBLE_CONVERTER = new JavaConverter(Double.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, (Double)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Double[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Double[])array)[i2] = (Double)value2.toJava(Double.class);
            }
        };
        JAVA_CHAR_CONVERTER = new JavaConverter(Character.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Character)object).charValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Character[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Character[])array)[i2] = (Character)value2.toJava(Character.class);
            }
        };
        JAVA_BYTE_CONVERTER = new JavaConverter(Byte.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Byte)object).byteValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Byte[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Byte[])array)[i2] = (Byte)value2.toJava(Byte.class);
            }
        };
        JAVA_SHORT_CONVERTER = new JavaConverter(Short.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Short)object).shortValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Short[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Short[])array)[i2] = (Short)value2.toJava(Short.class);
            }
        };
        JAVA_INT_CONVERTER = new JavaConverter(Integer.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Integer)object).intValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Integer[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Integer[])array)[i2] = (Integer)value2.toJava(Integer.class);
            }
        };
        JAVA_LONG_CONVERTER = new JavaConverter(Long.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, (Long)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((Long[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((Long[])array)[i2] = (Long)value2.toJava(Long.class);
            }
        };
        JAVA_BOOLEANPRIM_CONVERTER = new JavaConverter(Boolean.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyBoolean.newBoolean(runtime, (Boolean)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyBoolean.newBoolean(runtime, ((boolean[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((boolean[])array)[i2] = (Boolean)value2.toJava(Boolean.TYPE);
            }
        };
        JAVA_FLOATPRIM_CONVERTER = new JavaConverter(Float.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, ((Float)object).doubleValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyFloat.newFloat(runtime, ((float[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((float[])array)[i2] = ((Float)value2.toJava(Float.TYPE)).floatValue();
            }
        };
        JAVA_DOUBLEPRIM_CONVERTER = new JavaConverter(Double.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, (Double)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyFloat.newFloat(runtime, ((double[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((double[])array)[i2] = (Double)value2.toJava(Double.TYPE);
            }
        };
        JAVA_CHARPRIM_CONVERTER = new JavaConverter(Character.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Character)object).charValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyFixnum.newFixnum(runtime, ((char[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((char[])array)[i2] = ((Character)value2.toJava(Character.TYPE)).charValue();
            }
        };
        JAVA_BYTEPRIM_CONVERTER = new JavaConverter(Byte.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Byte)object).byteValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyFixnum.newFixnum(runtime, ((byte[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((byte[])array)[i2] = (Byte)value2.toJava(Byte.TYPE);
            }
        };
        JAVA_SHORTPRIM_CONVERTER = new JavaConverter(Short.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Short)object).shortValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyFixnum.newFixnum(runtime, ((short[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((short[])array)[i2] = (Short)value2.toJava(Short.TYPE);
            }
        };
        JAVA_INTPRIM_CONVERTER = new JavaConverter(Integer.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Integer)object).intValue());
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyFixnum.newFixnum(runtime, ((int[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((int[])array)[i2] = (Integer)value2.toJava(Integer.TYPE);
            }
        };
        JAVA_LONGPRIM_CONVERTER = new JavaConverter(Long.TYPE){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, (Long)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return RubyFixnum.newFixnum(runtime, ((long[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((long[])array)[i2] = (Long)value2.toJava(Long.TYPE);
            }
        };
        JAVA_STRING_CONVERTER = new JavaConverter(String.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyString.newUnicodeString(runtime, (String)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((String[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((String[])array)[i2] = (String)value2.toJava(String.class);
            }
        };
        JAVA_CHARSEQUENCE_CONVERTER = new JavaConverter(String.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyString.newUnicodeString(runtime, (CharSequence)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((CharSequence[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((CharSequence[])array)[i2] = (CharSequence)value2.toJava(CharSequence.class);
            }
        };
        BYTELIST_CONVERTER = new JavaConverter(ByteList.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyString.newString(runtime, (ByteList)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((ByteList[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((ByteList[])array)[i2] = (ByteList)value2.toJava(ByteList.class);
            }
        };
        JAVA_BIGINTEGER_CONVERTER = new JavaConverter(BigInteger.class){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyBignum.newBignum(runtime, (BigInteger)object);
            }

            @Override
            public IRubyObject get(Ruby runtime, Object array, int i2) {
                return this.convert(runtime, ((BigInteger[])array)[i2]);
            }

            @Override
            public void set(Ruby runtime, Object array, int i2, IRubyObject value2) {
                ((BigInteger[])array)[i2] = (BigInteger)value2.toJava(BigInteger.class);
            }
        };
        JAVA_CONVERTERS = new IdentityHashMap<Class, JavaConverter>(24);
        JAVA_CONVERTERS.put(Byte.class, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Byte.TYPE, JAVA_BYTEPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Short.class, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Short.TYPE, JAVA_SHORTPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Character.class, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Character.TYPE, JAVA_CHARPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Integer.class, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Integer.TYPE, JAVA_INTPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Long.class, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Long.TYPE, JAVA_LONGPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Float.class, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Float.TYPE, JAVA_FLOATPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Double.class, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Double.TYPE, JAVA_DOUBLEPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.class, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.TYPE, JAVA_BOOLEANPRIM_CONVERTER);
        JAVA_CONVERTERS.put(String.class, JAVA_STRING_CONVERTER);
        JAVA_CONVERTERS.put(CharSequence.class, JAVA_CHARSEQUENCE_CONVERTER);
        JAVA_CONVERTERS.put(ByteList.class, BYTELIST_CONVERTER);
        JAVA_CONVERTERS.put(BigInteger.class, JAVA_BIGINTEGER_CONVERTER);
        NUMERIC_TO_BYTE = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongByteable(value2)) {
                    return (byte)value2;
                }
                throw numeric.getRuntime().newRangeError("too big for byte: " + numeric);
            }
        };
        NUMERIC_TO_SHORT = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongShortable(value2)) {
                    return (short)value2;
                }
                throw numeric.getRuntime().newRangeError("too big for short: " + numeric);
            }
        };
        NUMERIC_TO_CHARACTER = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongCharable(value2)) {
                    return Character.valueOf((char)value2);
                }
                throw numeric.getRuntime().newRangeError("too big for char: " + numeric);
            }
        };
        NUMERIC_TO_INTEGER = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongIntable(value2)) {
                    return (int)value2;
                }
                throw numeric.getRuntime().newRangeError("too big for int: " + numeric);
            }
        };
        NUMERIC_TO_LONG = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                return numeric.getLongValue();
            }
        };
        NUMERIC_TO_FLOAT = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                double value2 = numeric.getDoubleValue();
                if (JavaUtil.isDoubleFloatable(value2)) {
                    return Float.valueOf((float)value2);
                }
                throw numeric.getRuntime().newTypeError("too big for float: " + numeric);
            }
        };
        NUMERIC_TO_DOUBLE = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                return numeric.getDoubleValue();
            }
        };
        NUMERIC_TO_BIGINTEGER = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                return numeric.getBigIntegerValue();
            }
        };
        NUMERIC_TO_OBJECT = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                if (numeric instanceof RubyFixnum) {
                    long value2 = numeric.getLongValue();
                    return value2;
                }
                if (numeric instanceof RubyFloat) {
                    double value3 = numeric.getDoubleValue();
                    return value3;
                }
                if (numeric instanceof RubyBignum) {
                    return ((RubyBignum)numeric).getValue();
                }
                if (numeric instanceof RubyBigDecimal) {
                    return ((RubyBigDecimal)numeric).getValue();
                }
                return NUMERIC_TO_OTHER.coerce(numeric, target);
            }
        };
        NUMERIC_TO_OTHER = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                if (target.isAssignableFrom(numeric.getClass())) {
                    return numeric;
                }
                throw numeric.getRuntime().newTypeError("could not coerce " + numeric.getMetaClass() + " to " + target);
            }
        };
        NUMERIC_TO_VOID = new NumericConverter(){

            @Override
            public Object coerce(RubyNumeric numeric, Class target) {
                return null;
            }
        };
        NUMERIC_CONVERTERS = new IdentityHashMap<Class, NumericConverter>(24);
        NUMERIC_CONVERTERS.put(Byte.TYPE, NUMERIC_TO_BYTE);
        NUMERIC_CONVERTERS.put(Byte.class, NUMERIC_TO_BYTE);
        NUMERIC_CONVERTERS.put(Short.TYPE, NUMERIC_TO_SHORT);
        NUMERIC_CONVERTERS.put(Short.class, NUMERIC_TO_SHORT);
        NUMERIC_CONVERTERS.put(Character.TYPE, NUMERIC_TO_CHARACTER);
        NUMERIC_CONVERTERS.put(Character.class, NUMERIC_TO_CHARACTER);
        NUMERIC_CONVERTERS.put(Integer.TYPE, NUMERIC_TO_INTEGER);
        NUMERIC_CONVERTERS.put(Integer.class, NUMERIC_TO_INTEGER);
        NUMERIC_CONVERTERS.put(Long.TYPE, NUMERIC_TO_LONG);
        NUMERIC_CONVERTERS.put(Long.class, NUMERIC_TO_LONG);
        NUMERIC_CONVERTERS.put(Float.TYPE, NUMERIC_TO_FLOAT);
        NUMERIC_CONVERTERS.put(Float.class, NUMERIC_TO_FLOAT);
        NUMERIC_CONVERTERS.put(Double.TYPE, NUMERIC_TO_DOUBLE);
        NUMERIC_CONVERTERS.put(Double.class, NUMERIC_TO_DOUBLE);
        NUMERIC_CONVERTERS.put(BigInteger.class, NUMERIC_TO_BIGINTEGER);
        NUMERIC_CONVERTERS.put(Object.class, NUMERIC_TO_OBJECT);
        NUMERIC_CONVERTERS.put(Number.class, NUMERIC_TO_OBJECT);
        NUMERIC_CONVERTERS.put(Serializable.class, NUMERIC_TO_OBJECT);
        NUMERIC_CONVERTERS.put(Void.TYPE, NUMERIC_TO_VOID);
        HashMap<String, Class<Comparable<Boolean>>> primitiveClasses = new HashMap<String, Class<Comparable<Boolean>>>(10, 1.0f);
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        PRIMITIVE_CLASSES = Collections.unmodifiableMap(primitiveClasses);
        RUBY_BOOLEAN_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.isTrue();
            }
        };
        RUBY_BYTE_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return (byte)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return (byte)0;
            }
        };
        RUBY_SHORT_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return (short)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return (short)0;
            }
        };
        RUBY_CHAR_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return Character.valueOf((char)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue());
                }
                return Character.valueOf('\u0000');
            }
        };
        RUBY_INTEGER_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return (int)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return 0;
            }
        };
        RUBY_LONG_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return ((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return 0L;
            }
        };
        RUBY_FLOAT_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_f")) {
                    return Float.valueOf((float)((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue());
                }
                return Float.valueOf(0.0f);
            }
        };
        RUBY_DOUBLE_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_f")) {
                    return ((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue();
                }
                return 0.0;
            }
        };
        RUBY_CONVERTERS = new HashMap<Class, RubyConverter>(16, 1.0f);
        RUBY_CONVERTERS.put(Boolean.class, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Boolean.TYPE, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Byte.class, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Byte.TYPE, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Short.class, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Short.TYPE, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Integer.class, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Integer.TYPE, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Long.class, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Long.TYPE, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Float.class, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Float.TYPE, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Double.class, RUBY_DOUBLE_CONVERTER);
        RUBY_CONVERTERS.put(Double.TYPE, RUBY_DOUBLE_CONVERTER);
        ARRAY_BOOLEAN_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Boolean.class);
            }
        };
        ARRAY_BYTE_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Byte.class);
            }
        };
        ARRAY_SHORT_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Short.class);
            }
        };
        ARRAY_CHAR_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Character.class);
            }
        };
        ARRAY_INT_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Integer.class);
            }
        };
        ARRAY_LONG_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Long.class);
            }
        };
        ARRAY_FLOAT_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Float.class);
            }
        };
        ARRAY_DOUBLE_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Double.class);
            }
        };
        ARRAY_OBJECT_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Object.class);
            }
        };
        ARRAY_CLASS_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Class.class);
            }
        };
        ARRAY_STRING_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(String.class);
            }
        };
        ARRAY_BIGINTEGER_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(BigInteger.class);
            }
        };
        ARRAY_BIGDECIMAL_CONVERTER = new RubyConverter(){

            @Override
            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(BigDecimal.class);
            }
        };
        ARRAY_CONVERTERS = new HashMap<Class, RubyConverter>(24, 1.0f);
        ARRAY_CONVERTERS.put(Boolean.class, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Boolean.TYPE, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.class, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.TYPE, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Short.class, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Short.TYPE, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Character.class, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Character.TYPE, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.class, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.TYPE, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Long.class, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Long.TYPE, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Float.class, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Float.TYPE, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Double.class, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(Double.TYPE, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(String.class, ARRAY_STRING_CONVERTER);
        ARRAY_CONVERTERS.put(Class.class, ARRAY_CLASS_CONVERTER);
        ARRAY_CONVERTERS.put(BigInteger.class, ARRAY_BIGINTEGER_CONVERTER);
        ARRAY_CONVERTERS.put(BigDecimal.class, ARRAY_BIGDECIMAL_CONVERTER);
    }

    @Deprecated
    public static interface RubyConverter {
        public Object convert(ThreadContext var1, IRubyObject var2);
    }

    public static interface NumericConverter {
        public Object coerce(RubyNumeric var1, Class var2);
    }

    public static abstract class JavaConverter {
        private final Class type;

        public JavaConverter(Class type2) {
            this.type = type2;
        }

        public abstract IRubyObject convert(Ruby var1, Object var2);

        public abstract IRubyObject get(Ruby var1, Object var2, int var3);

        public abstract void set(Ruby var1, Object var2, int var3, IRubyObject var4);

        public String toString() {
            return this.type.getName() + " converter";
        }
    }
}

