/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.cli.Options;

public final class GlobalVariable {
    private IAccessor accessor;
    private ArrayList<IRubyObject> traces = null;
    private boolean tracing;
    private Invalidator invalidator = OptoFactory.newGlobalInvalidator(Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load());
    private final Scope scope;

    public GlobalVariable(IAccessor accessor, Scope scope) {
        this.accessor = accessor;
        this.scope = scope;
    }

    public static GlobalVariable newUndefined(Ruby runtime2, String name2) {
        GlobalVariable variable = new GlobalVariable(null, Scope.GLOBAL);
        variable.setAccessor(new UndefinedAccessor(runtime2, variable, name2));
        return variable;
    }

    public IAccessor getAccessor() {
        return this.accessor;
    }

    public Scope getScope() {
        return this.scope;
    }

    public ArrayList getTraces() {
        return this.traces;
    }

    public void addTrace(RubyProc command) {
        if (this.traces == null) {
            this.traces = new ArrayList();
        }
        this.traces.add(command);
    }

    public boolean removeTrace(IRubyObject command) {
        if (this.traces == null || !this.traces.contains(command)) {
            return false;
        }
        this.traces.remove(command);
        return true;
    }

    public void removeTraces() {
        this.traces = null;
    }

    public void setAccessor(IAccessor accessor) {
        this.accessor = accessor;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(IRubyObject value2) {
        if (this.traces == null) {
            return;
        }
        ThreadContext context = value2.getRuntime().getCurrentContext();
        if (context.isWithinTrace()) {
            return;
        }
        try {
            context.setWithinTrace(true);
            for (int i2 = 0; i2 < this.traces.size(); ++i2) {
                ((RubyProc)this.traces.get(i2)).call(context, new IRubyObject[]{value2});
            }
        }
        finally {
            context.setWithinTrace(false);
        }
    }

    public Invalidator getInvalidator() {
        return this.invalidator;
    }

    public void invalidate() {
        this.invalidator.invalidate();
    }

    public static enum Scope {
        GLOBAL,
        THREAD,
        FRAME;

    }
}

