/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class AsStringInstr
extends ZeroOperandArgNoBlockCallInstr {
    public static final ByteList TO_S = new ByteList(new byte[]{116, 111, 95, 115});

    public AsStringInstr(IRScope scope, Variable result2, Operand source2, boolean isPotentiallyRefined) {
        super(scope, Operation.AS_STRING, CallType.FUNCTIONAL, result2, scope.getManager().getRuntime().newSymbol(TO_S), AsStringInstr.nonNull(source2), Operand.EMPTY_ARRAY, isPotentiallyRefined);
    }

    private AsStringInstr(IRScope scope, Variable result2, Operand source2, boolean isPotentiallyRefined, CallSite callSite, long callSiteId) {
        super(scope, Operation.AS_STRING, CallType.FUNCTIONAL, result2, scope.getManager().getRuntime().newSymbol(TO_S), AsStringInstr.nonNull(source2), Operand.EMPTY_ARRAY, isPotentiallyRefined, callSite, callSiteId);
    }

    private static Operand nonNull(Operand source2) {
        return source2 == null ? StringLiteral.EMPTY_STRING : source2;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new AsStringInstr(ii.getScope(), (Variable)this.getResult().cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.isPotentiallyRefined(), this.getCallSite(), this.getCallSiteId());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
    }

    public static AsStringInstr decode(IRReaderDecoder d) {
        return new AsStringInstr(d.getCurrentScope(), d.decodeVariable(), d.decodeOperand(), d.decodeBoolean());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object receiver2 = this.getReceiver().retrieve(context, self2, currScope, currDynScope, temp);
        if (this.isPotentiallyRefined()) {
            return IRRuntimeHelpers.asString(context, self2, (IRubyObject)receiver2, this.getCallSite());
        }
        return ((IRubyObject)receiver2).asString();
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AsStringInstr(this);
    }
}

