/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.IOException;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.parser.StaticScope;

public class IRWriter {
    private IRWriter() {
    }

    public static void persist(IRWriterEncoder file2, IRScope script) throws IOException {
        file2.startEncoding(script);
        IRWriter.persistScopeInstructions(file2, script);
        file2.startEncodingScopeHeaders(script);
        IRWriter.persistScopeHeaders(file2, script);
        file2.endEncodingScopeHeaders(script);
        file2.endEncoding(script);
    }

    private static void persistScopeInstructions(IRWriterEncoder file2, IRScope parent) {
        IRWriter.persistScopeInstrs(file2, parent);
        for (IRScope scope : parent.getLexicalScopes()) {
            IRWriter.persistScopeInstructions(file2, scope);
        }
    }

    private static void persistScopeInstrs(IRWriterEncoder file2, IRScope scope) {
        file2.startEncodingScopeInstrs(scope);
        InterpreterContext context = scope.builtInterpreterContext();
        for (Instr instr : context.getInstructions()) {
            file2.encode(instr);
        }
        file2.endEncodingScopeInstrs(scope);
    }

    private static void persistScopeHeaders(IRWriterEncoder file2, IRScope parent) {
        IRWriter.persistScopeHeader(file2, parent);
        for (IRScope scope : parent.getLexicalScopes()) {
            IRWriter.persistScopeHeaders(file2, scope);
        }
    }

    private static void persistScopeHeader(IRWriterEncoder file2, IRScope scope) {
        if (IRWriter.shouldLog(file2)) {
            System.out.println("persistScopeHeader(start)");
        }
        file2.startEncodingScopeHeader(scope);
        scope.persistScopeHeader(file2);
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("NAME = " + scope.getId());
        }
        if (scope instanceof IRScriptBody) {
            if (IRWriter.shouldLog(file2)) {
                System.out.println("persistScopeHeader: file = " + scope.getFile());
            }
            file2.encode(scope.getFile());
        } else {
            if (IRWriter.shouldLog(file2)) {
                System.out.println("persistScopeHeader: id   = " + scope.getId());
            }
            file2.encodeRaw(scope.getName());
            if (IRWriter.shouldLog(file2)) {
                System.out.println("persistScopeHeader(encode parent)");
            }
            file2.encode(scope.getLexicalParent());
        }
        IRWriter.persistStaticScope(file2, scope.getStaticScope());
        scope.persistScopeFlags(file2);
        file2.endEncodingScopeHeader(scope);
    }

    private static void persistStaticScope(IRWriterEncoder file2, StaticScope staticScope) {
        if (IRWriter.shouldLog(file2)) {
            System.out.println("persistStaticScope");
        }
        file2.encode(staticScope.getType());
        file2.encode(staticScope.getFile());
        file2.encode(staticScope.getVariables());
        file2.encode(staticScope.getFirstKeywordIndex());
        file2.encode(staticScope.getSignature());
    }

    public static boolean shouldLog(IRWriterEncoder encoder) {
        return RubyInstanceConfig.IR_WRITING_DEBUG && !encoder.isAnalyzer();
    }
}

