/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;

public final class ArgsUtil {
    private static final IRubyObject[] NULL_1 = new IRubyObject[]{null};
    private static final IRubyObject[] NULL_2 = new IRubyObject[]{null, null};
    public static final RubyHash.VisitorWithState<RubySymbol> SINGLE_KEY_CHECK_VISITOR = new RubyHash.VisitorWithState<RubySymbol>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubySymbol testKey) {
            if (!key2.equals(testKey)) {
                throw context.runtime.newArgumentError("unknown keyword: " + key2.inspect());
            }
        }
    };
    public static final RubyHash.VisitorWithState<Set<RubySymbol>> MULTI_KEY_CHECK_VISITOR = new RubyHash.VisitorWithState<Set<RubySymbol>>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Set<RubySymbol> validKeySet) {
            if (!validKeySet.contains(key2)) {
                throw context.runtime.newArgumentError("unknown keyword: " + key2.inspect());
            }
        }
    };

    public static RubyArray convertToRubyArray(Ruby runtime2, IRubyObject value2, boolean coerce2) {
        if (value2 == null) {
            return RubyArray.newEmptyArray(runtime2);
        }
        if (coerce2) {
            return ArgsUtil.convertToRubyArrayWithCoerce(runtime2, value2);
        }
        return RubyArray.newArrayLight(runtime2, value2);
    }

    public static RubyArray convertToRubyArrayWithCoerce(Ruby runtime2, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return (RubyArray)value2;
        }
        IRubyObject newValue = TypeConverter.convertToType(value2, runtime2.getArray(), "to_ary", false);
        if (newValue.isNil()) {
            return RubyArray.newArrayLight(runtime2, value2);
        }
        if (!(newValue instanceof RubyArray)) {
            throw runtime2.newTypeError(newValue.getMetaClass() + "#to_ary should return Array");
        }
        return (RubyArray)newValue;
    }

    public static int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public static boolean hasExceptionOption(ThreadContext context, IRubyObject options2, boolean defaultValue) {
        IRubyObject value2;
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, options2, false);
        if (!opts.isNil() && (value2 = ArgsUtil.extractKeywordArg(context, "exception", (RubyHash)opts)) != null) {
            return TypeConverter.booleanExpected(context, value2, "exception");
        }
        return defaultValue;
    }

    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject ... args2) {
        if (args2.length >= 1) {
            return TypeConverter.checkHashType(runtime2, args2[args2.length - 1]);
        }
        return runtime2.getNil();
    }

    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject arg2) {
        return ArgsUtil.getOptionsArg(runtime2, arg2, true);
    }

    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject arg2, boolean raise2) {
        if (arg2 == null) {
            return runtime2.getNil();
        }
        return TypeConverter.checkHashType(runtime2, arg2, raise2);
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, RubyHash options2, String ... validKeys) {
        if (options2.isEmpty()) {
            switch (validKeys.length) {
                case 1: {
                    return NULL_1;
                }
                case 2: {
                    return NULL_2;
                }
            }
            return new IRubyObject[validKeys.length];
        }
        IRubyObject[] ret = new IRubyObject[validKeys.length];
        HashSet<RubySymbol> validKeySet = new HashSet<RubySymbol>(ret.length);
        for (int i2 = 0; i2 < validKeys.length; ++i2) {
            IRubyObject val;
            String key2 = validKeys[i2];
            RubySymbol keySym = context.runtime.newSymbol(key2);
            ret[i2] = val = options2.fastARef(keySym);
            validKeySet.add(keySym);
        }
        options2.visitAll(context, MULTI_KEY_CHECK_VISITOR, validKeySet);
        return ret;
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, IRubyObject[] args2, String ... validKeys) {
        return ArgsUtil.extractKeywordArgs(context, ArgsUtil.getOptionsArg(context.runtime, args2), validKeys);
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, IRubyObject maybeKwargs, String ... validKeys) {
        IRubyObject options2 = ArgsUtil.getOptionsArg(context.runtime, maybeKwargs);
        if (options2 instanceof RubyHash) {
            return ArgsUtil.extractKeywordArgs(context, (RubyHash)options2, validKeys);
        }
        return null;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, IRubyObject maybeKwargs, String validKey) {
        IRubyObject options2 = ArgsUtil.getOptionsArg(context.runtime, maybeKwargs);
        if (options2 instanceof RubyHash) {
            return ArgsUtil.extractKeywordArg(context, (RubyHash)options2, validKey);
        }
        return null;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, RubyHash options2, String validKey) {
        if (options2.isEmpty()) {
            return null;
        }
        RubySymbol testKey = context.runtime.newSymbol(validKey);
        IRubyObject ret = options2.fastARef(testKey);
        if (ret == null || options2.size() > 1) {
            options2.visitAll(context, SINGLE_KEY_CHECK_VISITOR, testKey);
        }
        return ret;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, RubyHash opts) {
        return opts.op_aref(context, context.runtime.newSymbol(keyword));
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject arg2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, arg2);
        if (opts == context.nil) {
            return context.nil;
        }
        return ArgsUtil.extractKeywordArg(context, keyword, (RubyHash)opts);
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject ... args2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (opts == context.nil) {
            return context.nil;
        }
        return ArgsUtil.extractKeywordArg(context, keyword, (RubyHash)opts);
    }

    public static RubyHash extractKeywords(IRubyObject possiblyKeywordArg) {
        if (possiblyKeywordArg instanceof RubyHash) {
            return (RubyHash)possiblyKeywordArg;
        }
        return null;
    }

    public static IRubyObject getFreezeOpt(ThreadContext context, IRubyObject maybeOpts) {
        IRubyObject freeze2;
        Ruby runtime2 = context.runtime;
        IRubyObject kwfreeze = null;
        IRubyObject opts = ArgsUtil.getOptionsArg(runtime2, maybeOpts);
        if (!opts.isNil() && (freeze2 = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "freeze")) != null) {
            if (!freeze2.isNil() && freeze2 != runtime2.getTrue() && freeze2 != runtime2.getFalse()) {
                throw runtime2.newArgumentError(RubyStringBuilder.str(runtime2, "unexpected value for freeze: ", RubyStringBuilder.types(runtime2, (RubyModule)freeze2.getType())));
            }
            kwfreeze = freeze2;
        }
        return kwfreeze;
    }
}

