/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.jruby.IncludedModule;
import org.jruby.MetaClass;
import org.jruby.PrependedModule;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.JavaPackage;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Inspector;
import org.jruby.util.Numeric;
import org.jruby.util.collections.WeakValuedIdentityMap;
import org.jruby.util.collections.WeakValuedMap;

@JRubyModule(name={"ObjectSpace"})
public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(Ruby runtime2) {
        RubyModule objectSpaceModule = runtime2.defineModule("ObjectSpace");
        objectSpaceModule.defineAnnotatedMethods(RubyObjectSpace.class);
        WeakMap.createWeakMap(runtime2, objectSpaceModule);
        return objectSpaceModule;
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_finalizer(IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject finalizer;
        Ruby runtime2 = recv2.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, 2);
        IRubyObject obj = args2[0];
        if (argc == 2) {
            finalizer = args2[1];
            if (!finalizer.respondsTo("call")) {
                throw runtime2.newArgumentError("wrong type argument " + finalizer.getType() + " (should be callable)");
            }
            if (finalizer instanceof RubyMethod && ((RubyMethod)finalizer).getReceiver() == obj) {
                RubyObjectSpace.referenceWarning(runtime2);
            }
            if (finalizer instanceof RubyProc && ((RubyProc)finalizer).getBlock().getBinding().getSelf() == obj) {
                RubyObjectSpace.referenceWarning(runtime2);
            }
        } else {
            if (RubyObjectSpace.blockReferencesObject(obj, block)) {
                RubyObjectSpace.referenceWarning(runtime2);
            }
            finalizer = runtime2.newProc(Block.Type.PROC, block);
        }
        runtime2.getObjectSpace().addFinalizer(obj, finalizer);
        return runtime2.newArray((IRubyObject)RubyFixnum.zero(runtime2), finalizer);
    }

    private static void referenceWarning(Ruby runtime2) {
        runtime2.getWarnings().warn("finalizer references object to be finalized");
    }

    private static boolean blockReferencesObject(IRubyObject object, Block block) {
        return block.getBinding().getSelf() == object;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject undefine_finalizer(IRubyObject recv2, IRubyObject obj, Block block) {
        recv2.getRuntime().getObjectSpace().removeFinalizers(RubyNumeric.fix2long(obj.id()));
        return recv2;
    }

    @JRubyMethod(name={"_id2ref"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject id2ref(IRubyObject recv2, IRubyObject id2) {
        Ruby runtime2 = id2.getRuntime();
        if (!(id2 instanceof RubyFixnum)) {
            throw runtime2.newTypeError(id2, runtime2.getFixnum());
        }
        long longId = ((RubyFixnum)id2).getLongValue();
        if (longId == 0L) {
            return runtime2.getFalse();
        }
        if (longId == 20L) {
            return runtime2.getTrue();
        }
        if (longId == 8L) {
            return runtime2.getNil();
        }
        if ((longId & 1L) == 1L) {
            return runtime2.newFixnum((longId - 1L) / 2L);
        }
        if ((longId & 3L) == 2L) {
            double d = 0.0;
            if (longId != -9223372036854775806L) {
                long b63 = longId >>> 63;
                long longBits = Numeric.rotr(2L - b63 | longId & 0xFFFFFFFFFFFFFFFCL, 3);
                d = Double.longBitsToDouble(longBits);
            }
            return runtime2.newFloat(d);
        }
        if (runtime2.isObjectSpaceEnabled()) {
            IRubyObject object = runtime2.getObjectSpace().id2ref(longId);
            if (object == null) {
                return runtime2.getNil();
            }
            return object;
        }
        runtime2.getWarnings().warn("ObjectSpace is disabled; _id2ref only supports immediates, pass -X+O to enable");
        throw runtime2.newRangeError(String.format("0x%016x is not id value", longId));
    }

    public static IRubyObject each_objectInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject obj;
        RubyModule rubyClass;
        Ruby runtime2 = context.runtime;
        if (args2.length == 0) {
            rubyClass = runtime2.getObject();
        } else {
            if (!(args2[0] instanceof RubyModule)) {
                throw runtime2.newTypeError("class or module required");
            }
            rubyClass = (RubyModule)args2[0];
        }
        if (rubyClass == runtime2.getClassClass() || rubyClass == runtime2.getModule()) {
            ArrayList modules = new ArrayList(96);
            runtime2.eachModule(module -> {
                if (!(!rubyClass.isInstance((IRubyObject)module) || module instanceof IncludedModule || module instanceof PrependedModule || module == runtime2.getJavaSupport().getJavaPackageClass() || module instanceof JavaPackage || module instanceof MetaClass && ((MetaClass)module).getAttached() instanceof JavaPackage)) {
                    modules.add(module);
                }
            });
            int count2 = modules.size();
            for (int i2 = 0; i2 < count2; ++i2) {
                block.yield(context, (IRubyObject)modules.get(i2));
            }
            return runtime2.newFixnum(count2);
        }
        if (rubyClass.getClass() == MetaClass.class) {
            RubyBasicObject attached = ((MetaClass)args2[0]).getAttached();
            block.yield(context, attached);
            int count3 = 1;
            if (attached instanceof RubyClass) {
                for (RubyClass child : ((RubyClass)attached).subclasses(true)) {
                    if (child instanceof IncludedModule) continue;
                    ++count3;
                    block.yield(context, child);
                }
            }
            return runtime2.newFixnum(count3);
        }
        if (!runtime2.isObjectSpaceEnabled()) {
            throw runtime2.newRuntimeError("ObjectSpace is disabled; each_object will only work with Class, pass -X+O to enable");
        }
        Iterator iter = runtime2.getObjectSpace().iterator(rubyClass);
        int count4 = 0;
        while ((obj = (IRubyObject)iter.next()) != null) {
            ++count4;
            block.yield(context, obj);
        }
        return runtime2.newFixnum(count4);
    }

    @JRubyMethod(name={"each_object"}, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_object(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return block.isGiven() ? RubyObjectSpace.each_objectInternal(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_object", args2);
    }

    @JRubyMethod(name={"garbage_collect"}, module=true, visibility=Visibility.PRIVATE, optional=1, checkArity=false)
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyGC.start(context, recv2, args2);
    }

    public static class WeakMap
    extends RubyObject {
        private final WeakValuedIdentityMap<IRubyObject, IRubyObject> identityMap = new WeakValuedIdentityMap();
        private final WeakValuedMap<IRubyObject, IRubyObject> valueMap = new WeakValuedMap();

        static void createWeakMap(Ruby runtime2, RubyModule objectspaceModule) {
            RubyClass weakMap = objectspaceModule.defineClassUnder("WeakMap", runtime2.getObject(), WeakMap::new);
            weakMap.defineAnnotatedMethods(WeakMap.class);
        }

        public WeakMap(Ruby runtime2, RubyClass cls) {
            super(runtime2, cls);
        }

        @JRubyMethod(name={"[]"})
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            Map<IRubyObject, IRubyObject> weakMap = this.getWeakMapFor(key2);
            IRubyObject value2 = weakMap.get(key2);
            if (value2 != null) {
                return value2;
            }
            return context.nil;
        }

        private Map<IRubyObject, IRubyObject> getWeakMapFor(IRubyObject key2) {
            if (key2 instanceof RubyFixnum || key2 instanceof RubyFloat) {
                return this.valueMap;
            }
            return this.identityMap;
        }

        @JRubyMethod(name={"[]="})
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            Ruby runtime2 = context.runtime;
            Map<IRubyObject, IRubyObject> weakMap = this.getWeakMapFor(key2);
            weakMap.put(key2, value2);
            return runtime2.newFixnum(System.identityHashCode(value2));
        }

        @JRubyMethod(name={"key?"})
        public IRubyObject key_p(ThreadContext context, IRubyObject key2) {
            Map<IRubyObject, IRubyObject> weakMap = this.getWeakMapFor(key2);
            return RubyBoolean.newBoolean(context, weakMap.get(key2) != null);
        }

        @JRubyMethod(name={"keys"})
        public IRubyObject keys(ThreadContext context) {
            return context.runtime.newArrayNoCopy((IRubyObject[])this.getEntryStream().filter(entry -> entry.getValue() != null).map(Map.Entry::getKey).toArray(IRubyObject[]::new));
        }

        private Stream<Map.Entry<IRubyObject, IRubyObject>> getEntryStream() {
            return Stream.concat(this.identityMap.entrySet().stream(), this.valueMap.entrySet().stream());
        }

        @JRubyMethod(name={"values"})
        public IRubyObject values(ThreadContext context) {
            return context.runtime.newArrayNoCopy((IRubyObject[])this.getEntryStream().map(Map.Entry::getValue).filter(ref -> ref != null).toArray(IRubyObject[]::new));
        }

        @JRubyMethod(name={"length", "size"})
        public IRubyObject size(ThreadContext context) {
            return context.runtime.newFixnum(this.identityMap.size() + this.valueMap.size());
        }

        @JRubyMethod(name={"include?", "member?"})
        public IRubyObject member_p(ThreadContext context, IRubyObject key2) {
            return RubyBoolean.newBoolean(context, this.getWeakMapFor(key2).containsKey(key2));
        }

        @JRubyMethod(name={"each", "each_pair"})
        public IRubyObject each(ThreadContext context, Block block) {
            this.getEntryStream().forEach(entry -> {
                IRubyObject value2 = (IRubyObject)entry.getValue();
                if (value2 != null) {
                    block.yieldSpecific(context, (IRubyObject)entry.getKey(), value2);
                }
            });
            return this;
        }

        @JRubyMethod(name={"each_key"})
        public IRubyObject each_key(ThreadContext context, Block block) {
            this.getEntryStream().forEach(entry -> {
                if (entry.getValue() != null) {
                    block.yieldSpecific(context, (IRubyObject)entry.getKey());
                }
            });
            return this;
        }

        @JRubyMethod(name={"each_value"})
        public IRubyObject each_value(ThreadContext context, Block block) {
            this.getEntryStream().forEach(entry -> {
                IRubyObject value2 = (IRubyObject)entry.getValue();
                if (value2 != null) {
                    block.yieldSpecific(context, value2);
                }
            });
            return this;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect(ThreadContext context) {
            Ruby runtime2 = context.runtime;
            RubyString part = Inspector.inspectPrefix(runtime2.getCurrentContext(), this.metaClass.getRealClass(), this.inspectHashCode());
            int base = part.length();
            this.getEntryStream().forEach(entry -> {
                if (entry.getValue() != null) {
                    if (part.length() == base) {
                        part.cat(Inspector.COLON_SPACE);
                    } else {
                        part.cat(Inspector.COMMA_SPACE);
                    }
                    part.cat(((IRubyObject)entry.getKey()).inspect().convertToString());
                    part.cat(Inspector.SPACE_HASHROCKET_SPACE);
                    part.cat(((IRubyObject)entry.getValue()).inspect().convertToString());
                }
            });
            part.cat(Inspector.GT);
            return part;
        }
    }
}

