/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.asn1;

import impl.krypt.asn1.Asn1Object;
import impl.krypt.asn1.Header;
import impl.krypt.asn1.ParsedHeader;
import impl.krypt.asn1.Parser;
import impl.krypt.asn1.ParserFactory;
import impl.krypt.asn1.Tag;
import impl.krypt.asn1.TagClass;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.HashAdapter;
import org.jruby.ext.krypt.Streams;
import org.jruby.ext.krypt.asn1.Asn1Codecs;
import org.jruby.ext.krypt.asn1.RubyAsn1;
import org.jruby.ext.krypt.asn1.RubyTemplate;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;

public class TemplateParser {
    static final Parser PARSER = new ParserFactory().newHeaderParser();
    private static final ParseStrategy PRIMITIVE_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext mctx) {
            ThreadContext ctx = mctx.getCtx();
            RubyTemplate.Definition definition = mctx.getDefinition();
            RubyTemplate.ErrorCollector collector = mctx.getCollector();
            Ruby runtime = ctx.getRuntime();
            Integer defaultTag = definition.getTypeAsInteger().orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "'type' missing in definition")), collector);
            Integer tag = definition.getTagAsInteger().orNull();
            String tagging = definition.getTagging().orNull();
            if (Matcher.matchTagAndClass(ctx, mctx.getHeader(), tag, tagging, defaultTag)) {
                return ParseStrategy.MatchResult.MATCHED;
            }
            return TemplateParser.checkOptionalOrDefault(mctx, defaultTag);
        }

        @Override
        public void parse(ParseContext pctx) {
            TemplateParser.parseAndAssign(pctx);
        }

        @Override
        public void decode(ParseContext pctx) {
            byte[] bytes;
            ThreadContext ctx = pctx.getCtx();
            RubyTemplate.ErrorCollector collector = pctx.getCollector();
            RubyTemplate.Asn1Template template = pctx.getTemplate();
            Asn1Object object = template.getObject();
            Header h = object.getHeader();
            RubyTemplate.Definition definition = pctx.getDefinition();
            String tagging = definition.getTagging().orNull();
            if (h.getLength().isInfiniteLength()) {
                this.decodeInfiniteLength(pctx);
                return;
            }
            if (tagging != null && tagging.equals("EXPLICIT")) {
                if (!h.getTag().isConstructed()) {
                    throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(ctx.getRuntime(), "Constructive bit not set for explicitly tagged value")));
                }
                bytes = TemplateParser.skipExplicitHeader(object);
            } else {
                if (h.getTag().isConstructed()) {
                    throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(ctx.getRuntime(), "Constructive bit set")));
                }
                bytes = object.getValue();
            }
            int defaultTag = definition.getTypeAsInteger().orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(ctx.getRuntime(), "'type' missing in primitive ASN.1 definition")), collector);
            RubyAsn1.Asn1Codec codec = Asn1Codecs.CODECS[defaultTag];
            if (codec == null) {
                throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(ctx.getRuntime(), "No codec available for default tag: " + defaultTag)));
            }
            IRubyObject value = codec.decode(new RubyAsn1.DecodeContext(pctx.getReceiver(), ctx.getRuntime(), bytes));
            template.setValue(value);
            template.setDecoded(true);
        }

        private void decodeInfiniteLength(ParseContext pctx) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private static final ParseStrategy TEMPLATE_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext mctx) {
            MatchContext tmp;
            ThreadContext ctx = mctx.getCtx();
            RubyTemplate.Definition templateDefinition = mctx.getDefinition();
            HashAdapter templateOptions = templateDefinition.getOptions();
            HashAdapter newDefinition = this.getInnerDefinition(mctx);
            RubyTemplate.Definition d = new RubyTemplate.Definition(newDefinition, templateOptions);
            ParseStrategy s = d.accept(ctx, CodecStrategyVisitor.INSTANCE);
            ParseStrategy.MatchResult mr = s.match(tmp = mctx.createTemporary(d));
            if (mr.equals((Object)ParseStrategy.MatchResult.NO_MATCH) && templateDefinition.hasDefault(ctx)) {
                TemplateParser.setDefaultValue(mctx);
                return ParseStrategy.MatchResult.MATCHED_BY_DEFAULT;
            }
            return mr;
        }

        @Override
        public void parse(ParseContext pctx) {
            ThreadContext ctx = pctx.getCtx();
            Ruby runtime = ctx.getRuntime();
            RubyTemplate.ErrorCollector collector = pctx.getCollector();
            RubyTemplate.Definition definition = pctx.getDefinition();
            IRubyObject recv = pctx.getReceiver();
            RubyTemplate.Asn1Template template = pctx.getTemplate();
            String name = TemplateParser.determineName(definition.getName().orNull());
            RubyClass type = definition.getTypeAsClass(ctx).orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "'type' missing in ASN.1 definition")), collector);
            HashAdapter newDefinition = this.getInnerDefinition(pctx);
            HashAdapter oldDefinition = template.getDefinition();
            template.setDefinition(newDefinition);
            RubyTemplate.RubyAsn1Template instance = new RubyTemplate.RubyAsn1Template(runtime, type, template);
            RubyTemplate.Asn1Template newTemplate = new RubyTemplate.Asn1Template(null, oldDefinition, definition.getOptions());
            newTemplate.setValue((IRubyObject)instance);
            newTemplate.setParsed(true);
            newTemplate.setDecoded(true);
            recv.getInstanceVariables().setInstanceVariable(name, (IRubyObject)new RubyTemplate.RubyAsn1Template(runtime, RubyTemplate.cTemplateValue, newTemplate));
            template.setDecoded(true);
            template.setParsed(false);
        }

        private HashAdapter getInnerDefinition(AbstractParseContext pctx) {
            RubyTemplate.Definition definition = pctx.getDefinition();
            ThreadContext ctx = pctx.getCtx();
            Ruby runtime = ctx.getRuntime();
            RubyClass type = definition.getTypeAsClass(ctx).orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "'type' missing in ASN.1 definition")), pctx.getCollector());
            RubyHash typeDef = (RubyHash)type.instance_variable_get(ctx, (IRubyObject)runtime.newString("@definition"));
            if (typeDef == null) {
                throw Errors.newASN1Error(runtime, type + " has no ASN.1 definition");
            }
            return new HashAdapter(typeDef);
        }

        @Override
        public void decode(ParseContext ctx) {
        }
    };
    private static final ParseStrategy SEQUENCE_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext ctx) {
            return TemplateParser.matchConstructed(ctx, 16);
        }

        @Override
        public void parse(ParseContext ctx) {
            TemplateParser.parseConstructed(ctx);
        }

        @Override
        public void decode(ParseContext ctx) {
        }
    };
    private static final ParseStrategy SET_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext ctx) {
            return TemplateParser.matchConstructed(ctx, 17);
        }

        @Override
        public void parse(ParseContext ctx) {
            TemplateParser.parseConstructed(ctx);
        }

        @Override
        public void decode(ParseContext ctx) {
        }
    };
    private static final ParseStrategy SEQUENCE_OF_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext ctx) {
            return TemplateParser.matchConstructedOf(ctx, 16);
        }

        @Override
        public void parse(ParseContext ctx) {
            TemplateParser.parseAndAssign(ctx);
        }

        @Override
        public void decode(ParseContext ctx) {
            TemplateParser.decodeConstructedOf(ctx);
        }
    };
    private static final ParseStrategy SET_OF_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext ctx) {
            return TemplateParser.matchConstructedOf(ctx, 17);
        }

        @Override
        public void parse(ParseContext ctx) {
            TemplateParser.parseAndAssign(ctx);
        }

        @Override
        public void decode(ParseContext ctx) {
            TemplateParser.decodeConstructedOf(ctx);
        }
    };
    private static final ParseStrategy ANY_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext mctx) {
            ThreadContext ctx = mctx.getCtx();
            RubyTemplate.Definition definition = mctx.getDefinition();
            if (definition.isOptional(ctx)) {
                Ruby runtime = ctx.getRuntime();
                RubyTemplate.ErrorCollector collector = mctx.getCollector();
                String name = TemplateParser.determineName(definition.getName().orNull());
                String tagging = definition.getTagging().orNull();
                Integer tag = definition.getTagAsInteger().orNull();
                int pseudoDefaultTag = tag;
                if (tag == null) {
                    throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Cannot unambiguously assign ANY value " + name)));
                }
                if (!Matcher.matchTagAndClass(ctx, mctx.getHeader(), tag, tagging, pseudoDefaultTag)) {
                    if (definition.hasDefault(ctx)) {
                        TemplateParser.setDefaultValue(mctx);
                        return ParseStrategy.MatchResult.MATCHED_BY_DEFAULT;
                    }
                    return ParseStrategy.MatchResult.NO_MATCH;
                }
            }
            return ParseStrategy.MatchResult.MATCHED;
        }

        @Override
        public void parse(ParseContext ctx) {
            TemplateParser.parseAndAssign(ctx);
        }

        @Override
        public void decode(ParseContext pctx) {
            byte[] bytes;
            ThreadContext ctx = pctx.getCtx();
            RubyTemplate.Definition definition = pctx.getDefinition();
            RubyTemplate.ErrorCollector collector = pctx.getCollector();
            Ruby runtime = ctx.getRuntime();
            String tagging = definition.getTagging().orNull();
            RubyTemplate.Asn1Template template = pctx.getTemplate();
            Asn1Object object = template.getObject();
            final Header h = object.getHeader();
            final Iterator iter = new ArrayList<InputStream>(bytes = tagging != null && tagging.equals("EXPLICIT") ? TemplateParser.skipExplicitHeader(object) : object.getValue()){
                final /* synthetic */ byte[] val$bytes;
                {
                    this.val$bytes = byArray;
                    this.add(new ByteArrayInputStream(h.getTag().getEncoding()));
                    this.add(new ByteArrayInputStream(h.getLength().getEncoding()));
                    this.add(new ByteArrayInputStream(this.val$bytes));
                }
            }.iterator();
            SequenceInputStream in = new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

                @Override
                public boolean hasMoreElements() {
                    return iter.hasNext();
                }

                @Override
                public InputStream nextElement() {
                    return (InputStream)iter.next();
                }
            });
            IRubyObject asn1 = RubyAsn1.generateAsn1Data(runtime, in);
            if (asn1 == null) {
                throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Could not parse ANY value")));
            }
            template.setValue(asn1);
            template.setDecoded(true);
        }
    };
    private static final ParseStrategy CHOICE_PARSER = new ParseStrategy(){

        @Override
        public ParseStrategy.MatchResult match(MatchContext mctx) {
            ThreadContext ctx = mctx.getCtx();
            Ruby runtime = ctx.getRuntime();
            RubyTemplate.ErrorCollector collector = mctx.getCollector();
            RubyTemplate.Definition definition = mctx.getDefinition();
            RubyArray layout = definition.getLayout().orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "Constructive type misses 'layout' definition")), collector);
            int layoutSize = layout.size();
            int firstAny = -1;
            String tagging = this.enforceExplicitTagging(runtime, definition, collector);
            for (int i = 0; i < layoutSize; ++i) {
                HashAdapter currentDefinition = new HashAdapter((RubyHash)layout.get(i));
                collector.clear();
                IRubyObject codec = (IRubyObject)currentDefinition.get(RubyTemplate.CODEC);
                if (codec == RubyTemplate.CODEC_ANY && firstAny == -1) {
                    firstAny = i;
                }
                HashAdapter options = currentDefinition.getHash(RubyTemplate.OPTIONS);
                RubyTemplate.Definition d = new RubyTemplate.Definition(currentDefinition, options);
                ParseStrategy s = d.accept(ctx, CodecStrategyVisitor.INSTANCE);
                MatchContext innerCtx = mctx.createTemporary(d);
                if (!this.successfullySkipHeaderIfExplicit(tagging, innerCtx)) {
                    return ParseStrategy.MatchResult.NO_MATCH;
                }
                try {
                    ParseStrategy.MatchResult mr = s.match(innerCtx);
                    switch (mr) {
                        case MATCHED: {
                            definition.setMatchedIndex(i);
                            return ParseStrategy.MatchResult.MATCHED;
                        }
                        case MATCHED_BY_DEFAULT: {
                            throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Inner CHOICE definition cannot have default values")));
                        }
                    }
                    continue;
                }
                catch (RaiseException ex) {
                    // empty catch block
                }
            }
            if (firstAny != -1) {
                definition.setMatchedIndex(firstAny);
                return ParseStrategy.MatchResult.MATCHED;
            }
            if (!definition.isOptional(ctx)) {
                throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Mandatory CHOICE value not found")));
            }
            return ParseStrategy.MatchResult.NO_MATCH;
        }

        private String enforceExplicitTagging(Ruby runtime, RubyTemplate.Definition definition, RubyTemplate.ErrorCollector collector) {
            String tagging = definition.getTagging().orNull();
            if (tagging != null && !tagging.equals("EXPLICIT")) {
                throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Only explicit tagging is allowed for CHOICEs")));
            }
            return tagging;
        }

        private boolean successfullySkipHeaderIfExplicit(String tagging, MatchContext mctx) {
            if (tagging != null) {
                try {
                    mctx.nextHeader();
                }
                catch (RuntimeException ex) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void parse(ParseContext pctx) {
            ThreadContext ctx = pctx.getCtx();
            Ruby runtime = ctx.getRuntime();
            RubyTemplate.ErrorCollector collector = pctx.getCollector();
            RubyTemplate.Definition definition = pctx.getDefinition();
            IRubyObject recv = pctx.getReceiver();
            RubyTemplate.Asn1Template template = pctx.getTemplate();
            RubyArray layout = definition.getLayout().orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "Constructive type misses 'layout' definition")), collector);
            int matchedIndex = definition.getMatchedIndex();
            InstanceVariables ivs = recv.getInstanceVariables();
            HashAdapter matchedDef = new HashAdapter((RubyHash)layout.get(matchedIndex));
            HashAdapter matchedOpts = matchedDef.getHash(RubyTemplate.OPTIONS);
            HashAdapter oldDef = definition.getDefinition();
            HashAdapter oldOptions = definition.getOptions();
            if (this.enforceExplicitTagging(runtime, definition, collector) != null) {
                template = TemplateParser.nextTemplate(new ByteArrayInputStream(template.getObject().getValue()));
            }
            template.setDefinition(matchedDef);
            template.setOptions(matchedOpts);
            RubyTemplate.Definition d = new RubyTemplate.Definition(matchedDef, matchedOpts);
            ParseContext innerCtx = new ParseContext(ctx, recv, template, d, collector);
            d.accept(ctx, CodecStrategyVisitor.INSTANCE).parse(innerCtx);
            RubyTemplate.RubyAsn1Template v = (RubyTemplate.RubyAsn1Template)ivs.getInstanceVariable("value");
            RubyTemplate.Asn1Template choiceTemplate = new RubyTemplate.Asn1Template(null, oldDef, oldOptions);
            choiceTemplate.setMatchedLayoutIndex(matchedIndex);
            choiceTemplate.setValue((IRubyObject)v);
            choiceTemplate.setParsed(true);
            choiceTemplate.setDecoded(true);
            IRubyObject type = d.getTypeAsObject(ctx).orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "'type' missing in inner choice definition")), collector);
            RubyNumeric tag = RubyNumeric.int2fix((Ruby)runtime, (long)template.getObject().getHeader().getTag().getTag());
            ((RubyTemplate.RubyAsn1Template)recv).setTemplate(choiceTemplate);
            ivs.setInstanceVariable("type", type);
            ivs.setInstanceVariable("tag", (IRubyObject)tag);
        }

        @Override
        public void decode(ParseContext ctx) {
        }
    };

    private TemplateParser() {
    }

    @JRubyMethod
    public static IRubyObject parse_der(ThreadContext ctx, IRubyObject recv, IRubyObject value) {
        try {
            Ruby rt = ctx.getRuntime();
            InputStream in = Streams.asInputStreamDer(rt, value);
            IRubyObject ret = TemplateParser.generateAsn1Template(ctx, (RubyClass)recv, in);
            if (ret == null) {
                throw Errors.newASN1Error(rt, "Premature end of data");
            }
            return ret;
        }
        catch (Exception e) {
            throw Errors.newParseError(ctx.getRuntime(), e.getMessage());
        }
    }

    protected static IRubyObject generateAsn1Template(ThreadContext ctx, RubyClass type, InputStream in) {
        ParsedHeader h = PARSER.next(in);
        Ruby runtime = ctx.getRuntime();
        if (h == null) {
            return null;
        }
        RubyHash definition = (RubyHash)type.instance_variable_get(ctx, (IRubyObject)runtime.newString("@definition"));
        if (definition == null || definition.isNil()) {
            throw Errors.newASN1Error(runtime, "Type + " + type + " has no ASN.1 definition");
        }
        HashAdapter d = new HashAdapter(definition);
        HashAdapter o = d.getHash(RubyTemplate.OPTIONS);
        RubyTemplate.Asn1Template template = new RubyTemplate.Asn1Template(h.getObject(), d, o);
        return new RubyTemplate.RubyAsn1Template(runtime, type, template);
    }

    private static ParseStrategy.MatchResult matchConstructed(MatchContext mctx, int defaultTag) {
        if (TemplateParser.tryMatchConstructed(mctx, defaultTag)) {
            return ParseStrategy.MatchResult.MATCHED;
        }
        return ParseStrategy.MatchResult.NO_MATCH;
    }

    private static void parseConstructed(ParseContext pctx) {
        ThreadContext ctx = pctx.getCtx();
        Ruby runtime = ctx.getRuntime();
        RubyTemplate.ErrorCollector collector = pctx.getCollector();
        RubyTemplate.Definition definition = pctx.getDefinition();
        IRubyObject recv = pctx.getReceiver();
        RubyTemplate.Asn1Template template = pctx.getTemplate();
        RubyArray layout = definition.getLayout().orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "Constructive type misses 'layout' definition")), collector);
        String tagging = definition.getTagging().orNull();
        Asn1Object object = template.getObject();
        Header h = object.getHeader();
        byte[] bytes = tagging != null && tagging.equals("EXPLICIT") ? TemplateParser.skipExplicitHeader(object) : object.getValue();
        int numParsed = 0;
        int minSize = definition.getMinSize().orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "Constructive type misses 'min_size' entry")), collector);
        int layoutSize = layout.getLength();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        RubyTemplate.Asn1Template current = TemplateParser.nextTemplate(in);
        if (current == null) {
            throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Reached end of data")));
        }
        boolean goOn = true;
        block3: for (int i = 0; i < layoutSize && goOn; ++i) {
            HashAdapter currentDefinition = new HashAdapter((RubyHash)layout.get(i));
            collector.clear();
            current.setDefinition(currentDefinition);
            current.setOptions(currentDefinition.getHash(RubyTemplate.OPTIONS));
            ParseStrategy s = current.accept(ctx, CodecStrategyVisitor.INSTANCE);
            RubyTemplate.Definition d = new RubyTemplate.Definition(current.getDefinition(), current.getOptions());
            ParseContext innerCtx = new ParseContext(ctx, recv, current, d, collector);
            ParseStrategy.MatchResult mr = s.match(innerCtx.asMatchContext());
            switch (mr) {
                case MATCHED: {
                    s.parse(innerCtx);
                    ++numParsed;
                    if (i >= layoutSize - 1 || (current = TemplateParser.nextTemplate(in)) != null) continue block3;
                    TemplateParser.checkRestIsOptional(pctx, layout, i + 1);
                    goOn = false;
                    continue block3;
                }
            }
        }
        if (numParsed < minSize) {
            String rest = collector.getErrorMessages();
            throw Errors.newASN1Error(runtime, "Expected " + minSize + ".." + layoutSize + " values. Got: " + numParsed + ' ' + rest);
        }
        if (h.getLength().isInfiniteLength()) {
            TemplateParser.parseEoc(runtime, in);
        }
        if (!Streams.isConsumed(in)) {
            throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Data left that could not be parsed")));
        }
        object.invalidateValue();
        template.setParsed(true);
        template.setDecoded(true);
    }

    private static void checkRestIsOptional(ParseContext pctx, RubyArray layout, int index) {
        ThreadContext ctx = pctx.getCtx();
        for (int i = index; i < layout.size(); ++i) {
            HashAdapter currentDefinition = new HashAdapter((RubyHash)layout.get(i));
            RubyTemplate.Definition definition = new RubyTemplate.Definition(currentDefinition, currentDefinition.getHash(RubyTemplate.OPTIONS));
            if (!definition.isOptional(ctx)) {
                String name = TemplateParser.determineName(definition.getName().orNull());
                String msg = "Mandatory value " + name + " not found";
                throw pctx.getCollector().addAndReturn((RuntimeException)((Object)Errors.newASN1Error(ctx.getRuntime(), msg)));
            }
            if (!definition.hasDefault(ctx)) continue;
            MatchContext mctx = pctx.asMatchContext();
            mctx.setDefinition(definition);
            TemplateParser.setDefaultValue(mctx);
        }
    }

    private static RubyTemplate.Asn1Template nextTemplate(InputStream in) {
        ParsedHeader next = PARSER.next(in);
        if (next == null) {
            return null;
        }
        return new RubyTemplate.Asn1Template(next.getObject(), null, null);
    }

    private static void parseEoc(Ruby runtime, InputStream in) {
        ParsedHeader next = PARSER.next(in);
        if (next == null) {
            throw Errors.newASN1Error(runtime, "Premature end of stream detected");
        }
        Tag t = next.getTag();
        if (t.getTag() != 0 || !t.getTagClass().equals((Object)TagClass.UNIVERSAL)) {
            throw Errors.newASN1Error(runtime, "No closing END OF CONTENTS found for constructive value");
        }
    }

    private static ParseStrategy.MatchResult matchConstructedOf(MatchContext pctx, int defaultTag) {
        if (TemplateParser.tryMatchConstructed(pctx, defaultTag)) {
            return ParseStrategy.MatchResult.MATCHED;
        }
        return TemplateParser.checkOptionalOrDefault(pctx, defaultTag);
    }

    private static void decodeConstructedOf(ParseContext pctx) {
        RubyArray values;
        ThreadContext ctx = pctx.getCtx();
        RubyTemplate.Definition definition = pctx.getDefinition();
        RubyTemplate.ErrorCollector collector = pctx.getCollector();
        Ruby runtime = ctx.getRuntime();
        String name = TemplateParser.determineName(definition.getName().orNull());
        RubyClass type = definition.getTypeAsClass(ctx).orCollectAndThrow((RuntimeException)((Object)Errors.newASN1Error(runtime, "'type missing in ASN.1 definition")), collector);
        String tagging = definition.getTagging().orNull();
        RubyTemplate.Asn1Template template = pctx.getTemplate();
        Asn1Object object = template.getObject();
        Header h = object.getHeader();
        byte[] bytes = tagging != null && tagging.equals("EXPLICIT") ? TemplateParser.skipExplicitHeader(object) : object.getValue();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            values = type.hasModuleInHierarchy(RubyTemplate.mTemplate) ? TemplateParser.decodeConstructedOfTemplates(ctx, type, in) : TemplateParser.decodeConstructedOfPrimitives(ctx, type, in);
        }
        catch (RuntimeException e) {
            throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, e.getMessage())));
        }
        if (values.isEmpty() && !definition.isOptional(ctx)) {
            throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Mandatory value " + name + "could not be parsed. Sequence is empty")));
        }
        if (h.getLength().isInfiniteLength()) {
            TemplateParser.parseEoc(runtime, in);
        }
        if (!Streams.isConsumed(in)) {
            throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(runtime, "Data left that could not be parsed")));
        }
        template.setValue((IRubyObject)values);
        object.invalidateValue();
        template.setDecoded(true);
    }

    private static RubyArray decodeConstructedOfTemplates(ThreadContext ctx, RubyClass type, InputStream in) {
        IRubyObject current;
        RubyArray ret = ctx.getRuntime().newArray();
        while ((current = TemplateParser.generateAsn1Template(ctx, type, in)) != null) {
            ret.add((Object)current);
        }
        return ret;
    }

    private static RubyArray decodeConstructedOfPrimitives(ThreadContext ctx, RubyClass type, InputStream in) {
        IRubyObject current;
        RubyArray ret = ctx.getRuntime().newArray();
        while ((current = RubyAsn1.generateAsn1Data(ctx.getRuntime(), in)) != null) {
            if (!current.callMethod(ctx, "kind_of?", (IRubyObject)type).isTrue()) {
                throw Errors.newASN1Error(ctx.getRuntime(), "Expected " + type + " but got " + current.getMetaClass());
            }
            ret.add((Object)current);
        }
        return ret;
    }

    private static byte[] skipExplicitHeader(Asn1Object object) {
        byte[] old = object.getValue();
        ParsedHeader h = PARSER.next(new ByteArrayInputStream(old));
        int headerLen = h.getHeaderLength();
        int newLen = old.length - headerLen;
        byte[] bytes = new byte[newLen];
        System.arraycopy(old, headerLen, bytes, 0, newLen);
        return bytes;
    }

    private static String determineName(String name) {
        if (name != null) {
            return name.substring(1);
        }
        return "value";
    }

    private static void setDefaultValue(MatchContext mctx) {
        ThreadContext ctx = mctx.getCtx();
        Ruby runtime = ctx.getRuntime();
        RubyTemplate.Definition definition = mctx.getDefinition();
        IRubyObject defaultValue = definition.getDefault(ctx).orThrow();
        String name = TemplateParser.determineName(definition.getName().orNull());
        RubyTemplate.Asn1Template newTemplate = new RubyTemplate.Asn1Template(null, definition.getDefinition(), definition.getOptions());
        newTemplate.setValue(defaultValue);
        newTemplate.setParsed(true);
        newTemplate.setDecoded(true);
        mctx.getReceiver().getInstanceVariables().setInstanceVariable(name, (IRubyObject)new RubyTemplate.RubyAsn1Template(runtime, newTemplate));
    }

    private static boolean tryMatchConstructed(MatchContext mctx, int defaultTag) {
        ThreadContext ctx = mctx.getCtx();
        RubyTemplate.ErrorCollector collector = mctx.getCollector();
        RubyTemplate.Definition definition = mctx.getDefinition();
        Integer tag = definition.getTagAsInteger().orNull();
        String tagging = definition.getTagging().orNull();
        Header h = mctx.getHeader();
        if (!h.getTag().isConstructed()) {
            if (!definition.isOptional(ctx)) {
                throw collector.addAndReturn((RuntimeException)((Object)Errors.newASN1Error(ctx.getRuntime(), "Mandatory sequence value not found")));
            }
            return false;
        }
        if (Matcher.matchTagAndClass(ctx, h, tag, tagging, defaultTag)) {
            return true;
        }
        if (!definition.isOptional(ctx)) {
            throw collector.addAndReturn((RuntimeException)((Object)Matcher.tagMismatch(ctx, h, tag, tagging, defaultTag, "Constructive")));
        }
        return false;
    }

    private static ParseStrategy.MatchResult checkOptionalOrDefault(MatchContext mctx, int defaultTag) {
        ThreadContext ctx = mctx.getCtx();
        RubyTemplate.Definition definition = mctx.getDefinition();
        RubyTemplate.ErrorCollector collector = mctx.getCollector();
        Integer tag = definition.getTagAsInteger().orNull();
        String tagging = definition.getTagging().orNull();
        String name = TemplateParser.determineName(definition.getName().orNull());
        if (!definition.isOptional(ctx)) {
            throw collector.addAndReturn((RuntimeException)((Object)Matcher.tagMismatch(ctx, mctx.getHeader(), tag, tagging, defaultTag, name)));
        }
        if (definition.hasDefault(ctx)) {
            TemplateParser.setDefaultValue(mctx);
            return ParseStrategy.MatchResult.MATCHED_BY_DEFAULT;
        }
        return ParseStrategy.MatchResult.NO_MATCH;
    }

    private static void parseAndAssign(ParseContext pctx) {
        ThreadContext ctx = pctx.getCtx();
        RubyTemplate.Definition definition = pctx.getDefinition();
        Ruby runtime = ctx.getRuntime();
        String name = TemplateParser.determineName(definition.getName().orNull());
        RubyTemplate.Asn1Template template = pctx.getTemplate();
        pctx.getReceiver().getInstanceVariables().setInstanceVariable(name, (IRubyObject)new RubyTemplate.RubyAsn1Template(runtime, template));
        template.setParsed(true);
        template.setDecoded(false);
    }

    private static class Matcher {
        private Matcher() {
        }

        public static boolean matchTagAndClass(ThreadContext ctx, Header header, Integer tag, String tagging, int defaultTag) {
            return Matcher.matchTag(ctx, header, tag, defaultTag) && Matcher.matchTagClass(ctx, header, tagging);
        }

        public static boolean matchTag(ThreadContext ctx, Header header, Integer tag, int defaultTag) {
            return header.getTag().getTag() == Matcher.getExpectedTag(tag, defaultTag);
        }

        public static boolean matchTagClass(ThreadContext ctx, Header header, String tagging) {
            return Matcher.getExpectedTagClass(tagging) == header.getTag().getTagClass();
        }

        public static RaiseException tagMismatch(ThreadContext ctx, Header header, Integer tag, String tagging, int defaultTag, String name) {
            Tag t = header.getTag();
            int actualTag = t.getTag();
            TagClass actualTagClass = t.getTagClass();
            int expectedTag = Matcher.getExpectedTag(tag, defaultTag);
            TagClass expectedTagClass = Matcher.getExpectedTagClass(tagging);
            StringBuilder msg = new StringBuilder();
            if (name != null) {
                msg.append("Could not parse ").append(name).append(": ");
            }
            if (expectedTag != actualTag) {
                msg.append("Tag mismatch. Expected: ").append(expectedTag).append(" Got:").append(actualTag);
            }
            if (!expectedTagClass.equals((Object)actualTagClass)) {
                msg.append(" Tag class mismatch. Expected:").append((Object)expectedTagClass).append(" Got: ").append((Object)actualTagClass);
            }
            return Errors.newASN1Error(ctx.getRuntime(), msg.toString());
        }

        private static int getExpectedTag(Integer tag, int defaultTag) {
            if (tag != null) {
                return tag;
            }
            return defaultTag;
        }

        private static TagClass getExpectedTagClass(String tagging) {
            if (tagging == null) {
                return TagClass.UNIVERSAL;
            }
            return TagClass.forName(tagging);
        }
    }

    protected static class CodecStrategyVisitor
    implements RubyTemplate.CodecVisitor<ParseStrategy> {
        protected static final CodecStrategyVisitor INSTANCE = new CodecStrategyVisitor();

        private CodecStrategyVisitor() {
        }

        @Override
        public ParseStrategy visitPrimitive() {
            return PRIMITIVE_PARSER;
        }

        @Override
        public ParseStrategy visitTemplate() {
            return TEMPLATE_PARSER;
        }

        @Override
        public ParseStrategy visitSequence() {
            return SEQUENCE_PARSER;
        }

        @Override
        public ParseStrategy visitSet() {
            return SET_PARSER;
        }

        @Override
        public ParseStrategy visitSequenceOf() {
            return SEQUENCE_OF_PARSER;
        }

        @Override
        public ParseStrategy visitSetOf() {
            return SET_OF_PARSER;
        }

        @Override
        public ParseStrategy visitAny() {
            return ANY_PARSER;
        }

        @Override
        public ParseStrategy visitChoice() {
            return CHOICE_PARSER;
        }
    }

    protected static interface ParseStrategy {
        public MatchResult match(MatchContext var1);

        public void parse(ParseContext var1);

        public void decode(ParseContext var1);

        public static enum MatchResult {
            MATCHED,
            MATCHED_BY_DEFAULT,
            NO_MATCH;


            public boolean isSuccess() {
                return MATCHED.equals((Object)this) || MATCHED_BY_DEFAULT.equals((Object)this);
            }
        }
    }

    protected static class MatchContext
    implements AbstractParseContext {
        private final ParseContext inner;
        private Header header;
        private RubyTemplate.Definition definition;

        public MatchContext(ParseContext pctx) {
            this.inner = pctx;
            this.header = pctx.getTemplate().getObject().getHeader();
            this.definition = pctx.getDefinition();
        }

        @Override
        public RubyTemplate.ErrorCollector getCollector() {
            return this.inner.getCollector();
        }

        @Override
        public ThreadContext getCtx() {
            return this.inner.getCtx();
        }

        @Override
        public IRubyObject getReceiver() {
            return this.inner.getReceiver();
        }

        @Override
        public RubyTemplate.Definition getDefinition() {
            return this.definition;
        }

        public void setDefinition(RubyTemplate.Definition d) {
            this.definition = d;
        }

        public Header getHeader() {
            return this.header;
        }

        public void nextHeader() {
            Asn1Object object = this.inner.getTemplate().getObject();
            ByteArrayInputStream in = new ByteArrayInputStream(object.getValue());
            this.header = PARSER.next(in);
        }

        public MatchContext createTemporary(RubyTemplate.Definition d) {
            MatchContext tmp = new MatchContext(this.inner);
            tmp.definition = d;
            tmp.header = this.header;
            return tmp;
        }
    }

    protected static class ParseContext
    implements AbstractParseContext {
        private final ThreadContext ctx;
        private final IRubyObject recv;
        private final RubyTemplate.Asn1Template template;
        private final RubyTemplate.ErrorCollector collector;
        private final RubyTemplate.Definition definition;

        public ParseContext(ThreadContext ctx, IRubyObject recv, RubyTemplate.Asn1Template template, RubyTemplate.Definition definition, RubyTemplate.ErrorCollector collector) {
            this.ctx = ctx;
            this.recv = recv;
            this.template = template;
            this.definition = definition;
            this.collector = collector;
        }

        @Override
        public RubyTemplate.ErrorCollector getCollector() {
            return this.collector;
        }

        @Override
        public ThreadContext getCtx() {
            return this.ctx;
        }

        @Override
        public IRubyObject getReceiver() {
            return this.recv;
        }

        @Override
        public RubyTemplate.Definition getDefinition() {
            return this.definition;
        }

        public RubyTemplate.Asn1Template getTemplate() {
            return this.template;
        }

        public MatchContext asMatchContext() {
            return new MatchContext(this);
        }
    }

    protected static interface AbstractParseContext {
        public RubyTemplate.ErrorCollector getCollector();

        public ThreadContext getCtx();

        public IRubyObject getReceiver();

        public RubyTemplate.Definition getDefinition();
    }
}

