package org.jrubyparser.parser;

public class Ruby18YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          238,  238,  256,  595,  238,  222,  242,  242,  200,  187, 
          242,  252,  390,  584,  245,  245,  232,  555,  245,  508, 
          574,  202,  112,  112,  261,  263,  631,  284,  200,  427, 
          238,  238,  112,  283,  285,  508,   95,  279,  605,  217, 
          253,  202,  277,  280,  277,  508,  667,   69,  231,   64, 
          345,  282,  301,  290,   71,  461,  355,  470,  475,  306, 
          801,  631,  509,  704,  248,  112,  706,  456,  508,  269, 
          222,   61,  660,  299,  749,  361,  799,  378,  802,  299, 
          217,  302,   60,  670,  508,  251,  508,  349,  218,  461, 
          252,  470,  465,  352,  508,  339,  470,   82,  348,  301, 
          340,  399,  345,  344,  461,  365,  470,  475,  663,  112, 
          508,  262,   67,  239,  239,  541,  217,  239,  430,  313, 
          314,  257,  309,  456,  451,  378,  378,   71,  381,  218, 
          508,   82,  473,  251,  508,  508,   65,  474,  579,   75, 
          508,  664,  443,  273,   61,   82,   82,  377,  377,  217, 
          257,  503,  508,  377,  300,  459,  460,  461,  450,  508, 
          300,   40,  462,  216,  219,  218,  349,  525,  266,  503, 
          759,  309,  456,  451,  339,   87,  451,  348,  438,  340, 
          268,  345,  344,  402,  257,  431,  432,  497,  402,  508, 
          554,  764,  765,  780,  766,  218,  691,  602,  218,  784, 
          801,  359,  391,  275,  278,  360,  508,  453,  592,   87, 
          455,  574,  508,  222,  392,  371,  393,  699,  869,  346, 
          238,  238,  285,   87,   87,  800,  347,  372,  448,  260, 
          723,  617,  295,  238,  373,  238,  238,   51,  773,  242, 
          297,  242,  429,  435,  268,  112,  112,  245,  315,  245, 
          245,  454,  269,  456,  457,  508,  280,  447,   56,   57, 
          508,  508,  341,  371,  371,  348,  563,  564,  565,  566, 
          349,  661,  683,  685,  459,  460,  464,  313,  314,  330, 
          583,  462,  393,  332,  333,  362,  844,  343,  368,  845, 
          264,  265,  846,  269,  344,  356,  357,  350,  508,  508, 
          487,  488,  489,  490,  491,  492,  493,  494,  495,  496, 
          497,  498,  499,  500,  501,  502,  503,  504,  505,  506, 
          507,  508,  509,  510,  511,  512,  530,   69,  533,   64, 
          238,  540,  543,  531,  378,  534,  553,  380,  238,  544, 
          479,  537,  277,  508,  537,  484,  239,  353,  239,  425, 
          508,   63,  631,  238,   82,  538,  546,  386,  631,  881, 
          354,  238,   62,  268,  508,  277,   82,  537,  414,  112, 
          375,  238,  531,  593,  544,  277,  396,  397,  238,  231, 
          817,  640,  643,  277,  598,  363,  461,  508,  470,  475, 
          604,  604,   67,  509,  238,  728,  498,  437,  456,  238, 
          238,  654,  655,  238,  268,  378,  277,  634,  646,  428, 
          459,  460,  627,  621,  508,  438,   65,  462,  376,  637, 
          601,  638,  438,  758,  853,  650,  651,  652,  378,  112, 
          313,  314,   87,  736,  200,  238,  379,  841,  238,  641, 
          238,   40,   40,  273,   87,   82,  642,  202,  851,  497, 
          497,  497,  574,  419,  387,  497,  497,  389,  497,  388, 
          508,  480,  481,  482,  483,  508,  273,  508,  395,  508, 
          508,  631,  371,   82,   82,  113,  113,  508,  398,   82, 
          212,  212,  212,  508,  273,  230,  212,  212,  409,  218, 
          212,  508,   40,  280,  631,  870,  410,  212,  683,  685, 
          280,  411,  508,  275,  415,  489,  805,  273,  716,  583, 
          386,  694,  679,  414,   82,  212,  212,  238,  230,  586, 
          212,  418,  611,   87,  315,  366,  275,  594,  497,  596, 
          246,  436,  367,  247,  582,  585,  674,  293,  294,  689, 
          508,  680,  679,  497,  275,  497,  508,  682,  684,  497, 
          498,  508,  498,  708,  508,  508,  188,  188,  459,  460, 
          565,  566,  230,   89,  700,  462,  440,  275,  467,  441, 
          442,  444,  445,  648,  458,  468,  212,  188,   82,  200, 
          707,  449,  238,  539,  477,  472,  434,   60,   60,  108, 
          108,  108,  202,   60,  384,  508,  238,   89,  583,  229, 
          188,  385,  587,  849,  393,  600,  606,  607,  277,  608, 
          238,   89,   89,  612,  238,  622,  645,  632,  238,  644, 
          649,  653,  623,  662,  671,  672,  112,  677,   60,  678, 
          238,  688,  229,  666,  666,  693,  695,  112,  112,  681, 
          692,  762,  627,  697,  274,  459,  460,  466,  698,  776, 
          778,  794,  462,  701,  774,  781,  777,  779,  498,  498, 
          498,  703,  782,  783,  498,  498,  232,  498,   79,  705, 
          709,  666,  786,  238,  713,  676,  229,  719,  722,  724, 
          238,  720,  112,  721,  790,   79,  676,  676,  725,  459, 
          460,  469,   60,  727,  212,  212,  462,   82,  403,  403, 
          690,  210,  210,  210,  777,  779,  782,  676,  737,  273, 
          738,  236,  238,  830,  744,  280,    6,  831,  254,  212, 
          712,  212,  212,  750,  752,  407,    6,  112,  753,  238, 
          756,   82,  408,  604,  238,  238,  271,  498,   82,  711, 
          826,  760,  715,  757,  585,  508,  827,  438,  828,  508, 
          508,  761,  585,  785,  439,  112,  508,  791,  498,  609, 
          795,  508,  421,  838,  423,  426,  610,  792,  808,  275, 
          839,  739,  238,  809,  810,    6,  815,  818,   82,  212, 
          212,  212,  212,   82,  212,  212,  557,  819,  558,  559, 
          560,  561,  824,  833,  839,  763,  238,  358,  508,  508, 
          508,  832,  771,  835,  772,  508,  859,  775,  834,  837, 
          238,   60,  402,  402,  238,  842,  212,  843,  854,  212, 
           89,  212,  230,  855,  212,  212,  666,  563,  564,  565, 
          566,  858,   89,  861,  863,  866,  112,  745,  867,  212, 
           82,  212,  868,  882,  884,   60,  238,  751,  238,    8, 
          806,  886,   60,   82,  497,  508,  499,  212,  878,    8, 
          508,   82,  238,   82,  238,  812,  813,  814,  508,  807, 
          499,  238,  406,  406,  406,  238,  112,  501,  255,  406, 
          212,  274,  230,  396,  396,  396,  501,  499,  274,  509, 
          396,  503,   60,  212,  524,  508,  557,   60,  558,  559, 
          560,  561,  503,   79,  304,  212,  115,   82,    8,  883, 
          836,   89,  676,  676,  190,  210,  210,  524,  847,  696, 
          770,   86,   86,  114,  114,  796,   74,   86,  305,  871, 
          562,  307,    0,  231,    0,  524,  229,  563,  564,  565, 
          566,    0,  848,   74,  308,  309,  310,  311,  312,  798, 
            7,    0,  280,  820,   60,    0,  822,  823,  524,  280, 
            7,    0,   86,    0,  489,   79,  231,   60,    0,    0, 
          585,    0,    0,  438,    0,   60,    0,   60,    6,    6, 
            6,   81,   79,  188,    6,    6,  872,    6,    0,  524, 
            0,    0,    0,  873,    0,    0,  229,    0,   81,    0, 
          210,  210,  210,  210,    0,  485,  486,  162,  315,    7, 
          231,    0,    0,  320,  321,    0,    0,    0,  212,   82, 
            0,   60,    0,    0,  328,  329,   86,    0,  274,    0, 
          585,    0,    0,    0,    0,    0,  862,  864,    0,  330, 
           82,  331,    0,  332,  333,  334,  335,  336,  337,  338, 
            0,  339,    0,    0,   82,    0,  162,    6,   89,   89, 
            0,    0,  556,    0,   89,    0,    0,    0,    0,  875, 
          876,  174,  315,    0,    0,  880,    0,    0,    6,  403, 
            0,  174,  212,    0,    0,    0,    0,    0,  887,  212, 
          403,  403,    0,    0,    0,  889,    0,    0,  891,   89, 
            0,    0,  893,  330,    0,    0,    0,  332,  333,  334, 
          335,    8,    8,    8,  271,  218,  212,    8,    8,    0, 
            8,    0,    0,    0,   52,    0,  647,  188,  188,   82, 
          174,    0,    0,   60,   52,  230,   82,    0,   82,  315, 
            0,   82,  212,  212,    0,   86,  404,  404,  212,    0, 
            0,    0,    0,    0,   60,  328,  329,    0,    0,    0, 
          524,   74,    0,   89,    0,    0,    0,    0,   60,    0, 
          330,    0,  331,    0,  332,  333,  334,  335,    0,   86, 
          403,    0,   52,   52,   82,    0,   86,  212,  196,    0, 
            8,    0,    0,  402,    0,    0,    0,    0,  196,   82, 
           82,   82,    0,    0,  402,  402,    0,    0,  403,    0, 
          438,    8,    7,    7,    7,    0,   81,  438,    7,    7, 
            0,    7,    0,   74,    0,    0,   86,    0,    0,    0, 
            0,   86,  196,    0,    0,    0,    0,    0,    0,  210, 
           74,    0,    0,   60,   82,    0,  196,  196,    0,  229, 
           60,  196,   60,    0,    0,   60,  212,    0,    0,    0, 
           82,    0,    0,    0,    0,  274,    0,    0,    0,    0, 
          231,    0,  274,    0,    0,    0,   82,    0,   81,    0, 
            0,    0,   89,  405,  406,    0,    0,    0,   86,  403, 
            0,    7,    0,    0,  402,   81,    0,    0,   60,    0, 
            0,   86,    0,  162,   84,  162,  162,  162,  162,   86, 
          210,   86,    7,   60,   60,   60,   89,    0,   82,    0, 
           82,    0,  402,   89,    0,  433,    0,   82,    0,  403, 
          231,    0,  433,  174,  174,  174,    0,  162,   84,  174, 
          174,    0,  174,    0,  162,  162,  162,  162,    0,    0, 
            0,    0,   84,   84,    0,   86,    0,    0,   60,    0, 
           80,  174,  174,   89,  174,  174,  174,  174,   89,    0, 
            0,    0,    0,    0,   60,    0,    0,   80,    0,    0, 
            0,    0,    0,    0,    0,  488,   52,   52,   52,    0, 
           60,   52,   52,   52,    0,   52,    0,    0,    0,    0, 
            0,    0,    0,  402,    0,   52,   52,  281,  210,    0, 
            0,    0,  174,    0,   52,   52,  218,   52,   52,   52, 
           52,   52,    0,    0,    0,   89,  218,    0,    0,    0, 
            0,    0,   60,  174,   60,    0,    0,    0,   89,    0, 
            0,   60,    0,  402,    0,    0,   89,    0,   89,    0, 
          196,  196,  196,    0,    0,  196,  196,  196,    0,  196, 
          218,    0,    0,    0,    0,   52,    0,   86,   52,  196, 
          196,   86,    0,    0,  218,  218,    0,    0,  196,  196, 
            0,  196,  196,  196,  196,  196,   52,   88,   86,    0, 
            0,    0,   89,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   86,    0,    0,   86,  196,  196,  196,  196, 
          196,  196,  196,  196,  196,  196,    0,  196,  196,   86, 
           86,   88,    0,    0,    0,    0,  196,  404,    0,  196, 
            0,    0,  196,    0,  196,   88,   88,    0,  404,  404, 
            0,    0,    0,    0,  196,  196,  196,    0,  196,    0, 
          196,    0,  489,    0,    0,    0,    0,    0,   62,   62, 
            0,   84,   75,    0,   62,   62,   62,   62,  281,    0, 
            0,   62,   62,   84,  488,   62,  315,   86,  768,   75, 
            0,    0,   62,  231,   86,    0,   86,    0,    0,   86, 
            0,    0,  328,  329,    0,   80,    0,   94,   94,   62, 
           62,   62,    0,   94,   89,   62,    0,  330,    0,  282, 
            0,  332,  333,  334,  335,    0,    0,    0,    0,    0, 
            0,    0,  488,    0,    0,   89,    0,    0,  404,  488, 
            0,    0,   86,  155,  488,    0,    0,    0,   94,   89, 
            0,    0,    0,    0,  281,    0,    0,   86,   86,   86, 
            0,  281,   84,    0,    0,  488,  404,   80,    0,   32, 
            0,   62,    0,   62,  731,    0,    0,    0,    0,   32, 
            0,    0,    0,    0,   80,  741,  742,    0,  218,  218, 
          218,    0,  155,  218,  218,  218,    0,  218,    0,    0, 
            0,    0,   86,    0,    0,    0,    0,  218,  218,    0, 
          412,  413,   94,  262,    0,    0,  218,  218,   86,  218, 
          218,  218,  218,  218,   89,    0,    0,    0,   32,    0, 
            0,   89,    0,   89,   86,    0,   89,    0,   86,    0, 
            0,    0,    0,    0,    0,    0,    0,  404,    0,    0, 
           86,  489,    0,    0,   88,    0,    0,    0,    0,    0, 
            0,  186,    0,    0,  218,    0,   88,  218,    0,    0, 
          218,  186,  218,    0,    0,  804,   86,    0,   86,   89, 
            0,    0,    0,    0,    0,   86,    0,  404,  218,   62, 
           62,    0,   62,    0,   89,   89,   89,    0,    0,  489, 
            0,    0,    0,  816,   85,  186,  489,   75,    0,    0, 
            0,  489,    0,    0,   62,  281,   62,   62,    0,  186, 
          186,    0,  281,    0,  186,  536,   62,    0,  542,   86, 
            0,   94,  489,   62,    0,    0,    0,    0,   85,   89, 
           76,    0,    0,    0,    0,   88,    0,    0,    0,    0, 
            0,  580,   85,   85,    0,   89,  282,   76,    0,    0, 
            0,    0,    0,  282,    0,   94,    0,    0,  536,   75, 
            0,   89,   94,   62,   62,   62,   62,   62,   62,   62, 
           62,    0,    0,    0,  857,  492,   75,  488,    0,  624, 
          626,    0,    0,  630,    0,    0,    0,  636,   34,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   34,    0, 
            0,   62,   94,   89,   62,   89,   62,   94,    0,   62, 
           62,    0,   89,    0,  874,  657,    0,    0,  630,    0, 
          657,   32,   32,   32,   62,   62,   62,   32,   32,  155, 
           32,  155,  155,  155,  155,    0,    0,    0,   62,    0, 
            0,    0,   62,    0,    0,    0,   62,   34,   62,    0, 
            0,  432,   32,   32,   32,   32,   32,    0,  432,    0, 
            0,    0,    0,  155,   94,   62,    0,    0,    0,    0, 
          155,  155,  155,  155,    0,    0,    0,   94,   62,  165, 
            0,    0,    0,    0,    0,   94,    0,   94,    0,    0, 
           62,    0,   62,    0,    0,    0,    0,  686,    0,    0, 
           32,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  186,  186,  186,    0,    0,  186,  186, 
          186,   32,  186,    0,    0,    0,    0,    0,  165,    0, 
            0,   94,  186,  186,   83,    0,    0,    0,    0,    0, 
            0,  186,  186,    0,  186,  186,  186,  186,  186,    0, 
            0,   85,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  726,   85,  492,   76,  488,    0,   83,  186, 
          186,  186,  186,  186,  186,  186,  186,  186,  186,    0, 
          186,  186,   83,   83,  186,  186,    0,    0,    0,  186, 
          743,  150,  186,    0,  746,  186,    0,  186,  747,    0, 
            0,  186,    0,   62,   62,  186,  186,  186,  186,  186, 
          626,  186,  492,  186,  488,  282,    0,    0,    0,  492, 
            0,  488,    0,    0,  488,   62,  488,   76,    0,    0, 
            0,    0,    0,    0,  517,  522,    0,  528,  529,   62, 
          150,    0,   85,   94,   76,  492,    0,  488,    0,    0, 
           34,   34,   34,  788,    0,    0,   34,   34,  552,   34, 
          793,    0,    0,    0,   94,    0,    0,   62,    0,    0, 
            0,    0,    0,    0,   62,  517,  522,    0,   94,    0, 
            0,   34,   34,   34,   34,   34,    0,    0,    0,    0, 
            0,    0,  657,    0,    0,    0,  427,    0,    0,  552, 
            0,   62,    0,    0,    0,    0,  427,    0,  315,  630, 
            0,    0,    0,    0,   62,  630,    0,    0,    0,    0, 
            0,   62,    0,   62,  328,  329,   62,   62,   62,   34, 
          552,    0,    0,   62,    0,    0,    0,    0,    0,  330, 
          427,  331,    0,  332,  333,  334,  335,    0,    0,  338, 
           34,  339,  840,   94,  427,  427,    0,  427,    0,  427, 
           94,    0,   94,    0,    0,   94,    0,    0,    0,   62, 
            0,    0,   62,    0,    0,  165,  850,  165,  165,  165, 
          165,    0,    0,    0,   62,   62,   62,  427,    0,    0, 
          860,   83,    0,    0,  865,    0,    0,  434,    0,    0, 
            0,    0,    0,   83,  434,    0,    0,    0,   94,  165, 
            0,    0,    0,    0,    0,    0,  165,  165,  165,  165, 
          430,    0,    0,   94,   94,   94,  626,    0,  630,   62, 
          430,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   62,  885,    0,  888,   62,    0,    0,    0,    0, 
            0,  630,  282,    0,    0,  892,    0,    0,    0,  282, 
            0,   62,    0,    0,  430,    0,    0,    0,   94,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  430,  430, 
            0,  430,   83,  430,   94,    0,    0,  150,    0,  150, 
          150,  150,  150,    0,    0,    0,    0,    0,    0,    0, 
           94,  552,    0,   62,    0,   62,    0,    0,    0,  435, 
            0,  430,   62,    0,    0,    0,  435,    0,    0,    0, 
            0,  150,    0,    0,    0,    0,    0,    0,  150,  150, 
          150,  150,  754,  755,    0,    0,    0,    0,  509,    0, 
            0,    0,   94,    0,   94,    0,    0,  257,  509,    0, 
            0,   94,    0,  485,  485,  485,    0,  485,  427,  427, 
          427,  485,  485,  427,  427,  427,  485,  427,  485,  485, 
          485,  485,  485,  485,  485,  427,  485,  427,  427,  485, 
          485,  485,  485,  485,  485,  485,  427,  427,    0,  427, 
          427,  427,  427,  427,    0,  485,  509,  509,  485,  485, 
          340,    0,  485,  485,  485,  485,  485,  485,    0,    0, 
          485,  485,  485,  427,  427,  427,  427,  427,  427,  427, 
          427,  427,  427,  427,  427,  427,  427,    0,    0,  427, 
          427,  427,  485,  427,  427,  485,  485,  427,  485,  485, 
          427,  485,  427,  485,  427,  485,  427,  485,  427,  427, 
          427,  427,  427,  427,  427,  485,  427,  485,  427,    0, 
          485,  485,  485,  485,  485,  485,   54,    0,    0,    0, 
            0,  485,  485,    0,  485,  485,   54,  486,  486,  486, 
            0,  486,  430,  430,  430,  486,  486,  430,  430,  430, 
          486,  430,  486,  486,  486,  486,  486,  486,  486,  430, 
          486,  430,  430,  486,  486,  486,  486,  486,  486,  486, 
          430,  430,    0,  430,  430,  430,  430,  430,    0,  486, 
            0,    0,  486,  486,   54,   54,  486,  486,  486,  486, 
          486,  486,    0,    0,  486,  486,  486,  430,  430,  430, 
          430,  430,  430,  430,  430,  430,  430,  430,  430,  430, 
          430,    0,    0,  430,  430,  430,  486,  430,  430,  486, 
          486,  430,  486,  486,  430,  486,  430,  486,  430,  486, 
          430,  486,  430,  430,  430,  430,  430,  430,  430,  486, 
          430,  486,  430,  488,  486,  486,  486,  486,  486,  486, 
            0,    0,    0,  488,    0,  486,  486,    0,  486,  486, 
          509,  509,  509,    0,    0,  509,  509,  509,    0,  509, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  509, 
          509,    0,    0,    0,    0,    0,    0,  488,  509,  509, 
            0,  509,  509,  509,  509,  509,    0,    0,    0,    0, 
            0,  488,  488,    0,   84,    0,  488,    0,    0,    0, 
            0,    0,    0,    0,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,    0,  326,  327,    0,    0, 
          328,  329,    0,    0,  488,    0,    0,    0,    0,  509, 
            0,    0,  509,    0,  509,  330,    0,  331,    0,  332, 
          333,  334,  335,  336,  337,  338,    0,  339,    0,    0, 
          509,    0,    0,    0,    0,    0,  489,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  489,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   54,   54, 
           54,    0,    0,   54,   54,   54,    0,   54,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   54,   54,    0, 
          489,    0,    0,    0,    0,    0,   54,   54,    0,   54, 
           54,   54,   54,   54,  489,  489,    0,   86,    0,  489, 
            0,    0,    0,    0,    0,    0,    0,    0,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,    0, 
            0,    0,    0,    0,  328,  329,    0,  489,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   54,    0,  330, 
           54,  331,    0,  332,  333,  334,  335,  336,  337,  338, 
            0,  339,    0,    0,    0,   56,    0,    0,   54,    0, 
            0,    0,    0,    0,    0,   56,    0,    0,  133,    0, 
          488,  488,  488,    0,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,  488,  488,  488,  488,  488,  488, 
          488,  488,    0,  488,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,  488,    0,  488,  488,  488,  488, 
          488,    0,  488,   56,   56,  488,  488,  133,    0,  488, 
          488,  488,  488,  488,  488,    0,    0,  488,  488,  488, 
          488,  488,  488,  488,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,    0,    0,  488,  488,  488,  488, 
            0,  488,  488,  488,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,  488,  488,    0,  488,  488,  488, 
          488,  488,  488,    0,    0,    0,    0,    0,  488,  488, 
            0,  488,  488,  489,  489,  489,    0,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,  489,  489,  489, 
          489,  489,  489,  489,  489,  622,  489,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,  489,    0,  489, 
          489,  489,  489,  489,  340,  489,    0,    0,  489,  489, 
            0,    0,  489,  489,  489,  489,  489,  489,    0,    0, 
          489,  489,  489,  489,  489,  489,  489,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,    0,    0,  489, 
          489,  489,  489,    0,  489,  489,  489,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,  489,  489,  492, 
          489,  489,  489,  489,  489,  489,    0,    0,    0,  492, 
            0,  489,  489,    0,  489,  489,    0,   56,   56,   56, 
            0,    0,   56,   56,   56,    0,   56,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   56,   56,    0,    0, 
            0,    0,    0,  492,    0,   56,   56,    0,   56,   56, 
           56,   56,   56,    0,    0,    0,    0,  492,  492,    0, 
           85,    0,  492,    0,  133,    0,  133,  133,  133,  133, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  437,    0,    0,    0, 
          492,    0,    0,  437,    0,    0,   56,    0,  133,   56, 
            0,    0,    0,    0,    0,  133,  133,  133,  133,  315, 
          316,  317,  318,  319,  320,  321,  322,   56,  324,  325, 
            0,    0,  275,    0,    0,  328,  329,    0,    0,    0, 
            0,    0,  275,    0,    0,    0,    0,    0,    0,    0, 
          330,    0,  331,    0,  332,  333,  334,  335,  336,  337, 
          338,    0,  339,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  275,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          275,  275,    0,    0,    0,  275,    0,    0,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,    0, 
          326,  327,    0,    0,  328,  329,    0,    0,    0,    0, 
            0,    0,    0,  275,    0,    0,    0,    0,    0,  330, 
            0,  331,    0,  332,  333,  334,  335,  336,  337,  338, 
            0,  339,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   40,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   40,    0,    0,  134,    0,  488,  488,  488,    0, 
          488,  492,  492,  492,  488,  488,  492,  492,  492,  488, 
          492,  488,  488,  488,  488,  488,  488,  488,    0,  492, 
          492,  492,  488,  488,  488,  488,  488,  488,  488,  492, 
          492,    0,  492,  492,  492,  492,  492,    0,  488,   40, 
           40,  488,  488,  134,    0,  488,  488,  488,  488,  488, 
          488,    0,    0,  488,  488,  488,  492,  492,  492,  492, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,  492, 
            0,    0,  492,  492,  492,  488,    0,  492,  488,  488, 
          492,  488,  488,  492,  488,  492,  488,  492,  488,  492, 
          488,  492,  492,  492,  492,  492,  492,  492,  488,  492, 
          492,  492,    0,  488,  488,  488,  488,  488,  488,    0, 
            0,    0,    0,    0,  488,  488,    0,  488,  488,  487, 
          487,  487,    0,  487,  275,  275,  275,  487,  487,  275, 
          275,  275,  487,  275,  487,  487,  487,  487,  487,  487, 
          487,    0,  487,  275,  275,  487,  487,  487,  487,  487, 
          487,  487,  275,  275,    0,  275,  275,  275,  275,  275, 
            0,  487,  669,    0,  487,  487,    0,  340,  487,  487, 
          487,  487,  487,  487,    0,    0,  487,  487,  487,  275, 
          275,  275,  275,  275,  275,  275,  275,  275,  275,  275, 
          275,  275,  275,    0,    0,  275,  275,  275,  487,    0, 
          275,  487,  487,  275,  487,  487,  275,  487,  275,  487, 
          275,  487,  275,  487,  275,  275,  275,  275,  275,  275, 
          275,  487,  275,  487,  275,  493,  487,  487,  487,  487, 
          487,  487,    0,    0,    0,  493,    0,  487,  487,    0, 
          487,  487,    0,   40,   40,   40,    0,    0,   40,   40, 
           40,    0,   40,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   40,    0,    0,    0,    0,    0,    0,  493, 
            0,   40,   40,    0,   40,   40,   40,   40,   40,    0, 
            0,    0,    0,  493,  493,    0,    0,    0,  493,    0, 
          134,    0,  134,  134,  134,  134,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  436,    0,    0,    0,  493,    0,    0,  436, 
            0,    0,   40,    0,  134,    0,    0,    0,    0,    0, 
            0,  134,  134,  134,  134,  315,  316,  317,  318,  319, 
          320,  321,    0,   40,  324,  325,    0,    0,  494,    0, 
            0,  328,  329,    0,    0,    0,    0,    0,  494,    0, 
            0,    0,    0,    0,    0,    0,  330,    0,  331,    0, 
          332,  333,  334,  335,  336,  337,  338,    0,  339,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  494,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  494,  494,    0,    0, 
            0,  494,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,    0,  326,  327,    0,    0,  328,  329,  494, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  330,    0,  331,    0,  332,  333,  334,  335, 
          336,  337,  338,    0,  339,    0,    0,   42,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   42,    0,    0, 
           95,    0,  490,  490,  490,    0,  490,  493,  493,  493, 
          490,  490,  493,  493,  493,  490,  493,  490,  490,  490, 
          490,  490,  490,  490,    0,  493,  493,  493,  490,  490, 
          490,  490,  490,  490,  490,  493,  493,    0,  493,  493, 
          493,  493,  493,    0,  490,   42,   42,  490,  490,   95, 
            0,  490,  490,  490,  490,  490,  490,    0,    0,  490, 
          490,  490,  493,  493,  493,  493,  493,  493,  493,  493, 
          493,  493,  493,  493,  493,  493,    0,    0,  493,  493, 
          493,  490,    0,  493,  490,  490,  493,  490,  490,  493, 
          490,  493,  490,  493,  490,  493,  490,  493,  493,  493, 
          493,  493,  493,  493,  490,  493,  493,  493,    0,  490, 
          490,  490,  490,  490,  490,    0,    0,    0,    0,    0, 
          490,  490,    0,  490,  490,  491,  491,  491,    0,  491, 
          494,  494,  494,  491,  491,  494,  494,  494,  491,  494, 
          491,  491,  491,  491,  491,  491,  491,    0,  494,  494, 
          494,  491,  491,  491,  491,  491,  491,  491,  494,  494, 
            0,  494,  494,  494,  494,  494,  340,  491,    0,    0, 
          491,  491,    0,    0,  491,  491,  491,  491,  491,  491, 
            0,    0,  491,  491,  491,  494,  494,  494,  494,  494, 
          494,  494,  494,  494,  494,  494,  494,  494,  494,    0, 
            0,  494,  494,  494,  491,    0,  494,  491,  491,  494, 
          491,  491,  494,  491,  494,  491,  494,  491,  494,  491, 
          494,  494,  494,  494,  494,  494,  494,  491,  494,  494, 
          494,  365,  491,  491,  491,  491,  491,  491,    0,    0, 
            0,  365,    0,  491,  491,    0,  491,  491,    0,   42, 
           42,   42,    0,    0,   42,   42,   42,    0,   42,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   42,    0, 
            0,    0,    0,    0,    0,  365,    0,   42,   42,    0, 
           42,   42,   42,   42,   42,    0,    0,    0,    0,  365, 
          365,    0,    0,    0,  365,    0,   95,    0,   95,   95, 
           95,   95,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  427,    0, 
            0,    0,  365,    0,    0,  427,    0,    0,   42,    0, 
           95,    0,    0,    0,    0,    0,    0,   95,   95,   95, 
           95,    0,    0,    0,    0,    0,    0,    0,    0,   42, 
            0,    0,    0,    0,  508,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  508,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  508,    0, 
          687,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  508,  508,    0,    0,    0,  508,    0,    0, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,    0,  326,  327,    0,    0,  328,  329,    0,    0, 
            0,    0,    0,    0,    0,  508,    0,    0,    0,    0, 
            0,  330,    0,  331,    0,  332,  333,  334,  335,  336, 
          337,  338,    0,  339,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   47,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   47,    0,    0,   96,    0,  252,  252, 
          252,    0,  252,  365,  365,  365,  252,  252,  365,  365, 
          365,  252,  365,  252,  252,  252,  252,  252,  252,  252, 
            0,  365,  365,  365,  252,  252,  252,  252,  252,  252, 
          252,  365,  365,    0,  365,  365,  365,  365,  365,    0, 
          252,   47,   47,  252,  252,   96,    0,  252,  252,  252, 
          252,  252,  252,    0,    0,  252,  252,  252,  365,  365, 
          365,  365,  365,  365,  365,  365,  365,  365,  365,  365, 
          365,  365,    0,    0,  365,  365,  365,  252,    0,  365, 
          252,    0,  365,  252,  252,  365,  252,  365,  252,  365, 
          252,  365,  252,  365,  365,  365,  365,  365,  365,  365, 
          252,  365,  365,  365,    0,  252,  252,  252,  252,  252, 
          252,    0,    0,    0,    0,    0,  252,  252,    0,  252, 
          252,  252,  252,  252,    0,  252,  508,  508,  508,  252, 
          252,  508,  508,  508,  252,  508,  252,  252,  252,  252, 
          252,  252,  252,    0,  508,  508,  508,  252,  252,  252, 
          252,  252,  252,  252,  508,  508,    0,  508,  508,  508, 
          508,  508,  340,  252,    0,    0,  252,  252,    0,    0, 
          252,  252,  252,  252,  252,  252,    0,    0,  252,  252, 
          252,  508,  508,  508,  508,  508,  508,  508,  508,  508, 
          508,  508,  508,  508,  508,    0,    0,  508,  508,  508, 
          252,    0,  508,  252,    0,  508,  252,  252,  508,  252, 
          508,  252,  508,  252,  508,  252,  508,  508,  508,  508, 
          508,  508,  508,  252,  508,  508,  508,  280,  252,  252, 
          252,  252,  252,  252,    0,    0,    0,  280,    0,  252, 
          252,    0,  252,  252,    0,   47,   47,   47,    0,    0, 
           47,   47,   47,    0,   47,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   47,    0,    0,    0,    0,    0, 
            0,  280,    0,   47,   47,    0,   47,   47,   47,   47, 
           47,    0,    0,    0,    0,  280,  280,    0,   87,    0, 
          280,    0,   96,    0,   96,   96,   96,   96,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  430,    0,    0,    0,  280,    0, 
            0,  430,    0,    0,   47,    0,   96,    0,    0,    0, 
            0,    0,    0,   96,   96,   96,   96,    0,    0,    0, 
            0,    0,    0,    0,    0,   47,    0,    0,    0,    0, 
          288,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          288,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  288, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  288,  288,    0,    0,    0,  288,    0, 
            0,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,    0,  326,  327,    0,    0,  328,  329,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,    0,  330,    0,  331,    0,  332,  333,  334,  335, 
          336,  337,  338,    0,  339,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   41,    0,    0,    0,    0,  489, 
          489,  489,    0,  489,  280,  280,  280,  489,  489,  280, 
          280,  280,  489,  280,  489,  489,  489,  489,  489,  489, 
          489,    0,    0,  280,  280,  489,  489,  489,  489,  489, 
          489,  489,  280,  280,    0,  280,  280,  280,  280,  280, 
            0,  489,   41,   41,  489,  489,    0,    0,  489,  489, 
          489,  489,  489,  489,    0,    0,  489,  489,  489,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,    0,    0,  280,  280,  280,  489,    0, 
          280,  489,  489,  280,  489,  489,  280,  489,  280,  489, 
          280,  489,  280,  489,  280,  280,  280,  280,  280,  280, 
          280,  489,  280,    0,  280,    0,  489,  489,  489,  489, 
          489,  489,    0,    0,    0,    0,    0,  489,  489,    0, 
          489,  489,  252,  252,  252,    0,  252,  288,  288,  288, 
          252,  252,  288,  288,  288,  252,  288,  252,  252,  252, 
          252,  252,  252,  252,    0,    0,  288,  288,  252,  252, 
          252,  252,  252,  252,  252,  288,  288,    0,  288,  288, 
          288,  288,  288,    0,  252,    0,    0,  252,  252,    0, 
            0,  252,  252,  252,  252,  252,  252,    0,    0,  252, 
          252,  252,  288,  288,  288,  288,  288,  288,  288,  288, 
          288,  288,  288,  288,  288,  288,    0,    0,  288,  288, 
          288,  252,    0,  288,  252,    0,  288,  252,  252,  288, 
          252,  288,  252,  288,  252,  288,  252,  288,  288,  288, 
          288,  288,  288,  288,  252,  288,  488,  288,    0,  252, 
          252,  252,  252,  252,  252,    0,  488,    0,    0,    0, 
          252,  252,    0,  252,  252,    0,   41,   41,   41,    0, 
            0,   41,   41,   41,    0,   41,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   41,    0,    0,    0,    0, 
           76,    0,    0,    0,    0,    0,    0,   41,   41,   41, 
           41,   41,    0,    0,    0,  488,    0,   84,    0,  488, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  488,    0,    0, 
            0,    0,    0,    0,    0,   41,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,   41,    0,   11,  489, 
           12,   13,   14,   96,   97,   17,   18,    0,    0,  489, 
            0,   98,   99,  100,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  101,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,    0,   78,  104,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  489,    0, 
           86,    0,  489,    0,  225,    0,    0,  226,    0,    0, 
           44,   45,    0,   46,    0,  227,    0,  228,    0,    0, 
            0,    0,    0,    0,    0,    0,  769,    0,    0,    0, 
          489,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   14,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   14,    0,    0, 
            0,    0,    0,  488,  488,  488,    0,  488,  488,  488, 
          488,  488,  488,    0,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,  488,    0,  488,    0,    0,  488, 
          488,  488,  488,  488,  488,  488,  488,  488,    0,  488, 
          488,  488,  488,  488,    0,  488,   14,    0,  488,  488, 
            0,    0,  488,  488,  488,  488,  488,  488,    0,    0, 
          488,  488,  488,  488,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,  488,  488,  488,    0,    0,  488, 
          488,  488,  488,    0,    0,  488,  488,  488,  488,  488, 
            0,  488,    0,  488,  488,  488,  488,  488,  488,  488, 
          488,  488,  488,  488,  488,  488,  488,  488,  488,    0, 
          488,  488,  488,  488,  488,  488,    0,    0,    0,    0, 
            0,  488,  488,    0,  488,  488,  489,  489,  489,    0, 
          489,  489,  489,  489,  489,  489,    0,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,  489,    0,  489, 
            0,    0,  489,  489,  489,  489,  489,  489,  489,  489, 
          489,    0,  489,  489,  489,  489,  489,    0,  489,    0, 
            0,  489,  489,    0,    0,  489,  489,  489,  489,  489, 
          489,    0,    0,  489,  489,  489,  489,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,  489,  489,  489, 
            0,    0,  489,  489,  489,  489,    0,    0,  489,  489, 
          489,  489,  489,    0,  489,    0,  489,  489,  489,  489, 
          489,  489,  489,  489,  489,  489,  489,  489,  489,  489, 
          489,  489,  492,  489,  489,  489,  489,  489,  489,    0, 
            0,    0,  492,    0,  489,  489,    0,  489,  489,   14, 
           14,   14,    0,    0,    0,   14,   14,    0,   14,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   77,    0,    0,    0, 
           14,   14,   14,   14,   14,    0,    0,    0,    0,    0, 
            0,  492,    0,   85,    0,  492,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  492,    0,    0,    0,    0,   14,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    3,    4,    5,    6,    7,    8,    0,   14, 
            0,    9,   10,    0,    0,  280,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,  280,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,   29,   30,   31,   32, 
            0,    0,   33,   34,   35,   36,   37,   38,    0,   79, 
           39,   40,   41,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  280,    0,   87,    0,  280,    0, 
            0,    0,   42,    0,    0,   43,    0,    0,   44,   45, 
            0,   46,    0,   47,    0,    0,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,   49,  280,    0,    0,    0, 
           50,   51,   52,   53,   54,   55,    0,    0,    0,    0, 
            0,   56,   57,    0,   58,   59,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  508,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  508,  488, 
          488,  488,    0,  488,  492,  492,  492,  488,  488,    0, 
          492,  492,  488,  492,  488,  488,  488,  488,  488,  488, 
          488,    0,  492,    0,    0,  488,  488,  488,  488,  488, 
          488,  488,  492,  492,    0,  492,  492,  492,  492,  492, 
            0,  488,    0,    0,  488,  488,  508,  508,  488,  488, 
          488,  488,  488,  488,    0,    0,  488,  488,  488,  492, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,  492, 
          492,  492,  492,    0,    0,  492,  492,  492,  488,    0, 
            0,  488,  488,  492,  488,  488,    0,  488,    0,  488, 
          492,  488,  492,  488,  492,  492,  492,  492,  492,  492, 
          492,  488,  492,  492,  492,    0,  488,  488,  488,  488, 
          488,  488,    0,    0,    0,    0,    0,  488,  488,    0, 
          488,  488,  489,  489,  489,    0,  489,  280,  280,  280, 
          489,  489,    0,  280,  280,  489,  280,  489,  489,  489, 
          489,  489,  489,  489,    0,    0,    0,   90,  489,  489, 
          489,  489,  489,  489,  489,  280,  280,    0,  280,  280, 
          280,  280,  280,    0,  489,    0,    0,  489,  489,    0, 
            0,  489,  489,  489,  489,  489,  489,    0,    0,  489, 
          489,  489,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,   90,    0,  280,  280, 
          280,  489,    0,    0,  489,  489,  280,  489,  489,    0, 
          489,    0,  489,  280,  489,  280,  489,  280,  280,  280, 
          280,  280,  280,  280,  489,  280,    0,  280,  427,  489, 
          489,  489,  489,  489,  489,    0,    0,    0,    0,    0, 
          489,  489,    0,  489,  489,  252,  252,  252,    0,  252, 
          508,  508,  508,  252,  252,  508,  508,  508,  252,  508, 
          252,  252,  252,  252,  252,  252,  252,    0,    0,  508, 
            0,  252,  252,  252,  252,  252,  252,  252,  508,  508, 
            0,  508,  508,  508,  508,  508,    0,  252,    0,   91, 
          252,  252,    0,    0,  252,  252,  252,  252,  252,  252, 
            0,    0,  252,  252,  252,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  508,    0,    0,    0, 
            0,    0,    0,  508,  252,    0,    0,  252,    0,  508, 
          252,  252,    0,  252,    0,  252,    0,  252,   91,  252, 
            0,    0,    0,    0,    0,    0,    0,  252,    0,    0, 
          508,    0,  252,  252,  252,  252,  252,  252,    0,    0, 
            0,    0,    0,  252,  252,    0,  252,  252,    0,    0, 
          430,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   90,   90,   90,   90,   90,   90,   90, 
           90,   90,   90,   90,    0,    0,   90,   90,    0,   90, 
           90,   90,   90,   90,   90,   90,    0,  485,   90,    0, 
           90,   90,   90,   90,   90,   90,   90,    0,    0,   90, 
            0,    0,    0,    0,    0,   90,   90,   90,   90,   90, 
           90,    0,    0,   90,   90,   90,   90,   90,   90,    0, 
            0,   90,   90,   90,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  427,    0,   90,    0,    0, 
            0,    0,  427,   90,    0,    0,   90,  485,    0,   90, 
           90,    0,   90,    0,   90,    0,    0,    0,   90,    0, 
            0,    0,    0,   90,    0,    0,   90,    0,  485,  492, 
            0,   90,   90,   90,   90,   90,   90,    0,    0,    0, 
            0,    0,   90,   90,    0,   90,   90,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,    0,   91,   91,   91, 
            0,   91,   91,   91,   91,   91,   91,   91,    0,  486, 
            0,    0,   91,   91,   91,   91,   91,   91,   91,    0, 
            0,   91,    0,    0,    0,    0,    0,   91,   91,   91, 
           91,   91,   91,    0,    0,   91,   91,   91,   91,   91, 
           91,    0,    0,   91,   91,   91,   91,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  430,    0,    0, 
            0,    0,    0,    0,  430,   91,    0,    0,   91,  486, 
            0,   91,   91,    0,   91,    0,   91,    0,  280,    0, 
           91,    0,    0,    0,    0,   91,    0,    0,   91,    0, 
          486,    0,    0,   91,   91,   91,   91,   91,   91,    0, 
            0,    0,    0,    0,   91,   91,    0,   91,   91,    0, 
            0,    0,    0,    0,   90,   90,   90,   90,   90,   90, 
           90,   90,   90,   90,   90,    0,   91,   90,   90,    0, 
           90,   90,   90,   90,   90,   90,   90,    0,  492,    0, 
            0,   90,   90,   90,   90,   90,   90,   90,    0,    0, 
           90,    0,    0,    0,    0,    0,   90,   90,   90,   90, 
           90,   90,    0,    0,   90,   90,   90,   90,   90,   90, 
            0,    0,   90,   90,   90,   91,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  492,    0,    0,    0, 
            0,    0,    0,  492,   90,    0,    0,   90,  488,    0, 
           90,   90,    0,   90,    0,   90,    0,  281,    0,   90, 
            0,    0,    0,    0,   90,    0,    0,   90,    0,  492, 
            0,    0,   90,   90,   90,   90,   90,   90,    0,    0, 
            0,    0,    0,   90,   90,    0,   90,   90,    0,    0, 
            0,    0,    0,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,    0,  324,   91,   91,    0,   91, 
           91,   91,   91,   91,   91,   91,    0,    0,    0,    0, 
           91,   91,   91,   91,   91,   91,   91,    0,    0,   91, 
            0,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,    0,    0,   91,   91,   91,   91,   91,   91,    0, 
            0,   91,   91,   91,  324,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  280,    0,    0,    0,    0, 
            0,    0,  280,   91,    0,    0,   91,  489,    0,   91, 
           91,    0,   91,    0,   91,    0,    0,    0,   91,    0, 
            0,    0,    0,   91,    0,    0,   91,    0,    0,    0, 
            0,   91,   91,   91,   91,   91,   91,    0,    0,    0, 
            0,    0,   91,   91,    0,   91,   91,    0,    0,    0, 
            0,    0,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,    0,  508,   91,   91,    0,   91,   91, 
           91,   91,   91,   91,   91,    0,    0,    0,    0,   91, 
           91,   91,   91,   91,   91,   91,    0,    0,   91,    0, 
            0,    0,    0,    0,   91,   91,   91,   91,   91,   91, 
            0,    0,   91,   91,   91,   91,   91,   91,    0,    0, 
           91,   91,   91,  508,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  281,    0,    0,    0,    0,    0, 
            0,  281,   91,    0,    0,   91,    0,    0,   91,   91, 
            0,   91,    0,   91,    0,    0,    0,   91,    0,    0, 
            0,    0,   91,    0,    0,   91,    0,    0,    0,    0, 
           91,   91,   91,   91,   91,   91,    0,    0,    0,    0, 
            0,   91,   91,    0,   91,   91,    0,    0,    0,    0, 
            0,  324,  324,  324,  324,  324,  324,  324,  324,  324, 
          324,  324,    0,  324,  324,  324,  324,  324,  324,  324, 
          324,  324,  324,  324,  508,    0,    0,    0,  324,  324, 
          324,  324,  324,  324,  324,    0,    0,  324,    0,    0, 
            0,    0,    0,  324,  324,  324,  324,  324,  324,    0, 
            0,  324,  324,  324,  324,  324,  324,    0,    0,  324, 
          324,  324,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  508,    0,    0,    0,    0,    0,    0, 
            0,  324,    0,    0,  324,    0,    0,  324,  324,    0, 
          324,    0,  324,    0,    0,    0,  324,    0,    0,    0, 
            0,    0,    0,    0,  324,    0,    0,    0,    0,  324, 
          324,  324,  324,  324,  324,    0,    0,    0,    0,    0, 
          324,  324,    0,  324,  324,    0,    0,    0,    0,    0, 
          508,  508,  508,  508,  508,  508,    0,    0,  508,  508, 
          508,    0,    0,    0,  508,    0,  508,  508,  508,  508, 
          508,  508,  508,  217,    0,    0,    0,  508,  508,  508, 
          508,  508,  508,  508,    0,    0,  508,    0,    0,    0, 
            0,    0,  508,  508,  508,  508,  508,  508,    0,    0, 
          508,  508,  508,  508,  508,  508,    0,    0,  508,  508, 
          508,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  218,    0,    0,    0,    0,    0,    0,    0, 
          508,    0,    0,  508,    0,    0,  508,  508,    0,  508, 
            0,  508,    0,    0,    0,  508,    0,    0,    0,    0, 
            0,    0,    0,  508,    0,    0,    0,    0,  508,  508, 
          508,  508,  508,  508,    0,    0,    0,    0,    0,  508, 
          508,    0,  508,  508,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          508,  508,  508,  508,  508,  508,    0,    0,    0,  508, 
          508,    0,    0,  365,  508,    0,  508,  508,  508,  508, 
          508,  508,  508,  365,    0,    0,    0,  508,  508,  508, 
          508,  508,  508,  508,    0,    0,  508,    0,    0,    0, 
            0,    0,  508,  508,  508,  508,  508,  508,    0,    0, 
          508,  508,  508,  508,  508,  508,    0,  365,  508,  508, 
          508,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  365,  365,    0,    0,    0,  365,    0,    0,    0, 
          508,    0,    0,  508,    0,    0,  508,  508,    0,  508, 
            0,  508,    0,    0,    0,  508,    0,    0,    0,    0, 
            0,    0,    0,  508,  365,    0,  508,    0,  508,  508, 
          508,  508,  508,  508,    0,    0,    0,    0,    0,  508, 
          508,    0,  508,  508,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,  438,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,  438,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,    0,    0,   33, 
           34,   35,   36,   37,   38,    0,  438,   39,   40,   41, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          438,  438,    0,   82,    0,  438,    0,    0,    0,  208, 
            0,    0,  107,    0,    0,   44,   45,    0,   46,    0, 
            0,    0,    0,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,   49,  438,    0,    0,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,  508,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  508,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  365,  365,  365,    0,    0, 
          365,  365,  365,    0,  365,    0,    0,    0,    0,    0, 
            0,    0,    0,  365,  365,  365,    0,  508,    0,    0, 
            0,    0,    0,  365,  365,    0,  365,  365,  365,  365, 
          365,  508,  508,    0,    0,    0,  508,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          365,  365,  365,  365,  365,  365,  365,  365,  365,  365, 
          365,  365,  365,  365,  508,    0,  365,  365,  365,    0, 
            0,  365,    0,    0,  365,    0,    0,  365,    0,  365, 
            0,  365,    0,  365,    0,  365,  365,  365,  365,  365, 
          365,  365,    0,  365,  365,  365,    0,    0,    0,    0, 
            0,    0,  274,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  274,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  438,  438,  438,    0,    0,  438, 
          438,  438,    0,  438,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  438,  438,    0,  274,    0,    0,    0, 
            0,    0,  438,  438,    0,  438,  438,  438,  438,  438, 
          274,  274,    0,   89,    0,  274,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  438, 
          438,  438,  438,  438,  438,  438,  438,  438,  438,  438, 
          438,  438,  438,  274,    0,  438,  438,  438,    0,  439, 
          438,    0,    0,  438,    0,    0,  438,    0,  438,    0, 
          438,    0,  438,  281,  438,  438,  438,  438,  438,  438, 
          438,    0,  438,  281,  438,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  508,  508,  508,    0,    0, 
          508,  508,  508,    0,  508,    0,    0,    0,    0,    0, 
            0,    0,    0,  508,  508,  508,    0,  281,    0,    0, 
            0,    0,    0,  508,  508,    0,  508,  508,  508,  508, 
          508,  281,  281,    0,   88,    0,  281,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          508,  508,  508,  508,  508,  508,  508,  508,  508,  508, 
          508,  508,  508,  508,  281,    0,  508,  508,  508,    0, 
            0,  508,    0,    0,  508,    0,    0,  508,    0,  508, 
            0,  508,    0,  508,    0,  508,  508,  508,  508,  508, 
          508,  508,    0,  508,  508,  508,    0,    0,    0,    0, 
            0,    0,  282,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  282,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  274,  274,  274,    0,    0,  274, 
          274,  274,    0,  274,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  274,  274,    0,  282,    0,    0,    0, 
            0,    0,  274,  274,    0,  274,  274,  274,  274,  274, 
          282,  282,    0,   83,    0,  282,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  274, 
          274,  274,  274,  274,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,  282,    0,  274,  274,  274,    0,    0, 
          274,    0,    0,  274,    0,    0,  274,    0,  274,    0, 
          274,    0,  274,  388,  274,  274,  274,  274,  274,  274, 
          274,    0,  274,  388,  274,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  281,  281,  281,    0,    0, 
          281,  281,  281,    0,  281,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  281,  281,    0,  388,    0,    0, 
            0,    0,    0,  281,  281,    0,  281,  281,  281,  281, 
          281,  388,  388,    0,    0,    0,  388,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,  388,    0,  281,  281,  281,    0, 
            0,  281,    0,    0,  281,    0,    0,  281,    0,  281, 
            0,  281,    0,  281,    0,  281,  281,  281,  281,  281, 
          281,  281,    0,  281,    0,  281,    0,    0,    0,    0, 
            0,    0,  291,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  291,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  282,  282,  282,    0,    0,  282, 
          282,  282,    0,  282,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  282,  282,    0,  291,    0,    0,    0, 
            0,    0,  282,  282,    0,  282,  282,  282,  282,  282, 
          291,  291,    0,    0,    0,  291,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,  291,    0,  282,  282,  282,    0,    0, 
          282,    0,    0,  282,    0,    0,  282,    0,  282,    0, 
          282,    0,  282,  217,  282,  282,  282,  282,  282,  282, 
          282,    0,  282,  217,  282,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  388,  388,  388,    0,    0, 
          388,  388,  388,    0,  388,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  388,  388,    0,  217,    0,    0, 
            0,    0,    0,  388,  388,    0,  388,  388,  388,  388, 
          388,  217,  217,    0,    0,    0,  217,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          388,  388,  388,  388,  388,  388,  388,  388,  388,  388, 
          388,  388,  388,  388,  323,    0,  388,  388,  388,    0, 
            0,  388,    0,    0,  388,    0,    0,  388,    0,  388, 
            0,  388,    0,  388,    0,  388,  388,  388,  388,  388, 
          388,  388,    0,  388,    0,  388,    0,    0,    0,    0, 
            0,    0,  288,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  288,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  291,  291,  291,    0,    0,  291, 
          291,  291,    0,  291,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  291,  291,    0,  288,    0,    0,    0, 
            0,    0,  291,  291,    0,  291,  291,  291,  291,  291, 
          288,  288,    0,    0,    0,  288,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  291, 
          291,  291,  291,  291,  291,  291,  291,  291,  291,  291, 
          291,  291,  291,  288,    0,  291,  291,  291,    0,    0, 
          291,    0,    0,  291,    0,    0,  291,    0,  291,    0, 
          291,    0,  291,  425,  291,  291,  291,  291,  291,  291, 
          291,    0,  291,  425,  291,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,  217,  217,    0,    0, 
          217,  217,  217,    0,  217,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  217,  217,    0,  425,    0,    0, 
            0,    0,    0,  217,  217,    0,  217,  217,  217,  217, 
          217,  425,  425,    0,    0,    0,  425,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,  217,  217,  217,  217,  217,  217,  217,  217,  217, 
          217,  323,  217,  217,  425,    0,  217,  217,  323,    0, 
            0,  217,    0,    0,  217,    0,    0,  217,    0,  217, 
            0,  217,    0,  217,    0,  217,  217,  217,  217,  217, 
          217,  217,    0,  217,    0,  217,    0,    0,    0,    0, 
            0,    0,  426,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  426,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  288,  288,  288,    0,    0,  288, 
          288,  288,    0,  288,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  288,  288,    0,  426,    0,    0,    0, 
            0,    0,  288,  288,    0,  288,  288,  288,  288,  288, 
          426,  426,    0,    0,    0,  426,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  288, 
          288,  288,  288,  288,  288,  288,  288,  288,  288,  288, 
          288,  288,  288,  426,    0,  288,  288,  288,    0,    0, 
          288,    0,    0,  288,    0,    0,  288,    0,  288,    0, 
          288,    0,  288,  319,  288,  288,  288,  288,  288,  288, 
          288,    0,  288,  319,  288,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  425,  425,  425,    0,    0, 
          425,  425,  425,    0,  425,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  425,  425,    0,  319,    0,    0, 
            0,    0,    0,  425,  425,    0,  425,  425,  425,  425, 
          425,  319,  319,    0,    0,    0,  319,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  425,  425,  425,  425,  425,  425,  425,  425,  425, 
          425,  425,  425,  425,  319,    0,  425,  425,  425,    0, 
            0,  425,    0,    0,  425,    0,    0,  425,    0,  425, 
            0,  425,    0,  425,    0,  425,  425,  425,  425,  425, 
          425,  425,    0,  425,    0,  425,    0,    0,    0,    0, 
            0,    0,  320,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  320,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  426,  426,  426,    0,    0,  426, 
          426,  426,    0,  426,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  426,  426,    0,  320,    0,    0,    0, 
            0,    0,  426,  426,    0,  426,  426,  426,  426,  426, 
          320,  320,    0,    0,    0,  320,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          426,  426,  426,  426,  426,  426,  426,  426,  426,  426, 
          426,  426,  426,  320,    0,  426,  426,  426,    0,    0, 
          426,    0,    0,  426,    0,    0,  426,    0,  426,    0, 
          426,    0,  426,  285,  426,  426,  426,  426,  426,  426, 
          426,    0,  426,  285,  426,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  319,  319,  319,    0,    0, 
          319,  319,  319,    0,  319,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  319,    0,    0,  285,    0,    0, 
            0,    0,    0,  319,  319,    0,  319,  319,  319,  319, 
          319,  285,  285,    0,    0,    0,  285,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  319, 
          319,  319,  319,  319,  285,    0,  319,  319,  319,    0, 
            0,  319,    0,    0,  319,    0,    0,    0,    0,    0, 
            0,  319,    0,  319,    0,  319,  319,  319,  319,  319, 
          319,  319,    0,  319,    0,  319,    0,    0,    0,    0, 
            0,    0,  195,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  195,    0,    0,    0,    0,    0,    0,    0, 
           78,    0,    0,    0,  320,  320,  320,    0,    0,  320, 
          320,  320,    0,  320,    0,    0,    0,   78,    0,    0, 
            0,    0,    0,  320,    0,    0,  195,    0,    0,    0, 
            0,    0,  320,  320,    0,  320,  320,  320,  320,  320, 
          195,  195,    0,    0,    0,  195,    0,  489,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,    0,    0,  320,  320,  320,    0,    0, 
          320,    0,    0,  320,    0,    0,    0,    0,    0,    0, 
          320,    0,  320,  191,  320,  320,  320,  320,  320,  320, 
          320,    0,  320,  191,  320,    0,    0,    0,    0,    0, 
            0,   77,    0,    0,    0,  285,  285,  285,    0,    0, 
          285,  285,  285,    0,  285,    0,    0,    0,   77,    0, 
            0,    0,    0,    0,  285,    0,    0,  191,    0,    0, 
            0,    0,    0,  285,  285,    0,  285,  285,  285,  285, 
          285,  191,  191,    0,    0,    0,  191,    0,  492,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          285,  285,  285,  285,  285,  285,  285,  285,  285,  285, 
          285,  285,  285,  285,    0,    0,  285,  285,  285,    0, 
            0,  285,    0,    0,  285,    0,    0,    0,    0,    0, 
            0,  285,    0,  285,    0,  285,  285,  285,  285,  285, 
          285,  285,    0,  285,    0,  285,    0,    0,    0,    0, 
            0,    0,  188,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  188,    0,    0,   78,  489,    0,    0,    0, 
            0,    0,    0,    0,  195,  195,  195,    0,    0,  195, 
          195,  195,    0,  195,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  195,  195,    0,  188,    0,    0,    0, 
            0,    0,  195,  195,    0,  195,  195,  195,  195,  195, 
          188,  188,    0,    0,  489,  188,    0,    0,    0,    0, 
            0,  489,    0,    0,    0,    0,  489,   78,    0,    0, 
          195,  195,  195,  195,  195,  195,  195,  195,  195,  195, 
            0,  195,  195,    0,   78,  195,  195,  489,    0,    0, 
          195,    0,    0,  195,    0,    0,  195,    0,  195,    0, 
          195,    0,  195,  190,  195,  195,  195,  195,  195,  195, 
          195,    0,  195,  190,  195,    0,   77,  492,    0,    0, 
            0,    0,    0,    0,    0,  191,  191,  191,    0,    0, 
          191,  191,  191,    0,  191,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  191,  191,    0,  190,    0,    0, 
            0,    0,    0,  191,  191,    0,  191,  191,  191,  191, 
          191,  190,  190,    0,    0,  492,  190,    0,    0,    0, 
            0,    0,  492,    0,    0,    0,    0,  488,   77,    0, 
            0,  191,  191,  191,  191,  191,  191,  191,  191,  191, 
          191,    0,  191,  191,    0,   77,  191,  191,  492,    0, 
            0,  191,    0,    0,  191,    0,    0,  191,    0,  191, 
            0,  191,    0,  191,    0,  191,  191,  191,  191,  191, 
          191,  191,    0,  191,    0,  191,    0,    0,    0,    0, 
            0,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  188,  188,  188,    0,    0,  188, 
          188,  188,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  188,  188,    0,  189,    0,    0,    0, 
            0,    0,  188,  188,    0,  188,  188,  188,  188,  188, 
          189,  189,    0,    0,    0,  189,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          188,  188,  188,  188,  188,  188,  188,  188,  188,  188, 
            0,  188,  188,    0,    0,  188,  188,    0,    0,    0, 
          188,    0,    0,  188,    0,    0,  188,    0,  188,    0, 
          188,    0,  188,  192,  188, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          188,  188,  188,  188,  188,  188,    0,  188,  192,  188, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          190,  190,  190,    0,    0,  190,  190,  190,    0,  190, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  190, 
          190,    0,  192,    0,    0,    0,    0,    0,  190,  190, 
            0,  190,  190,  190,  190,  190,  192,  192,    0,    0, 
            0,  192,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  190,  190,  190,  190, 
          190,  190,  190,  190,  190,  190,    0,  190,  190,    0, 
            0,  190,  190,    0,    0,    0,  190,    0,    0,  190, 
            0,    0,  190,    0,  190,    0,  190,    0,  190,    0, 
          190,  190,  190,  190,  190,  190,  190,    0,  190,    0, 
          190,    0,    0,    0,    0,    0,    0,  193,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  193,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  189, 
          189,  189,    0,    0,  189,  189,  189,    0,  189,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  189,  189, 
            0,  193,    0,    0,    0,    0,    0,  189,  189,    0, 
          189,  189,  189,  189,  189,  193,  193,    0,    0,    0, 
          193,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  189,  189,  189,  189,  189, 
          189,  189,  189,  189,  189,    0,  189,  189,    0,    0, 
          189,  189,    0,    0,    0,  189,    0,    0,  189,    0, 
            0,  189,    0,  189,    0,  189,    0,  189,  438,  189, 
          189,  189,  189,  189,  189,  189,    0,  189,  438,  189, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          192,  192,  192,    0,    0,  192,  192,  192,    0,  192, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  192, 
          192,    0,   74,    0,    0,    0,    0,    0,  192,  192, 
            0,  192,  192,  192,  192,  192,    0,  438,    0,   82, 
            0,  438,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  192,  192,  192,  192, 
          192,  192,  192,  192,  192,  192,    0,  192,  192,  438, 
            0,  192,  192,    0,    0,    0,  192,    0,    0,  192, 
            0,    0,  192,    0,  192,    0,  192,    0,  192,    0, 
          192,  192,  192,  192,  192,  192,  192,    0,  192,    0, 
          192,    0,    0,    0,    0,    0,    0,  274,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  274,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  193, 
          193,  193,    0,    0,  193,  193,  193,    0,  193,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  193,  193, 
            0,   81,    0,    0,    0,    0,    0,  193,  193,    0, 
          193,  193,  193,  193,  193,    0,  274,    0,   89,    0, 
          274,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  193,  193,  193,  193,  193, 
          193,  193,  193,  193,  193,    0,  193,  193,  274,    0, 
          193,  193,    0,    0,    0,  193,    0,    0,  193,    0, 
            0,  193,    0,  193,    0,  193,    0,  193,  281,  193, 
          193,  193,  193,  193,  193,  193,    0,  193,  281,  193, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          438,  438,  438,    0,    0,    0,  438,  438,    0,  438, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   80,    0,    0,    0,    0,    0,  438,  438, 
            0,  438,  438,  438,  438,  438,    0,  281,    0,   88, 
            0,  281,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  438,  438,  438,  438,  438, 
          438,  438,  438,  438,  438,  438,  438,  438,  438,  281, 
            0,  438,  438,  438,    0,  439,    0,    0,    0,  438, 
            0,    0,    0,    0,    0,    0,  438,    0,  438,  282, 
          438,  438,  438,  438,  438,  438,  438,    0,  438,  282, 
          438,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  274, 
          274,  274,    0,   75,    0,  274,  274,    0,  274,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  282,    0, 
           83,    0,  282,    0,    0,    0,    0,  274,  274,    0, 
          274,  274,  274,  274,  274,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          282,    0,    0,    0,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,  274,  274,  274,  274,  274,    0,  187, 
          274,  274,  274,    0,    0,    0,    0,    0,  274,  187, 
            0,    0,    0,    0,    0,  274,    0,  274,    0,  274, 
          274,  274,  274,  274,  274,  274,    0,  274,    0,  274, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          281,  281,  281,  187,    0,    0,  281,  281,    0,  281, 
            0,    0,    0,    0,    0,    0,    0,  187,  187,    0, 
            0,    0,  187,    0,    0,    0,    0,    0,  281,  281, 
            0,  281,  281,  281,  281,  281,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,    0, 
          211,  281,  281,  281,    0,    0,    0,    0,    0,  281, 
          211,    0,    0,    0,    0,    0,  281,    0,  281,    0, 
          281,  281,  281,  281,  281,  281,  281,    0,  281,    0, 
          281,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  282,  282,  282,  211,    0,    0,  282,  282,    0, 
          282,    0,    0,    0,    0,    0,    0,    0,  211,  211, 
            0,    0,    0,  211,    0,    0,    0,    0,    0,  282, 
          282,    0,  282,  282,  282,  282,  282,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  282,  282,  282,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
            0,    0,  282,  282,  282,  212,    0,    0,    0,    0, 
          282,    0,    0,    0,    0,  212,    0,  282,    0,  282, 
            0,  282,  282,  282,  282,  282,  282,  282,    0,  282, 
            0,  282,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  187,  187,  187,    0,    0,  187,  187,  187,  212, 
          187,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          187,  187,    0,  212,  212,    0,    0,    0,  212,  187, 
          187,    0,  187,  187,  187,  187,  187,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  187,  187,  187, 
          187,  187,  187,  187,  187,  187,  187,    0,  187,  187, 
            0,  198,  187,  187,    0,    0,    0,  187,    0,    0, 
          187,  198,    0,  187,    0,  187,    0,    0,    0,  187, 
            0,    0,    0,  187,  187,  187,  187,  187,    0,  187, 
            0,  187,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  211,  211,  211,  198,    0,  211,  211,  211, 
            0,  211,    0,    0,    0,    0,    0,    0,    0,  198, 
          198,  211,  211,    0,  198,    0,    0,    0,    0,    0, 
          211,  211,    0,  211,  211,  211,  211,  211,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  211,  211, 
          211,  211,  211,  211,  211,  211,  211,  211,    0,  211, 
          211,    0,  197,  211,  211,    0,    0,    0,  211,    0, 
            0,  211,  197,    0,  211,    0,  211,    0,    0,    0, 
          211,    0,    0,    0,    0,    0,  211,  211,  211,    0, 
          211,    0,  211,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  197,  212,  212,  212, 
            0,    0,  212,  212,  212,    0,  212,    0,    0,    0, 
          197,  197,    0,    0,    0,  197,  212,  212,    0,    0, 
            0,    0,    0,    0,    0,  212,  212,    0,  212,  212, 
          212,  212,  212,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,  212,  212,  212,  212,  212,  212, 
          212,  212,  212,    0,  212,  212,    0,  201,  212,  212, 
            0,    0,    0,  212,    0,    0,  212,  201,    0,  212, 
            0,  212,    0,    0,    0,  212,    0,    0,    0,    0, 
            0,  212,  212,  212,    0,  212,    0,  212,    0,    0, 
            0,    0,    0,  198,  198,  198,    0,    0,  198,  198, 
          198,  201,  198,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  198,  198,    0,  201,  201,    0,    0,    0, 
          201,  198,  198,    0,  198,  198,  198,  198,  198,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  198, 
          198,  198,  198,  198,  198,  198,  198,  198,  198,    0, 
          198,  198,    0,  203,    0,    0,    0,    0,    0,  198, 
            0,    0,  198,  203,    0,  198,    0,  198,    0,    0, 
            0,  198,    0,    0,    0,    0,    0,  198,  198,  198, 
            0,  198,    0,  198,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  197,  197,  197,  203,    0,  197, 
          197,  197,    0,  197,    0,    0,    0,    0,    0,    0, 
            0,  203,  203,  197,  197,    0,  203,    0,    0,    0, 
            0,    0,  197,  197,    0,  197,  197,  197,  197,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          197,  197,  197,  197,  197,  197,  197,  197,  197,  197, 
            0,  197,  197,    0,  202,    0,    0,    0,    0,    0, 
          197,    0,    0,  197,  202,    0,  197,    0,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  197,  197, 
          197,    0,  197,    0,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  202,  201, 
          201,  201,    0,    0,  201,  201,  201,    0,  201,    0, 
            0,    0,  202,  202,    0,    0,    0,  202,  201,  201, 
            0,    0,    0,    0,    0,    0,    0,  201,  201,    0, 
          201,  201,  201,  201,  201,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  201,  201,  201,  201,  201, 
          201,  201,  201,  201,  201,    0,  201,  201,    0,  200, 
            0,    0,    0,    0,    0,  201,    0,    0,  201,  200, 
            0,  201,    0,  201,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  201,  201,    0,    0,    0,    0,  201, 
            0,    0,    0,    0,    0,  203,  203,  203,    0,    0, 
          203,  203,  203,  200,  203,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  203,  203,    0,  200,  200,    0, 
            0,    0,  200,  203,  203,    0,  203,  203,  203,  203, 
          203,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  203,  203,  203,  203,  203,  203,  203,  203,  203, 
          203,    0,  203,  203,    0,  199,    0,    0,    0,    0, 
            0,  203,    0,    0,  203,  199,    0,  203,    0,  203, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  203, 
          203,    0,    0,    0,    0,  203,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  202,  202,  202,  199, 
            0,  202,  202,  202,    0,  202,    0,    0,    0,    0, 
            0,    0,    0,  199,  199,  202,  202,    0,  199,    0, 
            0,    0,    0,    0,  202,  202,    0,  202,  202,  202, 
          202,  202,    0,    0,    0,    0,    0,    0,    0,    0, 
          204,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          204,    0,  202,  202,  202,  202,  202,  202,  202,  202, 
          202,  202,    0,  202,  202,    0,    0,    0,    0,    0, 
            0,    0,  202,    0,    0,  202,    0,    0,  202,    0, 
          202,    0,    0,    0,  204,    0,    0,    0,    0,    0, 
          202,  202,    0,    0,    0,    0,  202,    0,  204,  204, 
            0,    0,    0,  204,    0,    0,    0,    0,    0,    0, 
            0,  200,  200,  200,    0,    0,  200,  200,  200,    0, 
          200,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,  200,    0,    0,    0,    0,    0,    0,    0,  200, 
          200,  205,  200,  200,  200,  200,  200,    0,    0,    0, 
            0,  205,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  200,  200,  200, 
          200,  200,  200,  200,  200,  200,  200,    0,  200,  200, 
            0,    0,    0,    0,    0,  205,    0,  200,    0,    0, 
          200,    0,    0,  200,    0,  200,    0,    0,    0,  205, 
          205,    0,    0,    0,  205,  200,  200,    0,    0,    0, 
            0,  200,    0,    0,    0,    0,    0,  199,  199,  199, 
            0,    0,  199,  199,  199,    0,  199,    0,  206,    0, 
            0,    0,    0,    0,    0,    0,  199,  199,  206,    0, 
            0,    0,    0,    0,    0,  199,  199,    0,  199,  199, 
          199,  199,  199,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  206,    0,    0,    0,    0,    0,    0,  199, 
          199,    0,    0,    0,  199,  199,  206,  206,    0,    0, 
            0,  206,    0,  199,    0,    0,  199,    0,    0,  199, 
            0,  199,  204,  204,  204,    0,    0,  204,  204,  204, 
            0,  204,    0,  213,    0,    0,    0,  199,    0,    0, 
            0,  204,  204,  213,    0,    0,    0,    0,    0,    0, 
          204,  204,    0,  204,  204,  204,  204,  204,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  213,    0,    0, 
            0,    0,    0,    0,  204,  204,    0,    0,    0,  204, 
          204,  213,  213,    0,    0,    0,  213,    0,  204,    0, 
            0,  204,    0,    0,  204,    0,  204,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  207,  204,  205,  205,  205,    0,    0,  205,  205, 
          205,  207,  205,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  205,  205,    0,    0,    0,    0,    0,    0, 
            0,  205,  205,    0,  205,  205,  205,  205,  205,    0, 
            0,    0,    0,    0,    0,  207,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
          207,    0,    0,    0,  207,  205,  205,    0,    0,    0, 
          205,  205,    0,    0,    0,    0,    0,    0,    0,  205, 
            0,    0,  205,    0,    0,  205,    0,  205,  208,    0, 
          206,  206,  206,    0,    0,  206,  206,  206,  208,  206, 
            0,    0,    0,  205,    0,    0,    0,    0,    0,  206, 
          206,    0,    0,    0,    0,    0,    0,    0,  206,  206, 
            0,  206,  206,  206,  206,  206,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,  208,    0,    0, 
            0,  208,  206,  206,    0,    0,    0,  206,  206,    0, 
            0,    0,    0,    0,    0,    0,  206,    0,    0,  206, 
            0,    0,  206,  214,  206,  213,  213,  213,    0,    0, 
          213,  213,  213,  214,  213,    0,    0,    0,    0,    0, 
          206,    0,    0,    0,  213,  213,    0,    0,    0,    0, 
            0,    0,    0,  213,  213,    0,  213,  213,  213,  213, 
          213,    0,    0,    0,    0,    0,    0,  214,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  214,  214,    0,    0,    0,  214,  213,  213,    0, 
            0,    0,  213,  213,    0,    0,    0,    0,    0,    0, 
            0,  213,    0,    0,  213,    0,    0,  213,    0,  213, 
            0,  184,    0,  207,  207,  207,    0,    0,  207,  207, 
          207,  184,  207,    0,    0,  213,    0,    0,    0,    0, 
            0,    0,  207,  207,    0,    0,    0,    0,    0,    0, 
            0,  207,  207,    0,  207,  207,  207,  207,  207,    0, 
            0,    0,    0,    0,    0,  184,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  184, 
          184,    0,    0,    0,  184,  207,  207,    0,    0,    0, 
          207,  207,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  207,    0,    0,  207,    0,  207,  185,    0, 
          208,  208,  208,    0,    0,  208,  208,  208,  185,  208, 
            0,    0,    0,  207,    0,    0,    0,    0,    0,  208, 
          208,    0,    0,    0,    0,    0,    0,    0,  208,  208, 
            0,  208,  208,  208,  208,  208,    0,  215,    0,    0, 
            0,    0,  185,    0,    0,    0,    0,  215,    0,    0, 
            0,    0,    0,    0,    0,    0,  185,  185,    0,    0, 
            0,  185,  208,  208,    0,    0,    0,  208,  208,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  208, 
            0,  215,  208,    0,  208,  214,  214,  214,    0,    0, 
          214,  214,  214,    0,  214,  215,  215,    0,    0,    0, 
          208,    0,    0,    0,  214,  214,    0,    0,    0,    0, 
            0,    0,    0,  214,  214,    0,  214,  214,  214,  214, 
          214,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  183, 
            0,    0,    0,    0,    0,    0,    0,    0,  214,  183, 
            0,    0,  214,  214,    0,    0,    0,    0,    0,    0, 
            0,  214,    0,    0,  214,    0,    0,  214,    0,  214, 
            0,    0,    0,  184,  184,  184,  176,    0,  184,  184, 
          184,    0,  184,  183,    0,  214,  176,    0,    0,    0, 
            0,    0,  184,  184,    0,    0,    0,  183,  183,    0, 
            0,  184,  184,    0,  184,  184,  184,  184,  184,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          176,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  176,  176,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  184, 
            0,    0,  184,    0,    0,  184,    0,  184,    0,    0, 
          185,  185,  185,    0,    0,  185,  185,  185,    0,  185, 
            0,    0,    0,  184,    0,    0,    0,    0,    0,  185, 
          185,    0,    0,    0,    0,    0,    0,    0,  185,  185, 
            0,  185,  185,  185,  185,  185,    0,  182,    0,  215, 
          215,  215,    0,    0,  215,  215,  215,  182,  215,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  215,  215, 
            0,    0,    0,    0,    0,    0,    0,  215,  215,    0, 
          215,  215,  215,  215,  215,  216,  185,    0,    0,  185, 
            0,  182,  185,    0,  185,  216,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  182,  182,    0,    0,    0, 
          185,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  215,    0,    0,  215,  216, 
            0,  215,    0,  215,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  216,  216,    0,    0,    0,    0,  215, 
            0,  183,  183,  183,    0,    0,  183,  183,  183,    0, 
          183,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          183,  183,    0,    0,    0,    0,    0,    0,    0,  183, 
          183,  178,  183,  183,  183,  183,  183,    0,  176,  176, 
          176,  178,    0,  176,  176,  176,    0,  176,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  176,  176,    0, 
            0,    0,    0,    0,    0,    0,  176,  176,  179,  176, 
          176,  176,  176,  176,    0,  178,    0,  183,  179,    0, 
          183,    0,    0,  183,    0,  183,    0,    0,    0,  178, 
          178,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  183,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  179,    0,  176,    0,    0,  176,    0,    0, 
          176,    0,  176,    0,    0,    0,  179,  179,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  176,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  182, 
          182,  182,    0,    0,  182,  182,  182,    0,  182,    0, 
            0,    0,    0,    0,    0,  180,    0,    0,  182,  182, 
            0,    0,    0,    0,    0,  180,    0,  182,  182,    0, 
          182,  182,  182,  182,  182,    0,    0,  216,  216,  216, 
            0,    0,  216,  216,  216,    0,  216,    0,    0,    0, 
            0,  181,    0,    0,    0,    0,  216,  216,    0,  180, 
            0,  181,    0,    0,    0,  216,  216,    0,  216,  216, 
          216,  216,  216,  180,  180,  182,    0,    0,  182,    0, 
            0,  182,    0,  182,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  181,    0,    0,    0,  182, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  181, 
          181,    0,    0,  216,    0,    0,  216,    0,    0,  216, 
            0,  216,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  178,  178,  178,  175,  216,  178,  178, 
          178,    0,  178,    0,    0,    0,  175,    0,    0,    0, 
            0,    0,  178,  178,    0,    0,    0,    0,    0,    0, 
            0,  178,  178,    0,  178,  178,  178,  178,  178,    0, 
          179,  179,  179,    0,    0,  179,  179,  179,    0,  179, 
          175,    0,    0,    0,    0,    0,    0,    0,    0,  179, 
          179,    0,    0,    0,  175,  175,    0,  177,  179,  179, 
            0,  179,  179,  179,  179,  179,    0,  177,    0,  178, 
            0,    0,  178,    0,    0,  178,    0,  178,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  178,    0,    0,    0,    0,    0,    0, 
            0,  177,    0,    0,    0,    0,  179,    0,    0,  179, 
            0,    0,  179,    0,  179,  177,  177,    0,  262,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  262,    0, 
          179,    0,    0,    0,    0,    0,    0,  180,  180,  180, 
            0,    0,  180,  180,  180,    0,  180,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  180,  180,    0,    0, 
            0,    0,  262,    0,    0,  180,  180,    0,  180,  180, 
          180,  180,  180,  181,  181,  181,  262,  262,  181,  181, 
          181,    0,  181,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  181,  181,    0,    0,    0,    0,    0,    0, 
            0,  181,  181,    0,  181,  181,  181,  181,  181,    0, 
          174,    0,    0,  180,    0,    0,  180,    0,    0,  180, 
          174,  180,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  180,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  181, 
            0,    0,  181,    0,  174,  181,    0,  181,  175,  175, 
          175,    0,    0,  175,  175,  175,    0,  175,  174,  174, 
            0,  263,    0,  181,    0,    0,    0,  175,  175,    0, 
            0,  263,    0,    0,    0,    0,  175,  175,    0,  175, 
          175,  175,  175,  175,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  264,    0,    0,  263,    0,    0,    0,  177, 
          177,  177,  264,    0,  177,  177,  177,    0,  177,  263, 
          263,    0,    0,    0,  175,    0,    0,  175,  177,  177, 
          175,    0,  175,    0,    0,    0,    0,  177,  177,    0, 
          177,  177,  177,  177,  177,    0,  263,    0,  175,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          264,  264,    0,    0,    0,    0,    0,    0,    0,    0, 
          262,  262,  262,    0,    0,  262,  262,  262,    0,  262, 
            0,    0,    0,    0,    0,  177,    0,    0,  177,  262, 
          262,  177,    0,  177,    0,    0,    0,    0,  262,  262, 
            0,  262,  262,  262,  262,  262,    0,    0,    0,  177, 
            0,    0,    0,    0,    0,    0,  401,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  262, 
            0,    0,  262,    0,  262,    0,    0,    0,    0,    0, 
            0,    0,  174,  174,  174,    0,    0,  174,  174,  174, 
          262,  174,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  174,  174,    0,    0,    0,    0,    0,    0,    0, 
          174,  174,    0,  174,  174,  174,  174,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  263,  263,  263,    0,    0,  263,  263, 
          263,    0,  263,    0,    0,    0,    0,    0,  174,  740, 
            0,  174,  263,  263,  174,    0,  174,    0,    0,    0, 
            0,  263,  263,    0,  263,  263,  263,  263,  263,    0, 
            0,    0,  174,    0,  264,  264,  264,    0,    0,  264, 
          264,  264,    0,  264,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  264,  264,  264,  264,  264, 
            0,    0,  263,    0,    0,  263,    0,  263,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  263,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
          264,    0,   11,  264,   12,   13,   14,   96,   97,   17, 
           18,    0,    0,    0,    0,   98,   99,  100,   22,   23, 
           24,   25,    0,    0,  264,    0,    0,    0,    0,    0, 
            0,  101,    0,    0,   31,   32,    0,  395,   33,   34, 
           35,   36,   37,   38,    0,    0,    0,    0,  104,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  400,    0, 
            0,  107,    0,    0,   44,   45,    0,   46,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   50,   51,   52,   53, 
           54,   55,    0,    0,    0,    0,    0,   56,   57,    0, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  101,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  400,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   42,    0,    0,   43,    0,    0, 
           44,   45,    0,   46,    0,   47,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,   49,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    3,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,    0,    0,   33,   34, 
           35,   36,   37,   38,    0,    0,   39,   40,   41,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   42,    0, 
            0,  267,    0,    0,   44,   45,    0,   46,    0,   47, 
            0,    0,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,   49,    0,    0,    0,    0,   50,   51,   52,   53, 
           54,   55,    0,    0,    0,    0,    0,   56,   57,    0, 
           58,   59,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   42,    0,    0,   43,    0,    0,   44,   45,    0, 
           46,    0,   47,    0,    0,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,   49,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   96,   97,   17,   18,    0,    0,    0, 
            0,   98,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,  420, 
           44,   45,    0,   46,    0,  235,    0,  236,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  237,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,   39,   40,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          107,    0,    0,   44,   45,    0,   46,    0,  633,    0, 
          236,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
           49,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,    0,    0,   98,   20,   21, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,    0,    0, 
           33,   34,   35,   36,   37,   38,    0,    0,   39,   40, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  107,    0,    0,   44,   45,    0,   46, 
            0,  235,    0,  236,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,  237,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,    0,    0,   50,   51,   52,   53,   54,   55,    0, 
            0,    0,    0,    0,   56,   57,    0,   58,   59,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   96,   97,   17, 
           18,    0,    0,    0,    0,   98,   20,   21,   22,   23, 
           24,   25,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,    0,    0,   33,   34, 
           35,   36,   37,   38,    0,    0,   39,   40,   41,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  208,    0, 
            0,  107,    0,    0,  422,   45,    0,   46,    0,  235, 
            0,  236,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,  237,    0,    0,    0,    0,   50,   51,   52,   53, 
           54,   55,    0,    0,    0,    0,    0,   56,   57,    0, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,  625,    0,  236,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,  237,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   96,   97,   17,   18,    0,    0,    0, 
            0,   98,   99,  100,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,    0, 
           44,   45,    0,   46,    0,  629,    0,  236,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  237,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,   39,   40,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          107,    0,    0,   44,   45,    0,   46,    0,  625,    0, 
          236,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
          237,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,    0,    0,   98,   99,  100, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,    0,    0, 
           33,   34,   35,   36,   37,   38,    0,    0,   39,   40, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  107,    0,    0,   44,   45,    0,   46, 
            0,  821,    0,  236,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,  237,    0,    0,    0,    0,   50,   51, 
           52,   53,   54,   55,    0,    0,    0,    0,    0,   56, 
           57,    0,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,    0,    0,   33,   34,   35,   36,   37,   38,    0, 
            0,   39,   40,   41,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0,    0,  107,    0,    0,   44, 
           45,    0,   46,    0,  825,    0,  236,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,  237,    0,    0,    0, 
            0,   50,   51,   52,   53,   54,   55,    0,    0,    0, 
            0,    0,   56,   57,    0,   58,   59,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   96,   97,   17,   18,    0, 
            0,    0,    0,   98,   99,  100,   22,   23,   24,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,    0,    0,   33,   34,   35,   36, 
           37,   38,    0,    0,   39,   40,   41,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  107, 
            0,    0,   44,   45,    0,   46,    0,  829,    0,  236, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,  237, 
            0,    0,    0,    0,   50,   51,   52,   53,   54,   55, 
            0,    0,    0,    0,    0,   56,   57,    0,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,    0,    0,   33, 
           34,   35,   36,   37,   38,    0,    0,   39,   40,   41, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  208, 
            0,    0,  107,    0,    0,   44,   45,    0,   46,    0, 
          877,    0,  236,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,  237,    0,    0,    0,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
            0,    0,   33,   34,   35,   36,   37,   38,    0,    0, 
           39,   40,   41,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  107,    0,    0,   44,   45, 
            0,   46,    0,  879,    0,  236,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,  237,    0,    0,    0,    0, 
           50,   51,   52,   53,   54,   55,    0,    0,    0,    0, 
            0,   56,   57,    0,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,    0,    0,   33,   34,   35,   36,   37, 
           38,    0,    0,   39,   40,   41,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  208,    0,    0,  107,    0, 
            0,   44,   45,    0,   46,    0,  890,    0,  236,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,  237,    0, 
            0,    0,    0,   50,   51,   52,   53,   54,   55,    0, 
            0,    0,    0,    0,   56,   57,    0,   58,   59,  252, 
          252,  252,    0,  252,    0,    0,    0,  252,  252,    0, 
            0,    0,  252,    0,  252,  252,  252,  252,  252,  252, 
          252,    0,    0,    0,    0,  252,  252,  252,  252,  252, 
          252,  252,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  252,    0,    0,  252,  252,    0,    0,  252,  252, 
          252,  252,  252,  252,    0,    0,  252,  252,  252,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  252,    0, 
            0,  252,    0,    0,  252,  252,    0,  252,    0,  252, 
            0,  252,    0,  252,    0,    0,    0,    0,    0,    0, 
            0,  252,    0,    0,    0,    0,  252,  252,  252,  252, 
          252,  252,    0,    0,    0,    0,    0,  252,  252,    0, 
          252,  252,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,    0,    0,    0,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,   49,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   96,   97,   17,   18,    0,    0,    0, 
            0,   98,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,    0, 
           44,   45,    0,   46,    0,  272,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  237,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,   39,   40,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          107,  434,    0,   44,   45,    0,   46,    0,    0,    0, 
            0,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
          237,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,    0,    0, 
           33,   34,   35,   36,   37,   38,    0,    0,   39,   40, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  107,    0,    0,   44,   45,    0,   46, 
            0,  532,    0,    0,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,  237,    0,    0,    0,    0,   50,   51, 
           52,   53,   54,   55,    0,    0,    0,    0,    0,   56, 
           57,    0,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,    0,    0,   33,   34,   35,   36,   37,   38,    0, 
            0,   39,   40,   41,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0,    0,  107,    0,    0,   44, 
           45,    0,   46,    0,  532,    0,    0,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,  237,    0,    0,    0, 
            0,   50,   51,   52,   53,   54,   55,    0,    0,    0, 
            0,    0,   56,   57,    0,   58,   59,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   96,   97,   17,   18,    0, 
            0,    0,    0,   98,   99,  100,   22,   23,   24,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,    0,    0,   33,   34,   35,   36, 
           37,   38,    0,    0,   39,   40,   41,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  107, 
            0,    0,   44,   45,    0,   46,    0,  597,    0,    0, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,  237, 
            0,    0,    0,    0,   50,   51,   52,   53,   54,   55, 
            0,    0,    0,    0,    0,   56,   57,    0,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,    0,    0,   33, 
           34,   35,   36,   37,   38,    0,    0,   39,   40,   41, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  208, 
            0,    0,  107,    0,    0,   44,   45,    0,   46,    0, 
          656,    0,    0,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,  237,    0,    0,    0,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
            0,    0,   33,   34,   35,   36,   37,   38,    0,    0, 
           39,   40,   41,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  107,    0,    0,   44,   45, 
            0,   46,    0,  787,    0,    0,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,  237,    0,    0,    0,    0, 
           50,   51,   52,   53,   54,   55,    0,    0,    0,    0, 
            0,   56,   57,    0,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,    0,    0,   33,   34,   35,   36,   37, 
           38,    0,    0,   39,   40,   41,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  208,    0,    0,  107,    0, 
            0,   44,   45,    0,   46,    0,  811,    0,    0,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,  237,    0, 
            0,    0,    0,   50,   51,   52,   53,   54,   55,    0, 
            0,    0,    0,    0,   56,   57,    0,   58,   59,  499, 
          499,  499,    0,  499,    0,    0,    0,  499,  499,    0, 
            0,    0,  499,    0,  499,  499,  499,  499,  499,  499, 
          499,    0,    0,    0,    0,  499,  499,  499,  499,  499, 
          499,  499,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  499,    0,    0,  499,  499,    0,    0,  499,  499, 
          499,  499,  499,  499,    0,    0,  499,  499,  499,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  499,    0, 
            0,  499,  499,    0,  499,  499,    0,  499,    0,    0, 
            0,    0,    0,  499,    0,    0,    0,    0,    0,    0, 
            0,  499,    0,    0,    0,    0,  499,  499,  499,  499, 
          499,  499,    0,    0,    0,    0,    0,  499,  499,    0, 
          499,  499,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,    0,    0,    0,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,  237,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,    0, 
           44,   45,    0,   46,    0,    0,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  237,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          101,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,    0,    0,  104,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,    0,    0, 
          226,    0,    0,   44,   45,    0,   46,    0,  227,    0, 
          228,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,    0,    0,   98,   99,  100, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  101,    0,    0,   31,   32,    0,    0, 
           33,   34,   35,   36,   37,   38,    0,    0,    0,    0, 
          104,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,    0,  226,    0,    0,   44,   45,    0,   46, 
            0,  619,    0,  620,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   50,   51, 
           52,   53,   54,   55,    0,    0,    0,    0,    0,   56, 
           57,    0,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  101,    0,    0,   31, 
           32,    0,    0,  102,   34,   35,   36,  103,   38,    0, 
            0,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          105,    0,    0,  106,    0,    0,  107,    0,    0,   44, 
           45,    0,   46,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,   52,   53,   54,   55,    0,    0,    0, 
            0,    0,   56,   57,    0,   58,   59,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   96,   97,   17,   18,    0, 
            0,    0,    0,   98,   99,  100,   22,   23,   24,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  101, 
            0,    0,   31,   32,    0,    0,   33,   34,   35,   36, 
           37,   38,    0,    0,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  225,    0,    0,  226, 
            0,    0,   44,   45,    0,   46,    0,  351,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   50,   51,   52,   53,   54,   55, 
            0,    0,    0,    0,    0,   56,   57,    0,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  101,    0,    0,   31,   32,    0,    0,  102, 
           34,   35,   36,  103,   38,    0,    0,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  106, 
            0,    0,  107,    0,    0,   44,   45,    0,   46,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  101,    0,    0,   31,   32, 
            0,    0,   33,   34,   35,   36,   37,   38,    0,    0, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  225,    0,    0,  107,    0,    0,   44,   45, 
            0,   46,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           50,   51,   52,   53,   54,   55,    0,    0,    0,    0, 
            0,   56,   57,    0,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  101,    0, 
            0,   31,   32,    0,    0,   33,   34,   35,   36,   37, 
           38,    0,    0,    0,    0,  104,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  400,    0,    0,  107,    0, 
            0,   44,   45,    0,   46,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,   51,   52,   53,   54,   55,    0, 
            0,    0,    0,    0,   56,   57,    0,   58,   59,  116, 
          117,  118,  119,  120,  121,  122,  123,    0,    0,  124, 
          125,  126,  127,  128,    0,    0,  129,  130,  131,  132, 
          133,  134,  135,    0,    0,  136,  137,  138,  192,  193, 
          194,  195,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  196,  197,    0,    0,  198,  158, 
          255,    0,  199,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,    0,    0,  186,   50,  116,  117,  118, 
          119,  120,  121,  122,  123,    0,    0,  124,  125,  126, 
          127,  128,    0,    0,  129,  130,  131,  132,  133,  134, 
          135,    0,    0,  136,  137,  138,  192,  193,  194,  195, 
          143,  144,  145,  146,  147,  148,  149,  150,  151,  152, 
          153,  154,  196,  197,    0,    0,  198,  158,    0,    0, 
          199,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,    0,  166,  167,    0,    0,  168,    0,    0,    0, 
            0,  169,  170,  171,  172,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  174,  175,    0, 
          176,  177,  178,  179,  180,  181,  182,  183,  184,    0, 
          185,    0,    0,  186,   50,  116,  117,  118,  119,  120, 
          121,  122,  123,    0,    0,  124,  125,  126,  127,  128, 
            0,    0,  129,  130,  131,  132,  133,  134,  135,    0, 
            0,  136,  137,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,    0,    0,  157,  158,   35,   36,  159,   38, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,    0, 
          166,  167,    0,    0,  168,    0,    0,    0,    0,  169, 
          170,  171,  172,    0,    0,    0,    0,    0,  173,    0, 
            0,    0,    0,    0,    0,  174,  175,    0,  176,  177, 
          178,  179,  180,  181,  182,  183,  184,    0,  185,    0, 
            0,  186,  116,  117,  118,  119,  120,  121,  122,  123, 
            0,    0,  124,  125,  126,  127,  128,    0,    0,  129, 
          130,  131,  132,  133,  134,  135,    0,    0,  136,  137, 
          138,  192,  193,  194,  195,  143,  144,  145,  146,  147, 
          148,  149,  150,  151,  152,  153,  154,  196,  197,    0, 
            0,  198,  158,  286,  287,  199,  288,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,    0,  166,  167,    0, 
            0,  168,    0,    0,    0,    0,  169,  170,  171,  172, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  174,  175,    0,  176,  177,  178,  179,  180, 
          181,  182,  183,  184,    0,  185,    0,    0,  186,  116, 
          117,  118,  119,  120,  121,  122,  123,    0,    0,  124, 
          125,  126,  127,  128,    0,    0,  129,  130,  131,  132, 
          133,  134,  135,    0,    0,  136,  137,  138,  192,  193, 
          194,  195,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  196,  197,    0,    0,  198,  158, 
            0,    0,  199,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  514,  515,  186,    0,  516,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  519,  520, 
          186,    0,  521,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  526,  515,  186,    0,  527,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  550,  520, 
          186,    0,  551,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  588,  515,  186,    0,  589,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  590,  520, 
          186,    0,  591,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  613,  515,  186,    0,  614,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  615,  520, 
          186,    0,  616,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  732,  515,  186,    0,  733,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  734,  520, 
          186,    0,  735,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,    0,    0,  186, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           15,   16,   27,  391,   19,   11,   15,   16,    7,    6, 
           19,   21,  216,  377,   15,   16,   14,  369,   19,   10, 
          371,    7,    4,    5,   39,   40,  418,   49,   27,  251, 
           45,   46,   14,   48,   49,   10,    3,   46,  397,   10, 
           21,   27,   45,   46,   10,   10,  476,   61,   10,   61, 
           91,   47,   62,   50,   44,   10,  101,   10,   10,   76, 
          703,  453,   10,  573,  340,   47,  576,   10,   59,   43, 
           76,   61,   32,  280,   44,  106,  701,   10,  703,  280, 
           10,   62,   61,  513,   59,  340,   10,  279,   59,   44, 
          100,   44,  292,   91,   59,  279,  296,   10,  279,  109, 
          279,  226,  279,  279,   59,  111,   59,   59,  325,   91, 
           10,   44,   61,   15,   16,  353,   10,   19,  308,  290, 
          291,   10,   10,   10,   10,   58,   59,   44,   58,   59, 
            0,   44,  372,  340,   58,   59,   61,  377,  376,    2, 
           10,  358,  267,   45,   61,   58,   59,  263,  264,   10, 
           10,  344,   10,  269,  361,  370,  371,  372,   44,   59, 
          361,   10,  377,   10,   11,   59,  358,  345,  310,  362, 
          341,   59,   59,   10,  358,   10,   10,  358,   91,  358, 
           43,  358,  358,  372,   10,  375,  376,    0,  377,   59, 
          368,  308,  309,  674,  311,   44,  548,   58,   59,  680, 
          843,  306,  219,   45,   46,  310,   10,   44,  386,   44, 
           44,  562,   10,  219,  269,   10,  271,  569,  843,  328, 
          235,  236,  237,   58,   59,  306,  335,  328,  273,  361, 
          594,  409,   32,  248,  335,  250,  251,  365,  668,  248, 
           32,  250,  251,  258,  107,  227,  228,  248,  317,  250, 
          251,  277,  226,  279,  280,   59,   91,  272,  375,  376, 
           58,   59,  282,   58,   59,  337,  347,  348,  349,  350, 
           44,  471,  528,  529,  370,  371,  372,  290,  291,  348, 
          269,  377,  271,  352,  353,  256,  796,  328,   91,  799, 
          378,  379,  802,  267,  335,  378,  379,   61,  263,  264, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  348,  341,  350,  341, 
          345,  353,  354,  348,  267,  350,  367,  267,  353,  354, 
          307,  350,  345,  267,  353,  312,  248,   61,  250,  251, 
          341,  341,  744,  368,  267,  351,  362,   91,  750,  869, 
          337,  376,  341,  226,  264,  368,  279,  376,  338,  351, 
           44,  386,  387,  388,  389,  341,  223,  224,  393,  341, 
          739,  426,  427,  386,  393,  356,  341,  362,  341,  341, 
          396,  397,  341,  341,  409,  599,    0,  260,  341,  414, 
          415,  446,  447,  418,  267,  338,  409,  422,  433,  251, 
          370,  371,  415,  411,  338,  328,  341,  377,  262,  422, 
          281,  422,  335,  645,  812,  440,  441,  442,  264,  411, 
          290,  291,  267,  611,  433,  450,  310,  789,  453,  328, 
          455,  290,  291,  345,  279,  358,  335,  433,  812,  262, 
          263,  264,  803,  243,  337,  268,  269,  337,  271,   61, 
          264,  308,  309,  310,  311,  269,  368,  271,   59,  267, 
          328,  863,  267,    2,    3,    4,    5,  335,  310,    8, 
            9,   10,   11,  341,  386,   14,   15,   16,   91,  338, 
           19,   10,  341,  328,  886,  847,  279,   26,  754,  755, 
          335,   44,   10,  345,   44,  340,  710,  409,  268,  269, 
           91,  556,  522,  338,   43,   44,   45,  532,   47,  382, 
           49,   44,   91,  358,  317,  328,  368,  390,  341,  392, 
           16,  361,  335,   19,  376,  377,  517,   52,   53,  545, 
           59,  522,  552,  269,  386,  271,   10,  528,  529,  362, 
          269,   59,  271,  578,  263,  264,    6,    7,  370,  371, 
          349,  350,   91,   10,  570,  377,  317,  409,  380,  317, 
          337,  341,  341,  436,  362,  372,  105,   27,  107,  578, 
          577,  344,  597,   44,  346,  372,  340,    2,    3,    4, 
            5,    6,  578,    8,  328,   59,  611,   44,  269,   14, 
           50,  335,  267,  807,  271,  264,  341,  310,  611,  349, 
          625,   58,   59,   44,  629,   44,   44,  341,  633,  341, 
          362,  341,  412,   32,  337,  337,  608,  337,   43,  337, 
          645,   44,   47,  475,  476,  264,   61,  619,  620,  344, 
          344,  656,  645,  306,   91,  370,  371,  372,  306,  671, 
          672,  696,  377,   44,  669,  677,  671,  672,  262,  263, 
          264,   44,  677,  678,  268,  269,  664,  271,   44,   44, 
          338,  513,  687,  688,  263,  517,   91,  337,  344,  264, 
          695,  337,  664,  337,  690,   61,  528,  529,  264,  370, 
          371,  372,  107,   44,  223,  224,  377,  226,  227,  228, 
          547,    9,   10,   11,  719,  720,  721,  549,  349,  611, 
          344,  349,  727,  758,   44,   91,    0,  762,   26,  248, 
          583,  250,  251,   44,  341,  328,   10,  709,  341,  744, 
          341,  260,  335,  739,  749,  750,   44,  341,  267,  581, 
          749,  362,  584,  645,  586,  264,  749,  328,  749,  268, 
          269,  341,  594,  337,  335,  737,  264,  264,  362,  328, 
          264,  269,  248,  785,  250,  251,  335,  341,  264,  611, 
          785,  618,  787,  337,  264,   59,  344,  349,  307,  308, 
          309,  310,  311,  312,  313,  314,  306,   44,  308,  309, 
          310,  311,  341,  358,  809,  658,  811,  105,  262,  263, 
          264,  362,  665,  362,  667,  269,  821,  670,  264,  264, 
          825,  226,  227,  228,  829,  341,  345,   44,  264,  348, 
          267,  350,  351,  264,  353,  354,  668,  347,  348,  349, 
          350,  349,  279,   44,   44,  341,  818,  627,  362,  368, 
          369,  370,  264,  264,  264,  260,  861,  637,  863,    0, 
          713,   44,  267,  382,  271,  344,  340,  386,  861,   10, 
          362,  390,  877,  392,  879,  728,  729,  730,  341,  716, 
          344,  886,  370,  371,  372,  890,  858,  344,  341,  377, 
          409,  328,  411,  370,  371,  372,  362,  341,  335,  341, 
          377,  344,  307,  422,  344,  264,  306,  312,  308,  309, 
          310,  311,  362,  279,   64,  434,    5,  436,   59,  872, 
          773,  358,  754,  755,    6,  223,  224,  367,  803,  562, 
          664,    2,    3,    4,    5,  701,   44,    8,   68,  848, 
          340,   76,   -1,   14,   -1,  385,  351,  347,  348,  349, 
          350,   -1,  805,   61,  293,  294,  295,  296,  297,  701, 
            0,   -1,  328,  743,  369,   -1,  746,  747,  408,  335, 
           10,   -1,   43,   -1,  340,  341,   47,  382,   -1,   -1, 
          812,   -1,   -1,   91,   -1,  390,   -1,  392,  262,  263, 
          264,   44,  358,  433,  268,  269,  849,  271,   -1,  439, 
           -1,   -1,   -1,  856,   -1,   -1,  411,   -1,   61,   -1, 
          308,  309,  310,  311,   -1,  313,  314,   10,  317,   59, 
           91,   -1,   -1,  322,  323,   -1,   -1,   -1,  547,  548, 
           -1,  436,   -1,   -1,  333,  334,  107,   -1,   91,   -1, 
          872,   -1,   -1,   -1,   -1,   -1,  826,  827,   -1,  348, 
          569,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,   -1,  583,   -1,   59,  341,    2,    3, 
           -1,   -1,  370,   -1,    8,   -1,   -1,   -1,   -1,  859, 
          860,    0,  317,   -1,   -1,  865,   -1,   -1,  362,  608, 
           -1,   10,  611,   -1,   -1,   -1,   -1,   -1,  878,  618, 
          619,  620,   -1,   -1,   -1,  885,   -1,   -1,  888,   43, 
           -1,   -1,  892,  348,   -1,   -1,   -1,  352,  353,  354, 
          355,  262,  263,  264,  422,   44,  645,  268,  269,   -1, 
          271,   -1,   -1,   -1,    0,   -1,  434,  577,  578,  658, 
           59,   -1,   -1,  548,   10,  664,  665,   -1,  667,  317, 
           -1,  670,  671,  672,   -1,  226,  227,  228,  677,   -1, 
           -1,   -1,   -1,   -1,  569,  333,  334,   -1,   -1,   -1, 
          610,  279,   -1,  107,   -1,   -1,   -1,   -1,  583,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,   -1,  260, 
          709,   -1,   58,   59,  713,   -1,  267,  716,    0,   -1, 
          341,   -1,   -1,  608,   -1,   -1,   -1,   -1,   10,  728, 
          729,  730,   -1,   -1,  619,  620,   -1,   -1,  737,   -1, 
          328,  362,  262,  263,  264,   -1,  279,  335,  268,  269, 
           -1,  271,   -1,  341,   -1,   -1,  307,   -1,   -1,   -1, 
           -1,  312,   44,   -1,   -1,   -1,   -1,   -1,   -1,  547, 
          358,   -1,   -1,  658,  773,   -1,   58,   59,   -1,  664, 
          665,   63,  667,   -1,   -1,  670,  785,   -1,   -1,   -1, 
          789,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          351,   -1,  335,   -1,   -1,   -1,  805,   -1,  341,   -1, 
           -1,   -1,  226,  227,  228,   -1,   -1,   -1,  369,  818, 
           -1,  341,   -1,   -1,  709,  358,   -1,   -1,  713,   -1, 
           -1,  382,   -1,  306,   10,  308,  309,  310,  311,  390, 
          618,  392,  362,  728,  729,  730,  260,   -1,  847,   -1, 
          849,   -1,  737,  267,   -1,  328,   -1,  856,   -1,  858, 
          411,   -1,  335,  262,  263,  264,   -1,  340,   44,  268, 
          269,   -1,  271,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  436,   -1,   -1,  773,   -1, 
           44,  290,  291,  307,  293,  294,  295,  296,  312,   -1, 
           -1,   -1,   -1,   -1,  789,   -1,   -1,   61,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,  262,  263,  264,   -1, 
          805,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  818,   -1,  281,  282,   91,  716,   -1, 
           -1,   -1,  341,   -1,  290,  291,    0,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  369,   10,   -1,   -1,   -1, 
           -1,   -1,  847,  362,  849,   -1,   -1,   -1,  382,   -1, 
           -1,  856,   -1,  858,   -1,   -1,  390,   -1,  392,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           44,   -1,   -1,   -1,   -1,  341,   -1,  548,  344,  281, 
          282,   10,   -1,   -1,   58,   59,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  362,   10,  569,   -1, 
           -1,   -1,  436,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  583,   -1,   -1,   44,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   58, 
           59,   44,   -1,   -1,   -1,   -1,  338,  608,   -1,  341, 
           -1,   -1,  344,   -1,  346,   58,   59,   -1,  619,  620, 
           -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   91,   -1,   -1,   -1,   -1,   -1,    2,    3, 
           -1,  267,   44,   -1,    8,    9,   10,   11,   91,   -1, 
           -1,   15,   16,  279,  280,   19,  317,  658,  659,   61, 
           -1,   -1,   26,  664,  665,   -1,  667,   -1,   -1,  670, 
           -1,   -1,  333,  334,   -1,  279,   -1,    2,    3,   43, 
           44,   45,   -1,    8,  548,   49,   -1,  348,   -1,   91, 
           -1,  352,  353,  354,  355,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,  569,   -1,   -1,  709,  335, 
           -1,   -1,  713,   10,  340,   -1,   -1,   -1,   43,  583, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,  728,  729,  730, 
           -1,  335,  358,   -1,   -1,  361,  737,  341,   -1,    0, 
           -1,  105,   -1,  107,  608,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,  358,  619,  620,   -1,  262,  263, 
          264,   -1,   59,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,  773,   -1,   -1,   -1,   -1,  281,  282,   -1, 
          235,  236,  107,   44,   -1,   -1,  290,  291,  789,  293, 
          294,  295,  296,  297,  658,   -1,   -1,   -1,   59,   -1, 
           -1,  665,   -1,  667,  805,   -1,  670,   -1,  267,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  818,   -1,   -1, 
          279,  280,   -1,   -1,  267,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  338,   -1,  279,  341,   -1,   -1, 
          344,   10,  346,   -1,   -1,  709,  847,   -1,  849,  713, 
           -1,   -1,   -1,   -1,   -1,  856,   -1,  858,  362,  223, 
          224,   -1,  226,   -1,  728,  729,  730,   -1,   -1,  328, 
           -1,   -1,   -1,  737,   10,   44,  335,  279,   -1,   -1, 
           -1,  340,   -1,   -1,  248,  328,  250,  251,   -1,   58, 
           59,   -1,  335,   -1,   63,  350,  260,   -1,  353,  358, 
           -1,  226,  361,  267,   -1,   -1,   -1,   -1,   44,  773, 
           44,   -1,   -1,   -1,   -1,  358,   -1,   -1,   -1,   -1, 
           -1,  376,   58,   59,   -1,  789,  328,   61,   -1,   -1, 
           -1,   -1,   -1,  335,   -1,  260,   -1,   -1,  393,  341, 
           -1,  805,  267,  307,  308,  309,  310,  311,  312,  313, 
          314,   -1,   -1,   -1,  818,   91,  358,   91,   -1,  414, 
          415,   -1,   -1,  418,   -1,   -1,   -1,  422,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  345,  307,  847,  348,  849,  350,  312,   -1,  353, 
          354,   -1,  856,   -1,  858,  450,   -1,   -1,  453,   -1, 
          455,  262,  263,  264,  368,  369,  370,  268,  269,  306, 
          271,  308,  309,  310,  311,   -1,   -1,   -1,  382,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,  390,   59,  392,   -1, 
           -1,  328,  293,  294,  295,  296,  297,   -1,  335,   -1, 
           -1,   -1,   -1,  340,  369,  409,   -1,   -1,   -1,   -1, 
          347,  348,  349,  350,   -1,   -1,   -1,  382,  422,   10, 
           -1,   -1,   -1,   -1,   -1,  390,   -1,  392,   -1,   -1, 
          434,   -1,  436,   -1,   -1,   -1,   -1,  532,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  362,  271,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,  436,  281,  282,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,  267,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  597,  279,  280,  279,  280,   -1,   44,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   58,   59,  333,  334,   -1,   -1,   -1,  338, 
          625,   10,  341,   -1,  629,  344,   -1,  346,  633,   -1, 
           -1,  350,   -1,  547,  548,  354,  355,  356,  357,  358, 
          645,  360,  328,  362,  328,   91,   -1,   -1,   -1,  335, 
           -1,  335,   -1,   -1,  340,  569,  340,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  343,  344,   -1,  346,  347,  583, 
           59,   -1,  358,  548,  358,  361,   -1,  361,   -1,   -1, 
          262,  263,  264,  688,   -1,   -1,  268,  269,  367,  271, 
          695,   -1,   -1,   -1,  569,   -1,   -1,  611,   -1,   -1, 
           -1,   -1,   -1,   -1,  618,  384,  385,   -1,  583,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,  727,   -1,   -1,   -1,    0,   -1,   -1,  408, 
           -1,  645,   -1,   -1,   -1,   -1,   10,   -1,  317,  744, 
           -1,   -1,   -1,   -1,  658,  750,   -1,   -1,   -1,   -1, 
           -1,  665,   -1,  667,  333,  334,  670,  671,  672,  341, 
          439,   -1,   -1,  677,   -1,   -1,   -1,   -1,   -1,  348, 
           44,  350,   -1,  352,  353,  354,  355,   -1,   -1,  358, 
          362,  360,  787,  658,   58,   59,   -1,   61,   -1,   63, 
          665,   -1,  667,   -1,   -1,  670,   -1,   -1,   -1,  713, 
           -1,   -1,  716,   -1,   -1,  306,  811,  308,  309,  310, 
          311,   -1,   -1,   -1,  728,  729,  730,   91,   -1,   -1, 
          825,  267,   -1,   -1,  829,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,  279,  335,   -1,   -1,   -1,  713,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350, 
            0,   -1,   -1,  728,  729,  730,  861,   -1,  863,  773, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  785,  877,   -1,  879,  789,   -1,   -1,   -1,   -1, 
           -1,  886,  328,   -1,   -1,  890,   -1,   -1,   -1,  335, 
           -1,  805,   -1,   -1,   44,   -1,   -1,   -1,  773,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   61,  358,   63,  789,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          805,  610,   -1,  847,   -1,  849,   -1,   -1,   -1,  328, 
           -1,   91,  856,   -1,   -1,   -1,  335,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,  641,  642,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,  847,   -1,  849,   -1,   -1,   10,   10,   -1, 
           -1,  856,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  299,   58,   59,  302,  303, 
           63,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,    0,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,   10,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,   58,   59,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,    0,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   10,   -1,  375,  376,   -1,  378,  379, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   44,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   91,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
           -1,   -1,   -1,   -1,  333,  334,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,  348, 
          344,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,   -1,   -1,    0,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   10,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   58,   59,  302,  303,   59,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   44,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   63,  299,   -1,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,    0, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   10, 
           -1,  375,  376,   -1,  378,  379,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,  306,   -1,  308,  309,  310,  311, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           91,   -1,   -1,  335,   -1,   -1,  341,   -1,  340,  344, 
           -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350,  317, 
          318,  319,  320,  321,  322,  323,  324,  362,  326,  327, 
           -1,   -1,    0,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   10,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   58, 
           59,  302,  303,   59,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   58,   -1,  302,  303,   -1,   63,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,    0,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   10,   -1,  375,  376,   -1, 
          378,  379,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
          306,   -1,  308,  309,  310,  311,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   91,   -1,   -1,  335, 
           -1,   -1,  341,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,  349,  350,  317,  318,  319,  320,  321, 
          322,  323,   -1,  362,  326,  327,   -1,   -1,    0,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           10,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  299,   58,   59,  302,  303,   59, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
           -1,  293,  294,  295,  296,  297,   63,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,    0,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   10,   -1,  375,  376,   -1,  378,  379,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,  306,   -1,  308,  309, 
          310,  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   91,   -1,   -1,  335,   -1,   -1,  341,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349, 
          350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   10,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   58,   59,  302,  303,   59,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   63,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,    0,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   10,   -1,  375, 
          376,   -1,  378,  379,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   58,   59,   -1,   61,   -1, 
           63,   -1,  306,   -1,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   91,   -1, 
           -1,  335,   -1,   -1,  341,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   58,   59,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,   -1,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,    0,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   10,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,  362,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,   -1,   44,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  358,   -1,   -1,   -1, 
           91,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  299,   59,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,  340,  341,  342,  343, 
           -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,  340, 
          341,  342,  343,   -1,  345,   -1,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,    0,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   10,   -1,  375,  376,   -1,  378,  379,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,  362, 
           -1,  265,  266,   -1,   -1,    0,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   44, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   91,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,   58,   59,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,  340,  341,  342,  343,   -1,  345,   -1,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   10,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   59,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   91,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,  281, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  299,   -1,   10, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,   -1,  341, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   59,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   10,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   59,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361,   91, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   91,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
          361,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   10,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   91,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   10,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   10,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,  264,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   10,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,    0,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   10,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   44,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   91,   -1,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,    0,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   10,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   44,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   91,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  280,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,  361,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,  337, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  280,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,  361,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   61,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   61,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  279,  280,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,  328,   63,   -1,   -1,   -1,   -1, 
           -1,  335,   -1,   -1,   -1,   -1,  340,  341,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,  358,  333,  334,  361,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,  279,  280,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,  328,   63,   -1,   -1,   -1, 
           -1,   -1,  335,   -1,   -1,   -1,   -1,  340,  341,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,  358,  333,  334,  361,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   91, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   91,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,    0, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   10, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   44,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,    0, 
          333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341,   10, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   44,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
            0,  333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341, 
           10,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   44,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,    0,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   10,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   58,   59,   -1,   -1,   -1,   63,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,    0,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   10,   -1,  344,   -1,  346,   -1,   -1,   -1,  350, 
           -1,   -1,   -1,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   44,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  281,  282,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,    0,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   10,   -1,  344,   -1,  346,   -1,   -1,   -1, 
          350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,    0,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344, 
           -1,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1, 
           63,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,    0,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1,   -1, 
           -1,  350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,  281,  282,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   10, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   44,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59,   -1, 
           -1,   -1,   63,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   10,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356, 
          357,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,  281,  282,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          356,  357,   -1,   -1,   -1,   -1,  362,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,    0,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  356,  357,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1, 
           -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,    0,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  362,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   10,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,    0,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   10,  271, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  324,  325,   -1,   -1,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,    0,  346,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,    0,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   10,  271,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,    0,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   10,  271, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,    0,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  324,  325,   -1,   -1,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   44,  344,   -1,  346,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   58,   59,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  325,   10, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,  262,  263,  264,    0,   -1,  267,  268, 
          269,   -1,  271,   44,   -1,  362,   10,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   58,   59,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,    0,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   10,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,    0,  338,   -1,   -1,  341, 
           -1,   44,  344,   -1,  346,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   44, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,  362, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,    0,  293,  294,  295,  296,  297,   -1,  262,  263, 
          264,   10,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,    0,  293, 
          294,  295,  296,  297,   -1,   44,   -1,  338,   10,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   10,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,    0,  362,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   58,   59,   -1,    0,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   10,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   58,   59,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,  262,  263,  264,   58,   59,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
            0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           10,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   44,  344,   -1,  346,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   58,   59, 
           -1,    0,   -1,  362,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   44,   -1,   -1,   -1,  262, 
          263,  264,   10,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,   -1,   -1,  338,   -1,   -1,  341,  281,  282, 
          344,   -1,  346,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   44,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,  281, 
          282,  344,   -1,  346,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          362,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  338,   44, 
           -1,  341,  281,  282,  344,   -1,  346,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  362,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
          338,   -1,  270,  341,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,   -1,   59,  306,  307, 
          308,  309,  310,  311,   -1,   -1,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,  341, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          333,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
          308,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,  363,  364,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,   -1,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,   -1,  322,  323,   -1,   -1,  326,   -1,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,  363,  364,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,   -1,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,   -1, 
          322,  323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
           -1,  363,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,   -1,  322,  323,   -1, 
           -1,  326,   -1,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   -1,  363,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,  363, 
      };
   }

}
