/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby;

import de.saumya.mojo.ruby.ScriptUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;

public class GemScriptingContainer
extends ScriptingContainer {
    public GemScriptingContainer() {
        this(LocalContextScope.SINGLETON, LocalVariableBehavior.PERSISTENT, null, null);
    }

    public GemScriptingContainer(File gemHome, File gemPath) {
        this(LocalContextScope.SINGLETON, LocalVariableBehavior.PERSISTENT, gemHome, gemPath);
    }

    public GemScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, null, null);
    }

    public GemScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, File gemHome, File gemPath) {
        super(scope, behavior);
        HashMap<String, String> env = new HashMap<String, String>();
        if (gemHome != null && gemHome.exists()) {
            env.put("GEM_HOME", gemHome.getAbsolutePath());
        }
        if (gemPath != null && gemPath.exists()) {
            env.put("GEM_PATH", gemPath.getAbsolutePath());
        }
        this.getProvider().getRubyInstanceConfig().setEnvironment(env);
        URL jrubyHome = Thread.currentThread().getContextClassLoader().getResource("META-INF/jruby.home/lib");
        if (jrubyHome != null) {
            this.getProvider().getRubyInstanceConfig().setJRubyHome(jrubyHome.toString().replaceFirst("^jar:", "").replaceFirst("/lib$", ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runScriptletFromClassloader(String name, Class<?> clazz) throws IOException {
        try (InputStream script = ScriptUtils.getScriptAsStream(name, clazz);){
            Object object = this.runScriptlet(script, name);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runScriptletFromClassloader(String name) throws IOException {
        try (InputStream script = ScriptUtils.getScriptAsStream(name);){
            Object object = this.runScriptlet(ScriptUtils.getScriptAsStream(name), name);
            return object;
        }
    }
}

