/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.gems;

import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemManager;
import de.saumya.mojo.ruby.gems.GemsConfig;
import de.saumya.mojo.ruby.script.JRubyVersion;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class GemsInstaller {
    private static final String OPENSSL_VERSION = "0.8.2";
    private static final String OPENSSL = "jruby-openssl";
    private static final FileFilter FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.getName().endsWith(".gemspec");
        }
    };
    public final GemsConfig config;
    public final ScriptFactory factory;
    public final GemManager manager;

    public GemsInstaller(GemsConfig config, ScriptFactory factory, GemManager manager) {
        this.config = config;
        this.factory = factory;
        this.manager = manager;
    }

    public void installPom(MavenProject pom) throws IOException, ScriptException, GemException {
        this.installGems(pom, null);
    }

    public void installPom(MavenProject pom, ArtifactRepository localRepository) throws IOException, ScriptException, GemException {
        this.installPom(pom, localRepository, null);
    }

    public void installPom(MavenProject pom, ArtifactRepository localRepository, String scope) throws IOException, ScriptException, GemException {
        this.installGems(pom, localRepository, scope);
    }

    public MavenProject installOpenSSLGem(Object repositorySystemSession, ArtifactRepository localRepository, List<ArtifactRepository> remotes) throws GemException, IOException, ScriptException {
        return this.installGem(OPENSSL, OPENSSL_VERSION, repositorySystemSession, localRepository, remotes);
    }

    public MavenProject installGem(String name, String version, Object repositorySystemSession, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException, IOException, ScriptException {
        Artifact artifact = version == null ? this.manager.createGemArtifactWithLatestVersion(name, localRepository, remoteRepositories) : this.manager.createGemArtifact(name, version);
        MavenProject pom = this.manager.buildPom(artifact, repositorySystemSession, localRepository, remoteRepositories);
        this.installPom(pom);
        return pom;
    }

    public void installGems(MavenProject pom, ArtifactRepository localRepository) throws IOException, ScriptException, GemException {
        this.installGems(pom, localRepository, null);
    }

    public void installGems(MavenProject pom, ArtifactRepository localRepository, String scope) throws IOException, ScriptException, GemException {
        this.installGems(pom, (Collection<Artifact>)null, localRepository, scope);
    }

    public void installGems(MavenProject pom, PluginDescriptor plugin, ArtifactRepository localRepository) throws IOException, ScriptException, GemException {
        this.installGems(pom, (Collection<Artifact>)plugin.getArtifacts(), localRepository, (String)null);
    }

    public void installGems(MavenProject pom, Collection<Artifact> artifacts, ArtifactRepository localRepository, String scope) throws IOException, ScriptException, GemException {
        this.installGems(pom, artifacts, localRepository, pom.getRemoteArtifactRepositories(), scope);
    }

    public void installGems(MavenProject pom, Collection<Artifact> artifacts, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepos) throws IOException, ScriptException, GemException {
        this.installGems(pom, artifacts, localRepository, remoteRepos, null);
    }

    public void installGems(MavenProject pom, Collection<Artifact> artifacts, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepos, String scope) throws IOException, ScriptException, GemException {
        Script script = null;
        if (pom != null) {
            boolean hasAlreadyOpenSSL = false;
            for (Artifact artifact : pom.getArtifacts()) {
                if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope()) && pom.getBasedir() == null || scope != null && !scope.equals(artifact.getScope())) continue;
                if (!artifact.getFile().exists()) {
                    this.manager.resolve(artifact, localRepository, remoteRepos);
                }
                script = this.maybeAddArtifact(script, artifact);
                hasAlreadyOpenSSL = hasAlreadyOpenSSL || artifact.getArtifactId().equals(OPENSSL);
            }
            if (artifacts != null) {
                for (Artifact artifact : artifacts) {
                    if (!artifact.getFile().exists()) {
                        this.manager.resolve(artifact, localRepository, remoteRepos);
                    }
                    script = this.maybeAddArtifact(script, artifact);
                    hasAlreadyOpenSSL = hasAlreadyOpenSSL || artifact.getArtifactId().equals(OPENSSL);
                }
            }
            if (pom.getArtifact().getFile() != null && pom.getArtifact().getFile().isFile() && pom.getArtifact().getFile().getName().endsWith(".gem")) {
                script = this.maybeAddArtifact(script, pom.getArtifact());
            }
            if (!this.config.skipJRubyOpenSSL() && !hasAlreadyOpenSSL && script != null) {
                Artifact openssl = this.manager.createGemArtifact(OPENSSL, OPENSSL_VERSION);
                if (pom.getFile() == null) {
                    this.manager.addDefaultGemRepositories(remoteRepos);
                }
                for (Artifact a : this.manager.resolve(openssl, localRepository, remoteRepos, true)) {
                    if (a.getFile() == null || !a.getFile().exists()) {
                        this.manager.resolve(a, localRepository, remoteRepos);
                    }
                    script = this.maybeAddArtifact(script, a);
                }
            }
        }
        if (script != null) {
            script.addArg("--bindir", this.config.getBinDirectory());
            if (this.config.getBinDirectory() != null && !this.config.getBinDirectory().exists()) {
                this.config.getBinDirectory().mkdirs();
            }
            script.execute();
            if (this.config.getGemHome() != null) {
                for (File spec : new File(this.config.getGemHome(), "specifications").listFiles(FILTER)) {
                    String content = FileUtils.fileRead((File)spec);
                    FileUtils.fileWrite((String)spec.getAbsolutePath(), (String)content.replaceFirst(" 00:00:00.000000000Z", ""));
                }
            }
            this.factory.newScript("require 'jruby/commands'; JRuby::Commands.generate_dir_info '" + this.config.getGemHome() + "' if JRuby::Commands.respond_to? :generate_dir_info").execute();
        }
    }

    private boolean exists(Artifact artifact) {
        String basename = artifact.getArtifactId() + "-" + artifact.getVersion().replaceFirst("-SNAPSHOT$", "");
        String universalJavaBasename = basename + "-universal-java.gemspec";
        String javaBasename = basename + "-java.gemspec";
        String rubyBasename = basename + ".gemspec";
        for (File dir : this.config.getGemsDirectory()) {
            File specs = new File(dir.getParentFile(), "specifications");
            if (!new File(specs, rubyBasename).exists() && !new File(specs, javaBasename).exists() && !new File(specs, universalJavaBasename).exists()) continue;
            return true;
        }
        return false;
    }

    private Script maybeAddArtifact(Script script, Artifact artifact) throws IOException, GemException {
        if (artifact.getType().contains("gem") && !this.exists(artifact)) {
            if (script == null) {
                script = this.factory.newScriptFromJRubyJar("gem").addArg("install").addArg("--ignore-dependencies").addArg(this.booleanArg(this.config.isUserInstall(), "user-install")).addArg(this.booleanArg(this.config.isVerbose(), "verbose"));
                JRubyVersion version = this.factory.getVersion();
                if (version == null || version.isVersionLowerThan(9, 2, 10)) {
                    script.addArg(this.booleanArg(this.config.isAddRdoc(), "rdoc")).addArg(this.booleanArg(this.config.isAddRI(), "ri"));
                } else {
                    script.addArg(this.booleanArg(this.config.isAddRdoc(), "document"));
                }
            }
            if (artifact.getFile() != null) {
                script.addArg(artifact.getFile());
            }
        }
        return script;
    }

    private String booleanArg(boolean flag, String name) {
        return "--" + (flag ? "" : "no-") + name;
    }
}

