/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackDispatcher;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackResponseEnvironment;
import org.jruby.rack.servlet.RequestCapture;
import org.jruby.rack.servlet.ResponseCapture;
import org.jruby.rack.servlet.ServletRackEnvironment;
import org.jruby.rack.servlet.ServletRackResponseEnvironment;

public abstract class AbstractFilter
implements Filter {
    protected abstract RackContext getContext();

    protected abstract RackDispatcher getDispatcher();

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletRackResponseEnvironment responseEnv;
        ServletRackEnvironment env;
        ResponseCapture responseCapture;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        RequestCapture requestCapture = this.wrapRequest((ServletRequest)httpRequest);
        if (this.isDoDispatch(requestCapture, responseCapture = this.wrapResponse((ServletResponse)httpResponse), chain, env = new ServletRackEnvironment(httpRequest, httpResponse, this.getContext()), responseEnv = new ServletRackResponseEnvironment(httpResponse))) {
            this.getDispatcher().process(env, responseEnv);
        }
    }

    public void destroy() {
        this.getDispatcher().destroy();
    }

    protected boolean isDoDispatch(RequestCapture request, ResponseCapture response, FilterChain chain, RackEnvironment env) throws IOException, ServletException {
        return true;
    }

    @Deprecated
    protected boolean isDoDispatch(RequestCapture request, ResponseCapture response, FilterChain chain, RackEnvironment env, RackResponseEnvironment responseEnv) throws IOException, ServletException {
        return this.isDoDispatch(request, response, chain, env);
    }

    protected RequestCapture wrapRequest(ServletRequest request) {
        return new RequestCapture((HttpServletRequest)request);
    }

    protected ResponseCapture wrapResponse(ServletResponse response) {
        return new ResponseCapture((HttpServletResponse)response);
    }
}

