/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.IOException;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackDispatcher;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackException;
import org.jruby.rack.RackResponseEnvironment;

public abstract class AbstractRackDispatcher
implements RackDispatcher {
    protected final RackContext context;

    public AbstractRackDispatcher(RackContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RackEnvironment request, RackResponseEnvironment response) throws IOException {
        RackApplication app = null;
        try {
            app = this.getApplication();
            app.call(request).respond(response);
        }
        catch (Exception e) {
            this.handleException(e, request, response);
        }
        finally {
            if (app != null) {
                this.afterProcess(app);
            }
        }
    }

    protected void handleException(Exception e, RackEnvironment request, RackResponseEnvironment response) throws IOException {
        if (response.isCommitted()) {
            this.context.log("ERROR", "couldn't handle exception " + e + " : response is committed");
            return;
        }
        this.context.log("DEBUG", "resetting rack response due exception");
        response.reset();
        this.afterException(request, e, response);
    }

    protected abstract RackApplication getApplication() throws RackException;

    protected abstract void afterProcess(RackApplication var1) throws IOException;

    protected abstract void afterException(RackEnvironment var1, Exception var2, RackResponseEnvironment var3) throws IOException;
}

