/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyObjectAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackInput;
import org.jruby.rack.RackResponse;
import org.jruby.runtime.builtin.IRubyObject;

public class DefaultRackApplication
implements RackApplication {
    protected final RubyObjectAdapter adapter = JavaEmbedUtils.newObjectAdapter();
    protected IRubyObject application;

    public DefaultRackApplication() {
    }

    public DefaultRackApplication(IRubyObject application) {
        this.setApplication(application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RackResponse call(RackEnvironment env) {
        Ruby runtime = this.getRuntime();
        RackInput io = new RackInput(runtime, env);
        try {
            IRubyObject servlet_env = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)env);
            if (env instanceof RackEnvironment.ToIO) {
                ((RackEnvironment.ToIO)((Object)env)).setIO(io);
            } else {
                runtime.evalScriptlet("require 'jruby/rack/environment'");
                this.adapter.setInstanceVariable(servlet_env, "@_io", (IRubyObject)io);
            }
            IRubyObject response = this.adapter.callMethod(this.getApplication(), "call", servlet_env);
            RackResponse rackResponse = (RackResponse)JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)response, RackResponse.class);
            io.close();
            return rackResponse;
        }
        catch (Throwable throwable) {
            try {
                io.close();
                throw throwable;
            }
            catch (IOException e) {
                throw RaiseException.createNativeRaiseException((Ruby)runtime, (Throwable)e);
            }
        }
    }

    public void init() {
    }

    public void destroy() {
    }

    public Ruby getRuntime() {
        return this.getApplication().getRuntime();
    }

    public IRubyObject getApplication() {
        if (this.application == null) {
            throw new IllegalStateException("no application set");
        }
        return this.application;
    }

    public void setApplication(IRubyObject application) {
        this.application = application;
    }

    public boolean isApplicationSet() {
        return this.application != null;
    }

    @Deprecated
    public IRubyObject __call(IRubyObject env) {
        return this.adapter.callMethod(this.getApplication(), "call", env);
    }
}

