/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.rack.DefaultErrorApplication;
import org.jruby.rack.DefaultRackApplication;
import org.jruby.rack.DefaultRackConfig;
import org.jruby.rack.ErrorApplication;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackException;
import org.jruby.rack.RackInitializationException;
import org.jruby.rack.servlet.RewindableInputStream;
import org.jruby.rack.servlet.ServletRackContext;
import org.jruby.rack.util.IOHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefaultRackApplicationFactory
implements RackApplicationFactory {
    private String rackupScript;
    private String rackupLocation;
    private ServletRackContext rackContext;
    private RubyInstanceConfig runtimeConfig;
    private RackApplication errorApplication;

    public static RackApplicationFactory getRealFactory(RackApplicationFactory factory) {
        if (factory instanceof RackApplicationFactory.Decorator) {
            return DefaultRackApplicationFactory.getRealFactory(((RackApplicationFactory.Decorator)((Object)factory)).getDelegate());
        }
        return factory;
    }

    public RackContext getRackContext() {
        return this.rackContext;
    }

    public String getRackupScript() {
        return this.rackupScript;
    }

    public void setRackupScript(String rackupScript) {
        this.rackupScript = rackupScript;
        this.rackupLocation = null;
    }

    public void init(RackContext rackContext) {
        this.rackContext = (ServletRackContext)rackContext;
        if (this.getRackupScript() == null) {
            this.resolveRackupScript();
        }
        this.runtimeConfig = this.createRuntimeConfig();
        rackContext.log("INFO", this.runtimeConfig.getVersionString());
        this.configureDefaults();
    }

    public RackApplication newApplication() {
        return this.createApplication(new ApplicationObjectFactory(){

            public IRubyObject create(Ruby runtime) {
                return DefaultRackApplicationFactory.this.createApplicationObject(runtime);
            }
        });
    }

    public RackApplication getApplication() {
        RackApplication app = this.newApplication();
        app.init();
        return app;
    }

    public void finishedWithApplication(RackApplication app) {
        if (app != null) {
            app.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RackApplication getErrorApplication() {
        if (this.errorApplication == null) {
            DefaultRackApplicationFactory defaultRackApplicationFactory = this;
            synchronized (defaultRackApplicationFactory) {
                if (this.errorApplication == null) {
                    this.errorApplication = this.newErrorApplication();
                }
            }
        }
        return this.errorApplication;
    }

    public synchronized void setErrorApplication(RackApplication errorApplication) {
        this.errorApplication = errorApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.errorApplication != null) {
            DefaultRackApplicationFactory defaultRackApplicationFactory = this;
            synchronized (defaultRackApplicationFactory) {
                if (this.errorApplication != null) {
                    this.errorApplication.destroy();
                    this.errorApplication = null;
                }
            }
        }
    }

    public IRubyObject createApplicationObject(Ruby runtime) {
        if (this.rackupScript == null) {
            this.rackContext.log("WARN", "no rackup script found - starting empty Rack application!");
            this.rackupScript = "";
        }
        this.checkAndSetRackVersion(runtime);
        runtime.evalScriptlet("load 'jruby/rack/boot/rack.rb'");
        return this.createRackServletWrapper(runtime, this.rackupScript, this.rackupLocation);
    }

    public IRubyObject createErrorApplicationObject(Ruby runtime) {
        String errorApp = this.rackContext.getConfig().getProperty("jruby.rack.error.app");
        String errorAppPath = "<web.xml>";
        if (errorApp == null && (errorApp = this.rackContext.getConfig().getProperty("jruby.rack.error.app.path")) != null) {
            errorAppPath = this.rackContext.getRealPath(errorApp);
            try {
                errorApp = IOHelpers.inputStreamToString(this.rackContext.getResourceAsStream(errorApp));
            }
            catch (IOException e) {
                this.rackContext.log("WARN", "failed to read jruby.rack.error.app.path = '" + errorApp + "' " + "will use default error application", e);
                errorAppPath = null;
                errorApp = null;
            }
        }
        if (errorApp == null) {
            errorApp = "require 'jruby/rack/error_app' \nuse Rack::ShowStatus \nrun JRuby::Rack::ErrorApp.new";
        }
        runtime.evalScriptlet("load 'jruby/rack/boot/rack.rb'");
        return this.createRackServletWrapper(runtime, errorApp, errorAppPath);
    }

    public RackApplication newErrorApplication() {
        Boolean error = this.rackContext.getConfig().getBooleanProperty("jruby.rack.error");
        if (error != null && !error.booleanValue()) {
            return new DefaultErrorApplication(this.rackContext);
        }
        try {
            RackApplication app = this.createErrorApplication(new ApplicationObjectFactory(){

                public IRubyObject create(Ruby runtime) {
                    return DefaultRackApplicationFactory.this.createErrorApplicationObject(runtime);
                }
            });
            app.init();
            return app;
        }
        catch (Exception e) {
            this.rackContext.log("WARN", "error application could not be initialized", e);
            return new DefaultErrorApplication(this.rackContext);
        }
    }

    protected IRubyObject createRackServletWrapper(Ruby runtime, String rackup) {
        return this.createRackServletWrapper(runtime, rackup, null);
    }

    protected IRubyObject createRackServletWrapper(Ruby runtime, String rackup, String filename) {
        return runtime.executeScript("Rack::Handler::Servlet.new( Rack::Builder.new { (" + rackup + "\n) }.to_app " + ")", filename);
    }

    public RubyInstanceConfig createRuntimeConfig() {
        DefaultRackApplicationFactory.setupJRubyManagement();
        return this.initRuntimeConfig(new RubyInstanceConfig());
    }

    protected RubyInstanceConfig initRuntimeConfig(RubyInstanceConfig config) {
        block16: {
            RackConfig rackConfig = this.rackContext.getConfig();
            config.setLoader(Thread.currentThread().getContextClassLoader());
            try {
                Method setUpdateNativeENVEnabled = config.getClass().getMethod("setUpdateNativeENVEnabled", Boolean.TYPE);
                setUpdateNativeENVEnabled.invoke((Object)config, false);
            }
            catch (NoSuchMethodException e) {
                this.rackContext.log("DEBUG", "envronment changes made inside one app might affect another, consider updating JRuby if this is an issue");
            }
            catch (IllegalAccessException e) {
                this.rackContext.log("WARN", "failed to disable updating native environment", e);
            }
            catch (InvocationTargetException e) {
                throw new RackException(e.getTargetException());
            }
            Map<String, String> newEnv = rackConfig.getRuntimeEnvironment();
            if (newEnv != null) {
                if (!newEnv.containsKey("PATH")) {
                    newEnv.put("PATH", "");
                }
                if (DefaultRackConfig.isIgnoreRUBYOPT(rackConfig)) {
                    if (newEnv.containsKey("RUBYOPT")) {
                        newEnv.put("RUBYOPT", "");
                    }
                } else {
                    Map env = config.getEnvironment();
                    if (env != null && env.containsKey("RUBYOPT")) {
                        newEnv.put("RUBYOPT", (String)env.get("RUBYOPT"));
                    }
                }
                config.setEnvironment(newEnv);
            }
            config.processArguments(rackConfig.getRuntimeArguments());
            if (rackConfig.getCompatVersion() != null) {
                config.setCompatVersion(rackConfig.getCompatVersion());
            }
            try {
                String home;
                URL resource = RubyInstanceConfig.class.getResource("/META-INF/jruby.home");
                if (resource == null || !resource.getProtocol().equals("jar")) break block16;
                try {
                    home = resource.toURI().getSchemeSpecificPart();
                }
                catch (URISyntaxException e) {
                    home = resource.getPath();
                }
                if (home.endsWith("/")) {
                    home = home.substring(0, home.length() - 1);
                }
                config.setJRubyHome(home);
            }
            catch (Exception e) {
                this.rackContext.log("DEBUG", "won't set-up jruby.home from jar", e);
            }
        }
        return config;
    }

    public Ruby newRuntime() throws RaiseException {
        Ruby runtime = Ruby.newInstance((RubyInstanceConfig)this.runtimeConfig);
        this.initRuntime(runtime);
        return runtime;
    }

    void initRuntime(Ruby runtime) {
        String dechunk;
        Boolean dechunkFlag;
        String response;
        runtime.getGlobalVariables().set("$servlet_context", JavaUtil.convertJavaToRuby((Ruby)runtime, (Object)this.rackContext));
        runtime.evalScriptlet("require 'rack/handler/servlet'");
        String env = this.rackContext.getConfig().getProperty("jruby.rack.handler.env");
        if (env != null) {
            runtime.evalScriptlet("Rack::Handler::Servlet.env = '" + env + "'");
        }
        if ((response = this.rackContext.getConfig().getProperty("jruby.rack.handler.response")) == null) {
            response = this.rackContext.getConfig().getProperty("jruby.rack.response");
        }
        if (response != null) {
            runtime.evalScriptlet("Rack::Handler::Servlet.response = '" + response + "'");
        }
        if ((dechunkFlag = (Boolean)DefaultRackConfig.toStrictBoolean(dechunk = this.rackContext.getConfig().getProperty("jruby.rack.response.dechunk"), null)) != null) {
            runtime.evalScriptlet("JRuby::Rack::Response.dechunk = " + dechunkFlag + "");
        } else {
            runtime.evalScriptlet("JRuby::Rack::Booter.on_boot { require 'jruby/rack/chunked' }");
        }
    }

    String checkAndSetRackVersion(Ruby runtime) {
        String rackVersion = null;
        try {
            rackVersion = IOHelpers.rubyMagicCommentValue(this.rackupScript, "rack.version:");
        }
        catch (Exception e) {
            this.rackContext.log("DEBUG", "could not read 'rack.version' magic comment from rackup", e);
        }
        if (rackVersion == null) {
            // empty if block
        }
        if (rackVersion != null) {
            runtime.evalScriptlet("require 'rubygems'");
            if (rackVersion.equalsIgnoreCase("bundler")) {
                runtime.evalScriptlet("require 'bundler/setup'");
            } else {
                this.rackContext.log("DEBUG", "detected 'rack.version' magic comment, will use `gem 'rack', '" + rackVersion + "'`");
                runtime.evalScriptlet("gem 'rack', '" + rackVersion + "' if defined? gem");
            }
        }
        return rackVersion;
    }

    private RackApplication createApplication(ApplicationObjectFactory appFactory) {
        return new RackApplicationImpl(appFactory);
    }

    private RackApplication createErrorApplication(ApplicationObjectFactory appFactory) {
        return new ErrorApplicationImpl(appFactory);
    }

    private void captureMessage(RaiseException re) {
        try {
            RubyException rubyException = re.getException();
            ThreadContext context = rubyException.getRuntime().getCurrentContext();
            rubyException.callMethod(context, "capture");
            rubyException.callMethod(context, "store");
        }
        catch (Exception e) {
            this.rackContext.log("INFO", "failed to capture exception message", e);
        }
    }

    private String findConfigRuPathInSubDirectories(String path, int level) {
        Set entries = this.rackContext.getResourcePaths(path);
        if (entries != null) {
            String config_ru = path + "config.ru";
            if (entries.contains(config_ru)) {
                return config_ru;
            }
            if (level > 0) {
                --level;
                for (String subpath : entries) {
                    if (!subpath.endsWith("/") || (subpath = this.findConfigRuPathInSubDirectories(subpath, level)) == null) continue;
                    return subpath;
                }
            }
        }
        return null;
    }

    private String resolveRackupScript() throws RackInitializationException {
        this.rackupLocation = "<web.xml>";
        String rackup = this.rackContext.getConfig().getRackup();
        if (rackup == null) {
            String rackupPath;
            rackup = this.rackContext.getConfig().getRackupPath();
            if (rackup == null) {
                rackup = this.findConfigRuPathInSubDirectories("/WEB-INF/", 1);
            }
            if (rackup == null && (rackupPath = this.rackContext.getRealPath("/config.ru")) != null && new File(rackupPath).exists()) {
                rackup = "/config.ru";
            }
            if (rackup != null) {
                this.rackupLocation = this.rackContext.getRealPath(rackup);
                try {
                    rackup = IOHelpers.inputStreamToString(this.rackContext.getResourceAsStream(rackup));
                }
                catch (IOException e) {
                    this.rackContext.log("ERROR", "failed to read rackup from '" + rackup + "' (" + e + ")");
                    throw new RackInitializationException("failed to read rackup input", e);
                }
            }
        }
        this.rackupScript = rackup;
        return this.rackupScript;
    }

    private void configureDefaults() {
        Integer maxSize;
        RackConfig config = this.rackContext.getConfig();
        Integer iniSize = config.getInitialMemoryBufferSize();
        if (iniSize == null) {
            iniSize = 4096;
        }
        if ((maxSize = config.getMaximumMemoryBufferSize()) == null) {
            maxSize = 16384;
        }
        if (iniSize > maxSize) {
            iniSize = maxSize;
        }
        RewindableInputStream.setDefaultInitialBufferSize(iniSize);
        RewindableInputStream.setDefaultMaximumBufferSize(maxSize);
    }

    private static void setupJRubyManagement() {
        String jrubyMxEnabled = "jruby.management.enabled";
        if (!"false".equalsIgnoreCase(System.getProperty("jruby.management.enabled"))) {
            System.setProperty("jruby.management.enabled", "true");
        }
    }

    private class ErrorApplicationImpl
    extends RackApplicationImpl
    implements ErrorApplication {
        ErrorApplicationImpl(ApplicationObjectFactory appFactory) {
            super(appFactory);
        }

        public void init() {
            this.setApplication(this.appFactory.create(this.runtime));
        }
    }

    private class RackApplicationImpl
    extends DefaultRackApplication {
        protected final Ruby runtime;
        final ApplicationObjectFactory appFactory;

        RackApplicationImpl(ApplicationObjectFactory appFactory) {
            this.runtime = DefaultRackApplicationFactory.this.newRuntime();
            this.appFactory = appFactory;
        }

        public void init() {
            try {
                this.setApplication(this.appFactory.create(this.runtime));
            }
            catch (RaiseException e) {
                DefaultRackApplicationFactory.this.captureMessage(e);
                throw e;
            }
        }

        public void destroy() {
            this.runtime.tearDown(false);
        }
    }

    static interface ApplicationObjectFactory {
        public IRubyObject create(Ruby var1);
    }
}

