/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.IOException;
import org.jruby.rack.AbstractRackDispatcher;
import org.jruby.rack.ErrorApplicationHandler;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackException;
import org.jruby.rack.RackResponseEnvironment;
import org.jruby.rack.servlet.ServletRackContext;

public class DefaultRackDispatcher
extends AbstractRackDispatcher {
    private Integer errorApplicationFailureStatusCode = 500;

    public DefaultRackDispatcher(RackContext context) {
        super(context);
    }

    public Integer getErrorApplicationFailureStatusCode() {
        return this.errorApplicationFailureStatusCode;
    }

    public void setErrorApplicationFailureStatusCode(Integer code) {
        this.errorApplicationFailureStatusCode = code;
    }

    protected RackApplication getApplication() throws RackException {
        return this.getRackFactory().getApplication();
    }

    protected void afterException(RackEnvironment request, Exception e, RackResponseEnvironment response) throws IOException, RackException {
        ErrorApplicationHandler errorHandler = new ErrorApplicationHandler(this.getErrorApplication(), e);
        try {
            errorHandler.call(request).respond(response);
        }
        catch (RuntimeException ex) {
            if (ex instanceof RackException) {
                throw (RackException)ex;
            }
            this.context.log("ERROR", "error app failed to handle exception: " + e, ex);
            Integer errorCode = this.getErrorApplicationFailureStatusCode();
            if (errorCode != null && errorCode > 0) {
                response.sendError(errorCode);
            }
            throw ex;
        }
    }

    protected void afterProcess(RackApplication app) {
        this.getRackFactory().finishedWithApplication(app);
    }

    public void destroy() {
        this.getRackFactory().destroy();
    }

    protected RackApplicationFactory getRackFactory() {
        if (this.context instanceof ServletRackContext) {
            return ((ServletRackContext)this.context).getRackFactory();
        }
        throw new IllegalStateException("not a servlet rack context");
    }

    private RackApplication getErrorApplication() {
        return this.getRackFactory().getErrorApplication();
    }
}

