/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.servlet.RewindableInputStream;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RackInput
extends RubyObject {
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RackInput(runtime, klass);
        }
    };
    private boolean rewindable;
    private InputStream input;
    private int length;

    @Deprecated
    public static RubyClass getClass(Ruby runtime, String name, RubyClass parent, ObjectAllocator allocator, Class annoClass) {
        RubyModule jruby = runtime.getOrCreateModule("JRuby");
        RubyClass klass = jruby.getClass(name);
        if (klass == null) {
            klass = jruby.defineClassUnder(name, parent, allocator);
            klass.defineAnnotatedMethods(annoClass);
        }
        return klass;
    }

    public static RubyClass getRackInputClass(Ruby runtime) {
        RubyClass klass;
        RubyModule jruby = runtime.getOrCreateModule("JRuby");
        RubyModule rack = (RubyModule)jruby.getConstantAt("Rack");
        if (rack == null) {
            rack = runtime.defineModuleUnder("Rack", jruby);
        }
        if ((klass = rack.getClass("Input")) == null) {
            RubyClass parent = runtime.getObject();
            klass = rack.defineClassUnder("Input", parent, ALLOCATOR);
            klass.defineAnnotatedMethods(RackInput.class);
        }
        if (jruby.getConstantAt("RackInput") == null) {
            jruby.setConstant("RackInput", (IRubyObject)klass);
        }
        return klass;
    }

    public RackInput(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public RackInput(Ruby runtime, RackEnvironment env) throws IOException {
        super(runtime, RackInput.getRackInputClass(runtime));
        this.rewindable = env.getContext().getConfig().isRewindable();
        this.setInput(env.getInput());
        this.length = env.getContentLength();
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg) {
        Object obj = JavaEmbedUtils.rubyToJava((IRubyObject)arg);
        if (obj instanceof InputStream) {
            this.setInput((InputStream)obj);
        }
        this.length = 0;
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject gets(ThreadContext context) {
        try {
            int NEWLINE = 10;
            byte[] bytes = this.readUntil(10, 0);
            if (bytes != null) {
                return this.getRuntime().newString(new ByteList(bytes));
            }
            return this.getRuntime().getNil();
        }
        catch (IOException io) {
            throw this.getRuntime().newIOErrorFromException(io);
        }
    }

    @JRubyMethod(optional=2)
    public IRubyObject read(ThreadContext context, IRubyObject[] args) {
        int count = 0;
        if (args.length > 0) {
            long arg = args[0].convertToInteger("to_i").getLongValue();
            count = (int)Math.min(arg, Integer.MAX_VALUE);
        }
        RubyString string = null;
        if (args.length == 2) {
            string = args[1].convertToString();
        }
        try {
            byte[] bytes = this.readUntil(Integer.MAX_VALUE, count);
            if (bytes != null) {
                if (string != null) {
                    string.clear();
                    string.cat(bytes);
                    return string;
                }
                return this.getRuntime().newString(new ByteList(bytes));
            }
            if (count > 0) {
                return this.getRuntime().getNil();
            }
            return RubyString.newEmptyString((Ruby)this.getRuntime());
        }
        catch (IOException io) {
            throw this.getRuntime().newIOErrorFromException(io);
        }
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        IRubyObject nil = this.getRuntime().getNil();
        IRubyObject line = null;
        while ((line = this.gets(context)) != nil) {
            block.yield(context, line);
        }
        return nil;
    }

    @JRubyMethod
    public IRubyObject rewind(ThreadContext context) {
        if (this.input != null) {
            try {
                Method rewind = RackInput.getRewindMethod(this.input);
                if (rewind != null) {
                    rewind.invoke((Object)this.input, (Object[])null);
                }
            }
            catch (IllegalArgumentException e) {
                throw this.getRuntime().newArgumentError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getCause();
                if (target instanceof IOException) {
                    throw this.getRuntime().newIOErrorFromException((IOException)target);
                }
                throw this.getRuntime().newRuntimeError(target.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        return this.getRuntime().newFixnum(this.length);
    }

    public void close() {
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setInput(InputStream input) {
        if (input != null && this.rewindable && RackInput.getRewindMethod(input) == null) {
            input = new RewindableInputStream((InputStream)input);
        }
        this.input = input;
    }

    private static Method getRewindMethod(InputStream input) {
        try {
            return input.getClass().getMethod("rewind", null);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private byte[] readUntil(int match, int count) throws IOException {
        int b;
        ByteArrayOutputStream bs = null;
        long i = 0L;
        while ((b = this.input.read()) != -1) {
            if (bs == null) {
                bs = new ByteArrayOutputStream(count == 0 ? 128 : count);
            }
            bs.write(b);
            if (++i != (long)count && b != match) continue;
        }
        return bs == null ? null : bs.toByteArray();
    }
}

