/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.embed;

import java.io.PrintStream;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackContext;
import org.jruby.rack.embed.Config;

public class Context
implements RackContext {
    private final String serverInfo;
    private final Config config;

    public Context(String serverInfo) {
        this(serverInfo, new Config());
    }

    public Context(String serverInfo, Config config) {
        if (config == null) {
            throw new IllegalArgumentException("null config");
        }
        this.serverInfo = serverInfo;
        this.config = config;
    }

    @Deprecated
    public Context(String serverInfo, RackConfig config) {
        this(serverInfo, new Config(config));
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public Config getConfig() {
        return this.config;
    }

    public void log(String message) {
        this.config.getOut().println(message);
    }

    public void log(String message, Throwable ex) {
        PrintStream err = this.config.getErr();
        err.println(message);
        ex.printStackTrace(err);
    }

    public void log(String level, String message) {
        this.log(level + ": " + message);
    }

    public void log(String level, String message, Throwable e) {
        this.log(level + ": " + message, e);
    }
}

