/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackLogger;
import org.jruby.rack.servlet.ServletRackConfig;
import org.jruby.rack.servlet.ServletRackContext;

public class DefaultServletRackContext
implements ServletRackContext {
    private final RackConfig config;
    private final ServletContext context;
    private final RackLogger logger;

    public DefaultServletRackContext(ServletRackConfig config) {
        this.config = config;
        this.context = config.getServletContext();
        this.logger = config.getLogger();
    }

    public String getInitParameter(String key) {
        return this.config.getProperty(key);
    }

    public String getRealPath(String path) {
        String realPath = this.context.getRealPath(path);
        if (realPath == null) {
            try {
                URL url = this.context.getResource(path);
                if (url != null) {
                    String urlPath = url.getPath();
                    realPath = urlPath.startsWith("file:") ? new URL(urlPath).getPath() : urlPath;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return realPath;
    }

    public RackApplicationFactory getRackFactory() {
        return (RackApplicationFactory)this.context.getAttribute("rack.factory");
    }

    public ServletContext getContext(String path) {
        return this.context.getContext(path);
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return this.context.getServlet(name);
    }

    @Deprecated
    public Enumeration getServlets() {
        return this.context.getServlets();
    }

    @Deprecated
    public Enumeration getServletNames() {
        return this.context.getServletNames();
    }

    @Deprecated
    public void log(Exception e, String msg) {
        this.logger.log(msg, e);
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public Enumeration getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public Object getAttribute(String key) {
        return this.context.getAttribute(key);
    }

    public RackConfig getConfig() {
        return this.config;
    }

    public Enumeration getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public void setAttribute(String key, Object val) {
        this.context.setAttribute(key, val);
    }

    public void removeAttribute(String key) {
        this.context.removeAttribute(key);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public void log(String message) {
        this.logger.log(message);
    }

    public void log(String message, Throwable e) {
        this.logger.log(message, e);
    }

    public void log(String level, String message) {
        this.logger.log(level, message);
    }

    public void log(String level, String message, Throwable e) {
        this.logger.log(level, message, e);
    }
}

