/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseCapture
extends HttpServletResponseWrapper {
    private static final String STREAM = "stream";
    private static final String WRITER = "writer";
    private static Collection<Integer> defaultNotHandledStatuses = Collections.singleton(404);
    private Integer status;
    private Object output;
    private Collection<Integer> notHandledStatuses = defaultNotHandledStatuses;
    private boolean headerSet;

    public ResponseCapture(HttpServletResponse response) {
        super(response);
    }

    public int getStatus() {
        return this.status != null ? this.status : 200;
    }

    public boolean isStatusSet() {
        return this.status != null;
    }

    protected boolean handleStatus(int status, boolean error) {
        this.status = status;
        return this.isHandled();
    }

    public void setStatus(int status) {
        if (this.handleStatus(status, false)) {
            super.setStatus(status);
        }
    }

    public void setStatus(int status, String message) {
        if (this.handleStatus(status, false)) {
            super.setStatus(status, message);
        }
    }

    public void sendError(int status) throws IOException {
        if (this.handleStatus(status, true)) {
            super.sendError(status);
        }
    }

    public void sendError(int status, String message) throws IOException {
        if (this.handleStatus(status, true)) {
            super.sendError(status, message);
        }
    }

    public void sendRedirect(String path) throws IOException {
        if (this.handleStatus(302, false)) {
            super.sendRedirect(path);
        }
    }

    public boolean isHeaderSet() {
        return this.headerSet;
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        this.headerSet = true;
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.headerSet = true;
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.headerSet = true;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.headerSet = true;
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        this.headerSet = true;
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.headerSet = true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = STREAM;
        }
        if (this.isHandled()) {
            return super.getOutputStream();
        }
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.output == null) {
            this.output = WRITER;
        }
        if (this.isHandled()) {
            if (this.output != WRITER) {
                String enc = this.getCharacterEncoding();
                if (enc == null) {
                    enc = "UTF-8";
                }
                return new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), enc));
            }
            return super.getWriter();
        }
        return new PrintWriter(new OutputStream(){

            public void write(int b) throws IOException {
            }
        });
    }

    public void flushBuffer() throws IOException {
        if (this.isHandled()) {
            super.flushBuffer();
        }
    }

    public boolean isError() {
        return this.getStatus() >= 400;
    }

    public boolean isHandled() {
        if (!this.isStatusSet()) {
            return this.isHeaderSet();
        }
        return !this.notHandledStatuses.contains(this.getStatus());
    }

    public Collection<Integer> getNotHandledStatuses() {
        return this.notHandledStatuses;
    }

    public void setNotHandledStatuses(Collection<Integer> notHandledStatuses) {
        this.notHandledStatuses = notHandledStatuses == null ? Collections.EMPTY_SET : notHandledStatuses;
    }

    public boolean isOutputAccessed() {
        return this.output != null;
    }
}

