/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import org.jruby.Ruby;
import org.jruby.rack.ErrorApplication;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackResponse;

public class ErrorApplicationHandler
implements ErrorApplication {
    private Exception error;
    private final RackApplication errorApplication;

    public ErrorApplicationHandler(RackApplication errorApplication) {
        if (errorApplication == null) {
            throw new IllegalArgumentException("no error application given");
        }
        this.errorApplication = errorApplication;
    }

    public ErrorApplicationHandler(RackApplication errorApplication, Exception error) {
        this(errorApplication);
        this.setError(error);
    }

    public RackApplication getErrorApplication() {
        return this.errorApplication;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    @Override
    public RackResponse call(RackEnvironment env) {
        env.setAttribute("jruby.rack.exception", this.getError());
        return this.getErrorApplication().call(env);
    }

    @Override
    public void init() {
        this.getErrorApplication().init();
    }

    @Override
    public void destroy() {
        this.getErrorApplication().destroy();
    }

    @Override
    public Ruby getRuntime() {
        return this.getErrorApplication().getRuntime();
    }
}

