/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackDispatcher;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.UnmappedRackFilter;
import org.jruby.rack.servlet.RequestCapture;
import org.jruby.rack.servlet.ResponseCapture;
import org.jruby.rack.servlet.ServletRackContext;

public class RackFilter
extends UnmappedRackFilter {
    private boolean addsHtmlToPathInfo = true;
    private boolean verifiesHtmlResource = false;

    public RackFilter() {
    }

    public RackFilter(RackDispatcher dispatcher, RackContext context) {
        super(dispatcher, context);
        this.initializeFromConfig();
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.initializeFromConfig();
        String value = config.getInitParameter("addsHtmlToPathInfo");
        if (value != null) {
            this.setAddsHtmlToPathInfo(Boolean.parseBoolean(value));
        }
        if ((value = config.getInitParameter("verifiesHtmlResource")) != null) {
            this.setVerifiesHtmlResource(Boolean.parseBoolean(value));
        }
    }

    private void initializeFromConfig() {
        RackConfig rackConfig = this.getContext().getConfig();
        this.addsHtmlToPathInfo = rackConfig.getBooleanProperty("jruby.rack.filter.adds.html", true);
        this.verifiesHtmlResource = rackConfig.getBooleanProperty("jruby.rack.filter.verifies.resource", false);
    }

    @Override
    protected void doFilterInternal(RequestCapture requestCapture, ResponseCapture responseCapture, FilterChain chain, RackEnvironment env) throws IOException, ServletException {
        ServletRequest pathChangedRequest = this.addHtmlToPathAndVerifyResource((ServletRequest)requestCapture, env);
        chain.doFilter(pathChangedRequest, (ServletResponse)responseCapture);
    }

    private ServletRequest addHtmlToPathAndVerifyResource(ServletRequest request, RackEnvironment env) {
        Object httpRequest = (HttpServletRequest)request;
        if (!this.isAddsHtmlToPathInfo()) {
            return httpRequest;
        }
        String path = env.getPathInfo();
        int lastDelim = path.lastIndexOf(47);
        if (path.lastIndexOf(46) <= lastDelim) {
            StringBuilder htmlSuffix = new StringBuilder(10);
            if (lastDelim == path.length() - 1) {
                htmlSuffix.append("index");
            }
            htmlSuffix.append(".html");
            String htmlPath = path + htmlSuffix;
            if (httpRequest.getServletPath().equals(htmlPath)) {
                return httpRequest;
            }
            if (this.isVerifiesHtmlResource() && !this.resourceExists(htmlPath)) {
                return httpRequest;
            }
            final String requestURI = httpRequest.getRequestURI() + htmlSuffix;
            if (httpRequest.getPathInfo() != null) {
                final String pathInfo = httpRequest.getPathInfo() + htmlSuffix;
                httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                    public String getPathInfo() {
                        return pathInfo;
                    }

                    public String getRequestURI() {
                        return requestURI;
                    }
                };
            } else {
                final String servletPath = httpRequest.getServletPath() + htmlSuffix;
                httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                    public String getServletPath() {
                        return servletPath;
                    }

                    public String getRequestURI() {
                        return requestURI;
                    }
                };
            }
        }
        return httpRequest;
    }

    protected boolean resourceExists(String path) {
        ServletRackContext servletContext = (ServletRackContext)this.getContext();
        try {
            return servletContext.getResource(path) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean isAddsHtmlToPathInfo() {
        return this.addsHtmlToPathInfo;
    }

    public boolean isVerifiesHtmlResource() {
        return this.verifiesHtmlResource;
    }

    public void setAddsHtmlToPathInfo(boolean addsHtmlToPathInfo) {
        this.addsHtmlToPathInfo = addsHtmlToPathInfo;
    }

    public void setVerifiesHtmlResource(boolean verifiesHtmlResource) {
        this.verifiesHtmlResource = verifiesHtmlResource;
    }
}

