/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jruby.rack.AbstractFilter;
import org.jruby.rack.DefaultRackDispatcher;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackDispatcher;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.servlet.RequestCapture;
import org.jruby.rack.servlet.ResponseCapture;

public class UnmappedRackFilter
extends AbstractFilter {
    private static final String RESET_BUFFER_VALUE = "buffer";
    private Object resetUnhandledResponse = Boolean.TRUE;
    private boolean responseHandledByDefault = true;
    private static final Collection<Integer> RESPONSE_NOT_HANDLED_STATUSES;
    private Collection<Integer> responseNotHandledStatuses = RESPONSE_NOT_HANDLED_STATUSES;
    private RackContext context;
    private RackDispatcher dispatcher;

    public UnmappedRackFilter() {
    }

    public UnmappedRackFilter(RackDispatcher dispatcher, RackContext context) {
        this.context = context;
        this.dispatcher = dispatcher;
    }

    public void init(FilterConfig config) throws ServletException {
        this.context = (RackContext)config.getServletContext().getAttribute("rack.context");
        this.dispatcher = new DefaultRackDispatcher(this.context);
        String value = config.getInitParameter("resetUnhandledResponse");
        if (value != null) {
            this.setResetUnhandledResponseValue(value);
        }
        if ((value = config.getInitParameter("responseNotHandledStatuses")) != null) {
            HashSet<Integer> statuses = new HashSet<Integer>();
            for (String status : value.split(",")) {
                if ((status = status.trim()).length() <= 0) continue;
                statuses.add(Integer.parseInt(status));
            }
            this.responseNotHandledStatuses = statuses;
        }
        if ((value = config.getInitParameter("responseHandledByDefault")) != null) {
            this.responseHandledByDefault = Boolean.parseBoolean(value);
        }
    }

    @Override
    protected RackDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    protected RackContext getContext() {
        return this.context;
    }

    @Override
    protected boolean isDoDispatch(RequestCapture requestCapture, ResponseCapture responseCapture, FilterChain chain, RackEnvironment env) throws IOException, ServletException {
        try {
            this.doFilterInternal(requestCapture, responseCapture, chain, env);
        }
        catch (FileNotFoundException e) {
            responseCapture.setStatus(404);
        }
        return this.handleChainResponse(requestCapture, responseCapture);
    }

    protected void doFilterInternal(RequestCapture requestCapture, ResponseCapture responseCapture, FilterChain chain, RackEnvironment env) throws IOException, ServletException {
        chain.doFilter((ServletRequest)requestCapture, (ServletResponse)responseCapture);
    }

    protected boolean handleChainResponse(RequestCapture request, ResponseCapture response) throws IOException {
        if (!response.isHandled((HttpServletRequest)request)) {
            request.reset();
            if (this.isResetUnhandledResponse()) {
                response.reset();
            } else if (this.isResetUnhandledResponseBuffer()) {
                response.resetBuffer();
            }
            request.setAttribute("jruby.rack.dynamic.requests.only", Boolean.TRUE);
            return true;
        }
        return false;
    }

    @Override
    protected ResponseCapture wrapResponse(ServletResponse response) {
        ResponseCapture capture = super.wrapResponse(response);
        capture.setNotHandledStatuses(this.getResponseNotHandledStatuses());
        capture.setHandledByDefault(this.isResponseHandledByDefault());
        return capture;
    }

    public boolean isResetUnhandledResponse() {
        return this.resetUnhandledResponse == Boolean.TRUE;
    }

    public void setResetUnhandledResponse(boolean reset) {
        this.resetUnhandledResponse = reset;
    }

    public boolean isResetUnhandledResponseBuffer() {
        return this.resetUnhandledResponse == RESET_BUFFER_VALUE;
    }

    public void setResetUnhandledResponseBuffer(boolean reset) {
        this.resetUnhandledResponse = reset ? RESET_BUFFER_VALUE : null;
    }

    protected void setResetUnhandledResponseValue(String value) {
        this.resetUnhandledResponse = RESET_BUFFER_VALUE.equalsIgnoreCase(value) ? RESET_BUFFER_VALUE : Boolean.valueOf(value);
    }

    public Collection<Integer> getResponseNotHandledStatuses() {
        return this.responseNotHandledStatuses;
    }

    public void setDefaultNotHandledStatuses(Collection<Integer> responseNotHandledStatuses) {
        this.responseNotHandledStatuses = responseNotHandledStatuses == null ? Collections.EMPTY_SET : responseNotHandledStatuses;
    }

    public boolean isResponseHandledByDefault() {
        return this.responseHandledByDefault;
    }

    public void setResponseHandledByDefault(boolean responseHandledByDefault) {
        this.responseHandledByDefault = responseHandledByDefault;
    }

    static {
        HashSet<Integer> statuses = new HashSet<Integer>(8, 1.0f);
        statuses.add(404);
        statuses.add(403);
        statuses.add(405);
        statuses.add(501);
        RESPONSE_NOT_HANDLED_STATUSES = Collections.unmodifiableSet(statuses);
    }
}

