/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.ext;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.servlet.RewindableInputStream;
import org.jruby.rack.util.ExceptionUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Input
extends RubyObject {
    private static final MethodHandle CONCAT_WITH_CODERANGE;
    static final ObjectAllocator ALLOCATOR;
    private boolean rewindable;
    private InputStream input;
    private int length = 0;
    private static final int MATCH_NONE = Integer.MAX_VALUE;

    static RubyClass getClass(Ruby runtime) {
        RubyModule _JRuby_Rack = (RubyModule)runtime.getModule("JRuby").getConstantAt("Rack");
        return (RubyClass)_JRuby_Rack.getConstantAt("Input");
    }

    protected Input(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public Input(Ruby runtime, RackEnvironment env) {
        super(runtime, Input.getClass(runtime));
        this.initialize(env);
    }

    public Input(Ruby runtime, InputStream input, int length) {
        this(runtime, input, false, length);
    }

    public Input(Ruby runtime, InputStream input, boolean rewindable, int length) {
        super(runtime, Input.getClass(runtime));
        this.rewindable = rewindable;
        this.setInput(input);
        this.length = length;
    }

    private void initialize(RackEnvironment env) {
        this.rewindable = env.getContext().getConfig().isRewindable();
        try {
            this.setInput(env.getInput());
        }
        catch (IOException e) {
            throw ExceptionUtils.newIOError(this.getRuntime(), e);
        }
        this.length = env.getContentLength();
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject input) {
        Object arg = JavaEmbedUtils.rubyToJava((IRubyObject)input);
        if (arg instanceof InputStream) {
            this.setInput((InputStream)arg);
        } else if (arg instanceof RackEnvironment) {
            this.initialize((RackEnvironment)arg);
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject gets(ThreadContext context) {
        try {
            int NEWLINE = 10;
            byte[] bytes = this.readUntil(10, 0);
            if (bytes != null) {
                return context.runtime.newString(new ByteList(bytes, false));
            }
            return context.nil;
        }
        catch (IOException e) {
            throw ExceptionUtils.newIOError(context.runtime, e);
        }
    }

    @JRubyMethod(optional=2)
    public IRubyObject read(ThreadContext context, IRubyObject[] args) {
        int readLen = 0;
        if (args.length > 0) {
            long len = args[0].convertToInteger("to_i").getLongValue();
            readLen = (int)Math.min(len, Integer.MAX_VALUE);
        }
        RubyString buffer = args.length > 1 ? args[1].asString() : null;
        try {
            byte[] bytes = this.readUntil(Integer.MAX_VALUE, readLen);
            if (bytes != null) {
                if (buffer != null) {
                    buffer.clear();
                    try {
                        int n = CONCAT_WITH_CODERANGE.invokeExact(buffer, new ByteList(bytes, false), 0);
                    }
                    catch (Throwable t) {
                        Helpers.throwException((Throwable)t);
                    }
                    return buffer;
                }
                return context.runtime.newString(new ByteList(bytes, false));
            }
            return readLen > 0 ? context.nil : RubyString.newEmptyString((Ruby)context.runtime);
        }
        catch (IOException e) {
            throw ExceptionUtils.newIOError(context.runtime, e);
        }
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        IRubyObject line;
        IRubyObject nil = context.runtime.getNil();
        while ((line = this.gets(context)) != nil) {
            block.yield(context, line);
        }
        return nil;
    }

    @JRubyMethod
    public IRubyObject rewind(ThreadContext context) {
        if (this.input != null) {
            try {
                Method rewind = Input.getRewindMethod(this.input);
                if (rewind != null) {
                    rewind.invoke((Object)this.input, (Object[])null);
                }
            }
            catch (IllegalArgumentException e) {
                throw ExceptionUtils.newArgumentError(context.runtime, e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getCause();
                if (target instanceof IOException) {
                    throw ExceptionUtils.newIOError(context.runtime, (IOException)target);
                }
                throw ExceptionUtils.newRuntimeError(context.runtime, target);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        return context.runtime.newFixnum(this.length);
    }

    public void close() {
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setInput(InputStream input) {
        if (input != null && this.rewindable && Input.getRewindMethod(input) == null) {
            input = new RewindableInputStream((InputStream)input);
        }
        this.input = input;
    }

    private static Method getRewindMethod(InputStream input) {
        try {
            return input.getClass().getMethod("rewind", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private byte[] readUntil(int match, int count) throws IOException {
        int b;
        ByteArrayOutputStream bs = null;
        long i = 0L;
        while ((b = this.input.read()) != -1) {
            if (bs == null) {
                bs = new ByteArrayOutputStream(count == 0 ? 128 : count);
            }
            bs.write(b);
            if (++i != (long)count && b != match) continue;
        }
        return bs == null ? null : bs.toByteArray();
    }

    public InputStream getInput() {
        return this.input;
    }

    public boolean isRewindable() {
        return this.rewindable;
    }

    public void setRewindable(boolean rewindable) {
        this.rewindable = rewindable;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    static {
        MethodHandle catWithCR = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            catWithCR = lookup.findVirtual(RubyString.class, "catWithCodeRange", MethodType.methodType(Integer.TYPE, ByteList.class, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                catWithCR = lookup.findVirtual(RubyString.class, "cat19", MethodType.methodType(Integer.TYPE, ByteList.class, Integer.TYPE));
            }
            catch (Exception t) {
                Helpers.throwException((Throwable)t);
            }
        }
        CONCAT_WITH_CODERANGE = catWithCR;
        ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Input(runtime, klass);
            }
        };
    }
}

