/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.ext;

import javax.servlet.ServletContext;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackLogger;
import org.jruby.rack.logging.ServletContextLogger;
import org.jruby.rack.util.ExceptionUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"JRuby::Rack::Logger"})
public class Logger
extends RubyObject {
    static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Logger(runtime, klass);
        }
    };
    static final int DEBUG = 0;
    static final int INFO = 1;
    static final int WARN = 2;
    static final int ERROR = 3;
    static final int FATAL = 4;
    static final int UNKNOWN = 5;
    private static final int NOT_SET = -1;
    private int level = -1;
    private RackLogger logger;
    private IRubyObject formatter = null;
    private IRubyObject progname;
    private static final ByteList FORMATTED_DEBUG = new ByteList(new byte[]{68, 69, 66, 85, 71}, false);
    private static final ByteList FORMATTED_INFO = new ByteList(new byte[]{73, 78, 70, 79}, false);
    private static final ByteList FORMATTED_WARN = new ByteList(new byte[]{87, 65, 82, 78}, false);
    private static final ByteList FORMATTED_ERROR = new ByteList(new byte[]{69, 82, 82, 79, 82}, false);
    private static final ByteList FORMATTED_FATAL = new ByteList(new byte[]{70, 65, 84, 65, 76}, false);
    private static final ByteList FORMATTED_ANY = new ByteList(new byte[]{65, 78, 89}, false);
    private static boolean silencer = false;

    protected Logger(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=0)
    public IRubyObject initialize(ThreadContext context) {
        IRubyObject jrubyRack = context.runtime.getModule("JRuby").getConstant("Rack");
        this.initialize(jrubyRack.callMethod(context, "context"));
        return this;
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject logger) {
        this.initialize(logger);
        return this;
    }

    private void initialize(IRubyObject context) {
        if (context.isNil()) {
            throw this.getRuntime().newArgumentError("no context");
        }
        this.logger = context instanceof RackLogger ? (RackLogger)context : (context instanceof RackContext ? ((RackContext)context).getConfig().getLogger() : (RackLogger)context.toJava(RackLogger.class));
    }

    @JRubyMethod
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject logger) {
        Logger other = (Logger)logger;
        this.level = other.level;
        this.logger = other.logger;
        this.formatter = other.formatter;
        this.progname = other.progname;
        return this;
    }

    @JRubyMethod
    public IRubyObject real_logger(ThreadContext context) {
        return JavaEmbedUtils.javaToRuby((Ruby)context.runtime, (Object)this.logger);
    }

    public RackLogger getRealLogger() {
        return this.logger;
    }

    @JRubyMethod(name={"level"}, alias={"sev_threshold"})
    public IRubyObject get_level(ThreadContext context) {
        if (this.level == -1) {
            return context.nil;
        }
        return context.runtime.newFixnum(this.level);
    }

    @JRubyMethod(name={"level="}, alias={"sev_threshold="})
    public IRubyObject set_level(ThreadContext context, IRubyObject level) {
        if (level.isNil()) {
            this.level = -1;
            return level;
        }
        this.level = (int)level.convertToInteger("to_i").getLongValue();
        return this.get_level(context);
    }

    @JRubyMethod(name={"debug?"})
    public IRubyObject is_debug(ThreadContext context) {
        return context.runtime.newBoolean(this.isDebugEnabled());
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(0);
    }

    @JRubyMethod(name={"info?"})
    public IRubyObject is_info(ThreadContext context) {
        return context.runtime.newBoolean(this.isInfoEnabled());
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(1);
    }

    @JRubyMethod(name={"warn?"})
    public IRubyObject is_warn(ThreadContext context) {
        return context.runtime.newBoolean(this.isWarnEnabled());
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor(2);
    }

    @JRubyMethod(name={"error?"})
    public IRubyObject is_error(ThreadContext context) {
        return context.runtime.newBoolean(this.isErrorEnabled());
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor(3);
    }

    @JRubyMethod(name={"fatal?"})
    public IRubyObject is_fatal(ThreadContext context) {
        return context.runtime.newBoolean(this.isFatalEnabled());
    }

    public boolean isFatalEnabled() {
        return this.isEnabledFor(4);
    }

    private boolean isEnabledFor(int severity) {
        return this.isEnabledFor(severity, Logger.mapLevel(severity));
    }

    private boolean isEnabledFor(int severity, RackLogger.Level loggerLevel) {
        if (loggerLevel == null) {
            return this.level <= severity;
        }
        if (this.level == -1) {
            return this.logger.isEnabled(loggerLevel);
        }
        return this.level <= severity && this.logger.isEnabled(loggerLevel);
    }

    private static RackLogger.Level mapLevel(int level) {
        switch (level) {
            case 0: {
                return RackLogger.Level.DEBUG;
            }
            case 1: {
                return RackLogger.Level.INFO;
            }
            case 2: {
                return RackLogger.Level.WARN;
            }
            case 3: {
                return RackLogger.Level.ERROR;
            }
            case 4: {
                return RackLogger.Level.FATAL;
            }
        }
        return null;
    }

    @JRubyMethod(name={"progname"})
    public IRubyObject get_progname(ThreadContext context) {
        return this.progname;
    }

    @JRubyMethod(name={"progname="})
    public IRubyObject set_progname(ThreadContext context, IRubyObject progname) {
        this.progname = progname;
        return this.progname;
    }

    @JRubyMethod(name={"formatter"})
    public IRubyObject get_formatter(ThreadContext context) {
        return this.formatter;
    }

    @JRubyMethod(name={"formatter="})
    public IRubyObject set_formatter(ThreadContext context, IRubyObject formatter) {
        if (this.logger instanceof RackLogger.Base) {
            RackLogger.Base logger = (RackLogger.Base)this.logger;
            if (formatter.isNil()) {
                logger.setFormatting(true);
            } else {
                logger.setFormatting(false);
            }
        }
        this.formatter = formatter;
        return this.formatter;
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"debug"})
    public IRubyObject debug(ThreadContext context, IRubyObject msg, Block block) {
        return context.runtime.newBoolean(this.add(0, context, msg, block));
    }

    @JRubyMethod(name={"info"})
    public IRubyObject info(ThreadContext context, IRubyObject msg, Block block) {
        return context.runtime.newBoolean(this.add(1, context, msg, block));
    }

    @JRubyMethod(name={"info"})
    public IRubyObject info(ThreadContext context, Block block) {
        return this.info(context, context.nil, block);
    }

    @JRubyMethod(name={"warn"})
    public IRubyObject warn(ThreadContext context, IRubyObject msg, Block block) {
        return context.runtime.newBoolean(this.add(2, context, msg, block));
    }

    @JRubyMethod(name={"warn"})
    public IRubyObject warn(ThreadContext context, Block block) {
        return this.warn(context, context.nil, block);
    }

    @JRubyMethod(name={"error"})
    public IRubyObject error(ThreadContext context, IRubyObject msg, Block block) {
        return context.runtime.newBoolean(this.add(3, context, msg, block));
    }

    @JRubyMethod(name={"error"})
    public IRubyObject error(ThreadContext context, Block block) {
        return this.error(context, context.nil, block);
    }

    @JRubyMethod(name={"fatal"})
    public IRubyObject fatal(ThreadContext context, IRubyObject msg, Block block) {
        return context.runtime.newBoolean(this.add(4, context, msg, block));
    }

    @JRubyMethod(name={"fatal"})
    public IRubyObject fatal(ThreadContext context, Block block) {
        return this.fatal(context, context.nil, block);
    }

    @JRubyMethod(name={"unknown"})
    public IRubyObject unknown(ThreadContext context, IRubyObject msg, Block block) {
        return context.runtime.newBoolean(this.add(5, context, msg, block));
    }

    @JRubyMethod(name={"unknown"})
    public IRubyObject unknown(ThreadContext context, Block block) {
        return this.unknown(context, context.nil, block);
    }

    @JRubyMethod(name={"add"}, required=1, optional=2)
    public IRubyObject add(ThreadContext context, IRubyObject[] args, Block block) {
        IRubyObject msg;
        int severity = 5;
        IRubyObject sev = args[0];
        if (!sev.isNil()) {
            severity = (int)sev.convertToInteger("to_i").getLongValue();
        }
        if (args.length > 1) {
            msg = args[1];
            if (msg.isNil() && args.length > 2) {
                msg = args[2];
            }
        } else {
            msg = context.nil;
        }
        return context.runtime.newBoolean(this.add(severity, context, msg, block));
    }

    @JRubyMethod(name={"add"})
    public IRubyObject add(ThreadContext context, IRubyObject severity, IRubyObject msg, IRubyObject progname, Block block) {
        return context.runtime.newBoolean(this.add(5, context, msg, block));
    }

    private boolean add(int severity, ThreadContext context, IRubyObject msg, Block block) {
        RackLogger.Level loggerLevel = Logger.mapLevel(severity);
        if (!this.isEnabledFor(severity, loggerLevel)) {
            return true;
        }
        IRubyObject progname = null;
        if (msg.isNil() && block.isGiven()) {
            progname = msg;
            msg = block.yieldSpecific(context);
        }
        if (this.formatter != null) {
            if (progname == null) {
                progname = this.progname == null ? context.nil : this.progname;
            }
            long datetime = System.currentTimeMillis();
            msg = this.format_message(context, severity, datetime, progname, msg);
        } else if (msg instanceof RubyException) {
            RubyException error = (RubyException)msg;
            error.prepareIntegratedBacktrace(context, null);
            this.doLog(loggerLevel, ExceptionUtils.formatError(error).toString());
            return true;
        }
        if (!msg.isNil()) {
            this.doLog(loggerLevel, msg.asString());
        }
        return true;
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject append(ThreadContext context, IRubyObject msg) {
        RubyString msgString = msg.asString();
        this.doLog(msgString);
        return msgString.rubyLength(context);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, required=4)
    public IRubyObject format_message(ThreadContext context, IRubyObject[] args) {
        if (this.formatter instanceof RubyProc) {
            return ((RubyProc)this.formatter).call(context, args);
        }
        return this.formatter.callMethod(context, "call", args);
    }

    private IRubyObject format_message(ThreadContext context, int severityVal, long datetimeMillis, IRubyObject progname, IRubyObject msg) {
        RubyString severity = RubyString.newStringShared((Ruby)context.runtime, (ByteList)Logger.formatSeverity(severityVal));
        RubyTime datetime = RubyTime.newTime((Ruby)context.runtime, (long)datetimeMillis);
        return this.format_message(context, new IRubyObject[]{severity, datetime, progname, msg});
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject format_severity(ThreadContext context, IRubyObject sev) {
        int severity = (int)sev.convertToInteger("to_i").getLongValue();
        return RubyString.newStringShared((Ruby)context.runtime, (ByteList)Logger.formatSeverity(severity));
    }

    private static ByteList formatSeverity(int severity) {
        switch (severity) {
            case 0: {
                return FORMATTED_DEBUG;
            }
            case 1: {
                return FORMATTED_INFO;
            }
            case 2: {
                return FORMATTED_WARN;
            }
            case 3: {
                return FORMATTED_ERROR;
            }
            case 4: {
                return FORMATTED_FATAL;
            }
        }
        return FORMATTED_ANY;
    }

    public Object toJava(Class target) {
        if (RackLogger.class == target) {
            return this.logger;
        }
        return super.toJava(target);
    }

    private void doLog(RackLogger.Level level, String message) {
        this.logger.log(level, message);
    }

    private void doLog(RackLogger.Level level, RubyString message) {
        this.logger.log(level, message.toString());
    }

    private void doLog(RubyString message) {
        this.logger.log(message.toString());
    }

    @JRubyMethod(name={"silencer"}, meta=true)
    public static IRubyObject get_silencer(ThreadContext context, IRubyObject self) {
        return context.runtime.newBoolean(silencer);
    }

    @JRubyMethod(name={"silencer="}, meta=true)
    public static IRubyObject set_silencer(ThreadContext context, IRubyObject self, IRubyObject value) {
        silencer = value.isTrue();
        return context.runtime.newBoolean(silencer);
    }

    @JRubyMethod(name={"silence"})
    public IRubyObject silence(ThreadContext context, Block block) {
        return this.doSilence(3, context, block);
    }

    @JRubyMethod(name={"silence"}, required=1)
    public IRubyObject silence(ThreadContext context, IRubyObject temp_level, Block block) {
        int tempLevel = (int)temp_level.convertToInteger("to_i").getLongValue();
        return this.doSilence(tempLevel, context, block);
    }

    private IRubyObject doSilence(int tempLevel, ThreadContext context, Block block) {
        if (silencer) {
            return block.yield(context, (IRubyObject)this);
        }
        return block.yield(context, (IRubyObject)this);
    }

    @JRubyMethod(name={"flush"}, alias={"auto_flushing", "auto_flushing="})
    public IRubyObject stub(ThreadContext context) {
        return context.nil;
    }

    @JRubyClass(name={"JRuby::Rack::ServletLog"})
    public static class ServletLog
    extends RubyObject {
        static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ServletLog(runtime, klass);
            }
        };
        private RackLogger context;

        protected ServletLog(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod(required=0, optional=1)
        public IRubyObject initialize(ThreadContext context, IRubyObject[] args) {
            IRubyObject rackContext;
            if (args != null && args.length > 0) {
                rackContext = args[0];
            } else {
                IRubyObject jrubyRack = context.runtime.getModule("JRuby").getConstant("Rack");
                rackContext = jrubyRack.callMethod(context, "context");
            }
            if (rackContext.isNil()) {
                throw context.runtime.newArgumentError("no context");
            }
            if (rackContext instanceof RackContext) {
                this.context = (RackContext)rackContext;
            } else {
                try {
                    RackLogger logger;
                    this.context = logger = (RackLogger)rackContext.toJava(RackLogger.class);
                }
                catch (RaiseException e) {
                    RubyException error = e.getException();
                    if (error == null && !context.runtime.getTypeError().isInstance((IRubyObject)error)) {
                        throw e;
                    }
                    try {
                        ServletContext servletContext = (ServletContext)rackContext.toJava(ServletContext.class);
                        this.context = new ServletContextLogger(servletContext);
                    }
                    catch (RaiseException fail) {
                        throw context.runtime.newArgumentError("context is not a ServletContext nor a RackContext");
                    }
                }
            }
            return this;
        }

        @JRubyMethod
        public IRubyObject write(IRubyObject msg) {
            this.context.log(msg.toString());
            return msg;
        }

        @JRubyMethod
        public IRubyObject puts(IRubyObject msg) {
            return this.write(msg);
        }

        @JRubyMethod(name={"close"}, alias={"flush"})
        public IRubyObject noop(ThreadContext context) {
            return context.nil;
        }
    }
}

