/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseCapture
extends HttpServletResponseWrapper {
    private static final String STREAM = "stream";
    private static final String WRITER = "writer";
    private static final Collection<Integer> defaultNotHandledStatuses = Collections.singleton(404);
    private Integer status;
    private Object output;
    private boolean handledByDefault;
    private Collection<Integer> notHandledStatuses = defaultNotHandledStatuses;
    private boolean headerSet;
    private boolean handled;

    public ResponseCapture(HttpServletResponse response) {
        super(response);
    }

    public int getStatus() {
        return this.status != null ? this.status : 200;
    }

    public boolean isStatusSet() {
        return this.status != null;
    }

    protected boolean handleStatus(int status, boolean error) {
        this.status = status;
        return this.isHandled(null);
    }

    public void setStatus(int status) {
        if (this.handleStatus(status, false)) {
            super.setStatus(status);
        }
    }

    public void setStatus(int status, String message) {
        if (this.handleStatus(status, false)) {
            super.setStatus(status, message);
        }
    }

    public void sendError(int status) throws IOException {
        if (this.handleStatus(status, true)) {
            super.sendError(status);
        }
    }

    public void sendError(int status, String message) throws IOException {
        if (this.handleStatus(status, true)) {
            super.sendError(status, message);
        }
    }

    public void sendRedirect(String path) throws IOException {
        if (this.handleStatus(302, false)) {
            super.sendRedirect(path);
        }
    }

    public boolean isHeaderSet() {
        return this.headerSet;
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        this.headerSet = true;
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.headerSet = true;
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.headerSet = true;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.headerSet = true;
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        this.headerSet = true;
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.headerSet = true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = STREAM;
        }
        if (this.isHandled(null)) {
            return super.getOutputStream();
        }
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.output == null) {
            this.output = WRITER;
        }
        if (this.output != WRITER) {
            String enc = this.getCharacterEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            return new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), enc));
        }
        return super.getWriter();
    }

    public void flushBuffer() throws IOException {
        if (this.isHandled(null)) {
            super.flushBuffer();
        }
    }

    public boolean isError() {
        return this.getStatus() >= 400;
    }

    public boolean isHandled() {
        return this.isHandled(null);
    }

    public boolean isHandled(HttpServletRequest request) {
        if (this.handled) {
            return true;
        }
        if (!this.isStatusSet()) {
            if (!this.isHeaderSet()) {
                this.handled = this.isHandledByDefault();
                return this.handled;
            }
            if (request != null && "OPTIONS".equals(request.getMethod())) {
                Collection headerNames = this.getHeaderNames();
                if (headerNames == null || headerNames.isEmpty()) {
                    return false;
                }
                for (String headerName : headerNames) {
                    if ("Allow".equals(headerName) || "Date".equals(headerName)) continue;
                    this.handled = true;
                    return true;
                }
                return false;
            }
            this.handled = true;
            return true;
        }
        if (this.notHandledStatuses.contains(this.getStatus())) {
            return false;
        }
        this.handled = true;
        return true;
    }

    public Collection<Integer> getNotHandledStatuses() {
        return this.notHandledStatuses;
    }

    public void setNotHandledStatuses(Collection<Integer> notHandledStatuses) {
        this.notHandledStatuses = notHandledStatuses == null ? Collections.EMPTY_SET : notHandledStatuses;
    }

    boolean isHandledByDefault() {
        return this.handledByDefault;
    }

    public void setHandledByDefault(boolean handledByDefault) {
        this.handledByDefault = handledByDefault;
    }

    public boolean isOutputAccessed() {
        return this.output != null;
    }
}

