/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jscsi.exception.ConfigurationException;
import org.jscsi.exception.NoSuchSessionException;
import org.jscsi.exception.OperationalTextKeyException;
import org.jscsi.parser.datasegment.IResultFunction;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.datasegment.ResultFunctionFactory;
import org.jscsi.parser.datasegment.SettingEntry;
import org.jscsi.parser.datasegment.SettingsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Configuration {
    private static final String ELEMENT_GLOBAL = "global";
    private static final String ELEMENT_TARGET = "target";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_ADDRESS = "address";
    private static final String ATTRIBUTE_PORT = "port";
    private static final String ATTRIBUTE_RESULT = "result";
    private static final String ATTRIBUTE_SCOPE = "scope";
    private static final String VALUE_SCOPE_SESSION = "Session";
    private static final String VALUE_SCOPE_CONNECTION = "Connection";
    private static final File CONFIG_DIR = new File("src" + File.separator + "main" + File.separator + "resources" + File.separator);
    private static final File CONFIGURATION_SCHEMA_FILE = new File(CONFIG_DIR, "jscsi.xsd");
    private static final File CONFIGURATION_CONFIG_FILE = new File(CONFIG_DIR, "jscsi.xml");
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private final Map<OperationalTextKey, SettingEntry> globalConfig;
    private final ConcurrentHashMap<String, SessionConfiguration> sessionConfigs;

    public Configuration() {
        this(new Hashtable<OperationalTextKey, SettingEntry>(), new ConcurrentHashMap<String, SessionConfiguration>(0));
    }

    public Configuration(Hashtable<OperationalTextKey, SettingEntry> paramGlobalConfig, ConcurrentHashMap<String, SessionConfiguration> paramConfig) {
        this.globalConfig = paramGlobalConfig;
        this.sessionConfigs = paramConfig;
    }

    public static final Configuration create() throws ConfigurationException {
        return Configuration.create(CONFIGURATION_SCHEMA_FILE, CONFIGURATION_CONFIG_FILE);
    }

    public static final Configuration create(File configSchemaFileName, File configFileName) throws ConfigurationException {
        Configuration config = new Configuration();
        Document doc = config.parse(configSchemaFileName, configFileName);
        config.parseSettings(doc.getDocumentElement());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getSetting(String targetName, int connectionID, OperationalTextKey textKey) throws OperationalTextKeyException {
        SessionConfiguration sessionConfiguration;
        Map<String, SessionConfiguration> map;
        try {
            map = this.sessionConfigs;
            synchronized (map) {
                SessionConfiguration sc;
                sessionConfiguration = sc = this.sessionConfigs.get(targetName);
                synchronized (sessionConfiguration) {
                    String value;
                    if (sc != null && (value = sc.getSetting(connectionID, textKey)) != null) {
                        return value;
                    }
                }
            }
        }
        catch (OperationalTextKeyException e) {
            // empty catch block
        }
        map = this.globalConfig;
        synchronized (map) {
            SettingEntry se = this.globalConfig.get(textKey);
            sessionConfiguration = se;
            synchronized (sessionConfiguration) {
                if (se != null) {
                    return se.getValue();
                }
            }
        }
        throw new OperationalTextKeyException("No OperationalTextKey entry found for key: " + textKey.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SettingsMap getSettings(String targetName, int connectionID) {
        SettingsMap sm = new SettingsMap();
        Map<OperationalTextKey, SettingEntry> map = this.globalConfig;
        synchronized (map) {
            for (Map.Entry<OperationalTextKey, SettingEntry> e : this.globalConfig.entrySet()) {
                sm.add(e.getKey(), e.getValue().getValue());
            }
        }
        ConcurrentHashMap<String, SessionConfiguration> concurrentHashMap = this.sessionConfigs;
        synchronized (concurrentHashMap) {
            SessionConfiguration sc;
            SessionConfiguration sessionConfiguration = sc = this.sessionConfigs.get(targetName);
            synchronized (sessionConfiguration) {
                if (sc != null) {
                    SettingsMap furtherSettings = sc.getSettings(connectionID);
                    for (Map.Entry e : furtherSettings.entrySet()) {
                        sm.add((OperationalTextKey)e.getKey(), (String)e.getValue());
                    }
                }
            }
        }
        return sm;
    }

    public final String getSessionSetting(String targetName, OperationalTextKey textKey) throws OperationalTextKeyException {
        return this.getSetting(targetName, -1, textKey);
    }

    public final InetSocketAddress getTargetAddress(String targetName) throws NoSuchSessionException {
        SessionConfiguration sc = this.sessionConfigs.get(targetName);
        if (sc == null) {
            throw new NoSuchSessionException("A session with the ID '" + targetName + "' does not exist.");
        }
        return sc.getInetSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(String targetName, int connectionID, SettingsMap response) throws NoSuchSessionException {
        ConcurrentHashMap<String, SessionConfiguration> concurrentHashMap = this.sessionConfigs;
        synchronized (concurrentHashMap) {
            SessionConfiguration sc;
            SessionConfiguration sessionConfiguration = sc = this.sessionConfigs.get(targetName);
            synchronized (sessionConfiguration) {
                if (sc == null) {
                    throw new NoSuchSessionException("A session with the ID '" + targetName + "' does not exist.");
                }
                SettingsMap settingsMap = response;
                synchronized (settingsMap) {
                    for (Map.Entry e : response.entrySet()) {
                        Map<OperationalTextKey, SettingEntry> map = this.globalConfig;
                        synchronized (map) {
                            SettingEntry se = this.globalConfig.get(e.getKey());
                            if (se == null) {
                                if (LOGGER.isWarnEnabled()) {
                                    LOGGER.warn("This key " + e.getKey() + " is not in the globalConfig.");
                                }
                                continue;
                            }
                            SettingEntry settingEntry = se;
                            synchronized (settingEntry) {
                                if (se.getScope().compareTo(VALUE_SCOPE_SESSION) == 0) {
                                    sc.updateSessionSetting((OperationalTextKey)e.getKey(), (String)e.getValue(), se.getResult());
                                } else if (se.getScope().compareTo(VALUE_SCOPE_CONNECTION) == 0) {
                                    sc.updateConnectionSetting(connectionID, (OperationalTextKey)e.getKey(), (String)e.getValue(), se.getResult());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private final Document parse(File schemaLocation, File configFile) throws ConfigurationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaLocation);
            Validator validator = schema.newValidator();
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(configFile);
            DOMSource source = new DOMSource(doc);
            DOMResult result = new DOMResult();
            validator.validate(source, result);
            return (Document)result.getNode();
        }
        catch (SAXException exc) {
            throw new ConfigurationException(exc);
        }
        catch (ParserConfigurationException exc) {
            throw new ConfigurationException(exc);
        }
        catch (IOException exc) {
            throw new ConfigurationException(exc);
        }
    }

    private final void parseSettings(Element root) {
        if (root == null) {
            throw new NullPointerException();
        }
        this.clear();
        this.parseGlobalSettings(root);
        this.parseTargetSpecificSettings(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseGlobalSettings(Element root) {
        NodeList globalConfiguration = root.getElementsByTagName(ELEMENT_GLOBAL);
        ResultFunctionFactory resultFunctionFactory = new ResultFunctionFactory();
        for (int i = 0; i < globalConfiguration.getLength(); ++i) {
            NodeList parameters = globalConfiguration.item(i).getChildNodes();
            for (int j = 0; j < parameters.getLength(); ++j) {
                Node parameter = parameters.item(j);
                if (parameter.getNodeType() != 1) continue;
                NamedNodeMap attributes = parameter.getAttributes();
                SettingEntry key = new SettingEntry();
                key.setScope(attributes.getNamedItem(ATTRIBUTE_SCOPE).getNodeValue());
                key.setResult(resultFunctionFactory.create(attributes.getNamedItem(ATTRIBUTE_RESULT).getNodeValue()));
                key.setValue(parameter.getTextContent());
                Map<OperationalTextKey, SettingEntry> map = this.globalConfig;
                synchronized (map) {
                    this.globalConfig.put(OperationalTextKey.valueOfEx((String)parameter.getNodeName()), key);
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseTargetSpecificSettings(Element root) {
        block7: {
            NodeList targets = root.getElementsByTagName(ELEMENT_TARGET);
            try {
                for (int i = 0; i < targets.getLength(); ++i) {
                    Node target = targets.item(i);
                    NodeList parameters = target.getChildNodes();
                    SessionConfiguration sc = new SessionConfiguration();
                    sc.setAddress(target.getAttributes().getNamedItem(ATTRIBUTE_ADDRESS).getNodeValue(), Integer.parseInt(target.getAttributes().getNamedItem(ATTRIBUTE_PORT).getNodeValue()));
                    for (int j = 0; j < parameters.getLength(); ++j) {
                        Node parameter = parameters.item(j);
                        if (parameter.getNodeType() != 1) continue;
                        sc.addSessionSetting(OperationalTextKey.valueOfEx((String)parameter.getNodeName()), parameter.getTextContent());
                    }
                    ConcurrentHashMap<String, SessionConfiguration> concurrentHashMap = this.sessionConfigs;
                    synchronized (concurrentHashMap) {
                        this.sessionConfigs.put(target.getAttributes().getNamedItem(ATTRIBUTE_ID).getNodeValue(), sc);
                        continue;
                    }
                }
            }
            catch (UnknownHostException e) {
                if (!LOGGER.isErrorEnabled()) break block7;
                LOGGER.error("The given host is not reachable: " + e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clear() {
        Map<OperationalTextKey, SettingEntry> map = this.globalConfig;
        synchronized (map) {
            this.globalConfig.clear();
        }
        map = this.sessionConfigs;
        synchronized (map) {
            this.sessionConfigs.clear();
        }
    }

    private final class SessionConfiguration {
        private final SettingsMap sessionConfiguration = new SettingsMap();
        private final Map<Integer, SettingsMap> connectionConfiguration = new LinkedHashMap<Integer, SettingsMap>(0);
        private InetSocketAddress inetAddress;

        SessionConfiguration() {
        }

        final void addSessionSetting(OperationalTextKey textKey, String textValue) {
            this.sessionConfiguration.add(textKey, textValue);
        }

        final void updateSessionSetting(OperationalTextKey textKey, String textValue, IResultFunction resultFunction) {
            this.sessionConfiguration.update(textKey, textValue, resultFunction);
        }

        final void updateConnectionSetting(int connectionID, OperationalTextKey textKey, String textValue, IResultFunction resultFunction) {
            SettingsMap sm = this.connectionConfiguration.get(connectionID);
            if (sm == null) {
                sm = new SettingsMap();
                this.connectionConfiguration.put(connectionID, sm);
            }
            sm.update(textKey, textValue, resultFunction);
        }

        final String getSetting(int connectionID, OperationalTextKey textKey) throws OperationalTextKeyException {
            String value;
            SettingsMap sm = this.connectionConfiguration.get(connectionID);
            if (sm != null && (value = sm.get(textKey)) != null) {
                return value;
            }
            value = this.sessionConfiguration.get(textKey);
            if (value != null) {
                return value;
            }
            throw new OperationalTextKeyException("No OperationalTextKey entry found for key: " + textKey.value());
        }

        final SettingsMap getSettings(int connectionID) {
            SettingsMap sm = new SettingsMap();
            for (Map.Entry e : this.sessionConfiguration.entrySet()) {
                sm.add((OperationalTextKey)e.getKey(), (String)e.getValue());
            }
            SettingsMap connectionSettings = this.connectionConfiguration.get(connectionID);
            if (connectionSettings != null) {
                for (Map.Entry e : connectionSettings.entrySet()) {
                    sm.add((OperationalTextKey)e.getKey(), (String)e.getValue());
                }
            }
            return sm;
        }

        final InetSocketAddress getInetSocketAddress() {
            return this.inetAddress;
        }

        final void setAddress(String newInetAddress, int port) throws UnknownHostException {
            this.inetAddress = new InetSocketAddress(newInetAddress, port);
        }
    }
}

