/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jscsi.exception.NoSuchSessionException;
import org.jscsi.exception.TaskExecutionException;
import org.jscsi.initiator.Configuration;
import org.jscsi.initiator.LinkFactory;
import org.jscsi.initiator.connection.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Initiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Initiator.class);
    private final Configuration configuration;
    private final Map<String, Session> sessions;
    private final LinkFactory factory;

    public Initiator(Configuration initConfiguration) {
        this.configuration = initConfiguration;
        this.sessions = new Hashtable<String, Session>(1);
        this.factory = new LinkFactory(this);
    }

    public final void createSession(String targetName) throws NoSuchSessionException {
        this.createSession(this.configuration.getTargetAddress(targetName), targetName);
    }

    public final void createSession(InetSocketAddress targetAddress, String targetName) {
        Session session = this.factory.getSession(this.configuration, targetName, targetAddress);
        this.sessions.put(session.getTargetName(), session);
        LOGGER.info("Created the session with iSCSI Target '" + targetName + "' at " + targetAddress.getHostName() + " on port " + targetAddress.getPort() + ".");
    }

    public final void closeSession(String targetName) throws NoSuchSessionException, TaskExecutionException {
        this.getSession(targetName).logout();
        this.sessions.remove(targetName);
        LOGGER.info("Closed the session to the iSCSI Target '" + targetName + "'.");
    }

    public final Future<Void> multiThreadedRead(String targetName, ByteBuffer dst, int logicalBlockAddress, long transferLength) throws NoSuchSessionException, TaskExecutionException {
        Future<Void> returnVal = this.getSession(targetName).read(dst, logicalBlockAddress, transferLength);
        return returnVal;
    }

    public final void read(String targetName, ByteBuffer dst, int logicalBlockAddress, long transferLength) throws NoSuchSessionException, TaskExecutionException {
        try {
            this.multiThreadedRead(targetName, dst, logicalBlockAddress, transferLength).get();
        }
        catch (InterruptedException exc) {
            throw new TaskExecutionException(exc);
        }
        catch (ExecutionException exc) {
            throw new TaskExecutionException(exc);
        }
    }

    public final Future<Void> multiThreadedWrite(String targetName, ByteBuffer src, int logicalBlockAddress, long transferLength) throws NoSuchSessionException, TaskExecutionException {
        return this.getSession(targetName).write(src, logicalBlockAddress, transferLength);
    }

    public final void write(String targetName, ByteBuffer src, int logicalBlockAddress, long transferLength) throws NoSuchSessionException, TaskExecutionException {
        try {
            this.multiThreadedWrite(targetName, src, logicalBlockAddress, transferLength).get();
        }
        catch (InterruptedException exc) {
            throw new TaskExecutionException(exc);
        }
        catch (ExecutionException exc) {
            throw new TaskExecutionException(exc);
        }
    }

    public final long getBlockSize(String targetName) throws NoSuchSessionException {
        return this.getSession(targetName).getBlockSize();
    }

    public final long getCapacity(String targetName) throws NoSuchSessionException {
        return this.getSession(targetName).getCapacity();
    }

    private final Session getSession(String targetName) throws NoSuchSessionException {
        Session session = this.sessions.get(targetName);
        if (session != null) {
            return session;
        }
        throw new NoSuchSessionException("Session " + targetName + " not found!");
    }

    public final void removeSession(Session sessionReq) throws NoSuchSessionException {
        Session session = this.sessions.get(sessionReq.getTargetName());
        if (session == null) {
            throw new NoSuchSessionException("Session " + sessionReq.getTargetName() + " not found!");
        }
        this.sessions.remove(sessionReq.getTargetName());
    }

    public final Boolean noSessions() {
        return this.sessions.size() == 0;
    }
}

