/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator;

import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.jscsi.exception.NoSuchSessionException;
import org.jscsi.initiator.Configuration;
import org.jscsi.initiator.Initiator;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinkFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkFactory.class);
    private final Initiator initiator;

    public LinkFactory(Initiator initiat) {
        this.initiator = initiat;
    }

    public final Session getSession(Configuration initConfiguration, String initTargetName, InetSocketAddress inetAddress) {
        try {
            Session newSession = new Session(this, initConfiguration, initTargetName, inetAddress, Executors.newSingleThreadExecutor());
            return newSession;
        }
        catch (Exception e) {
            LOGGER.error("This exception is thrown: " + e);
            e.printStackTrace();
            return null;
        }
    }

    public final Connection getConnection(Session session, Configuration initConfiguration, InetSocketAddress inetAddress, short initConnectionID) {
        try {
            Connection newConnection = new Connection(session, initConfiguration, inetAddress, initConnectionID);
            return newConnection;
        }
        catch (Exception e) {
            LOGGER.error("This exception is thrown: " + e);
            e.printStackTrace();
            return null;
        }
    }

    public final void closedSession(Session session) {
        try {
            this.initiator.removeSession(session);
        }
        catch (NoSuchSessionException noSuchSessionException) {
            // empty catch block
        }
    }
}

