/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.DigestException;
import java.util.Queue;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.exception.NoSuchSessionException;
import org.jscsi.exception.OperationalTextKeyException;
import org.jscsi.initiator.Configuration;
import org.jscsi.initiator.connection.SenderWorker;
import org.jscsi.initiator.connection.Session;
import org.jscsi.initiator.connection.state.IState;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.datasegment.SettingsMap;
import org.jscsi.utils.SerialArithmeticNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final Session referenceSession;
    private final Configuration configuration;
    private IState state;
    private final short connectionID;
    private final SerialArithmeticNumber expectedStatusSequenceNumber;
    private final SenderWorker senderReceiver;

    public Connection(Session session, Configuration initConfiguration, InetSocketAddress inetAddress, short initConnectionID) throws Exception {
        this.senderReceiver = new SenderWorker(this, inetAddress);
        this.configuration = initConfiguration;
        this.connectionID = initConnectionID;
        this.referenceSession = session;
        this.expectedStatusSequenceNumber = new SerialArithmeticNumber();
    }

    public final void update(SettingsMap response) throws NoSuchSessionException {
        this.configuration.update(this.referenceSession.getTargetName(), this.connectionID, response);
    }

    public final boolean getSettingAsBoolean(OperationalTextKey textKey) throws OperationalTextKeyException {
        return this.getSetting(textKey).compareTo("Yes") == 0;
    }

    public final int getSettingAsInt(OperationalTextKey textKey) throws OperationalTextKeyException {
        return Integer.parseInt(this.getSetting(textKey));
    }

    public final String getSetting(OperationalTextKey textKey) throws OperationalTextKeyException {
        return this.configuration.getSetting(this.referenceSession.getTargetName(), this.connectionID, textKey);
    }

    public final SettingsMap getSettings() {
        return this.configuration.getSettings(this.referenceSession.getTargetName(), this.connectionID);
    }

    public final void incrementExpectedStatusSequenceNumber() {
        this.expectedStatusSequenceNumber.increment();
    }

    public final SerialArithmeticNumber getExpectedStatusSequenceNumber() {
        return this.expectedStatusSequenceNumber;
    }

    public final void setExpectedStatusSequenceNumber(int newExpectedStatusSequenceNumber) {
        this.expectedStatusSequenceNumber.setValue(newExpectedStatusSequenceNumber);
        LOGGER.trace("Set ExpStatSN to " + this.expectedStatusSequenceNumber);
    }

    public final void nextState(IState newState) throws InternetSCSIException {
        this.state = newState;
        if (this.state != null) {
            do {
                this.state.execute();
                LOGGER.info("State is following: " + this.state.nextStateFollowing());
            } while (this.state.nextStateFollowing());
        }
    }

    public final IState getState() {
        return this.state;
    }

    public final Session getSession() {
        return this.referenceSession;
    }

    public final short getConnectionID() {
        return this.connectionID;
    }

    public final void close() throws IOException {
        this.senderReceiver.close();
        LOGGER.debug("Connection with ID " + this.connectionID + " closed.");
    }

    public final void send(ProtocolDataUnit protocolDataUnit) throws InternetSCSIException {
        try {
            this.senderReceiver.sendOverWire(protocolDataUnit);
        }
        catch (IOException e) {
            throw new InternetSCSIException((Exception)e);
        }
        catch (InterruptedException e) {
            throw new InternetSCSIException((Exception)e);
        }
    }

    public final void send(Queue<ProtocolDataUnit> protocolDataUnits) throws InternetSCSIException {
        for (ProtocolDataUnit unit : protocolDataUnits) {
            this.send(unit);
        }
    }

    public final ProtocolDataUnit receive() throws InternetSCSIException {
        try {
            return this.senderReceiver.receiveFromWire();
        }
        catch (DigestException e) {
            throw new InternetSCSIException((Exception)e);
        }
        catch (IOException e) {
            throw new InternetSCSIException((Exception)e);
        }
    }
}

