/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.security.DigestException;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.Session;
import org.jscsi.parser.InitiatorMessageParser;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.ProtocolDataUnitFactory;
import org.jscsi.parser.TargetMessageParser;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SenderWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderWorker.class);
    private final Connection connection;
    private final SocketChannel socketChannel;
    private final ProtocolDataUnitFactory protocolDataUnitFactory;

    public SenderWorker(Connection initConnection, InetSocketAddress inetAddress) throws IOException {
        this.connection = initConnection;
        this.socketChannel = SocketChannel.open(inetAddress);
        this.socketChannel.socket().setTcpNoDelay(true);
        this.protocolDataUnitFactory = new ProtocolDataUnitFactory();
    }

    public final void close() throws IOException {
        this.socketChannel.close();
    }

    public ProtocolDataUnit receiveFromWire() throws DigestException, InternetSCSIException, IOException {
        ProtocolDataUnit protocolDataUnit = this.protocolDataUnitFactory.create(this.connection.getSetting(OperationalTextKey.HEADER_DIGEST), this.connection.getSetting(OperationalTextKey.DATA_DIGEST));
        try {
            protocolDataUnit.read(this.socketChannel);
        }
        catch (ClosedChannelException e) {
            throw new InternetSCSIException((Exception)e);
        }
        LOGGER.debug("Receiving this PDU: " + protocolDataUnit);
        Exception isCorrect = this.connection.getState().isCorrect(protocolDataUnit);
        if (isCorrect == null) {
            LOGGER.trace("Adding PDU to Receiving Queue.");
            TargetMessageParser parser = (TargetMessageParser)protocolDataUnit.getBasicHeaderSegment().getParser();
            Session session = this.connection.getSession();
            if (session.getMaximumCommandSequenceNumber().compareTo(parser.getMaximumCommandSequenceNumber()) < 0) {
                session.setMaximumCommandSequenceNumber(parser.getMaximumCommandSequenceNumber());
            }
            if (parser.incrementSequenceNumber()) {
                if (this.connection.getExpectedStatusSequenceNumber().compareTo(parser.getStatusSequenceNumber()) >= 0) {
                    this.connection.incrementExpectedStatusSequenceNumber();
                } else {
                    LOGGER.error("Status Sequence Number Mismatch (received, expected): " + parser.getStatusSequenceNumber() + ", " + (this.connection.getExpectedStatusSequenceNumber().getValue() - 1));
                }
            }
        } else {
            throw new InternetSCSIException(isCorrect);
        }
        return protocolDataUnit;
    }

    public final void sendOverWire(ProtocolDataUnit unit) throws InternetSCSIException, IOException, InterruptedException {
        Session session = this.connection.getSession();
        unit.getBasicHeaderSegment().setInitiatorTaskTag(session.getInitiatorTaskTag());
        InitiatorMessageParser parser = (InitiatorMessageParser)unit.getBasicHeaderSegment().getParser();
        parser.setCommandSequenceNumber(session.getCommandSequenceNumber());
        parser.setExpectedStatusSequenceNumber(this.connection.getExpectedStatusSequenceNumber().getValue());
        unit.write(this.socketChannel);
        LOGGER.debug("Sending this PDU: " + unit);
        if (parser.incrementSequenceNumber()) {
            this.connection.getSession().incrementCommandSequenceNumber();
        }
    }
}

