/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.jscsi.exception.NoSuchConnectionException;
import org.jscsi.exception.TaskExecutionException;
import org.jscsi.initiator.Configuration;
import org.jscsi.initiator.LinkFactory;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.IOTask;
import org.jscsi.initiator.connection.ITask;
import org.jscsi.initiator.connection.LoginTask;
import org.jscsi.initiator.connection.LogoutTask;
import org.jscsi.initiator.connection.ReadTask;
import org.jscsi.initiator.connection.TargetCapacityInformations;
import org.jscsi.initiator.connection.WriteTask;
import org.jscsi.initiator.connection.phase.IPhase;
import org.jscsi.initiator.connection.phase.SecurityNegotiationPhase;
import org.jscsi.initiator.connection.state.LoginRequestState;
import org.jscsi.initiator.taskbalancer.AbstractTaskBalancer;
import org.jscsi.initiator.taskbalancer.SimpleTaskBalancer;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.datasegment.SettingsMap;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.utils.SerialArithmeticNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Session {
    protected final String targetName;
    protected final InetSocketAddress inetSocketAddress;
    private int maxConnections;
    protected short nextFreeConnectionID;
    protected IPhase phase;
    protected final TargetCapacityInformations capacityInformations;
    protected final LinkedBlockingQueue<Connection> connections;
    protected final SerialArithmeticNumber commandSequenceNumber;
    protected final SerialArithmeticNumber maximumCommandSequenceNumber;
    protected final SerialArithmeticNumber initiatorTaskTag;
    protected boolean tsihChanged;
    protected short targetSessionIdentifyingHandle;
    private static final Logger LOGGER = LoggerFactory.getLogger(Session.class);
    protected final Configuration configuration;
    protected final LinkFactory factory;
    private final ExecutorService executor;
    private final ConcurrentHashMap<ITask, Connection> outstandingTasks;
    protected final AbstractTaskBalancer taskBalancer;

    public Session(LinkFactory linkFactory, Configuration initConfiguration, String initTargetName, InetSocketAddress inetAddress, ExecutorService initExecutor) throws Exception {
        this.maxConnections = Integer.parseInt(initConfiguration.getSessionSetting(initTargetName, OperationalTextKey.MAX_CONNECTIONS));
        this.factory = linkFactory;
        this.configuration = initConfiguration;
        this.commandSequenceNumber = new SerialArithmeticNumber();
        this.maximumCommandSequenceNumber = new SerialArithmeticNumber(1);
        this.nextFreeConnectionID = 1;
        this.inetSocketAddress = inetAddress;
        this.initiatorTaskTag = new SerialArithmeticNumber(1);
        this.targetName = initTargetName;
        this.phase = new SecurityNegotiationPhase();
        this.capacityInformations = new TargetCapacityInformations();
        this.connections = new LinkedBlockingQueue(this.maxConnections);
        this.executor = initExecutor;
        this.taskBalancer = new SimpleTaskBalancer(this.connections);
        this.outstandingTasks = new ConcurrentHashMap();
        this.addNewConnection();
        this.maxConnections = Integer.parseInt(this.configuration.getSessionSetting(this.targetName, OperationalTextKey.MAX_CONNECTIONS));
        int targetMaxC = this.connections.peek().getSettingAsInt(OperationalTextKey.MAX_CONNECTIONS);
        if (targetMaxC < this.maxConnections) {
            this.maxConnections = targetMaxC;
        }
        this.addConnections(this.maxConnections - 1);
    }

    public final short getTargetSessionIdentifyingHandle() {
        return this.targetSessionIdentifyingHandle;
    }

    public final void setTargetSessionIdentifyingHandle(short tsih) {
        if (!this.tsihChanged) {
            this.targetSessionIdentifyingHandle = tsih;
            this.tsihChanged = true;
        }
    }

    public final int getCommandSequenceNumber() {
        return this.commandSequenceNumber.getValue();
    }

    public final void setMaximumCommandSequenceNumber(int newMaximumCommandSequenceNumber) {
        this.maximumCommandSequenceNumber.setValue(newMaximumCommandSequenceNumber);
    }

    public final SerialArithmeticNumber getMaximumCommandSequenceNumber() {
        return this.maximumCommandSequenceNumber;
    }

    public final int getInitiatorTaskTag() {
        return this.initiatorTaskTag.getValue();
    }

    public final void incrementInitiatorTaskTag() {
        this.initiatorTaskTag.increment();
    }

    public final boolean hasTargetMoreResources() {
        return this.maximumCommandSequenceNumber.compareTo(this.commandSequenceNumber.getValue()) > 0;
    }

    public final String getTargetName() {
        return this.targetName;
    }

    public final void addConnections(int max) throws Exception {
        if (this.connections.size() < this.maxConnections) {
            for (int i = 1; i < max; ++i) {
                this.addNewConnection();
            }
        }
    }

    protected final short addNewConnection() throws Exception {
        if (this.connections.size() < this.maxConnections) {
            Connection connection = this.factory.getConnection(this, this.configuration, this.inetSocketAddress, this.nextFreeConnectionID);
            connection.nextState(new LoginRequestState(connection, LoginStage.FULL_FEATURE_PHASE));
            this.connections.add(connection);
            if (this.connections.size() == 1) {
                this.phase.getCapacity(this, this.capacityInformations);
                if (connection.getSettingAsInt(OperationalTextKey.MAX_CONNECTIONS) > 1) {
                    this.phase.login(this);
                }
            }
            short s = this.nextFreeConnectionID;
            this.nextFreeConnectionID = (short)(s + 1);
            return s;
        }
        LOGGER.warn("Unused new connection -> ignored!");
        return this.nextFreeConnectionID;
    }

    public void updateMaxConnections(int max) {
        try {
            Connection conn = this.taskBalancer.getConnection();
            int update = 0;
            int targetMaxC = this.connections.peek().getSettingAsInt(OperationalTextKey.MAX_CONNECTIONS);
            if (targetMaxC <= max) {
                if (targetMaxC > this.maxConnections) {
                    update = targetMaxC - this.maxConnections;
                    this.maxConnections = targetMaxC;
                }
            } else if (max >= this.maxConnections) {
                update = max - this.maxConnections;
                this.maxConnections = max;
            }
            SettingsMap sm = new SettingsMap();
            sm.add(OperationalTextKey.MAX_CONNECTIONS, String.valueOf(this.maxConnections));
            conn.update(sm);
            this.taskBalancer.releaseConnection(conn);
            if (update > 0) {
                this.addConnections(update);
            } else {
                for (int i = -1; i >= update; --i) {
                    this.taskBalancer.getConnection().close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final Connection getNextFreeConnection() throws NoSuchConnectionException {
        return this.taskBalancer.getConnection();
    }

    public final void incrementCommandSequenceNumber() {
        this.commandSequenceNumber.increment();
    }

    public final void close() throws IOException {
        LOGGER.info("Closing was requested.");
        for (Connection c : this.connections) {
            c.close();
        }
        this.connections.clear();
        this.factory.closedSession(this);
        this.executor.shutdown();
    }

    public final long getBlockSize() {
        return this.capacityInformations.getBlockSize();
    }

    public final long getCapacity() {
        return this.capacityInformations.getSize();
    }

    public final void login() throws Exception {
        this.executeTask(new LoginTask(this));
    }

    public final void logout() throws TaskExecutionException {
        this.executeTask(new LogoutTask(this));
    }

    public final Future<Void> read(ByteBuffer dst, int logicalBlockAddress, long transferLength) throws TaskExecutionException {
        return this.executeTask(new ReadTask(this, dst, logicalBlockAddress, transferLength));
    }

    public final Future<Void> write(ByteBuffer src, int logicalBlockAddress, long transferLength) throws TaskExecutionException {
        return this.executeTask(new WriteTask(this, src, logicalBlockAddress, transferLength));
    }

    public final LoginStage getPhase() {
        return this.phase.getStage();
    }

    public final void setPhase(IPhase newPhase) {
        this.phase = newPhase;
        LOGGER.trace("Switching to phase " + newPhase.getClass().getSimpleName());
    }

    private final Future<Void> executeTask(ITask task) throws TaskExecutionException {
        if (task instanceof IOTask) {
            Future<Void> returnVal = this.executor.submit((IOTask)task);
            return returnVal;
        }
        try {
            task.call();
        }
        catch (Exception exc) {
            throw new TaskExecutionException(new ExecutionException(exc));
        }
        return null;
    }

    public final void finishedTask(ITask ftask) {
        try {
            this.taskBalancer.releaseConnection(this.outstandingTasks.get(ftask));
        }
        catch (NoSuchConnectionException e) {
            e.printStackTrace();
        }
        this.outstandingTasks.remove(ftask);
        LOGGER.debug("Finished a " + ftask + " for the session " + this.targetName);
    }

    public final void restartTask(ITask task) throws ExecutionException {
        try {
            if (task != null) {
                if (task instanceof IOTask) {
                    this.executor.submit((IOTask)task);
                } else {
                    task.call();
                }
                this.taskBalancer.releaseConnection(this.outstandingTasks.get(task));
                this.outstandingTasks.remove(task);
            }
            LOGGER.debug("Restarted a Task out of the outstandingTasks Queue");
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public final void addOutstandingTask(Connection connection, ITask task) {
        this.outstandingTasks.put(task, connection);
        LOGGER.debug("Added a Task to the outstandingTasks Queue");
    }

    public final void releaseUsedConnection(Connection connection) throws NoSuchConnectionException {
        this.taskBalancer.releaseConnection(connection);
    }
}

