/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.phase;

import java.nio.ByteBuffer;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.ITask;
import org.jscsi.initiator.connection.Session;
import org.jscsi.initiator.connection.TargetCapacityInformations;
import org.jscsi.initiator.connection.phase.AbstractPhase;
import org.jscsi.initiator.connection.state.CapacityRequestState;
import org.jscsi.initiator.connection.state.GetConnectionsRequestState;
import org.jscsi.initiator.connection.state.LogoutRequestState;
import org.jscsi.initiator.connection.state.ReadRequestState;
import org.jscsi.initiator.connection.state.WriteRequestState;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.parser.logout.LogoutRequestParser;
import org.jscsi.parser.scsi.SCSICommandParser;

public final class FullFeaturePhase
extends AbstractPhase {
    private static final int READ_FIRST_STAGE_BLOCKS = 64;
    private static final int READ_SECOND_STAGE_BLOCKS = 128;
    private static final int READ_THIRD_STAGE_BLOCKS = 256;
    private static final int WRITE_FIRST_STAGE_BLOCKS = 1024;
    private static final int WRITE_SECOND_STAGE_BLOCKS = 2048;
    private static final int WRITE_THIRD_STAGE_BLOCKS = 4096;

    @Override
    public final boolean login(Session session) throws Exception {
        Connection connection = session.getNextFreeConnection();
        connection.nextState(new GetConnectionsRequestState(connection));
        session.releaseUsedConnection(connection);
        return true;
    }

    @Override
    public final boolean logoutSession(ITask task, Session session) throws Exception {
        Connection connection = session.getNextFreeConnection();
        connection.getSession().addOutstandingTask(connection, task);
        connection.nextState(new LogoutRequestState(connection, LogoutRequestParser.LogoutReasonCode.CLOSE_SESSION));
        return true;
    }

    @Override
    public final boolean read(ITask task, Session session, ByteBuffer dst, int logicalBlockAddress, long length) throws Exception {
        if ((long)dst.remaining() < length) {
            throw new IllegalArgumentException("Destination buffer is too small.");
        }
        int startAddress = logicalBlockAddress;
        long blockSize = session.getBlockSize();
        long totalBlocks = (long)Math.ceil((double)length / (double)blockSize);
        long bytes2Process = length;
        Connection connection = session.getNextFreeConnection();
        connection.getSession().addOutstandingTask(connection, task);
        short blocks = (short)Math.min(64L, totalBlocks);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Now reading sequences of length " + blocks + " blocks.");
        }
        connection.nextState(new ReadRequestState(connection, dst, SCSICommandParser.TaskAttributes.SIMPLE, (int)Math.min(bytes2Process, (long)blocks * blockSize), startAddress, blocks));
        startAddress += blocks;
        totalBlocks -= (long)blocks;
        bytes2Process -= (long)blocks * blockSize;
        blocks = (short)Math.min(128L, totalBlocks);
        if (blocks > 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Now reading sequences of length " + blocks + " blocks.");
            }
            connection.nextState(new ReadRequestState(connection, dst, SCSICommandParser.TaskAttributes.SIMPLE, (int)Math.min(bytes2Process, (long)blocks * blockSize), startAddress, blocks));
            startAddress += blocks;
            totalBlocks -= (long)blocks;
            bytes2Process -= (long)blocks * blockSize;
        }
        blocks = (short)Math.min(256L, totalBlocks);
        while (blocks > 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Now reading sequences of length " + blocks + " blocks.");
            }
            connection.nextState(new ReadRequestState(connection, dst, SCSICommandParser.TaskAttributes.SIMPLE, (int)Math.min(bytes2Process, (long)blocks * blockSize), startAddress, blocks));
            startAddress += blocks;
            blocks = (short)Math.min(256L, totalBlocks -= (long)blocks);
        }
        return true;
    }

    @Override
    public final boolean write(ITask task, Session session, ByteBuffer src, int logicalBlockAddress, long length) throws Exception {
        if ((long)src.remaining() < length) {
            throw new IllegalArgumentException("Source buffer is too small. Buffer size: " + src.remaining() + " Expected: " + length);
        }
        int startAddress = logicalBlockAddress;
        long blockSize = session.getBlockSize();
        int totalBlocks = (int)Math.ceil((double)length / (double)blockSize);
        long bytes2Process = length;
        int bufferPosition = 0;
        Connection connection = session.getNextFreeConnection();
        connection.getSession().addOutstandingTask(connection, task);
        short blocks = (short)Math.min(1024, totalBlocks);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Now sending sequences of length " + blocks + " blocks.");
        }
        int expectedDataTransferLength = (int)Math.min(bytes2Process, (long)blocks * blockSize);
        connection.nextState(new WriteRequestState(connection, src, bufferPosition, SCSICommandParser.TaskAttributes.SIMPLE, expectedDataTransferLength, startAddress, blocks));
        startAddress += blocks;
        totalBlocks -= blocks;
        bytes2Process -= (long)blocks * blockSize;
        bufferPosition += expectedDataTransferLength;
        blocks = (short)Math.min(2048, totalBlocks);
        if (blocks > 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Now sending sequences of length " + blocks + " blocks.");
                LOGGER.info("Remaining, DataSegmentLength: " + bytes2Process + ", " + expectedDataTransferLength);
            }
            expectedDataTransferLength = (int)Math.min(bytes2Process, (long)blocks * blockSize);
            connection.nextState(new WriteRequestState(connection, src, bufferPosition, SCSICommandParser.TaskAttributes.SIMPLE, expectedDataTransferLength, startAddress, blocks));
            startAddress += blocks;
            totalBlocks -= blocks;
            bytes2Process -= (long)blocks * blockSize;
            bufferPosition += expectedDataTransferLength;
        }
        blocks = (short)Math.min(4096, totalBlocks);
        while (blocks > 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Now sending sequences of length " + blocks + " blocks.");
            }
            expectedDataTransferLength = (int)Math.min(bytes2Process, (long)blocks * blockSize);
            connection.nextState(new WriteRequestState(connection, src, bufferPosition, SCSICommandParser.TaskAttributes.SIMPLE, expectedDataTransferLength, startAddress, blocks));
            startAddress += blocks;
            blocks = (short)Math.min(256, totalBlocks -= blocks);
            bufferPosition += expectedDataTransferLength;
        }
        return true;
    }

    @Override
    public final boolean getCapacity(Session session, TargetCapacityInformations capacityInformation) throws Exception {
        if (capacityInformation == null) {
            throw new NullPointerException();
        }
        Connection connection = session.getNextFreeConnection();
        if (connection == null) {
            throw new NullPointerException();
        }
        connection.nextState(new CapacityRequestState(connection, capacityInformation, SCSICommandParser.TaskAttributes.SIMPLE));
        session.releaseUsedConnection(connection);
        return true;
    }

    @Override
    public final LoginStage getStage() {
        return LoginStage.FULL_FEATURE_PHASE;
    }
}

