/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.TargetCapacityInformations;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.CapacityResponseState;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.scsi.SCSICommandDescriptorBlockParser;
import org.jscsi.parser.scsi.SCSICommandParser;

public final class CapacityRequestState
extends AbstractState {
    private static final int EXPECTED_DATA_TRANSFER_LENGTH = 8;
    private final TargetCapacityInformations capacityInformation;
    private final SCSICommandParser.TaskAttributes taskAttributes;

    public CapacityRequestState(Connection initConnection, TargetCapacityInformations initCapacityInformation, SCSICommandParser.TaskAttributes initTaskAttributes) {
        super(initConnection);
        this.capacityInformation = initCapacityInformation;
        this.taskAttributes = initTaskAttributes;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        ProtocolDataUnit protocolDataUnit = this.protocolDataUnitFactory.create(false, true, OperationCode.SCSI_COMMAND, this.connection.getSetting(OperationalTextKey.HEADER_DIGEST), this.connection.getSetting(OperationalTextKey.DATA_DIGEST));
        SCSICommandParser scsi = (SCSICommandParser)protocolDataUnit.getBasicHeaderSegment().getParser();
        scsi.setReadExpectedFlag(true);
        scsi.setWriteExpectedFlag(false);
        scsi.setTaskAttributes(this.taskAttributes);
        scsi.setExpectedDataTransferLength(8);
        scsi.setCommandDescriptorBlock(SCSICommandDescriptorBlockParser.createReadCapacityMessage());
        this.connection.send(protocolDataUnit);
        this.connection.nextState(new CapacityResponseState(this.connection, this.capacityInformation));
        this.stateFollowing = true;
    }
}

