/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.TargetCapacityInformations;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.CapacityRequestState;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.data.DataInParser;
import org.jscsi.parser.scsi.SCSICommandParser;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;

public final class CapacityResponseState
extends AbstractState {
    private final TargetCapacityInformations capacityInformation;

    protected CapacityResponseState(Connection initConnection, TargetCapacityInformations initCapacityInformation) {
        super(initConnection);
        this.capacityInformation = initCapacityInformation;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        ProtocolDataUnit protocolDataUnit = this.connection.receive();
        if (!(protocolDataUnit.getBasicHeaderSegment().getParser() instanceof DataInParser)) {
            if (protocolDataUnit.getBasicHeaderSegment().getParser() instanceof SCSIResponseParser) {
                this.connection.nextState(new CapacityRequestState(this.connection, this.capacityInformation, SCSICommandParser.TaskAttributes.SIMPLE));
                this.stateFollowing = true;
                return;
            }
            throw new InternetSCSIException(protocolDataUnit.getBasicHeaderSegment().getParser().getClass().getSimpleName() + " is not the expected type of PDU.");
        }
        DataInParser parser = (DataInParser)protocolDataUnit.getBasicHeaderSegment().getParser();
        this.capacityInformation.deserialize(protocolDataUnit.getDataSegment());
        if (!parser.isStatusFlag() || parser.getStatus() != SCSIStatus.GOOD) {
            SCSIResponseParser scsiParser;
            ProtocolDataUnit scsiPdu = this.connection.receive();
            if (scsiPdu.getBasicHeaderSegment().getOpCode() == OperationCode.SCSI_RESPONSE && (scsiParser = (SCSIResponseParser)scsiPdu.getBasicHeaderSegment().getParser()).getStatus() == SCSIStatus.GOOD) {
                return;
            }
            throw new InternetSCSIException("Error: Task did not finish successfully.");
        }
    }
}

