/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.LoginResponseState;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.datasegment.DataSegmentFactory;
import org.jscsi.parser.datasegment.IDataSegment;
import org.jscsi.parser.datasegment.IDataSegmentIterator;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.datasegment.SettingsMap;
import org.jscsi.parser.login.ISID;
import org.jscsi.parser.login.LoginRequestParser;
import org.jscsi.parser.login.LoginStage;

public final class LoginRequestState
extends AbstractState {
    private static final byte MAXIMUM_VERSION = 0;
    private static final byte MINIMUM_VERSION = 0;
    private final LoginStage nextStage;

    public LoginRequestState(Connection initConnection, LoginStage initNextStage) {
        super(initConnection);
        this.nextStage = initNextStage;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        SettingsMap loginParameters = this.connection.getSettings();
        LOGGER.info("Sending these login parameters:\n" + loginParameters);
        int maxRecvDataSegmentLength = this.connection.getSettingAsInt(OperationalTextKey.MAX_RECV_DATA_SEGMENT_LENGTH);
        ISID isid = ISID.createRandom((long)System.currentTimeMillis());
        IDataSegment dataSegment = DataSegmentFactory.create((ByteBuffer)loginParameters.asByteBuffer(), (DataSegmentFactory.DataSegmentFormat)DataSegmentFactory.DataSegmentFormat.TEXT, (int)maxRecvDataSegmentLength);
        IDataSegmentIterator iterator = dataSegment.iterator();
        LinkedList<ProtocolDataUnit> protocolDataUnits = new LinkedList<ProtocolDataUnit>();
        for (int bytes2Transfer = dataSegment.getLength(); bytes2Transfer > 0 && iterator.hasNext(); bytes2Transfer -= maxRecvDataSegmentLength) {
            boolean continueFlag;
            IDataSegmentIterator.IDataSegmentChunk dataSegmentChunk;
            if (bytes2Transfer <= maxRecvDataSegmentLength) {
                dataSegmentChunk = iterator.next(bytes2Transfer);
                continueFlag = false;
            } else {
                dataSegmentChunk = iterator.next(maxRecvDataSegmentLength);
                continueFlag = true;
            }
            boolean finalFlag = !continueFlag;
            ProtocolDataUnit protocolDataUnit = this.protocolDataUnitFactory.create(true, finalFlag, OperationCode.LOGIN_REQUEST, "None", "None");
            LoginRequestParser loginRequest = (LoginRequestParser)protocolDataUnit.getBasicHeaderSegment().getParser();
            loginRequest.setContinueFlag(continueFlag);
            loginRequest.setCurrentStageNumber(this.connection.getSession().getPhase());
            LOGGER.debug("Phase:\n" + loginRequest.getCurrentStageNumber());
            if (finalFlag) {
                loginRequest.setNextStageNumber(this.nextStage);
            }
            loginRequest.setMaxVersion((byte)0);
            loginRequest.setMinVersion((byte)0);
            loginRequest.setInitiatorSessionID(isid);
            loginRequest.setTargetSessionIdentifyingHandle(this.connection.getSession().getTargetSessionIdentifyingHandle());
            protocolDataUnit.setDataSegment(dataSegmentChunk);
            protocolDataUnits.offer(protocolDataUnit);
        }
        this.connection.send(protocolDataUnits);
        this.connection.nextState(new LoginResponseState(this.connection, this.nextStage));
        this.stateFollowing = true;
    }
}

