/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.phase.FullFeaturePhase;
import org.jscsi.initiator.connection.phase.LoginOperationalNegotiationPhase;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.datasegment.DataSegmentFactory;
import org.jscsi.parser.datasegment.IDataSegment;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.login.LoginResponseParser;
import org.jscsi.parser.login.LoginStage;

public final class LoginResponseState
extends AbstractState {
    private final LoginStage nextStage;

    public LoginResponseState(Connection initConnection, LoginStage initNextStage) {
        super(initConnection);
        this.nextStage = initNextStage;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        ProtocolDataUnit protocolDataUnit;
        IDataSegment loginResponse = DataSegmentFactory.create((DataSegmentFactory.DataSegmentFormat)DataSegmentFactory.DataSegmentFormat.TEXT, (int)this.connection.getSettingAsInt(OperationalTextKey.MAX_RECV_DATA_SEGMENT_LENGTH));
        while ((protocolDataUnit = this.connection.receive()).getBasicHeaderSegment().getParser() instanceof LoginResponseParser) {
            loginResponse.append(protocolDataUnit.getDataSegment(), protocolDataUnit.getBasicHeaderSegment().getDataSegmentLength());
            if (!protocolDataUnit.getBasicHeaderSegment().isFinalFlag()) continue;
        }
        LoginResponseParser parser = (LoginResponseParser)protocolDataUnit.getBasicHeaderSegment().getParser();
        this.connection.getSession().setTargetSessionIdentifyingHandle(parser.getTargetSessionIdentifyingHandle());
        this.connection.setExpectedStatusSequenceNumber(parser.getStatusSequenceNumber() + 1);
        LOGGER.info("Retrieving these login parameters:\n" + loginResponse.getSettings());
        this.connection.update(loginResponse.getSettings());
        LOGGER.info("Updated settings to these:\n" + this.connection.getSettings());
        LOGGER.info("Nextstage is : " + this.nextStage);
        if (protocolDataUnit.getBasicHeaderSegment().isFinalFlag()) {
            if (this.nextStage == LoginStage.LOGIN_OPERATIONAL_NEGOTIATION) {
                this.connection.getSession().setPhase(new LoginOperationalNegotiationPhase());
            } else if (this.nextStage == LoginStage.FULL_FEATURE_PHASE) {
                this.connection.getSession().setPhase(new FullFeaturePhase());
            }
        }
    }

    @Override
    public final Exception isCorrect(ProtocolDataUnit protocolDataUnit) {
        if (protocolDataUnit.getBasicHeaderSegment().getParser() instanceof LoginResponseParser) {
            return null;
        }
        return new IllegalStateException("Parser " + protocolDataUnit.getBasicHeaderSegment().getParser().toString() + " is instance of " + protocolDataUnit.getBasicHeaderSegment().getParser().getClass().toString() + " and not instance if LoginParser!");
    }
}

