/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import java.nio.ByteBuffer;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.ReadResponseState;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.scsi.SCSICommandDescriptorBlockParser;
import org.jscsi.parser.scsi.SCSICommandParser;

public final class ReadRequestState
extends AbstractState {
    private final ByteBuffer buffer;
    private final SCSICommandParser.TaskAttributes taskAttributes;
    private final int expectedDataTransferLength;
    private final int logicalBlockAddress;
    private final short transferLength;

    public ReadRequestState(Connection initConnection, ByteBuffer initBuffer, SCSICommandParser.TaskAttributes initTaskAttributes, int initExpectedDataTransferLength, int initLogicalBlockAddress, short initTransferLength) {
        super(initConnection);
        this.buffer = initBuffer;
        this.taskAttributes = initTaskAttributes;
        this.expectedDataTransferLength = initExpectedDataTransferLength;
        this.logicalBlockAddress = initLogicalBlockAddress;
        this.transferLength = initTransferLength;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        ProtocolDataUnit protocolDataUnit = this.protocolDataUnitFactory.create(false, true, OperationCode.SCSI_COMMAND, this.connection.getSetting(OperationalTextKey.HEADER_DIGEST), this.connection.getSetting(OperationalTextKey.DATA_DIGEST));
        SCSICommandParser scsi = (SCSICommandParser)protocolDataUnit.getBasicHeaderSegment().getParser();
        scsi.setReadExpectedFlag(true);
        scsi.setWriteExpectedFlag(false);
        scsi.setTaskAttributes(this.taskAttributes);
        scsi.setExpectedDataTransferLength(this.expectedDataTransferLength);
        scsi.setCommandDescriptorBlock(SCSICommandDescriptorBlockParser.createReadMessage((int)this.logicalBlockAddress, (short)this.transferLength));
        this.connection.send(protocolDataUnit);
        this.connection.nextState(new ReadResponseState(this.connection, this.buffer, 0, 0));
        this.stateFollowing = true;
    }
}

