/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import java.nio.ByteBuffer;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.exception.OperationalTextKeyException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.SNACKRequestState;
import org.jscsi.parser.AbstractMessageParser;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.data.DataInParser;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;

public final class ReadResponseState
extends AbstractState {
    private static final int WRAP_AROUND_DIVISOR = (int)Math.pow(2.0, 32.0);
    private final ByteBuffer buffer;
    private int bufferOffset;
    private int expectedDataSequenceNumber;

    public ReadResponseState(Connection initConnection, ByteBuffer initBuffer, int initBufferOffset, int initExpectedDataSequenceNumber) {
        super(initConnection);
        this.buffer = initBuffer;
        this.bufferOffset = initBufferOffset;
        this.expectedDataSequenceNumber = initExpectedDataSequenceNumber;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        ProtocolDataUnit protocolDataUnit;
        do {
            protocolDataUnit = this.connection.receive();
            boolean dataWasRead = false;
            if (!(protocolDataUnit.getBasicHeaderSegment().getParser() instanceof DataInParser)) continue;
            DataInParser parser = (DataInParser)protocolDataUnit.getBasicHeaderSegment().getParser();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Remaining, DataSegmentLength: " + this.buffer.remaining() + ", " + protocolDataUnit.getBasicHeaderSegment().getDataSegmentLength());
            }
            ByteBuffer dataSegment = protocolDataUnit.getDataSegment();
            while (this.buffer.hasRemaining() && dataSegment.hasRemaining()) {
                this.buffer.put(dataSegment.get());
            }
            dataWasRead = true;
            if (parser.isStatusFlag() && parser.getStatus() == SCSIStatus.GOOD) {
                return;
            }
            if (this.connection.getSettingAsInt(OperationalTextKey.ERROR_RECOVERY_LEVEL) > 0 && parser.isAcknowledgeFlag()) {
                this.connection.nextState(new SNACKRequestState(this.connection, this, parser.getTargetTaskTag()));
                return;
            }
            if (!(protocolDataUnit.getBasicHeaderSegment().getParser() instanceof SCSIResponseParser) || dataWasRead) continue;
            this.readHandleImmediateData(protocolDataUnit);
        } while (!protocolDataUnit.getBasicHeaderSegment().isFinalFlag());
        if (this.connection.getSettingAsBoolean(OperationalTextKey.IMMEDIATE_DATA)) {
            return;
        }
        protocolDataUnit = this.connection.receive();
        if (protocolDataUnit.getBasicHeaderSegment().getParser() instanceof SCSIResponseParser) {
            this.readHandleImmediateData(protocolDataUnit);
        }
    }

    private void readHandleImmediateData(ProtocolDataUnit protocolDataUnit) throws InternetSCSIException {
        SCSIResponseParser parser = (SCSIResponseParser)protocolDataUnit.getBasicHeaderSegment().getParser();
        ByteBuffer dataSegment = protocolDataUnit.getDataSegment();
        while (this.buffer.hasRemaining() && dataSegment.hasRemaining()) {
            this.buffer.put(dataSegment.get());
        }
        if (parser.getStatus() == SCSIStatus.GOOD) {
            this.stateFollowing = false;
            return;
        }
        throw new InternetSCSIException();
    }

    @Override
    public Exception isCorrect(ProtocolDataUnit protocolDataUnit) {
        AbstractMessageParser parser = protocolDataUnit.getBasicHeaderSegment().getParser();
        if (parser instanceof DataInParser) {
            DataInParser dataParser = (DataInParser)parser;
            try {
                if (this.connection.getSettingAsBoolean(OperationalTextKey.DATA_PDU_IN_ORDER) && this.connection.getSettingAsBoolean(OperationalTextKey.DATA_SEQUENCE_IN_ORDER)) {
                    if (dataParser.getBufferOffset() < this.bufferOffset) {
                        return new IllegalStateException("This buffer offsets must be in increasing order and overlays are forbidden." + " The parserOffset here is " + dataParser.getBufferOffset() + " and the bufferOffset is " + this.bufferOffset);
                    }
                    this.bufferOffset = dataParser.getBufferOffset();
                }
            }
            catch (OperationalTextKeyException e) {
                return e;
            }
            if (dataParser.getDataSequenceNumber() != this.expectedDataSequenceNumber) {
                return new IllegalStateException("Data Sequence Number Mismatch (received, expected): " + dataParser.getDataSequenceNumber() + ", " + this.expectedDataSequenceNumber);
            }
            this.incrementExpectedDataSequenceNumber();
            if (dataParser.isStatusFlag()) {
                this.incrementExpectedDataSequenceNumber();
                return super.isCorrect(protocolDataUnit);
            }
            if (dataParser.getStatusSequenceNumber() != 0) {
                return new IllegalStateException("Status Sequence Number must be zero.");
            }
            return null;
        }
        if (parser instanceof SCSIResponseParser) {
            try {
                if (this.connection.getSettingAsBoolean(OperationalTextKey.IMMEDIATE_DATA)) {
                    return new IllegalStateException("Parser " + "should not be instance of SCSIResponseParser because of ImmendiateData-Flag \"no\" in config!");
                }
            }
            catch (OperationalTextKeyException e) {
                return e;
            }
            return null;
        }
        return new IllegalStateException("Parser " + protocolDataUnit.getBasicHeaderSegment().getParser().toString() + " is instance of " + protocolDataUnit.getBasicHeaderSegment().getParser().getClass().toString() + " and not instance of either DataInParser or SCSIResponseParser!");
    }

    private void incrementExpectedDataSequenceNumber() {
        this.expectedDataSequenceNumber = (this.expectedDataSequenceNumber + 1) % WRAP_AROUND_DIVISOR;
    }
}

