/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import java.util.LinkedList;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.WriteSecondResponseState;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.data.DataOutParser;
import org.jscsi.parser.datasegment.IDataSegmentIterator;
import org.jscsi.parser.datasegment.OperationalTextKey;

public final class WriteFirstBurstState
extends AbstractState {
    private IDataSegmentIterator iterator;
    private final int targetTransferTag;
    private int dataSequenceNumber;
    private int bufferOffset;

    public WriteFirstBurstState(Connection initConnection, IDataSegmentIterator initIterator, int initTargetTransferTag, int initDataSequenceNumber, int initBufferOffset) {
        super(initConnection);
        this.iterator = initIterator;
        this.targetTransferTag = initTargetTransferTag;
        this.dataSequenceNumber = initDataSequenceNumber;
        this.bufferOffset = initBufferOffset;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        LinkedList<ProtocolDataUnit> protocolDataUnits = new LinkedList<ProtocolDataUnit>();
        boolean finalFlag = false;
        int maxRecvDataSegmentLength = this.connection.getSettingAsInt(OperationalTextKey.MAX_RECV_DATA_SEGMENT_LENGTH);
        for (int bytes2Transfer = this.connection.getSettingAsInt(OperationalTextKey.FIRST_BURST_LENGTH) - this.bufferOffset; bytes2Transfer > 0 && this.iterator.hasNext(); bytes2Transfer -= maxRecvDataSegmentLength) {
            IDataSegmentIterator.IDataSegmentChunk dataSegmentChunk;
            if (bytes2Transfer <= maxRecvDataSegmentLength) {
                dataSegmentChunk = this.iterator.next(bytes2Transfer);
                finalFlag = true;
            } else {
                dataSegmentChunk = this.iterator.next(maxRecvDataSegmentLength);
                finalFlag = false;
            }
            ProtocolDataUnit protocolDataUnit = this.protocolDataUnitFactory.create(false, finalFlag, OperationCode.SCSI_DATA_OUT, this.connection.getSetting(OperationalTextKey.HEADER_DIGEST), this.connection.getSetting(OperationalTextKey.DATA_DIGEST));
            protocolDataUnit.getBasicHeaderSegment().setInitiatorTaskTag(this.connection.getSession().getInitiatorTaskTag());
            DataOutParser dataOut = (DataOutParser)protocolDataUnit.getBasicHeaderSegment().getParser();
            dataOut.setTargetTransferTag(this.targetTransferTag);
            dataOut.setDataSequenceNumber(this.dataSequenceNumber++);
            dataOut.setBufferOffset(this.bufferOffset);
            this.bufferOffset += maxRecvDataSegmentLength;
            protocolDataUnit.setDataSegment(dataSegmentChunk);
            protocolDataUnits.offer(protocolDataUnit);
        }
        this.connection.send(protocolDataUnits);
        this.connection.nextState(new WriteSecondResponseState(this.connection, this.iterator, this.dataSequenceNumber, this.bufferOffset));
        this.stateFollowing = true;
    }
}

