/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import java.nio.ByteBuffer;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.WriteFirstBurstState;
import org.jscsi.initiator.connection.state.WriteSecondResponseState;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.datasegment.DataSegmentFactory;
import org.jscsi.parser.datasegment.IDataSegment;
import org.jscsi.parser.datasegment.IDataSegmentIterator;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.scsi.SCSICommandDescriptorBlockParser;
import org.jscsi.parser.scsi.SCSICommandParser;

public final class WriteRequestState
extends AbstractState {
    private final ByteBuffer buffer;
    private final SCSICommandParser.TaskAttributes taskAttributes;
    private final int expectedDataTransferLength;
    private final int logicalBlockAddress;
    private final int bufferPosition;
    private final short transferLength;

    public WriteRequestState(Connection initConnection, ByteBuffer initBuffer, int initBufferPosition, SCSICommandParser.TaskAttributes initTaskAttributes, int initExpectedDataTransferLength, int initLogicalBlockAddress, short initTransferLength) {
        super(initConnection);
        this.buffer = initBuffer;
        this.bufferPosition = initBufferPosition;
        this.taskAttributes = initTaskAttributes;
        this.expectedDataTransferLength = initExpectedDataTransferLength;
        this.logicalBlockAddress = initLogicalBlockAddress;
        this.transferLength = initTransferLength;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        ProtocolDataUnit protocolDataUnit = this.protocolDataUnitFactory.create(false, true, OperationCode.SCSI_COMMAND, this.connection.getSetting(OperationalTextKey.HEADER_DIGEST), this.connection.getSetting(OperationalTextKey.DATA_DIGEST));
        SCSICommandParser scsi = (SCSICommandParser)protocolDataUnit.getBasicHeaderSegment().getParser();
        scsi.setReadExpectedFlag(false);
        scsi.setWriteExpectedFlag(true);
        scsi.setTaskAttributes(this.taskAttributes);
        scsi.setExpectedDataTransferLength(this.expectedDataTransferLength);
        int maxRecvDataSegmentLength = this.connection.getSettingAsInt(OperationalTextKey.MAX_RECV_DATA_SEGMENT_LENGTH);
        scsi.setCommandDescriptorBlock(SCSICommandDescriptorBlockParser.createWriteMessage((int)this.logicalBlockAddress, (short)this.transferLength));
        IDataSegment dataSegment = DataSegmentFactory.create((ByteBuffer)this.buffer, (int)this.bufferPosition, (int)this.expectedDataTransferLength, (DataSegmentFactory.DataSegmentFormat)DataSegmentFactory.DataSegmentFormat.BINARY, (int)maxRecvDataSegmentLength);
        IDataSegmentIterator iterator = dataSegment.iterator();
        int bufferOffset = 0;
        if (this.connection.getSettingAsBoolean(OperationalTextKey.IMMEDIATE_DATA)) {
            int min = Math.min(maxRecvDataSegmentLength, this.connection.getSettingAsInt(OperationalTextKey.FIRST_BURST_LENGTH));
            protocolDataUnit.setDataSegment(iterator.next(min));
            bufferOffset += min;
        }
        this.connection.send(protocolDataUnit);
        if (!this.connection.getSettingAsBoolean(OperationalTextKey.INITIAL_R2T) && iterator.hasNext()) {
            this.connection.nextState(new WriteFirstBurstState(this.connection, iterator, -1, 0, bufferOffset));
        } else {
            this.connection.nextState(new WriteSecondResponseState(this.connection, iterator, 0, bufferOffset));
        }
        this.stateFollowing = true;
    }
}

