/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import java.util.LinkedList;
import org.jscsi.exception.InternetSCSIException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.WriteSecondResponseState;
import org.jscsi.parser.OperationCode;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.data.DataOutParser;
import org.jscsi.parser.datasegment.IDataSegmentIterator;
import org.jscsi.parser.datasegment.OperationalTextKey;

public final class WriteSecondBurstState
extends AbstractState {
    private final IDataSegmentIterator iterator;
    private final int targetTransferTag;
    private final int desiredDataTransferLength;
    private int dataSequenceNumber;
    private int bufferOffset;

    public WriteSecondBurstState(Connection initConnection, IDataSegmentIterator initIterator, int initTargetTransferTag, int initDesiredDataTransferLength, int initDataSequenceNumber, int initBufferOffset) {
        super(initConnection);
        this.iterator = initIterator;
        this.targetTransferTag = initTargetTransferTag;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("TTT set to " + this.targetTransferTag);
        }
        this.desiredDataTransferLength = initDesiredDataTransferLength;
        this.dataSequenceNumber = 0;
        this.bufferOffset = initBufferOffset;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        LinkedList<ProtocolDataUnit> protocolDataUnits = new LinkedList<ProtocolDataUnit>();
        boolean finalFlag = false;
        int maxRecvDataSegmentLength = this.connection.getSettingAsInt(OperationalTextKey.MAX_RECV_DATA_SEGMENT_LENGTH);
        int bytes2Transfer = Math.min(this.connection.getSettingAsInt(OperationalTextKey.MAX_BURST_LENGTH), this.desiredDataTransferLength);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("bytes2Transfer: " + bytes2Transfer + " iterator.hasNext(): " + this.iterator.hasNext());
        }
        while (bytes2Transfer > 0 && this.iterator.hasNext()) {
            IDataSegmentIterator.IDataSegmentChunk dataSegmentChunk;
            if (bytes2Transfer <= maxRecvDataSegmentLength) {
                dataSegmentChunk = this.iterator.next(bytes2Transfer);
                finalFlag = true;
            } else {
                dataSegmentChunk = this.iterator.next(maxRecvDataSegmentLength);
                finalFlag = false;
            }
            ProtocolDataUnit protocolDataUnit = this.protocolDataUnitFactory.create(false, finalFlag, OperationCode.SCSI_DATA_OUT, this.connection.getSetting(OperationalTextKey.HEADER_DIGEST), this.connection.getSetting(OperationalTextKey.DATA_DIGEST));
            protocolDataUnit.getBasicHeaderSegment().setInitiatorTaskTag(this.connection.getSession().getInitiatorTaskTag());
            DataOutParser dataOut = (DataOutParser)protocolDataUnit.getBasicHeaderSegment().getParser();
            dataOut.setTargetTransferTag(this.targetTransferTag);
            dataOut.setDataSequenceNumber(this.dataSequenceNumber++);
            dataOut.setBufferOffset(this.bufferOffset);
            this.bufferOffset += maxRecvDataSegmentLength;
            protocolDataUnit.setDataSegment(dataSegmentChunk);
            protocolDataUnits.offer(protocolDataUnit);
            bytes2Transfer -= maxRecvDataSegmentLength;
        }
        this.connection.send(protocolDataUnits);
        this.connection.nextState(new WriteSecondResponseState(this.connection, this.iterator, this.dataSequenceNumber, this.bufferOffset));
    }

    @Override
    public boolean nextStateFollowing() {
        return true;
    }
}

