/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.connection.state;

import org.jscsi.exception.InternetSCSIException;
import org.jscsi.exception.OperationalTextKeyException;
import org.jscsi.initiator.connection.Connection;
import org.jscsi.initiator.connection.state.AbstractState;
import org.jscsi.initiator.connection.state.WriteSecondBurstState;
import org.jscsi.parser.ProtocolDataUnit;
import org.jscsi.parser.datasegment.IDataSegmentIterator;
import org.jscsi.parser.datasegment.OperationalTextKey;
import org.jscsi.parser.r2t.Ready2TransferParser;
import org.jscsi.parser.scsi.SCSIResponseParser;
import org.jscsi.parser.scsi.SCSIStatus;

public final class WriteSecondResponseState
extends AbstractState {
    private final IDataSegmentIterator iterator;
    private final int dataSequenceNumber;
    private final int bufferOffset;

    public WriteSecondResponseState(Connection initConnection, IDataSegmentIterator initIterator, int initDataSequenceNumber, int initBufferOffset) {
        super(initConnection);
        this.iterator = initIterator;
        this.dataSequenceNumber = initDataSequenceNumber;
        this.bufferOffset = initBufferOffset;
    }

    @Override
    public final void execute() throws InternetSCSIException {
        ProtocolDataUnit protocolDataUnit = this.connection.receive();
        LOGGER.trace("1" + protocolDataUnit);
        if (protocolDataUnit.getBasicHeaderSegment().getParser() instanceof Ready2TransferParser) {
            int desiredDataTransferLength;
            LOGGER.trace("2");
            Ready2TransferParser parser = (Ready2TransferParser)protocolDataUnit.getBasicHeaderSegment().getParser();
            int targetTransferTag = parser.getTargetTransferTag();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("R2T has TTT set to " + targetTransferTag);
            }
            if ((desiredDataTransferLength = parser.getDesiredDataTransferLength()) > this.connection.getSettingAsInt(OperationalTextKey.MAX_BURST_LENGTH)) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("MaxBurstLength limit is exceed.");
                }
                throw new InternetSCSIException("MaxBurstLength limit is exceed.");
            }
            this.connection.nextState(new WriteSecondBurstState(this.connection, this.iterator, targetTransferTag, desiredDataTransferLength, this.dataSequenceNumber, this.bufferOffset));
            this.stateFollowing = true;
            return;
        }
        if (protocolDataUnit.getBasicHeaderSegment().getParser() instanceof SCSIResponseParser) {
            SCSIResponseParser parser = (SCSIResponseParser)protocolDataUnit.getBasicHeaderSegment().getParser();
            if (!this.iterator.hasNext() && parser.getStatus() == SCSIStatus.GOOD) {
                this.connection.getSession().incrementInitiatorTaskTag();
                this.stateFollowing = false;
                return;
            }
        }
        throw new RuntimeException(protocolDataUnit.getBasicHeaderSegment().getParser().toString());
    }

    @Override
    public final Exception isCorrect(ProtocolDataUnit protocolDataUnit) {
        try {
            if (!this.connection.getSettingAsBoolean(OperationalTextKey.DATA_PDU_IN_ORDER) && !this.connection.getSettingAsBoolean(OperationalTextKey.DATA_SEQUENCE_IN_ORDER)) {
                return new UnsupportedOperationException(OperationalTextKey.DATA_PDU_IN_ORDER.toString() + " is yet not supported.");
            }
            return null;
        }
        catch (OperationalTextKeyException e) {
            return e;
        }
    }
}

