/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.example;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jscsi.exception.ConfigurationException;
import org.jscsi.exception.NoSuchSessionException;
import org.jscsi.exception.TaskExecutionException;
import org.jscsi.initiator.Configuration;
import org.jscsi.initiator.Initiator;

public class MultiThreadedReadWrite {
    public static void main(String[] args) throws NoSuchSessionException, TaskExecutionException, ConfigurationException, InterruptedException, ExecutionException {
        int numBlocks = 50;
        int address = 12345;
        ByteBuffer writeData1 = ByteBuffer.allocate(512 * numBlocks);
        ByteBuffer readData1 = ByteBuffer.allocate(512 * numBlocks);
        ByteBuffer writeData2 = ByteBuffer.allocate(512 * numBlocks);
        ByteBuffer readData2 = ByteBuffer.allocate(512 * numBlocks);
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(writeData1.array());
        random.nextBytes(writeData2.array());
        String target1 = "testing-xen2-disk1";
        String target2 = "testing-xen2-disk2";
        Initiator initiator = new Initiator(Configuration.create());
        initiator.createSession(target1);
        initiator.createSession(target2);
        Future<Void> write1 = initiator.multiThreadedWrite(target1, writeData1, address, writeData1.capacity());
        Future<Void> write2 = initiator.multiThreadedWrite(target2, writeData2, address, writeData2.capacity());
        write1.get();
        write2.get();
        Future<Void> read1 = initiator.multiThreadedRead(target1, readData1, address, readData1.capacity());
        Future<Void> read2 = initiator.multiThreadedRead(target2, readData2, address, readData2.capacity());
        read1.get();
        read2.get();
        initiator.closeSession(target1);
        initiator.closeSession(target2);
        if (!Arrays.equals(writeData1.array(), readData1.array()) || !Arrays.equals(writeData2.array(), readData2.array())) {
            throw new IllegalStateException("Data read must be equal to the data written");
        }
    }
}

