/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.initiator.example;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.jscsi.exception.ConfigurationException;
import org.jscsi.exception.NoSuchSessionException;
import org.jscsi.exception.TaskExecutionException;
import org.jscsi.initiator.Configuration;
import org.jscsi.initiator.Initiator;

public class SingleThreadedReadWrite {
    public static void main(String[] args) throws NoSuchSessionException, TaskExecutionException, ConfigurationException {
        int numBlocks = 50;
        int address = 12345;
        ByteBuffer writeData = ByteBuffer.allocate(512 * numBlocks);
        ByteBuffer readData = ByteBuffer.allocate(512 * numBlocks);
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(writeData.array());
        String target = "testing-xen2-disk1";
        Initiator initiator = new Initiator(Configuration.create());
        initiator.createSession(target);
        initiator.write(target, writeData, address, writeData.capacity());
        initiator.read(target, readData, address, readData.capacity());
        initiator.closeSession(target);
        if (!Arrays.equals(writeData.array(), readData.array())) {
            throw new IllegalStateException("Data read must be equal to the data written");
        }
    }
}

