/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.simulator.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import org.jsmart.simulator.domain.Api;
import org.jsmart.simulator.domain.ApiSpec;
import org.jsmart.simulator.domain.RestResponse;

public class ApiSpecDeserializer
extends JsonDeserializer<ApiSpec> {
    public ApiSpec deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String name = node.get("name").asText();
        ArrayList<Api> apis = new ArrayList<Api>();
        ArrayNode apisNode = (ArrayNode)node.get("apis");
        for (JsonNode apiNode : apisNode) {
            String apiName = apiNode.get("name").asText();
            String operation = apiNode.get("operation").asText();
            String url = apiNode.get("url").asText();
            JsonNode bodyNode = apiNode.get("body");
            String body = null != bodyNode ? bodyNode.toString() : null;
            JsonNode ignoreBodyNode = apiNode.get("ignoreBody");
            Boolean ignoreBody = null != ignoreBodyNode && ignoreBodyNode.asBoolean();
            JsonNode headersNode = apiNode.get("headers");
            String headers = headersNode != null ? headersNode.toString() : null;
            JsonNode jsonStatusNode = apiNode.get("response").get("status");
            int responseStatus = null != jsonStatusNode ? jsonStatusNode.asInt() : 200;
            JsonNode jsonBodyNode = apiNode.get("response").get("body");
            String responseBody = jsonBodyNode != null ? jsonBodyNode.toString() : null;
            JsonNode stringBodyNode = apiNode.get("response").get("stringBody");
            String stringBody = stringBodyNode != null ? stringBodyNode.asText() : null;
            JsonNode xmlBodyNode = apiNode.get("response").get("xmlBody");
            String xmlBody = xmlBodyNode != null ? xmlBodyNode.asText() : null;
            JsonNode jsonHeaderNode = apiNode.get("response").get("headers");
            String responseHeaders = null != jsonHeaderNode ? jsonHeaderNode.toString() : "";
            Api api = new Api(apiName, operation, url, body, ignoreBody, headers, new RestResponse(responseHeaders, responseStatus, responseBody, stringBody, xmlBody));
            apis.add(api);
        }
        return new ApiSpec(name, apis);
    }
}

