/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.simulator.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.classpath.ClassPath;
import com.google.classpath.ClassPathFactory;
import com.google.classpath.RegExpResourceFilter;
import com.google.classpath.ResourceFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jsmart.simulator.annotations.ApiRepo;
import org.jsmart.simulator.base.BaseSimulator;
import org.jsmart.simulator.domain.Api;
import org.jsmart.simulator.domain.ApiSpec;
import org.jsmart.simulator.domain.RestResponse;
import org.jsmart.simulator.utils.SimulatorJsonUtils;
import org.json.JSONException;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;
import org.simpleframework.http.core.Container;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiRepo(value="simulators")
public class JsonBasedSimulator
extends BaseSimulator
implements Container {
    private static final Logger logger = LoggerFactory.getLogger(JsonBasedSimulator.class);
    private final String NOT_FOUND_PLACEHOLDER = "$NOT_FOUND";
    public static String namesAsAString = "";
    private Class<?> mainRunnerClass;
    private String packageName;
    List<ApiSpec> apiSpecRequestResponseList;

    public JsonBasedSimulator(int port) {
        super(port);
        this.setActualContainer(this);
        this.mainRunnerClass = this.getClass();
        this.apiSpecRequestResponseList = this.getDeserializedApiSpecList();
        this.setSimulatorName(this.getNamesComaSeparated(this.apiSpecRequestResponseList));
    }

    public void addApiSpec(ApiSpec apiSpec) {
        if (null != apiSpec) {
            this.apiSpecRequestResponseList.add(apiSpec);
        }
    }

    public void handle(Request request, Response response) {
        logger.info("\n-------  REST api  ------------ \nRequest: \n" + request.getMethod() + ":" + request.getTarget());
        try {
            PrintStream body = this.getPrintStreamForResponse(response);
            String responseBody = this.generateSimulatedResponse(request, response);
            body.print(responseBody);
            body.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String generateSimulatedResponse(Request request, Response response) throws IOException, JSONException {
        String REQUEST_METHOD;
        String notFoundMessage = "{\n    \"class\": \"org.jsmart.exceptions.exceptions.service.InternalServerErrorException\",\n    \"correlationId\": \"ncb5a561-yye7-44a0-bdea-6d918f310cdXX\",\n    \"description\": \"An exception occurred Because could not find the end point in Simulator\",\n    \"errorId\": \"org.jsmart.simulator.could.not.find.end.point:" + request.getTarget() + "\",\n" + "    \"causes\": [],\n" + "    \"suppressed\": []\n" + "}";
        switch (REQUEST_METHOD = request.getMethod()) {
            case "GET": {
                return this.respondGET(request, response, notFoundMessage);
            }
            case "POST": {
                return this.respondPOST(request, response, notFoundMessage);
            }
            case "PUT": {
                return this.respondToPUT(request, response, notFoundMessage);
            }
            case "PATCH": {
                this.listenToPATCHForGETResponse(request);
                return this.respondToPATCH(request.getTarget(), response, notFoundMessage);
            }
            case "OTHERS": {
                notFoundMessage = "Not implemented.Please raise an issue in GitHub and let the author know. Contribute to OSS";
                break;
            }
            default: {
                response.setStatus(Status.NOT_IMPLEMENTED);
                String message = "{\"message\": \"" + REQUEST_METHOD + " #method not yet implemented.\"}";
                logger.info("\nSimulator Response:" + message);
                return message;
            }
        }
        response.setStatus(Status.NOT_FOUND);
        return notFoundMessage;
    }

    private String respondGET(Request request, Response response, String notFoundMessage) {
        String requestTarget = request.getTarget();
        logger.info("# Requested Target : GET: " + requestTarget);
        for (ApiSpec apiSpec : this.apiSpecRequestResponseList) {
            for (Api api : apiSpec.getApis()) {
                if (!"GET".equals(api.getOperation()) || !requestTarget.equals(api.getUrl())) continue;
                return this.createResponse(response, api, request);
            }
            String body = this.handleMatchingApiNotFound(requestTarget, response, apiSpec);
            if (body == null) continue;
            return body;
        }
        response.setStatus(Status.NOT_FOUND);
        return notFoundMessage;
    }

    private void matchRequestHeaders(CharSequence headerCharSequence, String apiHeadersJson) {
        if (!StringUtils.isEmpty((String)apiHeadersJson)) {
            String rawHeadersSequenceString;
            String string = rawHeadersSequenceString = headerCharSequence != null ? headerCharSequence.toString() : null;
            if (rawHeadersSequenceString == null) {
                throw new RuntimeException("micro-simulator: Headers were null in the request. Could not find API matching the requested headers");
            }
            Map<String, Object> requestHeadersMap = SimulatorJsonUtils.getRequestHeadersMap(rawHeadersSequenceString);
            try {
                String rawHeadersJson = new ObjectMapper().writeValueAsString(requestHeadersMap);
                boolean passed = JSONCompare.compareJSON((String)apiHeadersJson, (String)rawHeadersJson, (JSONCompareMode)JSONCompareMode.LENIENT).passed();
                if (!passed) {
                    String errMessage = "Micro-Simulator headers comparison did not pass. Expected headers were:" + apiHeadersJson + ", Actual headers were: " + rawHeadersJson;
                    System.err.println(errMessage);
                    logger.error(errMessage);
                    throw new RuntimeException(errMessage);
                }
            }
            catch (Exception ex) {
                System.err.println("Micro-Simulator headers parsing exception probably:" + ex);
                logger.error("Micro-Simulator headers parsing exception probably:" + ex);
                throw new RuntimeException("micro-simulator: Headers mismatch was found. Could not find API matching the requested headers");
            }
        }
    }

    private String responseBodyFromInputJson(RestResponse response) {
        if (!StringUtils.isEmpty((String)response.getStringBody())) {
            return response.getStringBody();
        }
        if (!StringUtils.isEmpty((String)response.getXmlBody())) {
            return response.getXmlBody();
        }
        return response.getBody();
    }

    private String handleMatchingApiNotFound(String requestTarget, Response response, ApiSpec apiSpec) {
        for (Api api : apiSpec.getApis()) {
            if (!"GET".equals(api.getOperation()) || !this.urlMatchesForNotFound(api.getUrl(), requestTarget)) continue;
            logger.info("# Found Target: api.getOperation() : " + api.getOperation() + ", api.getUrl(): " + api.getUrl());
            logger.info("\nSimulator Response: \nStatus:" + api.getResponse().getStatus() + "\nbody: " + api.getResponse().getBody());
            response.setStatus(Status.getStatus((int)api.getResponse().getStatus()));
            return api.getResponse().getBody();
        }
        return null;
    }

    private String handleNotFoundPOSTEndPoints(Request request, Response response) {
        for (ApiSpec apiSpec : this.apiSpecRequestResponseList) {
            for (Api api : apiSpec.getApis()) {
                if (!"POST".equals(api.getOperation()) || api.getBody() == null || !api.getBody().contains("$NOT_FOUND") || !this.urlMatchesForNotFound(api.getUrl(), request.getTarget())) continue;
                logger.info("# Found Target: api.getOperation() : " + api.getOperation() + ", api.getUrl(): " + api.getUrl());
                logger.info("\nSimulator Response: \nStatus:" + api.getResponse().getStatus() + "\nbody: " + api.getResponse().getBody());
                response.setStatus(Status.getStatus((int)api.getResponse().getStatus()));
                return api.getResponse().getBody();
            }
        }
        logger.info("No default target found for: " + request.getTarget());
        return null;
    }

    private boolean urlMatchesForNotFound(String apiUrl, String requestedUrl) {
        if (apiUrl.contains("$NOT_FOUND")) {
            int indexOfNF = apiUrl.indexOf("$NOT_FOUND");
            int lengthAfterNF = apiUrl.length() - (indexOfNF + "$NOT_FOUND".length());
            String startOfApiURL = apiUrl.substring(0, indexOfNF);
            if (requestedUrl.length() < indexOfNF) {
                return false;
            }
            String startOfRequestedUrl = requestedUrl.substring(0, indexOfNF);
            boolean startMatch = startOfApiURL.equals(startOfRequestedUrl);
            String endOfApiURL = apiUrl.substring(apiUrl.length() - lengthAfterNF);
            if (requestedUrl.length() < lengthAfterNF) {
                return false;
            }
            String endOfRequestedUrl = requestedUrl.substring(requestedUrl.length() - lengthAfterNF);
            boolean endMatch = endOfApiURL.equals(endOfRequestedUrl);
            return startMatch && endMatch;
        }
        return apiUrl.equals(requestedUrl);
    }

    private String respondPOST(Request request, Response response, String notFoundMessage) throws IOException, JSONException {
        String requestTarget = request.getTarget();
        String requestContent = request.getContent();
        logger.info("# Requested Target : POST: " + requestTarget);
        for (ApiSpec apiSpec : this.apiSpecRequestResponseList) {
            for (Api api : apiSpec.getApis()) {
                if (!"POST".equals(api.getOperation()) || !requestTarget.equals(api.getUrl()) || (!StringUtils.isBlank((String)api.getBody()) || !StringUtils.isBlank((String)requestContent)) && !this.compareJson(api, requestContent)) continue;
                return this.createResponse(response, api, request);
            }
        }
        logger.info("No specific target found for: " + request.getTarget());
        String body = this.handleNotFoundPOSTEndPoints(request, response);
        if (body != null) {
            return body;
        }
        response.setStatus(Status.NOT_FOUND);
        return notFoundMessage;
    }

    private String createResponse(Response response, Api api, Request request) {
        logger.info("# Found simulated Target: api.getOperation() : " + api.getOperation() + ", api.getUrl(): " + api.getUrl() + ", api.getName(): " + api.getName());
        logger.info("\nSimulator Response: \nStatus:" + api.getResponse().getStatus() + "\nbody: " + api.getResponse().getBody());
        this.matchRequestHeaders(request.getHeader(), api.getHeaders());
        response.setStatus(Status.getStatus((int)api.getResponse().getStatus()));
        this.setResponseHeaders(response, api.getResponse().getHeaders());
        return this.responseBodyFromInputJson(api.getResponse());
    }

    private boolean compareJson(Api api, String str2) {
        if (api.getIgnoreBody() == null || !api.getIgnoreBody().booleanValue()) {
            boolean passed = false;
            try {
                passed = JSONCompare.compareJSON((String)api.getBody(), (String)str2, (JSONCompareMode)JSONCompareMode.LENIENT).passed();
            }
            catch (Exception e) {
                logger.info("Exception while comparing: " + e.getMessage());
                passed = false;
            }
            if (!passed) {
                logger.info("#REST end point found, but the request body did not match with simulated body.\n=>Request body: " + api.getBody() + "\n=>Simulated body: " + str2);
            }
            return passed;
        }
        return true;
    }

    private String respondToPUT(Request request, Response response, String notFoundMessage) {
        String requestTarget = request.getTarget();
        String OPERATION = "PUT";
        for (ApiSpec apiSpec : this.apiSpecRequestResponseList) {
            logger.info("# Requested Target : PUT: " + requestTarget);
            for (Api api : apiSpec.getApis()) {
                if (!"PUT".equals(api.getOperation()) || !requestTarget.equals(api.getUrl())) continue;
                return this.createResponse(response, api, request);
            }
        }
        response.setStatus(Status.NOT_FOUND);
        return notFoundMessage;
    }

    private String respondToPATCH(String requestTarget, Response response, String notFoundMessage) {
        String OPERATION = "PATCH";
        for (ApiSpec apiSpec : this.apiSpecRequestResponseList) {
            logger.info("# Requested Target : PATCH: " + requestTarget);
            for (Api api : apiSpec.getApis()) {
                if (!"PATCH".equals(api.getOperation()) || !requestTarget.equals(api.getUrl())) continue;
                logger.info("# Found simulated Target: api.getOperation() : " + api.getOperation() + ", api.getUrl(): " + api.getUrl());
                logger.info("\nSimulator Response: \nStatus:" + api.getResponse().getStatus() + "\nbody: " + api.getResponse().getBody());
                response.setStatus(Status.getStatus((int)api.getResponse().getStatus()));
                this.setResponseHeaders(response, api.getResponse().getHeaders());
                return this.responseBodyFromInputJson(api.getResponse());
            }
        }
        response.setStatus(Status.NOT_FOUND);
        return notFoundMessage;
    }

    private void setResponseHeaders(Response response, String headersJson) {
        if (StringUtils.isEmpty((String)headersJson)) {
            return;
        }
        Map headersMap = SimulatorJsonUtils.getAsMap(headersJson);
        for (String key : headersMap.keySet()) {
            response.addValue(key, (String)headersMap.get(key));
        }
    }

    private void listenToPATCHForGETResponse(Request request) {
        try {
            String body = request.getContent();
            Api inMemoryPATCHApi = new Api("End point for PATCH request", "PATCH", request.getTarget(), null, false, "{\"Language\":\"en_USA\"}", new RestResponse(null, 201, body, null, null));
            this.addOrReplaceInMemoryApi(inMemoryPATCHApi);
            Api inMemoryGETApi = new Api("Simulated using PATCH: End point for for GET request", "GET", request.getTarget(), null, false, "{\"Language\":\"en_USA\"}", new RestResponse("{\"Language\":\"en_gb\"}", 200, body, null, null));
            this.addOrReplaceInMemoryApi(inMemoryGETApi);
        }
        catch (Exception excp) {
            excp.printStackTrace();
            logger.error("Exception was: " + excp);
            throw new RuntimeException(excp.getMessage());
        }
    }

    private void addOrReplaceInMemoryApi(Api inMemoryApi) {
        int itemIndex = this.apiSpecRequestResponseList.get(0).getApis().indexOf(inMemoryApi);
        if (itemIndex != -1) {
            logger.info("\n#Overridden: Listened to PATCH and simulated in-memory {} api: {}", (Object)inMemoryApi.getOperation(), (Object)inMemoryApi);
            this.apiSpecRequestResponseList.get(0).getApis().set(itemIndex, inMemoryApi);
        } else {
            logger.info("\n#Added: Listened to PATCH and simulated in-memory {} api: {}", (Object)inMemoryApi.getOperation(), (Object)inMemoryApi);
            this.apiSpecRequestResponseList.get(0).getApis().add(inMemoryApi);
        }
    }

    private PrintStream getPrintStreamForResponse(Response response) throws IOException {
        PrintStream body = response.getPrintStream();
        long time = System.currentTimeMillis();
        response.setContentType("application/json");
        response.setDescription(this.getSimulatorName());
        response.setDate("Date", time);
        response.setDate("Last-Modified", time);
        return body;
    }

    private String getNamesComaSeparated(List<ApiSpec> requestResponseList) {
        String simulatorNames = "All Simulators::";
        for (ApiSpec apiSpec : requestResponseList) {
            simulatorNames = simulatorNames + ":" + apiSpec.getName();
        }
        return simulatorNames;
    }

    private List<ApiSpec> getDeserializedApiSpecList() {
        ClassPathFactory factory = new ClassPathFactory();
        ClassPath jvmClassPath = factory.createFromJVM();
        ApiRepo annotation = this.getMainRunnerClass().getAnnotation(ApiRepo.class);
        this.packageName = annotation.value();
        String[] allSimulationFiles = jvmClassPath.findResources(this.packageName, (ResourceFilter)new RegExpResourceFilter(".*", ".*\\.json$"));
        if (null == allSimulationFiles || allSimulationFiles.length == 0) {
            throw new RuntimeException("YouTriedToSimulateNothingException: Check the (" + this.packageName + ") integration test repo folder(empty?). ");
        }
        ArrayList<ApiSpec> apiSpecList = new ArrayList<ApiSpec>();
        for (String resourceName : allSimulationFiles) {
            try {
                InputStream stream = jvmClassPath.getResourceAsStream(resourceName);
                InputStreamReader reader = new InputStreamReader(stream);
                apiSpecList.add(SimulatorJsonUtils.deserialize(reader));
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Error while parsing '%s': %s", resourceName, e.getMessage()), e);
            }
        }
        return apiSpecList;
    }

    public Class getMainRunnerClass() {
        return this.mainRunnerClass;
    }
}

