/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.simulator.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.jsmart.simulator.domain.ApiSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorJsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(SimulatorJsonUtils.class);

    public static ApiSpec deserialize(Reader json) {
        ApiSpec apiSpec;
        try {
            apiSpec = (ApiSpec)new ObjectMapper().readValue(json, ApiSpec.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return apiSpec;
    }

    public static Map getAsMap(String jsonString) {
        Map map = new HashMap();
        ObjectMapper mapper = new ObjectMapper();
        try {
            map = (Map)mapper.readValue(jsonString, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (Exception ex) {
            logger.error("\n\nMicro-Simulator: Encountered Parsing Exception probably: " + ex);
            System.err.println("\n\nMicro-Simulator: Parse Exception probably: " + ex);
            throw new RuntimeException(ex);
        }
        return map;
    }

    public static void main(String[] args) {
        String raw = "GET /customers HTTP/1.1\ncache-control: no-cache\nPostman-Token: d2b1f2b1-bfff-401a-8627-b1944dae1aa9\nContent-Type: application/json\nhsbc-client-id-x: rss-value-client-id-x\nUser-Agent: PostmanRuntime/3.0.11-hotfix.2\nAccept: */*\nHost: localhost:9999\naccept-encoding: gzip, deflate\nConnection: keep-alive\n\n";
        Map<String, Object> myMap = SimulatorJsonUtils.getRequestHeadersMap(raw);
        System.out.println(myMap);
    }

    public static Map<String, Object> getRequestHeadersMap(String colonSeparatedHeaders) {
        String[] colonPairs = colonSeparatedHeaders.replaceAll("\r", "").split("\n");
        HashMap<String, Object> headersMap = new HashMap<String, Object>();
        String KV_SEPARATOR = ": ";
        for (int i = 0; i < colonPairs.length; ++i) {
            String pair = colonPairs[i];
            String[] keyValue = pair.split(": ");
            if (keyValue.length != 2) continue;
            headersMap.put(keyValue[0], keyValue[1]);
        }
        return headersMap;
    }

    public static String readValue(String jsonString, String key) {
        try {
            return (String)JsonPath.read((String)jsonString, (String)("$." + key));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

