/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.mocker;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.domain.MockStep;
import org.jsmart.zerocode.core.domain.MockSteps;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestEndPointMocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonServiceExecutorImpl.class);
    public static WireMockServer wireMockServer;

    public static void createWithWireMock(MockSteps mockSteps, int mockPort) {
        RestEndPointMocker.restartWireMock(mockPort);
        mockSteps.getMocks().forEach(mockStep -> {
            String jsonBodyRequest = mockStep.getResponse().get("body").toString();
            if ("GET".equals(mockStep.getOperation())) {
                LOGGER.info("*****WireMock- Mocking the GET endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createGetRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.info("WireMock- Mocking the GET endpoint -done- *****");
            } else if ("POST".equals(mockStep.getOperation())) {
                LOGGER.info("*****WireMock- Mocking the POST endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createPostRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.info("WireMock- Mocking the POST endpoint -done-*****");
            } else if ("PUT".equals(mockStep.getOperation())) {
                LOGGER.info("*****WireMock- Mocking the PUT endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createPutRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.info("WireMock- Mocking the PUT endpoint -done-*****");
            }
        });
    }

    public static void restartWireMock(int dynamicPort) {
        wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(dynamicPort));
        wireMockServer.stop();
        wireMockServer.start();
        WireMock.configureFor((String)"localhost", (int)dynamicPort);
    }

    private static MappingBuilder createPutRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.put((UrlMatchingStrategy)WireMock.urlEqualTo((String)mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static MappingBuilder createPostRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static MappingBuilder createGetRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static MappingBuilder createRequestBuilderWithHeaders(MockStep mockStep, MappingBuilder requestBuilder) {
        Map<String, Object> headersMap;
        String bodyJson = mockStep.getBody();
        if (StringUtils.isNotEmpty((String)bodyJson)) {
            requestBuilder.withRequestBody(WireMock.equalToJson((String)bodyJson));
        }
        if ((headersMap = mockStep.getHeadersMap()).size() > 0) {
            for (String key : headersMap.keySet()) {
                requestBuilder.withHeader(key, WireMock.equalTo((String)((String)headersMap.get(key))));
            }
        }
        return requestBuilder;
    }

    private static ResponseDefinitionBuilder responseBuilder(MockStep mockStep, String jsonBodyRequest) {
        ResponseDefinitionBuilder responseBuilder = WireMock.aResponse().withStatus(mockStep.getResponse().get("status").asInt()).withBody(jsonBodyRequest);
        return responseBuilder;
    }

    public static int createWithVirtuosoMock(String endPointJsonApi) {
        return 200;
    }

    public static int createWithLocalMock(String endPointJsonApi) {
        if (StringUtils.isNotEmpty((String)endPointJsonApi)) {
            // empty if block
        }
        return 200;
    }
}

