/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.logbuilder;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeReportStepBuilder;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeReportStep;
import org.jsmart.zerocode.core.logbuilder.RequestLogBuilder;
import org.jsmart.zerocode.core.logbuilder.ResponseLogBuilder;
import org.jsmart.zerocode.core.logbuilder.ScenarioLogBuilder;
import org.slf4j.Logger;

public class LogCorrelationshipPrinter {
    private static final String DISPLAY_DEMARCATION_ = "\n--------- TEST-STEP-CORRELATION-ID: %s ---------";
    Logger logger;
    static String correlationId;
    RequestLogBuilder requestLogBuilder = new RequestLogBuilder();
    ResponseLogBuilder responseLogBuilder = new ResponseLogBuilder();
    ScenarioLogBuilder scenarioLogBuilder = new ScenarioLogBuilder();
    Integer stepLoop;
    private Boolean result;
    private Double responseDelay;

    public LogCorrelationshipPrinter(Logger logger) {
        this.logger = logger;
    }

    public static LogCorrelationshipPrinter newInstance(Logger logger) {
        return new LogCorrelationshipPrinter(logger);
    }

    public RequestLogBuilder aRequestBuilder() {
        return this.requestLogBuilder;
    }

    public LogCorrelationshipPrinter assertion(String assertionJson) {
        this.responseLogBuilder.assertionSection(assertionJson);
        return this;
    }

    public LogCorrelationshipPrinter stepLoop(Integer stepLoop) {
        this.stepLoop = stepLoop;
        return this;
    }

    public LogCorrelationshipPrinter result(Boolean result) {
        this.result = result;
        return this;
    }

    public ZeroCodeReportStep buildReportSingleStep() {
        ZeroCodeReportStep zeroCodeReportStep = ZeroCodeReportStepBuilder.newInstance().loop(this.stepLoop).name(this.requestLogBuilder.stepName).correlationId(correlationId).result(this.result == true ? "PASSED" : "FAILED").url(this.requestLogBuilder.url).operation(this.requestLogBuilder.method).requestTimeStamp(this.requestLogBuilder.requestTimeStamp).responseTimeStamp(this.responseLogBuilder.responseTimeStamp).responseDelay(this.responseDelay).build();
        return zeroCodeReportStep;
    }

    public ResponseLogBuilder aResponseBuilder() {
        return this.responseLogBuilder;
    }

    public ScenarioLogBuilder aScenarioBuilder() {
        return this.scenarioLogBuilder;
    }

    public void print() {
        this.responseDelay = LogCorrelationshipPrinter.durationMilliSecBetween(this.requestLogBuilder.getRequestTimeStamp(), this.responseLogBuilder.getResponseTimeStamp());
        this.logger.info(String.format("%s %s \n*Response delay:%s milli-secs \n%s \n-done-\n", this.requestLogBuilder.toString(), this.responseLogBuilder.toString(), this.responseDelay, "---------> Assertion: <----------\n" + this.responseLogBuilder.getAssertion()));
    }

    public static double durationMilliSecBetween(LocalDateTime requestTimeStamp, LocalDateTime responseTimeStamp) {
        Duration dur = Duration.between(requestTimeStamp, responseTimeStamp);
        return dur.toMillis();
    }

    public static String createRelationshipId() {
        correlationId = LogCorrelationshipPrinter.getRelationshipUniqueId();
        return String.format(DISPLAY_DEMARCATION_, correlationId);
    }

    public static String getRelationshipUniqueId() {
        return UUID.randomUUID().toString();
    }

    public String getCorrelationId() {
        return correlationId;
    }
}

